/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.OrthogonalPathLayouter;
import ru.biosoft.graph.Path;

public class Util {
    protected static Map<OrthogonalPathLayouter.Orientation, Map<OrthogonalPathLayouter.Orientation, Integer>> numberOfTurnsMap = new HashMap<OrthogonalPathLayouter.Orientation, Map<OrthogonalPathLayouter.Orientation, Integer>>(){
        {
            this.put(OrthogonalPathLayouter.Orientation.TOP, new HashMap<OrthogonalPathLayouter.Orientation, Integer>(){
                {
                    this.put(OrthogonalPathLayouter.Orientation.TOP, 0);
                    this.put(OrthogonalPathLayouter.Orientation.RIGHT, 1);
                    this.put(OrthogonalPathLayouter.Orientation.BOTTOM, 2);
                    this.put(OrthogonalPathLayouter.Orientation.LEFT, 3);
                }
            });
            this.put(OrthogonalPathLayouter.Orientation.RIGHT, new HashMap<OrthogonalPathLayouter.Orientation, Integer>(){
                {
                    this.put(OrthogonalPathLayouter.Orientation.TOP, 3);
                    this.put(OrthogonalPathLayouter.Orientation.RIGHT, 0);
                    this.put(OrthogonalPathLayouter.Orientation.BOTTOM, 1);
                    this.put(OrthogonalPathLayouter.Orientation.LEFT, 2);
                }
            });
            this.put(OrthogonalPathLayouter.Orientation.BOTTOM, new HashMap<OrthogonalPathLayouter.Orientation, Integer>(){
                {
                    this.put(OrthogonalPathLayouter.Orientation.TOP, 2);
                    this.put(OrthogonalPathLayouter.Orientation.RIGHT, 3);
                    this.put(OrthogonalPathLayouter.Orientation.BOTTOM, 0);
                    this.put(OrthogonalPathLayouter.Orientation.LEFT, 1);
                }
            });
            this.put(OrthogonalPathLayouter.Orientation.LEFT, new HashMap<OrthogonalPathLayouter.Orientation, Integer>(){
                {
                    this.put(OrthogonalPathLayouter.Orientation.TOP, 1);
                    this.put(OrthogonalPathLayouter.Orientation.RIGHT, 2);
                    this.put(OrthogonalPathLayouter.Orientation.BOTTOM, 3);
                    this.put(OrthogonalPathLayouter.Orientation.LEFT, 0);
                }
            });
        }
    };

    private Util() {
    }

    public static Set<Node> getNodes(Node node, Graph graph) {
        HashSet<Node> result = new HashSet<Node>();
        if (graph.getEdges(node) != null) {
            for (Edge edge : graph.getEdges(node)) {
                result.add(edge.to);
                result.add(edge.from);
            }
        }
        return result;
    }

    public static boolean hasFixedNodes(Graph graph) {
        for (Node node : graph.nodeList) {
            if (!node.fixed) continue;
            return true;
        }
        return false;
    }

    public static Rectangle getBounds(Set<Node> nodes) {
        if (nodes == null) {
            return new Rectangle();
        }
        Rectangle rect = null;
        for (Node node : nodes) {
            Rectangle r = node.getBounds();
            if (rect == null) {
                rect = r;
                continue;
            }
            rect = rect.union(r);
        }
        if (rect == null) {
            rect = new Rectangle();
        }
        rect.x -= 10;
        rect.y -= 10;
        rect.width += 20;
        rect.height += 20;
        return rect;
    }

    public static Node getCompartment(Node node, Graph graph) {
        String compartmentName = node.getAttribute("compartmentName");
        if (compartmentName == null) {
            return null;
        }
        return graph.getNode(compartmentName);
    }

    public static Set<Node> getCompartments(Node node, Graph graph) {
        HashSet<Node> compartments = new HashSet<Node>();
        Node compartment = Util.getCompartment(node, graph);
        while (compartment != null) {
            compartments.add(compartment);
            compartment = Util.getCompartment(compartment, graph);
        }
        return compartments;
    }

    public static Integer getLevel(Node node) {
        String path = node.getAttribute("compartmentName");
        if (path == null) {
            return 0;
        }
        return path.length() - path.replace(".", "").length() + 1;
    }

    public static boolean isCompartment(Node node) {
        if (node == null) {
            return false;
        }
        String attr = node.getAttribute("isCompartment");
        return attr != null && attr.toString().equals("true");
    }

    public static boolean areConnected(Node n1, Node n2, Graph graph) {
        return graph.getEdge(n1, n2) != null || graph.getEdge(n2, n1) != null;
    }

    public static void outGraph(String path, Graph graph) {
        try (BufferedWriter buf = new BufferedWriter(new FileWriter(path));){
            String out = graph.generateText(true);
            buf.write(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCommonCompartment(String p1, String p2) {
        if (p1 == null || p2 == null) {
            return null;
        }
        if (p1.contains(p2)) {
            return p2;
        }
        if (p2.contains(p1)) {
            return p1;
        }
        StringBuffer result = new StringBuffer();
        String[] names1 = p1.split("\\.");
        String[] names2 = p2.split("\\.");
        int length = Math.min(names1.length, names2.length);
        for (int i = 0; i < length; ++i) {
            if (!names1[i].equals(names2[i])) continue;
            result.append(names1[i]).append(".");
        }
        if (result.length() != 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static Rectangle getFixedBounds(Graph g) {
        Rectangle rect = null;
        for (Node node : g.nodeList) {
            if (!node.fixed) continue;
            Rectangle r = node.getBounds();
            if (rect == null) {
                rect = r;
                continue;
            }
            rect = rect.union(r);
        }
        for (Edge edge : g.edgeList) {
            Path path;
            if (!edge.fixed || (path = edge.path) == null) continue;
            Rectangle r = path.getBounds();
            if (rect == null) {
                rect = r;
                continue;
            }
            rect = rect.union(r);
        }
        return rect;
    }

    public static Rectangle getBounds(Graph g, Node compartment, int offset) {
        Rectangle rect = null;
        String compartmentName = compartment.getName();
        for (Node node : g.nodeList) {
            if (!compartmentName.equals(node.getAttribute("compartmentName"))) continue;
            Rectangle r = node.getBounds();
            rect = rect == null ? r : rect.union(r);
        }
        if (rect == null) {
            return null;
        }
        rect.x -= offset;
        rect.y -= offset;
        rect.width += 2 * offset;
        rect.height += 2 * offset;
        return rect;
    }

    public static void adjustOrientations(Graph graph) {
        for (Node node : graph.nodeList) {
            if (node.fixed) continue;
            Util.calcOrientation(graph, node);
            node.adjustSize();
        }
    }

    public static void calcOrientation(Graph graph, Node node) {
        String orientationStr = node.getAttribute("orientation");
        if (orientationStr == null) {
            return;
        }
        OrthogonalPathLayouter.Orientation orientation = OrthogonalPathLayouter.Orientation.fromString(orientationStr);
        int[] rotations = new int[4];
        for (Edge e : graph.getEdges(node)) {
            Node otherNode = e.to.equals(node) ? e.from : e.to;
            Point port = node.findPort(node.x, node.y, e);
            Point otherPort = node.findPort(node.x + node.width, node.y + node.height, e);
            if (port.x != otherPort.x || port.y != otherPort.y) continue;
            OrthogonalPathLayouter.Orientation actualPosition = Util.getRelativePosition(node, otherNode);
            OrthogonalPathLayouter.Orientation desiredPosition = Util.getPortLocation(node, port);
            Integer numberOfTurns = numberOfTurnsMap.get((Object)desiredPosition).get((Object)actualPosition);
            int n = numberOfTurns;
            rotations[n] = rotations[n] + 1;
        }
        if (rotations[0] <= rotations[1] || rotations[0] <= rotations[2] || rotations[0] <= rotations[3]) {
            orientation = rotations[1] > rotations[2] && rotations[1] > rotations[3] ? orientation.clockwise() : (rotations[2] > rotations[3] ? orientation.clockwise().clockwise() : orientation.clockwise().clockwise().clockwise());
        }
        node.setAttribute("orientation", orientation.toString());
    }

    protected static OrthogonalPathLayouter.Orientation getPortLocation(Node base, Point p) {
        if (p.x <= base.x) {
            return OrthogonalPathLayouter.Orientation.LEFT;
        }
        if (p.y <= base.y) {
            return OrthogonalPathLayouter.Orientation.TOP;
        }
        if (p.x >= base.x + base.width) {
            return OrthogonalPathLayouter.Orientation.RIGHT;
        }
        return OrthogonalPathLayouter.Orientation.BOTTOM;
    }

    protected static OrthogonalPathLayouter.Orientation getRelativePosition(Node base, Node target) {
        int distX = target.x - base.x + (target.width - base.width) / 2;
        int distY = target.y - base.y + (target.height - base.height) / 2;
        if (Math.abs(distX) > Math.abs(distY)) {
            return distX > 0 ? OrthogonalPathLayouter.Orientation.RIGHT : OrthogonalPathLayouter.Orientation.LEFT;
        }
        return distY > 0 ? OrthogonalPathLayouter.Orientation.BOTTOM : OrthogonalPathLayouter.Orientation.TOP;
    }

    public static Set<Node> getCompartments(Edge edge, Graph graph) {
        HashSet<Node> exclusions = new HashSet<Node>();
        Node comaprtmentFrom = Util.getCompartment(edge.getFrom(), graph);
        Node compartmentTo = Util.getCompartment(edge.getTo(), graph);
        if (comaprtmentFrom != null) {
            exclusions.add(comaprtmentFrom);
        }
        if (compartmentTo != null) {
            exclusions.add(compartmentTo);
        }
        return exclusions;
    }
}

