/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.Util;

public class SubgraphLayouter {
    protected static final Logger log = Logger.getLogger(SubgraphLayouter.class.getName());
    public int layerDeltaX = 50;
    public int layerDeltaY = 50;

    public int getLayerDeltaX() {
        return this.layerDeltaX;
    }

    public void setLayerDeltaX(int layerDeltaX) {
        this.layerDeltaX = layerDeltaX;
    }

    public int getLayerDeltaY() {
        return this.layerDeltaY;
    }

    public void setLayerDeltaY(int layerDeltaY) {
        this.layerDeltaY = layerDeltaY;
    }

    public void doLayout(AbstractLayouter graphLayouter, Graph initialGraph, LayoutJobControl lJC) {
        Point pos;
        Rectangle bounds;
        List<Graph> graphs = initialGraph.split();
        this.sortByFixedNodes(graphs);
        if (lJC != null) {
            lJC.begin();
        }
        RectangleStack rectangleStack = new RectangleStack();
        for (Graph graph : graphs) {
            if (graph.nodeCount() != 1) continue;
            if (graphLayouter != null && graph.edgeCount() > 0) {
                graphLayouter.layoutNodes(graph, lJC);
                graphLayouter.layoutEdges(graph, lJC);
            }
            bounds = graph.getBounds();
            pos = rectangleStack.addRectangle(new Dimension(bounds.width + this.layerDeltaX, bounds.height + this.layerDeltaY));
            graph.setLocationForced(pos.x, pos.y);
        }
        for (Graph graph : graphs) {
            if (graph.nodeCount() == 1) continue;
            if (graphLayouter != null) {
                graphLayouter.layoutNodes(graph, lJC);
            }
            bounds = graph.getBounds();
            pos = rectangleStack.addRectangle(new Dimension(bounds.width + this.layerDeltaX, bounds.height + this.layerDeltaY));
            graph.setLocationForced(pos.x, pos.y);
            if (graphLayouter != null) {
                graphLayouter.layoutEdges(graph, lJC);
            }
            this.savePath(initialGraph, graph);
        }
        int nodeCount = 0;
        int edgeCount = 0;
        for (Graph graph1 : graphs) {
            nodeCount += graph1.nodeCount();
            edgeCount += graph1.edgeCount();
        }
        if (nodeCount != initialGraph.nodeCount()) {
            log.log(Level.SEVERE, "Error in graph split, icorrect node count: " + nodeCount + " but should be " + initialGraph.nodeCount());
        }
        if (edgeCount != initialGraph.edgeCount()) {
            log.log(Level.SEVERE, "Error in graph split, icorrect edge count: " + edgeCount + " but should be " + initialGraph.edgeCount());
        }
    }

    private void sortByFixedNodes(List<Graph> graphs) {
        Collections.sort(graphs, new Comparator<Graph>(){

            @Override
            public int compare(Graph lhs, Graph rhs) {
                Rectangle r1 = Util.getFixedBounds(lhs);
                Rectangle r2 = Util.getFixedBounds(rhs);
                if (r1 == null && r2 == null) {
                    return 0;
                }
                if (r1 == null && r2 != null) {
                    return 1;
                }
                if (r1 != null && r2 == null) {
                    return -1;
                }
                if (r1.x == r2.x && r1.y == r2.y) {
                    return 0;
                }
                return r1.y < r2.y ? -1 : (r1.y > r2.y ? 1 : (r1.x < r2.x ? -1 : 1));
            }
        });
    }

    protected void savePath(Graph initialGraph, Graph processedGraph) {
        Iterator<Edge> iterLevel = processedGraph.edgeIterator();
        while (iterLevel.hasNext()) {
            Edge currLevel = iterLevel.next();
            if (!currLevel.master) continue;
            Iterator<Edge> iterInitial = initialGraph.edgeIterator();
            while (iterInitial.hasNext()) {
                Edge currInitial = iterInitial.next();
                if (!currInitial.master) continue;
                if (currInitial.isReversed()) {
                    currInitial.reverseDirection();
                }
                if (!currLevel.from.name.equals(currInitial.from.name) || !currLevel.to.name.equals(currInitial.to.name)) continue;
                currInitial.path = currLevel.path;
                if (currInitial.slaves == null) continue;
                if (currLevel.slaves != null && currInitial.slaves.size() == currLevel.slaves.size()) {
                    for (int j = 0; j < currInitial.slaves.size(); ++j) {
                        currInitial.slaves.get((int)j).path = currLevel.slaves.get((int)j).path;
                    }
                    continue;
                }
                for (Edge slave : currInitial.slaves) {
                    slave.path = new Path(currLevel.path.xpoints, currLevel.path.ypoints, currLevel.path.npoints);
                }
            }
        }
    }

    private static class RectangleStack {
        int width = 0;
        int height = 0;
        int gapWidth = 0;
        int gapHeight = 0;

        private RectangleStack() {
        }

        public Point addRectangle(Dimension size) {
            double ratio2;
            if (size.width <= 0 || size.height <= 0) {
                return new Point(0, 0);
            }
            if (size.width <= this.gapWidth && size.height <= this.gapHeight) {
                Point result = new Point(this.width - this.gapWidth, this.height - this.gapHeight);
                if ((this.gapWidth - size.width) * this.gapHeight > (this.gapHeight - size.height) * this.gapWidth) {
                    this.gapWidth -= size.width;
                } else {
                    this.gapHeight -= size.height;
                }
                return result;
            }
            double ratio1 = ((double)this.width + (double)size.width) / (double)Math.max(this.height, size.height);
            if (ratio1 > (ratio2 = ((double)this.height + (double)size.height) / (double)Math.max(this.width, size.width))) {
                this.height += size.height;
                if (size.width >= this.width) {
                    this.width = size.width;
                    this.gapHeight = 0;
                    this.gapWidth = 0;
                } else if ((this.gapHeight + size.height) * Math.min(this.width - size.width, this.gapWidth) > size.height * (this.width - size.width)) {
                    this.gapHeight += size.height;
                    this.gapWidth = Math.min(this.width - size.width, this.gapWidth);
                } else {
                    this.gapHeight = size.height;
                    this.gapWidth = this.width - size.width;
                }
                return new Point(0, this.height - size.height);
            }
            this.width += size.width;
            if (size.height > this.height) {
                this.height = size.height;
                this.gapHeight = 0;
                this.gapWidth = 0;
            } else if ((this.gapWidth + size.width) * Math.min(this.height - size.height, this.gapHeight) > size.width * (this.height - size.height)) {
                this.gapWidth += size.width;
                this.gapHeight = Math.min(this.height - size.height, this.gapHeight);
            } else {
                this.gapWidth = size.width;
                this.gapHeight = this.height - size.height;
            }
            return new Point(this.width - size.width, 0);
        }
    }
}

