/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.PathWeighter;

public class SelfLoopLayouter {
    public int loopLength = 30;

    public void doLayout(Graph graph, PathWeighter pathWeighter) {
        for (Edge edge : graph.edgeList) {
            if (edge.fixed || edge.from != edge.to) continue;
            this.layoutPath(graph, edge, pathWeighter);
        }
    }

    public void layoutPath(Graph graph, Edge edge, PathWeighter pathWeighter) {
        Node node = edge.from;
        int xf_1 = node.x + Math.min(this.loopLength, node.width) / 2;
        int xf_2 = node.x + node.width - Math.min(this.loopLength, node.width) / 2;
        int yf_1 = node.y + Math.min(this.loopLength, node.height) / 2;
        int yf_2 = node.y + node.height - Math.min(this.loopLength, node.height) / 2;
        Path[] pathes = new Path[4];
        pathes[0] = new Path();
        pathes[0].addPoint(node.x, yf_1);
        pathes[0].addPoint(node.x - this.loopLength / 2, yf_1);
        pathes[0].addPoint(node.x - this.loopLength / 2, yf_1 - this.loopLength);
        pathes[0].addPoint(xf_1, yf_1 - this.loopLength);
        pathes[0].addPoint(xf_1, node.y);
        pathes[1] = new Path();
        pathes[1].addPoint(xf_2, node.y);
        pathes[1].addPoint(xf_2, node.y - this.loopLength / 2);
        pathes[1].addPoint(xf_2 + this.loopLength, node.y - this.loopLength / 2);
        pathes[1].addPoint(xf_2 + this.loopLength, yf_1);
        pathes[1].addPoint(node.x + node.width, yf_1);
        pathes[2] = new Path();
        pathes[2].addPoint(node.x + node.width, yf_2);
        pathes[2].addPoint(node.x + node.width + this.loopLength / 2, yf_2);
        pathes[2].addPoint(node.x + node.width + this.loopLength / 2, yf_2 + this.loopLength);
        pathes[2].addPoint(xf_2, yf_2 + this.loopLength);
        pathes[2].addPoint(xf_2, node.y + node.height);
        pathes[3] = new Path();
        pathes[3].addPoint(xf_1, node.y + node.height);
        pathes[3].addPoint(xf_1, node.y + node.height + this.loopLength / 2);
        pathes[3].addPoint(xf_1 - this.loopLength, node.y + node.height + this.loopLength / 2);
        pathes[3].addPoint(xf_1 - this.loopLength, yf_2);
        pathes[3].addPoint(node.x, yf_2);
        Path bestPath = null;
        int bestWeight = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int weight = pathWeighter.calcPathWeight(graph, pathes[i], bestWeight);
            if (i == 2) {
                bestWeight -= 100;
            }
            if (weight >= bestWeight) continue;
            bestPath = pathes[i];
            bestWeight = weight;
        }
        edge.path = bestPath;
    }
}

