/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.HierarchicLayouter;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayoutJobControlImpl;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.Util;

public class PathwayLayouter
extends AbstractLayouter {
    private final Layouter layouter;
    private final HashMap<String, Set<Node>> compartmentToNodes = new HashMap();
    private final HashMap<Integer, Set<Node>> levelToNodesMap = new HashMap();
    private final Set<Node> events = new HashSet<Node>();
    private final Set<Node> equations = new HashSet<Node>();
    private final Set<Node> functions = new HashSet<Node>();
    private final Set<Edge> notLayoutedEdges = new HashSet<Edge>();

    public PathwayLayouter(Layouter layouter) {
        this.layouter = layouter;
        if (layouter instanceof AbstractLayouter) {
            this.adjustReactions = ((AbstractLayouter)layouter).isAdjustReactions();
        }
    }

    public Graph prepareGraph(Graph graph) {
        Graph graphToLayout = new Graph();
        for (Node node : graph.nodeList) {
            String type = node.getAttribute("Type");
            if (graph.getEdges(node).isEmpty() && type != null) {
                if (type.equals("Event")) {
                    this.events.add(node);
                    continue;
                }
                if (type.equals("Equation")) {
                    this.equations.add(node);
                    continue;
                }
                if (type.equals("Function")) {
                    this.functions.add(node);
                    continue;
                }
                graphToLayout.addNode(node);
                continue;
            }
            graphToLayout.addNode(node);
        }
        for (Edge edge : graph.edgeList) {
            graphToLayout.addEdge(edge);
        }
        if (this.isAdjustReactions()) {
            this.adjustReactions(graphToLayout);
        }
        this.initMaps(graphToLayout);
        return graphToLayout;
    }

    @Override
    public void doLayout(Graph graph, LayoutJobControl jobControl) {
        block10: {
            try {
                if (jobControl != null) {
                    jobControl.begin();
                }
                Graph graphToLayout = this.prepareGraph(graph);
                if (this.layouter.getInfo().supportCompartments()) {
                    this.layouter.doLayout(graphToLayout, jobControl);
                } else {
                    int levelCount = this.getLevelCount();
                    for (int i = levelCount - 1; i >= 0; --i) {
                        this.layoutLevel(i, graphToLayout, jobControl);
                    }
                    for (Edge edge : this.notLayoutedEdges) {
                        this.layouter.layoutPath(graphToLayout, edge, jobControl);
                    }
                }
                this.postProcess(graphToLayout, true);
                this.layoutMath(graph);
                if (jobControl != null && jobControl instanceof LayoutJobControlImpl) {
                    ((LayoutJobControlImpl)jobControl).resultsAreReady();
                } else if (jobControl != null) {
                    jobControl.terminate();
                }
            }
            catch (Exception ex) {
                if (jobControl == null) break block10;
                jobControl.terminate();
            }
        }
    }

    @Override
    public void layoutNodes(Graph graph, LayoutJobControl jobControl) {
        this.layouter.doLayout(graph, jobControl);
    }

    public void layoutMath(Graph graph) {
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        int y = 0;
        int yMax = 0;
        for (Node node : this.equations) {
            node.x = x1;
            node.y = y;
            y += node.height + 10;
            x2 = Math.max(x2, node.width);
        }
        yMax = y;
        y = 0;
        x2 += 10;
        for (Node node : this.events) {
            node.x = x2;
            node.y = y;
            y += node.height + 10;
            x3 = Math.max(x3, node.width);
        }
        yMax = Math.max(y, yMax);
        y = 0;
        x3 += 10;
        for (Node node : this.functions) {
            node.x = x3;
            node.y = y;
            y += node.height + 10;
        }
        yMax = Math.max(y, yMax);
        for (Node node : graph.nodeList) {
            if (this.events.contains(node) || this.equations.contains(node) || this.functions.contains(node)) continue;
            node.y += yMax;
        }
        for (Edge edge : graph.edgeList) {
            int i = 0;
            while (i < edge.path.npoints) {
                int n = i++;
                edge.path.ypoints[n] = edge.path.ypoints[n] + yMax;
            }
        }
    }

    public int getLevelCount() {
        return this.levelToNodesMap.size();
    }

    public Graph layoutLevel(int level, Graph graph, LayoutJobControl jobControl) {
        Set<Node> nodeList = this.levelToNodesMap.get(level);
        if (nodeList == null) {
            return null;
        }
        Graph levelGraph = this.generateLevelGraph(nodeList, graph);
        HashMap<Node, Point> levelCompartments = new HashMap<Node, Point>();
        for (Node node : nodeList) {
            if (!Util.isCompartment(node)) continue;
            levelCompartments.put(node, new Point(node.getBounds().getLocation()));
        }
        this.layouter.doLayout(levelGraph, jobControl);
        if (this.layouter instanceof HierarchicLayouter) {
            this.makeHierarchicPath(graph, levelGraph);
        }
        for (Node compartment : levelCompartments.keySet()) {
            Point oldLocation = (Point)levelCompartments.get(compartment);
            int shiftX = compartment.x - oldLocation.x;
            int shiftY = compartment.y - oldLocation.y;
            this.moveNodes(compartment, shiftX, shiftY, graph);
            this.moveEdges(compartment, shiftX, shiftY, graph);
        }
        return levelGraph;
    }

    protected Graph generateLevelGraph(Set<Node> nodeList, Graph graph) {
        Graph levelGraph = new Graph();
        for (Node node : nodeList) {
            if (this.compartmentToNodes.containsKey(node.name) && (node.getAttribute("isNotResizable") == null || !Boolean.parseBoolean(node.getAttribute("isNotResizable")))) {
                node.setBounds(Util.getBounds(this.compartmentToNodes.get(node.name)));
            }
            levelGraph.addNode(node);
        }
        for (Edge edge : graph.edgeList) {
            Node from = levelGraph.getNode(edge.from.name);
            Node to = levelGraph.getNode(edge.to.name);
            if (from == null || to == null || !edge.master) continue;
            Edge newEdge = graph.getEdge(from, to);
            if (newEdge == null) {
                newEdge = new Edge(from, to);
            }
            levelGraph.addEdge(newEdge);
            if (edge.slaves == null) continue;
            for (Edge slave : edge.slaves) {
                levelGraph.addEdge(slave);
            }
        }
        for (Node compartment : levelGraph.nodeList) {
            if (!Util.isCompartment(compartment)) continue;
            Set<Node> innerNodes = this.getInnerNodes(compartment, graph);
            for (Node node : innerNodes) {
                List<Edge> edges = graph.getEdges(node);
                if (edges == null) continue;
                for (Edge edge : edges) {
                    Edge newEdge;
                    String curName;
                    Node to = edge.to;
                    Node from = edge.from;
                    if (innerNodes.contains(to) && !innerNodes.contains(from)) {
                        Node newFrom = null;
                        curName = from.name;
                        while (newFrom == null && !curName.isEmpty()) {
                            newFrom = levelGraph.getNode(curName);
                            curName = curName.indexOf(46) == -1 ? "" : curName.substring(0, curName.lastIndexOf(46));
                        }
                        if (newFrom == null) continue;
                        newEdge = new Edge(newFrom, compartment);
                        levelGraph.addEdge(newEdge);
                        this.notLayoutedEdges.add(edge);
                        continue;
                    }
                    if (!innerNodes.contains(from) || innerNodes.contains(to)) continue;
                    Node newTo = null;
                    curName = to.name;
                    while (!curName.isEmpty() && newTo == null) {
                        newTo = levelGraph.getNode(curName);
                        curName = curName.indexOf(46) == -1 ? "" : curName.substring(0, curName.lastIndexOf(46));
                    }
                    if (newTo == null) continue;
                    newEdge = new Edge(compartment, newTo);
                    levelGraph.addEdge(newEdge);
                    this.notLayoutedEdges.add(edge);
                }
            }
        }
        return levelGraph;
    }

    private void moveNodes(Node compartment, int shiftX, int shiftY, Graph graph) {
        Set<Node> nodes = this.compartmentToNodes.get(compartment.name);
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            node.x += shiftX;
            node.y += shiftY;
            this.moveNodes(node, shiftX, shiftY, graph);
            this.moveEdges(node, shiftX, shiftY, graph);
        }
    }

    private void moveEdges(Node compartment, int shiftX, int shiftY, Graph graph) {
        HashSet<Edge> movedEdges = new HashSet<Edge>();
        Set<Node> nodes = this.compartmentToNodes.get(compartment.name);
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            List<Edge> edges = graph.getEdges(node);
            if (edges == null) continue;
            for (Edge edge : edges) {
                if (!nodes.contains(edge.getFrom()) || !nodes.contains(edge.getTo())) continue;
                this.moveEdge(edge, shiftX, shiftY, movedEdges);
                if (edge.slaves == null) continue;
                for (Edge e : edge.slaves) {
                    this.moveEdge(e, shiftX, shiftY, movedEdges);
                }
            }
        }
    }

    private void moveEdge(Edge edge, int shiftX, int shiftY, Set<Edge> movedEdges) {
        if (movedEdges.contains(edge)) {
            return;
        }
        movedEdges.add(edge);
        Path p = edge.getPath();
        int i = 0;
        while (i < p.npoints) {
            int n = i;
            p.xpoints[n] = p.xpoints[n] + shiftX;
            int n2 = i++;
            p.ypoints[n2] = p.ypoints[n2] + shiftY;
        }
    }

    private Set<Node> getInnerNodes(Node compartment, Graph graph) {
        HashSet<Node> result = new HashSet<Node>();
        if (compartment == null) {
            return result;
        }
        Set<Node> nodes = this.compartmentToNodes.get(compartment.name);
        if (nodes != null) {
            for (Node node : nodes) {
                result.add(node);
                result.addAll(this.getInnerNodes(node, graph));
            }
        }
        return result;
    }

    private void postProcess(Graph graph, boolean processEdges) {
        if (!this.layouter.getInfo().supportCompartments()) {
            int levelCount = this.getLevelCount();
            for (int i = levelCount - 1; i >= 0; --i) {
                Set<Node> compartments = this.levelToNodesMap.get(i);
                if (compartments == null) continue;
                for (Node compartment : compartments) {
                    Set<Node> nodes;
                    if (!Util.isCompartment(compartment) || (nodes = this.compartmentToNodes.get(compartment.name)) == null) continue;
                    compartment.setBounds(Util.getBounds(nodes));
                }
            }
        }
        if (!Util.hasFixedNodes(graph)) {
            int dx = Integer.MAX_VALUE;
            int dy = Integer.MAX_VALUE;
            for (Node node : graph.nodeList) {
                dx = Math.min(node.x, dx);
                dy = Math.min(node.y, dy);
            }
            for (Node node : graph.nodeList) {
                node.x -= dx;
                node.y -= dy;
            }
            if (processEdges) {
                for (Edge e : graph.edgeList) {
                    Path p = e.getPath();
                    int i = 0;
                    while (i < p.npoints) {
                        int n = i;
                        p.xpoints[n] = p.xpoints[n] - dx;
                        int n2 = i++;
                        p.ypoints[n2] = p.ypoints[n2] - dy;
                    }
                    e.path = p;
                }
            }
        }
    }

    private void initMaps(Graph graph) {
        Iterator<Node> iter = graph.nodeIterator();
        while (iter.hasNext()) {
            Node node = iter.next();
            Integer level = Util.getLevel(node);
            Set<Node> nodes = this.levelToNodesMap.get(level);
            if (nodes == null) {
                nodes = new HashSet<Node>();
            }
            nodes.add(node);
            this.levelToNodesMap.put(level, nodes);
            Node compartment = Util.getCompartment(node, graph);
            if (compartment == null) continue;
            String compartmentName = compartment.name;
            nodes = this.compartmentToNodes.get(compartmentName);
            if (nodes == null) {
                nodes = new HashSet<Node>();
            }
            nodes.add(node);
            this.compartmentToNodes.put(compartmentName, nodes);
        }
    }

    private void adjustReactions(Graph graph) {
        for (Node node : graph.nodeList) {
            String type = node.getAttribute("Type");
            String path = node.getAttribute("compartmentName");
            if (type == null || !type.equals("Reaction") || path == null) continue;
            Set<Node> nodes = Util.getNodes(node, graph);
            nodes.remove(node);
            if (nodes.size() == 0) continue;
            Node[] arr = nodes.toArray(new Node[nodes.size()]);
            path = arr[0].getAttribute("compartmentName");
            for (int i = 1; i < arr.length; ++i) {
                String newPath = arr[i].getAttribute("compartmentName");
                if (newPath == null) continue;
                path = Util.getCommonCompartment(path, newPath);
            }
            node.setAttribute("compartmentName", path);
        }
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl lJC) {
        this.layouter.layoutEdges(graph, lJC);
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl lJC) {
        this.layouter.layoutPath(graph, edge, lJC);
    }

    @Override
    public int estimate(Graph graph, int what) {
        return this.layouter.estimate(graph, what);
    }

    @Override
    public LayouterInfo getInfo() {
        return this.layouter.getInfo();
    }

    private void makeHierarchicPath(Graph initialGraph, Graph levelGraph) {
        Iterator<Edge> iterInitial = initialGraph.edgeIterator();
        while (iterInitial.hasNext()) {
            Edge currInitial = iterInitial.next();
            if (!currInitial.isReversed()) continue;
            currInitial.reverseDirection();
        }
        Iterator<Edge> iterLevel = levelGraph.edgeIterator();
        while (iterLevel.hasNext()) {
            Edge currLevel = iterLevel.next();
            if (!currLevel.master) continue;
            iterInitial = initialGraph.edgeIterator();
            while (iterInitial.hasNext()) {
                Path p;
                Edge currInitial = iterInitial.next();
                if (!currInitial.master || !currLevel.from.name.equals(currInitial.from.name) || !currLevel.to.name.equals(currInitial.to.name)) continue;
                currInitial.path = p = currLevel.path;
                if (currInitial.slaves == null) continue;
                if (currLevel.slaves != null && currInitial.slaves.size() == currLevel.slaves.size()) {
                    for (int j = 0; j < currInitial.slaves.size(); ++j) {
                        currInitial.slaves.get((int)j).path = currLevel.slaves.get((int)j).path;
                    }
                    continue;
                }
                for (Edge slave : currInitial.slaves) {
                    slave.path = new Path(p.xpoints, p.ypoints, p.npoints);
                }
            }
        }
    }

    private HashMap<Integer, List<Node>> makeHierarchicLevelsList(Graph graph, Layouter layouter) {
        HashMap<Integer, List<Node>> levelMap = new HashMap<Integer, List<Node>>();
        for (Node n : graph.nodeList) {
            ArrayList<Node> levelList = new ArrayList<Node>();
            if (n.data == null) continue;
            int level = ((HierarchicLayouter.LayoutData)n.data).level;
            if (!levelMap.containsKey(level)) {
                levelList.add(n);
                levelMap.put(level, levelList);
                continue;
            }
            levelMap.get(level).add(n);
        }
        return levelMap;
    }

    private Path correctPath(Edge pathEdge, HashMap<Integer, List<Node>> levelMap, boolean isVertical) {
        Point point;
        List<Node> currLevelList;
        int i;
        int j;
        int startLevel = ((HierarchicLayouter.LayoutData)pathEdge.from.data).level;
        int endLevel = ((HierarchicLayouter.LayoutData)pathEdge.to.data).level;
        int increment = 1;
        if (startLevel > endLevel) {
            increment = -1;
        }
        Path p = pathEdge.path;
        int[] xP = p.xpoints;
        int[] yP = p.ypoints;
        if (!isVertical) {
            for (j = 1; j < p.npoints - 1; ++j) {
                yP[j] = yP[j] - (int)(6.0 * Math.random());
            }
        } else {
            for (j = 1; j < p.npoints - 1; ++j) {
                xP[j] = xP[j] - (int)(6.0 * Math.random());
            }
        }
        Vector<Point> newPath = new Vector<Point>();
        Vector<Integer> pointTypes = new Vector<Integer>();
        if (!isVertical) {
            newPath.add(new Point(xP[0], yP[0]));
            i = 0;
            for (i = 1; i < p.npoints; ++i) {
                if (startLevel + increment * i == endLevel) {
                    if (yP[i] == yP[i - 1]) {
                        newPath.add(new Point(xP[i], yP[i]));
                        continue;
                    }
                    newPath.add(this.addBetweenPoint(new Point(xP[i - 1], yP[i - 1]), new Point(xP[i], yP[i])));
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                currLevelList = levelMap.get(startLevel + increment * i);
                if (!this.checkContains(currLevelList, point = new Point(xP[i], yP[i - 1]))) {
                    yP[i] = yP[i - 1];
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                if (i == p.npoints - 1 || i == 1) {
                    newPath.add(this.addBetweenPoint(new Point(xP[i - 1], yP[i - 1]), new Point(xP[i], yP[i])));
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                point = ++i == p.npoints - 1 ? new Point(xP[i], yP[i]) : new Point(xP[i], yP[i - 1]);
                currLevelList = levelMap.get(startLevel + increment * i);
                if (!this.checkContains(currLevelList, point)) {
                    yP[i] = yP[i - 1];
                    newPath.add(this.addBetweenPoint(new Point(xP[i - 2], yP[i - 2]), new Point(xP[i - 1], yP[i - 1])));
                    newPath.add(new Point(xP[i - 1], yP[i - 1]));
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                newPath.add(new Point(xP[i - 1], yP[i - 1]));
                newPath.add(new Point(xP[i], yP[i]));
            }
        } else {
            newPath.add(new Point(xP[0], yP[0]));
            i = 0;
            for (i = 1; i < p.npoints; ++i) {
                if (startLevel + increment * i == endLevel) {
                    if (xP[i] == xP[i - 1]) {
                        newPath.add(new Point(xP[i], yP[i]));
                        continue;
                    }
                    newPath.add(this.addBetweenPoint(new Point(xP[i - 1], yP[i - 1]), new Point(xP[i], yP[i])));
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                currLevelList = levelMap.get(startLevel + increment * i);
                if (!this.checkContains(currLevelList, point = new Point(xP[i - 1], yP[i]))) {
                    xP[i] = xP[i - 1];
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                if (i == p.npoints - 1 || i == 1) {
                    newPath.add(this.addBetweenPoint(new Point(xP[i - 1], yP[i - 1]), new Point(xP[i], yP[i])));
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                point = ++i == p.npoints - 1 ? new Point(xP[i], yP[i]) : new Point(xP[i - 1], yP[i]);
                currLevelList = levelMap.get(startLevel + increment * i);
                if (!this.checkContains(currLevelList, point)) {
                    xP[i] = xP[i - 1];
                    newPath.add(this.addBetweenPoint(new Point(xP[i - 2], yP[i - 2]), new Point(xP[i - 1], yP[i - 1])));
                    newPath.add(new Point(xP[i - 1], yP[i - 1]));
                    newPath.add(new Point(xP[i], yP[i]));
                    continue;
                }
                newPath.add(new Point(xP[i - 1], yP[i - 1]));
                newPath.add(new Point(xP[i], yP[i]));
            }
        }
        pointTypes.add(1);
        for (i = 1; i < newPath.size(); ++i) {
            if (!isVertical) {
                if (((Point)newPath.get((int)i)).y == newPath.get((int)(i - 1)).y) {
                    pointTypes.add(0);
                    continue;
                }
                pointTypes.add(1);
                continue;
            }
            if (((Point)newPath.get((int)i)).x == newPath.get((int)(i - 1)).x) {
                pointTypes.add(0);
                continue;
            }
            pointTypes.add(1);
        }
        this.processConvexes(newPath, pointTypes, isVertical);
        p = new Path();
        for (Point point2 : newPath) {
            p.addPoint(point2.x, point2.y, pointTypes.get(newPath.indexOf(point2)));
        }
        pathEdge.path = p;
        return p;
    }

    private void processConvexes(Vector<Point> newPath, Vector<Integer> pointTypes, boolean vertical) {
        for (int i = 1; i < newPath.size() - 1; ++i) {
            if (newPath.get((int)i).x != (int)((double)(newPath.get((int)(i - 1)).x + newPath.get((int)(i + 1)).x) / 2.0) || newPath.get((int)i).y != (int)((double)(newPath.get((int)(i - 1)).y + newPath.get((int)(i + 1)).y) / 2.0)) continue;
            if (!vertical) {
                if (pointTypes.get(i - 1) == 0) {
                    newPath.get((int)i).y = (int)((double)(8 * newPath.get((int)(i - 1)).y) / 10.0 + (double)(2 * newPath.get((int)(i + 1)).y) / 10.0);
                    continue;
                }
                newPath.get((int)i).y = (int)((double)(2 * newPath.get((int)(i - 1)).y) / 10.0 + (double)(8 * newPath.get((int)(i + 1)).y) / 10.0);
                continue;
            }
            newPath.get((int)i).x = pointTypes.get(i + 1) == 1 ? (int)((double)(8 * newPath.get((int)(i - 1)).x) / 10.0 + (double)(2 * newPath.get((int)(i + 1)).x) / 10.0) : (int)((double)(2 * newPath.get((int)(i - 1)).x) / 10.0 + (double)(8 * newPath.get((int)(i + 1)).x) / 10.0);
        }
    }

    private Point addBetweenPoint(Point start, Point end) {
        int x = (int)((double)(start.x + end.x) / 2.0);
        int y = (int)((double)(start.y + end.y) / 2.0);
        Point between = new Point(x, y);
        return between;
    }

    private boolean checkContains(List<Node> currLevelList, Point point) {
        for (Node n : currLevelList) {
            Rectangle r = n.getBounds();
            r.setLocation(r.x - 1, r.y - 1);
            r.setSize(r.width + 2, r.height + 2);
            if (!r.contains(point)) continue;
            return true;
        }
        return false;
    }
}

