/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Rectangle;
import java.util.Set;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;

public class PathWeighter {
    public static final int nodeIntersectionPenalty = 100000;
    public static final int edgeIntersectionPenalty = 5000;
    int bendPenalty = 500;
    int confluencePenalty = 5;
    int lengthPenalty = 1;

    public int calcPathWeight(Graph graph, Path path, int bestWeight) {
        int i;
        int penalty = 0;
        if ((penalty += this.bendPenalty * (path.npoints - 2)) >= bestWeight) {
            return bestWeight + 1;
        }
        for (i = 0; i < path.npoints - 1; ++i) {
            int dx = path.xpoints[i] - path.xpoints[i + 1];
            int dy = path.ypoints[i] - path.ypoints[i + 1];
            penalty += this.lengthPenalty * (int)Math.sqrt(dx * dx + dy * dy);
        }
        if (penalty >= bestWeight) {
            return bestWeight + 1;
        }
        for (i = 0; i < path.npoints - 1; ++i) {
            int xFrom = Math.min(path.xpoints[i], path.xpoints[i + 1]) - 1;
            int yFrom = Math.min(path.ypoints[i], path.ypoints[i + 1]) - 1;
            int width = Math.abs(path.xpoints[i] - path.xpoints[i + 1]) + 1;
            int height = Math.abs(path.ypoints[i] - path.ypoints[i + 1]) + 1;
            Rectangle rect = new Rectangle(xFrom, yFrom, width, height);
            for (Edge edge : graph.edgeList) {
                if (edge.path == null || edge.path == path || (penalty += 5000 * this.calcIntersections(rect, edge.path)) < bestWeight) continue;
                return bestWeight + 1;
            }
        }
        return penalty;
    }

    public int calcLineWeight(Graph graph, int x1, int y1, int x2, int y2, int maxWeight, Set<Node> exclusions) {
        int penalty = 0;
        if (graph.getIntersectedNode(x1 - 1, y1 - 1, x2 + 1, y2 + 1, exclusions) != null) {
            penalty += 100000;
        }
        if (penalty > maxWeight) {
            return penalty;
        }
        int dx = x1 - x2;
        int dy = y1 - y2;
        if ((penalty += this.lengthPenalty * (int)Math.sqrt(dx * dx + dy * dy)) > maxWeight) {
            return penalty;
        }
        int x = Math.min(x1, x2) - 1;
        int y = Math.min(y1, y2) - 1;
        int width = Math.abs(x2 - x1) + 2;
        int height = Math.abs(y2 - y1) + 2;
        Rectangle rect = new Rectangle(x, y, width, height);
        for (Edge edge : graph.edgeList) {
            if (edge.path == null || (penalty += 5000 * this.calcIntersections(rect, edge.path)) <= maxWeight) continue;
            return maxWeight;
        }
        return penalty;
    }

    protected int calcIntersections(Rectangle rect, Path path) {
        int intersections = 0;
        for (int i = 0; i < path.npoints - 1; ++i) {
            int height;
            int width;
            int yFrom;
            int xFrom = Math.min(path.xpoints[i], path.xpoints[i + 1]) - 1;
            if (!new Rectangle(xFrom, yFrom = Math.min(path.ypoints[i], path.ypoints[i + 1]) - 1, width = Math.abs(path.xpoints[i] - path.xpoints[i + 1]) + 1, height = Math.abs(path.ypoints[i] - path.ypoints[i + 1]) + 1).intersects(rect)) continue;
            ++intersections;
            if (width == rect.width && rect.width == 1) {
                intersections += this.confluencePenalty;
            }
            if (height != rect.height || rect.height != 1) continue;
            intersections += this.confluencePenalty;
        }
        return intersections;
    }
}

