/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.util.Objects;
import ru.biosoft.graph.DiagonalPathLayouter;
import ru.biosoft.graph.HierarchicPathLayouter;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.OrthogonalPathLayouter;

public class PathLayouterWrapper {
    private static String ORTHOGONAL = "Orthogonal Layouter";
    private static String DIAGONAL = "Diagonal Layouter";
    private static String HIERARCHIC = "Hierarchic Layouter";
    private String pathLayouterName;
    private Layouter pathLayouter;

    public PathLayouterWrapper(Layouter layouter) {
        this.pathLayouter = layouter;
        this.pathLayouterName = this.getLayouterNameByClass(layouter);
    }

    public PathLayouterWrapper() {
    }

    public static String[] getTags() {
        return new String[]{ORTHOGONAL, DIAGONAL, HIERARCHIC};
    }

    public boolean hiddenOptions() {
        return !(this.pathLayouter instanceof OrthogonalPathLayouter);
    }

    public static Layouter getPathLayouterByName(String name) {
        if (ORTHOGONAL.equals(name)) {
            return new OrthogonalPathLayouter();
        }
        if (DIAGONAL.equals(name)) {
            return new DiagonalPathLayouter();
        }
        if (HIERARCHIC.equals(name)) {
            return new HierarchicPathLayouter();
        }
        return null;
    }

    private String getLayouterNameByClass(Layouter layouter) {
        if (layouter instanceof OrthogonalPathLayouter) {
            return ORTHOGONAL;
        }
        if (layouter instanceof HierarchicPathLayouter) {
            return HIERARCHIC;
        }
        if (layouter instanceof DiagonalPathLayouter) {
            return DIAGONAL;
        }
        return null;
    }

    public String getPathLayouterName() {
        return this.pathLayouterName;
    }

    public void setPathLayouterName(String pathLayouterName) {
        if (!Objects.equals(this.pathLayouterName, pathLayouterName)) {
            this.pathLayouterName = pathLayouterName;
            this.setPathLayouterOptions(PathLayouterWrapper.getPathLayouterByName(pathLayouterName));
        }
    }

    public Layouter getPathLayouter() {
        return this.pathLayouter;
    }

    public void setPathLayouterOptions(Layouter pathLayouterOptions) {
        this.pathLayouter = pathLayouterOptions;
    }

    public void setPathLayouter(Layouter pathLayouter) {
        this.setPathLayouterOptions(pathLayouter);
        this.pathLayouterName = this.getLayouterNameByClass(pathLayouter);
    }
}

