/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Node;

public class Path
extends Polygon {
    public static final int LINE_TYPE = 0;
    public static final int QUAD_TYPE = 1;
    public static final int CUBIC_TYPE = 2;
    public int[] pointTypes;

    public Path() {
    }

    public Path(String fromString) {
        String[] values = fromString.split(";");
        int n = Integer.parseInt(values[0]);
        if (values.length >= 3 * n + 1) {
            for (int i = 0; i < n; ++i) {
                this.addPoint(Integer.parseInt(values[3 * i + 1]), Integer.parseInt(values[3 * i + 2]), Integer.parseInt(values[3 * i + 3]));
            }
        }
    }

    public Path(int[] xpoints, int[] ypoints, int npoints) {
        super(xpoints, ypoints, npoints);
        this.pointTypes = new int[npoints];
    }

    public Path(int[] xpoints, int[] ypoints, int[] pointTypes, int npoints) {
        super(xpoints, ypoints, npoints);
        if (pointTypes != null) {
            int[] newPointTypes = new int[pointTypes.length];
            System.arraycopy(pointTypes, 0, newPointTypes, 0, npoints);
            this.pointTypes = newPointTypes;
        } else {
            this.pointTypes = new int[npoints];
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.npoints);
        for (int i = 0; i < this.npoints; ++i) {
            sb.append(";");
            sb.append(this.xpoints[i]);
            sb.append(";");
            sb.append(this.ypoints[i]);
            sb.append(";");
            sb.append(this.pointTypes[i]);
        }
        return sb.toString();
    }

    public void removePoint(int n) {
        if (n >= 0 && n < this.npoints) {
            for (int i = n; i < this.npoints - 1; ++i) {
                this.xpoints[i] = this.xpoints[i + 1];
                this.ypoints[i] = this.ypoints[i + 1];
                this.pointTypes[i] = this.pointTypes[i + 1];
            }
            --this.npoints;
        }
    }

    @Override
    public void addPoint(int x, int y) {
        super.addPoint(x, y);
        if (this.pointTypes == null) {
            this.pointTypes = new int[this.npoints];
        } else if (this.pointTypes.length < this.npoints) {
            int[] newPointTypes = new int[this.npoints];
            System.arraycopy(this.pointTypes, 0, newPointTypes, 0, this.pointTypes.length);
            this.pointTypes = newPointTypes;
        }
    }

    public void addPoint(int x, int y, int type) {
        this.addPoint(x, y);
        this.pointTypes[this.npoints - 1] = type;
    }

    public void removeSelfIntersections() {
        if (this.npoints < 5) {
            return;
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (int i = 1; i < this.npoints; ++i) {
            Segment s = new Segment();
            s.x1 = this.xpoints[i - 1];
            s.y1 = this.ypoints[i - 1];
            s.x2 = this.xpoints[i];
            s.y2 = this.ypoints[i];
            segments.add(s);
        }
        int j = 0;
        int k = 0;
        Point cross = null;
        for (j = 0; j < this.npoints - 1; ++j) {
            Segment s2;
            Segment s1 = (Segment)segments.get(j);
            for (k = 0; k < j && (cross = Path.getCross(s1, s2 = (Segment)segments.get(k))) == null; ++k) {
            }
            if (cross != null) break;
        }
        if (cross == null) {
            return;
        }
        for (int r = k + 1; r < j; ++r) {
            this.removePoint(k + 1);
        }
        this.xpoints[k + 1] = cross.x;
        this.ypoints[k + 1] = cross.y;
        this.removeSelfIntersections();
    }

    private static Point getCross(Segment s1, Segment s2) {
        if (s1.isHorizontal() == s2.isHorizontal()) {
            return null;
        }
        if (s1.isHorizontal()) {
            int x2 = s2.x1;
            int y1 = s1.y1;
            if ((x2 - s1.x1) * (x2 - s1.x2) >= 0 || (y1 - s2.y1) * (y1 - s2.y2) >= 0) {
                return null;
            }
            return new Point(x2, y1);
        }
        int x1 = s1.x1;
        int y2 = s2.y1;
        if ((x1 - s2.x1) * (x1 - s2.x2) >= 0 || (y2 - s1.y1) * (y2 - s1.y2) >= 0) {
            return null;
        }
        return new Point(x1, y2);
    }

    public void removeUTurn(Graph g) {
        if (this.npoints < 5) {
            return;
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (int i = 1; i < this.npoints; ++i) {
            Segment s = new Segment();
            s.x1 = this.xpoints[i - 1];
            s.y1 = this.ypoints[i - 1];
            s.x2 = this.xpoints[i];
            s.y2 = this.ypoints[i];
            segments.add(s);
        }
        for (int j = 0; j < this.npoints - 4; ++j) {
            boolean ccwReverse;
            boolean ccwForward;
            Segment s0 = (Segment)segments.get(j);
            Segment s1 = (Segment)segments.get(j + 1);
            Segment s2 = (Segment)segments.get(j + 2);
            Segment s3 = (Segment)segments.get(j + 3);
            Direction d0 = s0.getDirection();
            Direction d1 = s1.getDirection();
            Direction d2 = s2.getDirection();
            Direction d3 = s3.getDirection();
            boolean cwForward = Path.isClockwise(d0, d1) && Path.isClockwise(d1, d2) && !Path.isClockwise(d2, d3);
            boolean bl = ccwForward = !Path.isClockwise(d0, d1) && !Path.isClockwise(d1, d2) && Path.isClockwise(d2, d3);
            if (cwForward || ccwForward) {
                if (!s0.isHorizontal()) {
                    if (!Path.isCovered(this.ypoints[j + 3], this.ypoints[j], s0.getDirection() == Direction.UP) || Path.checkIntersections(g, this.xpoints[j], this.ypoints[j + 3], this.xpoints[j + 3], this.ypoints[j + 3])) continue;
                    this.removePoint(j + 1);
                    this.removePoint(j + 1);
                    this.xpoints[j + 1] = this.xpoints[j];
                    this.removeUTurn(g);
                } else {
                    if (!Path.isCovered(this.xpoints[j + 3], this.xpoints[j], s0.getDirection() == Direction.RIGHT) || Path.checkIntersections(g, this.xpoints[j + 3], this.ypoints[j], this.xpoints[j + 3], this.ypoints[j + 3])) continue;
                    this.removePoint(j + 1);
                    this.removePoint(j + 1);
                    this.ypoints[j + 1] = this.ypoints[j];
                    this.removeUTurn(g);
                }
            }
            boolean cwReverse = !Path.isClockwise(d0, d1) && Path.isClockwise(d1, d2) && Path.isClockwise(d2, d3);
            boolean bl2 = ccwReverse = Path.isClockwise(d0, d1) && !Path.isClockwise(d1, d2) && !Path.isClockwise(d2, d3);
            if (!cwReverse && !ccwReverse) continue;
            if (!s1.isHorizontal()) {
                if (!Path.isCovered(this.ypoints[j + 1], this.ypoints[j + 4], s1.getDirection() == Direction.UP) || Path.checkIntersections(g, this.xpoints[j + 1], this.ypoints[j + 1], this.xpoints[j + 4], this.ypoints[j + 1])) continue;
                this.removePoint(j + 2);
                this.removePoint(j + 2);
                this.xpoints[j + 1] = this.xpoints[j + 2];
                this.removeUTurn(g);
                continue;
            }
            if (!Path.isCovered(this.xpoints[j + 1], this.xpoints[j + 4], s1.getDirection() == Direction.RIGHT) || Path.checkIntersections(g, this.xpoints[j + 1], this.ypoints[j + 1], this.xpoints[j + 1], this.ypoints[j + 4])) continue;
            this.removePoint(j + 2);
            this.removePoint(j + 2);
            this.ypoints[j + 1] = this.ypoints[j + 2];
            this.removeUTurn(g);
        }
    }

    private static boolean isCovered(int connection, int cover, boolean positiveDirection) {
        return connection != cover && connection - cover > 0 == positiveDirection;
    }

    public static boolean checkIntersections(Graph g, int x1, int y1, int x2, int y2) {
        int deltaX = 1;
        int deltaY = 1;
        if (x1 > x2) {
            int x = x2;
            x2 = x1;
            x1 = x;
        }
        if (y1 > y2) {
            int y = y2;
            y2 = y1;
            y1 = y;
        }
        Rectangle rect = new Rectangle(x1 -= deltaX, y1 -= deltaY, (x2 += deltaX) - x1, (y2 += deltaY) - y1);
        for (Node node : g.nodeList) {
            if (!rect.intersects(node.x, node.y, node.width, node.height)) continue;
            return true;
        }
        return false;
    }

    private static boolean isClockwise(Direction from, Direction to) {
        switch (from) {
            case UP: {
                return to == Direction.RIGHT;
            }
            case RIGHT: {
                return to == Direction.DOWN;
            }
            case DOWN: {
                return to == Direction.LEFT;
            }
            case LEFT: {
                return to == Direction.UP;
            }
        }
        return false;
    }

    public static Path concat(Path from, Path to) {
        int i;
        Path result = new Path();
        for (i = 0; i < from.npoints; ++i) {
            result.addPoint(from.xpoints[i], from.ypoints[i], from.pointTypes[i]);
        }
        if (from.xpoints[from.npoints - 1] != to.xpoints[0] || from.ypoints[from.npoints - 1] != to.ypoints[0]) {
            result.addPoint(to.xpoints[0], to.ypoints[0], to.pointTypes[0]);
        }
        for (i = 1; i < to.npoints; ++i) {
            result.addPoint(to.xpoints[i], to.ypoints[i], to.pointTypes[i]);
        }
        return result;
    }

    public double getLastSegmentAngle() {
        if (this.npoints < 2) {
            return 0.0;
        }
        int n = this.npoints;
        int x1 = this.xpoints[n - 2];
        int x2 = this.xpoints[n - 1];
        int y1 = this.ypoints[n - 2];
        int y2 = this.ypoints[n - 1];
        int dx = x2 - x1;
        int dy = y2 - y1;
        double l = Math.sqrt(dx * dx + dy * dy);
        double alpha = Math.asin((double)dy / l);
        if (dx < 0) {
            alpha = Math.PI - alpha;
        }
        return alpha;
    }

    public static Point intersect(Rectangle rect, Point point1, Point point2, int offset) {
        Point result = Path.intersect(point1, point2, new Point(rect.x - offset, rect.y - offset), new Point(rect.x + rect.width + offset, rect.y - offset));
        if (result != null) {
            return result;
        }
        result = Path.intersect(point1, point2, new Point(rect.x + rect.width + offset, rect.y - offset), new Point(rect.x + rect.width + offset, rect.y + rect.height + offset));
        if (result != null) {
            return result;
        }
        result = Path.intersect(point1, point2, new Point(rect.x - offset, rect.y + rect.height + offset), new Point(rect.x + rect.width + offset, rect.y + rect.height + offset));
        if (result != null) {
            return result;
        }
        result = Path.intersect(point1, point2, new Point(rect.x - offset, rect.y - offset), new Point(rect.x - offset, rect.y + rect.height + offset));
        return result;
    }

    private static Point intersect(Point line1Point1, Point line1Point2, Point line2Point1, Point line2Point2) {
        float q = (line1Point1.y - line2Point1.y) * (line2Point2.x - line2Point1.x) - (line1Point1.x - line2Point1.x) * (line2Point2.y - line2Point1.y);
        float d = (line1Point2.x - line1Point1.x) * (line2Point2.y - line2Point1.y) - (line1Point2.y - line1Point1.y) * (line2Point2.x - line2Point1.x);
        if (d == 0.0f) {
            return null;
        }
        float r = q / d;
        q = (line1Point1.y - line2Point1.y) * (line1Point2.x - line1Point1.x) - (line1Point1.x - line2Point1.x) * (line1Point2.y - line1Point1.y);
        float s = q / d;
        if (r < 0.0f || r > 1.0f || s < 0.0f || s > 1.0f) {
            return null;
        }
        Point result = new Point();
        result.x = line1Point1.x + (int)(0.5f + r * (float)(line1Point2.x - line1Point1.x));
        result.y = line1Point1.y + (int)(0.5f + r * (float)(line1Point2.y - line1Point1.y));
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.pointTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        if (this.npoints != other.npoints) {
            return false;
        }
        for (int i = 0; i < this.npoints; ++i) {
            if (this.pointTypes[i] == other.pointTypes[i] && this.xpoints[i] == other.xpoints[i] && this.ypoints[i] == other.ypoints[i]) continue;
            return false;
        }
        return true;
    }

    public Path clone() {
        Path clone = new Path();
        clone.xpoints = new int[this.npoints];
        System.arraycopy(this.xpoints, 0, clone.xpoints, 0, this.npoints);
        clone.ypoints = new int[this.npoints];
        System.arraycopy(this.ypoints, 0, clone.ypoints, 0, this.npoints);
        clone.npoints = this.npoints;
        clone.pointTypes = new int[this.npoints];
        if (this.pointTypes != null) {
            System.arraycopy(this.pointTypes, 0, clone.pointTypes, 0, this.npoints);
        }
        return clone;
    }

    static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    class Segment {
        int x1;
        int y1;
        int x2;
        int y2;

        Segment() {
        }

        public boolean isHorizontal() {
            return this.y1 == this.y2;
        }

        public Direction getDirection() {
            if (this.isHorizontal()) {
                if (this.x1 < this.x2) {
                    return Direction.RIGHT;
                }
                return Direction.LEFT;
            }
            if (this.y1 < this.y2) {
                return Direction.UP;
            }
            return Direction.DOWN;
        }
    }
}

