/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.DiagonalPathLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Face;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.OrthogonalPathFinder;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.PathWeighter;
import ru.biosoft.graph.SelfLoopLayouter;
import ru.biosoft.graph.Util;

public class OrthogonalPathLayouter
extends AbstractLayouter {
    protected static final Logger log = Logger.getLogger(OrthogonalPathLayouter.class.getName());
    Orientation orientation = Orientation.NONE;
    public static final double RADIUS = 5.0;
    public static final int MINIMAL_SIZE = 15;
    public static final String OLD_WIDTH_ATTR = "oldWidth";
    public static final String OLD_HEIGHT_ATTR = "oldHeight";
    private boolean smoothEdges = false;
    public int gridX = 10;
    public int gridY = 10;
    private int iterationMax = 7;
    private int iterationK = 3;
    private boolean oneEdgeToPoint = false;
    private int portExchangeMax = 5;
    private final SelfLoopLayouter selfLoopLayouter = new SelfLoopLayouter();
    private final DiagonalPathLayouter stubPathLayouter = new DiagonalPathLayouter();
    private final Shift[] shifts;
    private final List<Integer> intersections = new ArrayList<Integer>();

    public String getOrientation() {
        return this.orientation.toString();
    }

    public void setOrientation(String text) {
        this.orientation = Orientation.fromString(text);
    }

    public boolean isSmoothEdges() {
        return this.smoothEdges;
    }

    public void setSmoothEdges(boolean smoothEdges) {
        this.smoothEdges = smoothEdges;
    }

    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
    }

    public int getIterationMax() {
        return this.iterationMax;
    }

    public void setIterationMax(int iterationMax) {
        this.iterationMax = iterationMax;
    }

    public int getIterationK() {
        return this.iterationMax;
    }

    public void setIterationK(int iterationK) {
        this.iterationK = iterationK;
    }

    public void setOneEdgeToPoint(boolean oneEdgeToPoint) {
        this.oneEdgeToPoint = oneEdgeToPoint;
    }

    public void setPortExchangeMax(int portExchangeMax) {
        this.portExchangeMax = portExchangeMax;
    }

    public OrthogonalPathLayouter(int gridX, int gridY) {
        this();
        this.gridX = gridX;
        this.gridY = gridY;
    }

    public OrthogonalPathLayouter() {
        this.shifts = new Shift[8];
        this.shifts[0] = new Shift(-1, 0);
        this.shifts[1] = new Shift(1, 0);
        this.shifts[2] = new Shift(-2, 0);
        this.shifts[3] = new Shift(2, 0);
        this.shifts[4] = new Shift(0, -1);
        this.shifts[5] = new Shift(0, -2);
        this.shifts[6] = new Shift(0, 2);
        this.shifts[7] = new Shift(0, 1);
    }

    @Override
    public void layoutNodes(Graph graph, LayoutJobControl jobControl) {
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl lJC) {
        if (this.smoothEdges) {
            this.preprocess(graph);
            this.doLayoutEdges(graph, lJC);
            this.postproces(graph);
        } else {
            this.doLayoutEdges(graph, lJC);
        }
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl lJC) {
        if (edge.fixed) {
            return;
        }
        if (this.smoothEdges) {
            this.preprocess(graph);
            this.doLayoutPath(graph, edge, lJC);
            this.postproces(graph);
        } else {
            this.doLayoutPath(graph, edge, lJC);
        }
    }

    public void doLayoutEdges(Graph graph, LayoutJobControl jobControl) {
        for (Edge edge : graph.edgeList) {
            if (edge.fixed) continue;
            edge.setPath(null);
        }
        for (Edge edge : graph.edgeList) {
            int weight;
            if (edge.fixed || edge.getFrom() == edge.getTo() || (this.createHorisontalLinePath(graph, edge) || this.createVerticalLinePath(graph, edge)) && (weight = this.pathWeighter.calcPathWeight(graph, edge.getPath(), 5000)) < 5000) continue;
            edge.setPath(null);
        }
        this.selfLoopLayouter.doLayout(graph, this.pathWeighter);
        for (Edge edge : graph.edgeList) {
            if (edge.fixed || edge.getPath() != null) continue;
            this.createPath(graph, edge, this.pathWeighter);
        }
        for (int i = 0; i < this.portExchangeMax && this.refinePorts(graph, this.pathWeighter); ++i) {
        }
        this.refinePaths(graph, this.pathWeighter);
        for (Edge edge : graph.edgeList) {
            if (edge.fixed || edge.getPath() == null) continue;
            edge.getPath().removeSelfIntersections();
            edge.getPath().removeUTurn(graph);
        }
        for (Edge edge : graph.edgeList) {
            if (edge.fixed || edge.getPath() == null) continue;
            Path p = edge.getPath();
            Point start = edge.getFrom().findPort(p.xpoints[0], p.ypoints[0], edge);
            Point finish = edge.getTo().findPort(p.xpoints[p.npoints - 1], p.ypoints[p.npoints - 1], edge);
            p.xpoints[0] = start.x;
            p.ypoints[0] = start.y;
            p.xpoints[p.npoints - 1] = finish.x;
            p.ypoints[p.npoints - 1] = finish.y;
        }
    }

    @Override
    public int estimate(Graph graph, int what) {
        return 0;
    }

    @Override
    public LayouterInfo getInfo() {
        return new LayouterInfoSupport(true, false, false, false, false, false);
    }

    public void doLayoutPath(Graph graph, Edge edge, LayoutJobControl jobControl) {
        edge.setPath(null);
        if (edge.getFrom() == edge.getTo()) {
            this.selfLoopLayouter.layoutPath(graph, edge, this.pathWeighter);
            return;
        }
        Path straightPath = null;
        int straightWeight = Integer.MAX_VALUE;
        if (this.createHorisontalLinePath(graph, edge) || this.createVerticalLinePath(graph, edge)) {
            straightWeight = this.pathWeighter.calcPathWeight(graph, edge.getPath(), 5000);
            if (straightWeight < 5000) {
                return;
            }
            straightPath = edge.getPath();
        }
        edge.setPath(null);
        if (this.createPath(graph, edge, this.pathWeighter) > straightWeight) {
            edge.setPath(straightPath);
        }
        this.refinePaths(graph, edge, this.pathWeighter);
    }

    public boolean createHorisontalLinePath(Graph graph, Edge edge) {
        int yk;
        int x2;
        int x1;
        int y2;
        int dy;
        int y1;
        int y;
        if (this.orientation == Orientation.TOP || this.orientation == Orientation.BOTTOM) {
            return false;
        }
        Node from = edge.getFrom();
        Node to = edge.getTo();
        HashSet<Node> exclusions = new HashSet<Node>();
        Node comaprtmentFrom = Util.getCompartment(from, graph);
        Node compartmentTo = Util.getCompartment(to, graph);
        if (comaprtmentFrom != null) {
            exclusions.add(comaprtmentFrom);
        }
        if (compartmentTo != null) {
            exclusions.add(compartmentTo);
        }
        if ((y = (y1 = Math.max(from.y, to.y)) + (dy = (y2 = Math.min(from.y + from.height, to.y + to.height)) - y1) / 2 / this.gridY * this.gridY) < y1 - 3) {
            return false;
        }
        if (from.x < to.x) {
            x1 = from.x + from.width;
            x2 = to.x;
        } else {
            x1 = from.x;
            x2 = to.x + to.width;
        }
        Point newFrom1 = from.findPort(x1, y, edge);
        Point newTo1 = to.findPort(x2, newFrom1.y, edge);
        Point newTo2 = to.findPort(x2, y, edge);
        Point newFrom2 = from.findPort(x1, newTo2.y, edge);
        if (!(this.createPath(edge, x1, y, x2, y, false) || this.createPath(edge, newFrom1.x, newFrom1.y, newTo1.x, newTo1.y, false) || this.createPath(edge, newFrom2.x, newFrom2.y, newTo2.x, newTo2.y, false))) {
            return false;
        }
        Node node = graph.getIntersectedNode(x1, y - this.gridY, x2, y + this.gridY, exclusions);
        if (node == null) {
            return true;
        }
        if (node.y - y1 < this.gridY + 1 && y2 - node.y - node.height < this.gridY + 1) {
            return false;
        }
        int k = dy / this.gridY;
        if (k == 1 && graph.getIntersectedNode(x1, (yk = y + this.gridY) - this.gridY, x2, yk + this.gridY, exclusions) == null && this.createPath(edge, x1, yk, x2, yk, false)) {
            return true;
        }
        k /= 2;
        for (int i = 1; i < k; ++i) {
            yk = y + i * this.gridY;
            if (graph.getIntersectedNode(x1, yk - this.gridY, x2, yk + this.gridY, exclusions) == null && this.createPath(edge, x1, yk, x2, yk, false)) {
                return true;
            }
            yk = y - i * this.gridY;
            if (graph.getIntersectedNode(x1, yk - this.gridY, x2, yk + this.gridY, exclusions) != null || !this.createPath(edge, x1, yk, x2, yk, false)) continue;
            return true;
        }
        return false;
    }

    public boolean createVerticalLinePath(Graph graph, Edge edge) {
        int xk;
        int y2;
        int y1;
        int x2;
        int dx;
        if (this.orientation == Orientation.LEFT || this.orientation == Orientation.RIGHT) {
            return false;
        }
        Node from = edge.getFrom();
        Node to = edge.getTo();
        Set<Node> exclusions = Util.getCompartments(edge, graph);
        int x1 = Math.max(from.x, to.x);
        int x = x1 + (dx = (x2 = Math.min(from.x + from.width, to.x + to.width)) - x1) / 2 / this.gridX * this.gridX;
        if (x < x1 - 3) {
            return false;
        }
        if (from.y < to.y) {
            y1 = from.y + from.height;
            y2 = to.y;
        } else {
            y1 = from.y;
            y2 = to.y + to.height;
        }
        Point newFrom1 = from.findPort(x, y1, edge);
        Point newTo1 = to.findPort(newFrom1.x, y2, edge);
        Point newTo2 = to.findPort(x, y2, edge);
        Point newFrom2 = from.findPort(newTo2.x, y1, edge);
        if (!(this.createPath(edge, x, y1, x, y2, true) || this.createPath(edge, newFrom1.x, newFrom1.y, newTo1.x, newTo1.y, true) || this.createPath(edge, newFrom2.x, newFrom2.y, newTo2.x, newTo2.y, true))) {
            return false;
        }
        Node node = graph.getIntersectedNode(x - this.gridX, y1, x + this.gridX, y2, exclusions);
        if (node == null) {
            return true;
        }
        if (node.x - x1 < this.gridX + 1 && x2 - node.x - node.width < this.gridX + 1) {
            return false;
        }
        int k = dx / this.gridX;
        if (k == 1 && graph.getIntersectedNode(y1, (xk = x + this.gridX) - this.gridX, x2, xk + this.gridX, exclusions) == null && this.createPath(edge, y1, xk, y2, xk, false)) {
            return true;
        }
        k /= 2;
        for (int i = 1; i < k; ++i) {
            xk = x + i * this.gridX;
            if (graph.getIntersectedNode(xk - this.gridX, y1, xk + this.gridX, y2, exclusions) == null && this.createPath(edge, xk, y1, xk, y2, true)) {
                return true;
            }
            xk = x - i * this.gridX;
            if (graph.getIntersectedNode(xk - this.gridX, y1, xk + this.gridX, y2, exclusions) != null || !this.createPath(edge, xk, y1, xk, y2, true)) continue;
            return true;
        }
        return false;
    }

    private boolean createPath(Edge edge, int x1, int y1, int x2, int y2, boolean isVertical) {
        edge.setPath(null);
        Point pFrom = edge.getFrom().findPort(x1, y1, edge);
        Point pTo = edge.getTo().findPort(x2, y2, edge);
        Node from = edge.getFrom();
        Node to = edge.getTo();
        if (isVertical ? pFrom.x != pTo.x || pFrom.x < from.x || pFrom.x > from.x + from.width || pTo.x < to.x || pTo.x > to.x + to.width || Math.abs(pFrom.y - y1) > from.width / 2 || Math.abs(pTo.y - y2) > to.width / 2 : pFrom.y != pTo.y || pFrom.y < from.y || pFrom.y > from.y + from.height || pTo.y < to.y || pTo.y > to.y + to.height || Math.abs(pFrom.x - x1) > from.height / 2 || Math.abs(pTo.x - x2) > to.height / 2) {
            return false;
        }
        edge.setPath(new Path(new int[]{pFrom.x, pTo.x}, new int[]{pFrom.y, pTo.y}, 2));
        return true;
    }

    private int createPath(Graph graph, Edge edge, PathWeighter pathWeighter) {
        int weight = this.createPath(graph, edge, this.iterationMax, pathWeighter);
        if (edge.getPath() == null) {
            log.log(Level.FINE, "can not find path for edge: " + edge.toString());
            this.stubPathLayouter.layoutPath(graph, edge, pathWeighter);
        }
        return weight;
    }

    private int createPath(Graph graph, Edge edge, int iterMax, PathWeighter pathWeighter) {
        int i;
        Node from = edge.getFrom();
        Node to = edge.getTo();
        Set<Node> exc = Util.getCompartments(edge, graph);
        Face fromFace = new Face(graph, from, edge, this.gridX, this.gridY, this.oneEdgeToPoint, this.orientation);
        Face toFace = new Face(graph, to, edge, this.gridX, this.gridY, this.oneEdgeToPoint, this.orientation);
        int fromCount = fromFace.size();
        int toCount = toFace.size();
        int totalCount = fromCount * toCount;
        OrthogonalPathFinder[] finders = new OrthogonalPathFinder[fromCount * toCount];
        for (i = 0; i < fromCount; ++i) {
            Point pFrom = fromFace.startPoints.get(fromFace.points.get(i));
            for (int j = 0; j < toCount; ++j) {
                Point pTo = toFace.startPoints.get(toFace.points.get(j));
                int toX = pTo.x;
                int toY = pTo.y;
                finders[i * toCount + j] = new OrthogonalPathFinder(graph, exc, pFrom.x, pFrom.y, toX, toY, this.gridX, this.gridY);
            }
        }
        for (int n = iterMax; n > 0; --n) {
            for (int k = 0; k < totalCount; ++k) {
                finders[k].nextStep();
                if (!finders[k].hasSolution() || n <= this.iterationK) continue;
                n = this.iterationK;
            }
        }
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (i = 0; i < fromCount; ++i) {
            Point pFrom = fromFace.startPoints.get(fromFace.points.get(i));
            for (int j = 0; j < toCount; ++j) {
                Point pTo = toFace.startPoints.get(toFace.points.get(j));
                int toXs = pTo.x;
                int toYs = pTo.y;
                List<Path> paths = finders[i * toCount + j].getSolutions();
                if (paths == null) continue;
                for (Path path : paths) {
                    pathList.add(this.createPath(pFrom.x, pFrom.y, path, toXs, toYs));
                }
            }
        }
        Path bestPath = null;
        int bestWeight = Integer.MAX_VALUE;
        for (i = 0; i < pathList.size(); ++i) {
            Path path = (Path)pathList.get(i);
            this.optimisePath(path);
            int weight = pathWeighter.calcPathWeight(graph, path, bestWeight);
            if (weight >= bestWeight) continue;
            bestPath = path;
            bestWeight = weight;
        }
        if ((bestPath = this.simplifyPath(graph, bestPath, bestWeight, pathWeighter)) != null) {
            edge.setPath(bestPath);
            return pathWeighter.calcPathWeight(graph, bestPath, bestWeight);
        }
        return bestWeight;
    }

    private Path simplifyPath(Graph graph, Path bestPath, int bestWeight, PathWeighter pathWeighter) {
        Path path = bestPath;
        if (path != null && path.npoints >= 5) {
            boolean needMoreIteration = true;
            block0: while (needMoreIteration) {
                needMoreIteration = false;
                for (int i = 0; i < path.npoints - 4; ++i) {
                    int weight;
                    Path newPath = this.createSimplifyPath(graph, path, i);
                    if (newPath == null || (weight = pathWeighter.calcPathWeight(graph, newPath, bestWeight)) > bestWeight) continue;
                    path = newPath;
                    bestWeight = weight;
                    needMoreIteration = true;
                    continue block0;
                }
            }
        }
        return path;
    }

    private Path createSimplifyPath(Graph graph, Path basePath, int pos) {
        Path newPath = new Path();
        for (int i = 0; i < pos + 1; ++i) {
            newPath.addPoint(basePath.xpoints[i], basePath.ypoints[i]);
        }
        Point newPoint = null;
        if (basePath.ypoints[pos] == basePath.ypoints[pos + 1] && basePath.xpoints[pos + 3] == basePath.xpoints[pos + 4]) {
            newPoint = new Point(basePath.xpoints[pos + 3], basePath.ypoints[pos]);
        } else if (basePath.xpoints[pos] == basePath.xpoints[pos + 1] && basePath.ypoints[pos + 3] == basePath.ypoints[pos + 4]) {
            newPoint = new Point(basePath.xpoints[pos], basePath.ypoints[pos + 3]);
        } else {
            return null;
        }
        if (Path.checkIntersections(graph, basePath.xpoints[pos], basePath.ypoints[pos], newPoint.x, newPoint.y) || Path.checkIntersections(graph, newPoint.x, newPoint.y, basePath.xpoints[pos + 4], basePath.ypoints[pos + 4])) {
            return null;
        }
        newPath.addPoint(newPoint.x, newPoint.y);
        for (int i = pos + 4; i < basePath.npoints; ++i) {
            newPath.addPoint(basePath.xpoints[i], basePath.ypoints[i]);
        }
        return newPath;
    }

    private void optimisePath(Path path) {
        boolean optimise = false;
        for (int i = 0; i < path.npoints - 2; ++i) {
            if ((path.xpoints[i] != path.xpoints[i + 1] || path.xpoints[i + 1] != path.xpoints[i + 2]) && (path.ypoints[i] != path.ypoints[i + 1] || path.ypoints[i + 1] != path.ypoints[i + 2])) continue;
            path.removePoint(i + 1);
            optimise = true;
            break;
        }
        if (optimise) {
            this.optimisePath(path);
        }
    }

    private Path createPath(int xFrom, int yFrom, Path subPath, int xTo, int yTo) {
        Path path = new Path();
        path.addPoint(xFrom, yFrom);
        for (int i = 0; i < subPath.npoints; ++i) {
            path.addPoint(subPath.xpoints[i], subPath.ypoints[i]);
        }
        path.addPoint(xTo, yTo);
        return path;
    }

    private void refinePaths(Graph graph, PathWeighter pathWeighter) {
        int edgeCount = graph.edgeCount();
        for (int k1 = 0; k1 < edgeCount; ++k1) {
            Edge e1 = graph.edgeList.get(k1);
            if (e1.fixed) continue;
            for (int k2 = k1 + 1; k2 < edgeCount; ++k2) {
                Edge e2 = graph.edgeList.get(k2);
                if (e2.fixed) continue;
                this.refine(graph, e1, e2, pathWeighter);
            }
        }
    }

    private void refinePaths(Graph graph, Edge e, PathWeighter pathWeighter) {
        int edgeCount = graph.edgeCount();
        for (int i = 1; i < edgeCount; ++i) {
            Edge e2 = graph.edgeList.get(i);
            if (e.equals(e2)) continue;
            this.refine(graph, e, e2, pathWeighter);
        }
    }

    private void refine(Graph graph, Edge e1, Edge e2, PathWeighter pathWeighter) {
        if (e1.getPath() == null || e2.getPath() == null) {
            return;
        }
        if (this.calcIntersections(e1, e2)) {
            int s;
            int s1 = this.intersections.get(0);
            int s2 = this.intersections.get(1);
            Path p1 = e1.getPath();
            Path p2 = e2.getPath();
            Set<Node> exc1 = Util.getCompartments(e1, graph);
            Set<Node> exc2 = Util.getCompartments(e2, graph);
            boolean vertical = p1.xpoints[s1] == p1.xpoints[s1 + 1];
            int delta = vertical ? this.gridX : this.gridY;
            boolean first = true;
            int position = 0;
            int bestWeight = this.calcSegmentWeight(graph, vertical, Integer.MAX_VALUE, p1, s1, 0, p2, s2, 0, pathWeighter, exc1, exc2);
            for (Shift shift : this.shifts) {
                int weight = this.calcSegmentWeight(graph, vertical, bestWeight, p1, s1, delta * shift.first, p2, s2, delta * shift.second, pathWeighter, exc1, exc2);
                if (weight >= bestWeight) continue;
                bestWeight = weight;
                first = shift.first != 0;
                position = first ? delta * shift.first : delta * shift.second;
            }
            Path p = first ? p1 : p2;
            int n = s = first ? s1 : s2;
            if (vertical) {
                int n2 = s;
                p.xpoints[n2] = p.xpoints[n2] + position;
                int n3 = s + 1;
                p.xpoints[n3] = p.xpoints[n3] + position;
            } else {
                int n4 = s;
                p.ypoints[n4] = p.ypoints[n4] + position;
                int n5 = s + 1;
                p.ypoints[n5] = p.ypoints[n5] + position;
            }
        }
    }

    private boolean refinePorts(Graph graph, PathWeighter pathWeighter) {
        int edgeCount = graph.edgeCount();
        boolean result = false;
        for (int k1 = 0; k1 < edgeCount; ++k1) {
            Edge e1 = graph.edgeList.get(k1);
            if (e1.fixed) continue;
            for (int k2 = k1 + 1; k2 < edgeCount; ++k2) {
                Edge e2 = graph.edgeList.get(k2);
                if (e2.fixed || e1.getPath() == null || e2.getPath() == null || e1.getFrom() != e2.getFrom() && e1.getFrom() != e2.getTo() && e1.getTo() != e2.getFrom() && e1.getTo() != e2.getTo() || !this.isIntersected(e1, e2) || !this.refinePort(graph, e1, e2, pathWeighter)) continue;
                result = true;
            }
        }
        return result;
    }

    private boolean refinePort(Graph graph, Edge e1, Edge e2, PathWeighter pathWeighter) {
        int currentWeight = pathWeighter.calcPathWeight(graph, e1.getPath(), Integer.MAX_VALUE);
        currentWeight += pathWeighter.calcPathWeight(graph, e2.getPath(), Integer.MAX_VALUE);
        Path oldPath1 = e1.getPath();
        Path oldPath2 = e2.getPath();
        Point input1 = new Point();
        Point output1 = new Point();
        Point input2 = new Point();
        Point output2 = new Point();
        if (e1.getFrom() == e2.getFrom()) {
            input1.x = oldPath2.xpoints[0];
            input1.y = oldPath2.ypoints[0];
            input2.x = oldPath1.xpoints[0];
            input2.y = oldPath1.ypoints[0];
            output1.x = oldPath1.xpoints[oldPath1.npoints - 1];
            output1.y = oldPath1.ypoints[oldPath1.npoints - 1];
            output2.x = oldPath2.xpoints[oldPath2.npoints - 1];
            output2.y = oldPath2.ypoints[oldPath2.npoints - 1];
        } else if (e1.getFrom() == e2.getTo()) {
            input1.x = oldPath2.xpoints[oldPath2.npoints - 1];
            input1.y = oldPath2.ypoints[oldPath2.npoints - 1];
            input2.x = oldPath2.xpoints[0];
            input2.y = oldPath2.ypoints[0];
            output1.x = oldPath1.xpoints[oldPath1.npoints - 1];
            output1.y = oldPath1.ypoints[oldPath1.npoints - 1];
            output2.x = oldPath1.xpoints[0];
            output2.y = oldPath1.ypoints[0];
        } else if (e1.getTo() == e2.getFrom()) {
            input1.x = oldPath1.xpoints[0];
            input1.y = oldPath1.ypoints[0];
            input2.x = oldPath1.xpoints[oldPath1.npoints - 1];
            input2.y = oldPath1.ypoints[oldPath1.npoints - 1];
            output1.x = oldPath2.xpoints[0];
            output1.y = oldPath2.ypoints[0];
            output2.x = oldPath2.xpoints[oldPath2.npoints - 1];
            output2.y = oldPath2.ypoints[oldPath2.npoints - 1];
        } else if (e1.getTo() == e2.getTo()) {
            input1.x = oldPath1.xpoints[0];
            input1.y = oldPath1.ypoints[0];
            input2.x = oldPath2.xpoints[0];
            input2.y = oldPath2.ypoints[0];
            output1.x = oldPath2.xpoints[oldPath2.npoints - 1];
            output1.y = oldPath2.ypoints[oldPath2.npoints - 1];
            output2.x = oldPath1.xpoints[oldPath1.npoints - 1];
            output2.y = oldPath1.ypoints[oldPath1.npoints - 1];
        }
        input1 = e1.getFrom().findPort(input1.x, input1.y, e1);
        output1 = e1.getTo().findPort(output1.x, output1.y, e1);
        input2 = e2.getFrom().findPort(input2.x, input2.y, e2);
        output2 = e2.getTo().findPort(output2.x, output2.y, e2);
        Set<Node> exc1 = Util.getCompartments(e1, graph);
        OrthogonalPathFinder finderE1 = new OrthogonalPathFinder(graph, exc1, input1.x, input1.y, output1.x, output1.y, this.gridX, this.gridY);
        for (int i = 0; i < this.iterationMax; ++i) {
            finderE1.nextStep();
            if (finderE1.hasSolution()) break;
        }
        Set<Node> exc2 = Util.getCompartments(e2, graph);
        OrthogonalPathFinder finderE2 = new OrthogonalPathFinder(graph, exc2, input2.x, input2.y, output2.x, output2.y, this.gridX, this.gridY);
        for (int i = 0; i < this.iterationMax; ++i) {
            finderE2.nextStep();
            if (finderE2.hasSolution()) break;
        }
        if (finderE1.hasSolution() && finderE2.hasSolution()) {
            Path newPathE1 = finderE1.getSolutions().get(0);
            this.optimisePath(newPathE1);
            newPathE1 = this.simplifyPath(graph, newPathE1, pathWeighter.calcPathWeight(graph, newPathE1, Integer.MAX_VALUE), pathWeighter);
            Path newPathE2 = finderE2.getSolutions().get(0);
            this.optimisePath(newPathE2);
            newPathE2 = this.simplifyPath(graph, newPathE2, pathWeighter.calcPathWeight(graph, newPathE2, Integer.MAX_VALUE), pathWeighter);
            e1.setPath(null);
            e2.setPath(null);
            int newWeight = pathWeighter.calcPathWeight(graph, newPathE1, currentWeight);
            if ((newWeight += pathWeighter.calcPathWeight(graph, newPathE2, currentWeight)) < currentWeight) {
                e1.setPath(newPathE1);
                e2.setPath(newPathE2);
                return true;
            }
            e1.setPath(oldPath1);
            e2.setPath(oldPath2);
        }
        return false;
    }

    private int calcSegmentWeight(Graph graph, boolean vertical, int maxWeight, Path p1, int s1, int shift1, Path p2, int s2, int shift2, PathWeighter pathWeighter, Set<Node> exc1, Set<Node> exc2) {
        int weight = 0;
        if (shift1 != 0 && (s1 == 0 || s1 == p1.npoints - 1) || shift2 != 0 && (s2 == 0 || s2 == p2.npoints - 1)) {
            return Integer.MAX_VALUE;
        }
        weight += pathWeighter.calcLineWeight(graph, p1.xpoints[s1] + (vertical ? shift1 : 0), p1.ypoints[s1] + (vertical ? 0 : shift1), p1.xpoints[s1 + 1] + (vertical ? shift1 : 0), p1.ypoints[s1 + 1] + (vertical ? 0 : shift1), maxWeight, exc1);
        return weight += pathWeighter.calcLineWeight(graph, p2.xpoints[s2] + (vertical ? shift2 : 0), p2.ypoints[s2] + (vertical ? 0 : shift2), p2.xpoints[s2 + 1] + (vertical ? shift2 : 0), p2.ypoints[s2 + 1] + (vertical ? 0 : shift2), maxWeight, exc2);
    }

    private boolean calcIntersections(Edge e1, Edge e2) {
        this.intersections.clear();
        boolean confluences = false;
        Path path1 = e1.getPath();
        Path path2 = e2.getPath();
        for (int i = 0; i < path1.npoints - 1; ++i) {
            int tx = Math.min(path1.xpoints[i], path1.xpoints[i + 1]) - 1;
            int ty = Math.min(path1.ypoints[i], path1.ypoints[i + 1]) - 1;
            int tw = Math.max(path1.xpoints[i], path1.xpoints[i + 1]) + 1;
            int th = Math.max(path1.ypoints[i], path1.ypoints[i + 1]) + 1;
            for (int j = 0; j < path2.npoints - 1; ++j) {
                int rx = Math.min(path2.xpoints[j], path2.xpoints[j + 1]) - 1;
                int ry = Math.min(path2.ypoints[j], path2.ypoints[j + 1]) - 1;
                int rw = Math.max(path2.xpoints[j], path2.xpoints[j + 1]) + 1;
                int rh = Math.max(path2.ypoints[j], path2.ypoints[j + 1]) + 1;
                if (rw >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry || (rx != tx || rw - rx != 2 || tw - tx != 2) && (ry != ty || rh - ry != 2 || th - ty != 2)) continue;
                this.intersections.add(i);
                this.intersections.add(j);
                confluences = true;
                this.intersections.add(1);
            }
        }
        return confluences;
    }

    private boolean isIntersected(Edge e1, Edge e2) {
        Path path1 = e1.getPath();
        Path path2 = e2.getPath();
        for (int i = 0; i < path1.npoints - 1; ++i) {
            int tx = Math.min(path1.xpoints[i], path1.xpoints[i + 1]) - 1;
            int ty = Math.min(path1.ypoints[i], path1.ypoints[i + 1]) - 1;
            int tw = Math.abs(path1.xpoints[i] - path1.xpoints[i + 1]) + 1;
            int th = Math.abs(path1.ypoints[i] - path1.ypoints[i + 1]) + 1;
            Rectangle r1 = new Rectangle(tx, ty, tw, th);
            for (int j = 0; j < path2.npoints - 1; ++j) {
                int rh;
                int rw;
                int ry;
                int rx = Math.min(path2.xpoints[j], path2.xpoints[j + 1]) - 1;
                if (!r1.intersects(new Rectangle(rx, ry = Math.min(path2.ypoints[j], path2.ypoints[j + 1]) - 1, rw = Math.abs(path2.xpoints[j] - path2.xpoints[j + 1]) + 1, rh = Math.abs(path2.ypoints[j] - path2.ypoints[j + 1]) + 1))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doLayout(Graph graph, LayoutJobControl lJC) {
        this.layoutEdges(graph, lJC);
    }

    protected void preprocess(Graph graph) {
        this.resizeNodes(graph);
    }

    protected void postproces(Graph graph) {
        this.restoreNodeSize(graph);
        this.smoothEdges(graph);
    }

    protected void resizeNodes(Graph graph) {
        Iterator<Node> iter = graph.nodeIterator();
        while (iter.hasNext()) {
            Node node = iter.next();
            if (node.width < 15) {
                node.setAttribute(OLD_WIDTH_ATTR, Integer.toString(node.width));
                node.x -= (15 - node.width) / 2;
                node.width = 15;
            }
            if (node.height >= 15) continue;
            node.setAttribute(OLD_HEIGHT_ATTR, Integer.toString(node.height));
            node.y -= (15 - node.height) / 2;
            node.height = 15;
        }
    }

    protected void restoreNodeSize(Graph graph) {
        Iterator<Node> iter = graph.nodeIterator();
        while (iter.hasNext()) {
            String height;
            Node node = iter.next();
            String width = node.getAttribute(OLD_WIDTH_ATTR);
            if (width != null) {
                int oldWidth = Integer.parseInt(width);
                node.x += (node.width - oldWidth) / 2;
                node.width = oldWidth;
            }
            if ((height = node.getAttribute(OLD_HEIGHT_ATTR)) == null) continue;
            int oldHeight = Integer.parseInt(height);
            node.y += (node.height - oldHeight) / 2;
            node.height = oldHeight;
        }
    }

    protected void smoothEdges(Graph graph) {
        Iterator<Edge> iter = graph.edgeIterator();
        while (iter.hasNext()) {
            Path oldPath;
            Edge edge = iter.next();
            if (edge.fixed || (oldPath = edge.getPath()) == null || oldPath.npoints <= 2) continue;
            Path newPath = new Path();
            newPath.addPoint(oldPath.xpoints[0], oldPath.ypoints[0], 0);
            Point previous = new Point(oldPath.xpoints[0], oldPath.ypoints[0]);
            Point current = new Point(oldPath.xpoints[1], oldPath.ypoints[1]);
            for (int i = 2; i < oldPath.npoints; ++i) {
                int y;
                int x;
                Point next = new Point(oldPath.xpoints[i], oldPath.ypoints[i]);
                double d = Point.distance(previous.x, previous.y, current.x, current.y);
                if (d > 5.0) {
                    x = current.x + (int)((double)(previous.x - current.x) / 2.0);
                    y = current.y + (int)((double)(previous.y - current.y) / 2.0);
                    newPath.addPoint(x, y, 0);
                }
                newPath.addPoint(current.x, current.y, 1);
                d = Point.distance(current.x, current.y, next.x, next.y);
                if (d > 5.0) {
                    x = current.x + (int)((double)(next.x - current.x) / 2.0);
                    y = current.y + (int)((double)(next.y - current.y) / 2.0);
                    newPath.addPoint(x, y, 0);
                    current.setLocation(x, y);
                }
                previous = current;
                current = next;
            }
            newPath.addPoint(current.x, current.y, 0);
            edge.setPath(newPath);
        }
    }

    static class Shift {
        int first;
        int second;

        public Shift(int first, int second) {
            this.first = first;
            this.second = second;
        }
    }

    public static enum Orientation {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        NONE;

        public static final String LEFT_NAME = "left";
        public static final String RIGHT_NAME = "right";
        public static final String TOP_NAME = "top";
        public static final String BOTTOM_NAME = "bottom";
        public static final String NONE_NAME = "none";

        public String toString() {
            switch (this) {
                case LEFT: {
                    return LEFT_NAME;
                }
                case RIGHT: {
                    return RIGHT_NAME;
                }
                case TOP: {
                    return TOP_NAME;
                }
                case BOTTOM: {
                    return BOTTOM_NAME;
                }
            }
            return NONE_NAME;
        }

        public static Orientation fromString(String value) {
            if (value != null) {
                if (value.equals(LEFT_NAME)) {
                    return LEFT;
                }
                if (value.equals(RIGHT_NAME)) {
                    return RIGHT;
                }
                if (value.equals(TOP_NAME)) {
                    return TOP;
                }
                if (value.equals(BOTTOM_NAME)) {
                    return BOTTOM;
                }
            }
            return NONE;
        }

        public static String[] getAvailableTags() {
            Orientation[] vals = Orientation.values();
            String[] result = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                result[i] = ((Object)((Object)vals[i])).toString();
            }
            return result;
        }

        public Orientation clockwise() {
            switch (this) {
                case TOP: {
                    return RIGHT;
                }
                case RIGHT: {
                    return BOTTOM;
                }
                case BOTTOM: {
                    return LEFT;
                }
            }
            return TOP;
        }
    }
}

