/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;

public class OrthogonalPathFinder {
    private final Graph graph;
    private final Set<Node> exclusions;
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;
    private final int gridX;
    private final int gridY;
    private boolean nextStep;
    private boolean solution;
    List<Path> pathes = new ArrayList<Path>();
    private OrthogonalPathFinder pf1 = null;
    private OrthogonalPathFinder pf2 = null;
    private OrthogonalPathFinder pf3 = null;
    private OrthogonalPathFinder pf4 = null;

    public OrthogonalPathFinder(Graph graph, Set<Node> exclusions, int x1, int y1, int x2, int y2, int gridX, int gridY) {
        this.graph = graph;
        this.exclusions = exclusions;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.gridX = gridX;
        this.gridY = gridY;
        this.nextStep = true;
        this.solution = false;
    }

    public boolean hasNextStep() {
        return this.nextStep;
    }

    public boolean hasSolution() {
        return this.solution;
    }

    public List<Path> getSolutions() {
        return this.pathes;
    }

    public void nextStep() {
        Node node;
        List<Path> listTo;
        List<Path> listFrom;
        if (!this.nextStep) {
            return;
        }
        if (this.pf1 != null) {
            this.pf1.nextStep();
            this.pf2.nextStep();
            if (this.pf1.hasSolution() && this.pf2.hasSolution()) {
                this.solution = true;
                listFrom = this.pf1.getSolutions();
                listTo = this.pf2.getSolutions();
                for (Path pFrom : listFrom) {
                    for (Path pTo : listTo) {
                        this.pathes.add(Path.concat(pFrom, pTo));
                    }
                }
                this.pf1 = null;
                this.pf2 = null;
                if (this.pf3 == null) {
                    this.nextStep = false;
                }
            }
        }
        if (this.pf3 != null) {
            this.pf3.nextStep();
            this.pf4.nextStep();
            if (this.pf3.hasSolution() && this.pf4.hasSolution()) {
                this.solution = true;
                listFrom = this.pf3.getSolutions();
                listTo = this.pf4.getSolutions();
                for (Path pFrom : listFrom) {
                    for (Path pTo : listTo) {
                        this.pathes.add(Path.concat(pFrom, pTo));
                    }
                }
                this.pf3 = null;
                this.pf4 = null;
                if (this.pf1 == null) {
                    this.nextStep = false;
                }
            }
        }
        if (this.pf1 != null || this.pf3 != null || !this.nextStep) {
            return;
        }
        if (this.x1 != this.x2 && this.y1 != this.y2) {
            this.pf1 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x1, this.y1, this.x1, this.y2, this.gridX, this.gridY);
            this.pf2 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x1, this.y2, this.x2, this.y2, this.gridX, this.gridY);
            this.pf3 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x1, this.y1, this.x2, this.y1, this.gridX, this.gridY);
            this.pf4 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x2, this.y1, this.x2, this.y2, this.gridX, this.gridY);
            return;
        }
        if (this.x1 == this.x2) {
            node = this.graph.getIntersectedNode(this.x1 - this.gridX, this.y1, this.x1 + this.gridX, this.y2, this.exclusions);
            if (node == null) {
                this.makeSimplePath();
                return;
            }
            int y = (node.y + node.height / 2) / this.gridY * this.gridY;
            int xl = node.x / this.gridX * this.gridX - 2 * this.gridX;
            int xr = (node.x + node.width) / this.gridX * this.gridX + 2 * this.gridX;
            this.pf1 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x1, this.y1, xl, y, this.gridX, this.gridY);
            this.pf2 = new OrthogonalPathFinder(this.graph, this.exclusions, xl, y, this.x2, this.y2, this.gridX, this.gridY);
            this.pf3 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x1, this.y1, xr, y, this.gridX, this.gridY);
            this.pf4 = new OrthogonalPathFinder(this.graph, this.exclusions, xr, y, this.x2, this.y2, this.gridX, this.gridY);
        } else {
            node = this.graph.getIntersectedNode(this.x1, this.y1 - this.gridY, this.x2, this.y2 + this.gridY, this.exclusions);
            if (node == null) {
                this.makeSimplePath();
                return;
            }
            int x = (node.x + node.width / 2) / this.gridX * this.gridX;
            int yt = node.y / this.gridY * this.gridY - 2 * this.gridY;
            int yb = (node.y + node.height) / this.gridY * this.gridY + 2 * this.gridY;
            this.pf1 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x1, this.y1, x, yt, this.gridX, this.gridY);
            this.pf2 = new OrthogonalPathFinder(this.graph, this.exclusions, x, yt, this.x2, this.y2, this.gridX, this.gridY);
            this.pf3 = new OrthogonalPathFinder(this.graph, this.exclusions, this.x1, this.y1, x, yb, this.gridX, this.gridY);
            this.pf4 = new OrthogonalPathFinder(this.graph, this.exclusions, x, yb, this.x2, this.y2, this.gridX, this.gridY);
        }
    }

    protected void makeSimplePath() {
        Path path = new Path();
        path.addPoint(this.x1, this.y1);
        path.addPoint(this.x2, this.y2);
        this.pathes.add(path);
        this.nextStep = false;
        this.solution = true;
    }
}

