/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.OrthogonalPathLayouter;
import ru.biosoft.graph.PortFinder;

public class OrientedPortFinder
implements PortFinder {
    private final Map<Object, Map<OrthogonalPathLayouter.Orientation, List<OrthogonalPathLayouter.Orientation>>> portMap = new HashMap<Object, Map<OrthogonalPathLayouter.Orientation, List<OrthogonalPathLayouter.Orientation>>>();

    @Override
    public Point findPort(Node node, Edge edge, int x, int y) {
        Object id = edge.applicationData;
        Map<OrthogonalPathLayouter.Orientation, List<OrthogonalPathLayouter.Orientation>> orientationToPoints = this.portMap.get(id);
        if (orientationToPoints == null) {
            return new Point(x, y);
        }
        OrthogonalPathLayouter.Orientation orientation = OrthogonalPathLayouter.Orientation.fromString(node.getAttribute("orientation"));
        List<OrthogonalPathLayouter.Orientation> points = orientationToPoints.get((Object)orientation);
        Iterator<OrthogonalPathLayouter.Orientation> iter = points.iterator();
        Point nearestPoint = this.getPoint(node, iter.next());
        if (!iter.hasNext()) {
            return nearestPoint;
        }
        double minDistance = Math.abs(nearestPoint.x - x) + Math.abs(nearestPoint.y - y);
        while (iter.hasNext()) {
            Point nextPoint = this.getPoint(node, iter.next());
            double distance = Math.abs(nextPoint.x - x) + Math.abs(nextPoint.y - y);
            if (!(distance < minDistance)) continue;
            nearestPoint = new Point(nextPoint);
            minDistance = distance;
        }
        return nearestPoint;
    }

    private Point getPoint(Node node, OrthogonalPathLayouter.Orientation orientation) {
        switch (orientation) {
            case TOP: {
                return new Point(node.x + node.width / 2, node.y);
            }
            case RIGHT: {
                return new Point(node.x + node.width, node.y + node.height / 2);
            }
            case BOTTOM: {
                return new Point(node.x + node.width / 2, node.y + node.height);
            }
        }
        return new Point(node.x, node.y + node.height / 2);
    }

    public void addPort(Object appData, OrthogonalPathLayouter.Orientation nodeOrientation, OrthogonalPathLayouter.Orientation portOrientation) {
        Map<OrthogonalPathLayouter.Orientation, List<OrthogonalPathLayouter.Orientation>> orientationToPoints = this.portMap.get(appData);
        if (orientationToPoints == null) {
            HashMap map = new HashMap();
            ArrayList<OrthogonalPathLayouter.Orientation> points = new ArrayList<OrthogonalPathLayouter.Orientation>();
            points.add(portOrientation);
            map.put(nodeOrientation, points);
            this.portMap.put(appData, map);
            return;
        }
        List<OrthogonalPathLayouter.Orientation> points = orientationToPoints.get((Object)nodeOrientation);
        if (points == null) {
            points = new ArrayList<OrthogonalPathLayouter.Orientation>();
            points.add(portOrientation);
            orientationToPoints.put(nodeOrientation, points);
        } else {
            points.add(portOrientation);
        }
    }
}

