/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.PortFinder;
import ru.biosoft.graph.ShapeChanger;

public class Node
implements Cloneable {
    protected String name;
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean fixed;
    Object data;
    public Object applicationData;
    protected HashMap<String, String> attributes;
    public PortFinder portFinder = null;
    public ShapeChanger shapeChanger = null;

    public Node(String name) {
        this(name, 0, 0, 4, 4, false);
    }

    public Node(String name, int x, int y, int width, int height) {
        this(name, x, y, width, height, false);
    }

    public Node(String name, int x, int y, int width, int height, boolean fixed) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fixed = fixed;
    }

    public String toString() {
        return "N:" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle rec) {
        this.x = rec.x;
        this.y = rec.y;
        this.width = rec.width;
        this.height = rec.height;
    }

    public static void copyAttributes(Node nodeFrom, Node nodeTo) {
        for (Map.Entry<String, String> entry : nodeFrom.attributes.entrySet()) {
            nodeTo.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public String getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public void setPortFinder(PortFinder finder) {
        this.portFinder = finder;
    }

    public Point findPort(int x, int y, Edge edge) {
        if (this.portFinder != null) {
            return this.portFinder.findPort(this, edge, x, y);
        }
        return new Point(x, y);
    }

    public void setShapeChanger(ShapeChanger shapeChanger) {
        this.shapeChanger = shapeChanger;
    }

    public void adjustSize() {
        if (this.shapeChanger == null) {
            return;
        }
        this.shapeChanger.changeShape(this);
    }

    public Node clone() {
        Node newNode = new Node(this.name, this.x, this.y, this.width, this.height);
        newNode.applicationData = this.applicationData;
        newNode.fixed = this.fixed;
        newNode.data = this.data;
        if (this.attributes != null) {
            for (String attr : this.attributes.keySet()) {
                newNode.setAttribute(attr, this.attributes.get(attr));
            }
        }
        return newNode;
    }
}

