/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.ForceDirectedLayouter;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.SelfLoopLayouter;

public class ModHierarchicLayouter
extends AbstractLayouter {
    protected static final Logger log = Logger.getLogger(ModHierarchicLayouter.class.getName());
    protected Map<String, Object> edgesToRestore = new HashMap<String, Object>();
    protected boolean verticalOrientation = true;
    protected boolean hoistNodes = false;
    protected int layerOrderIterationNum = 100;
    public static final int STRAIGHTEN_DEFAULT = 0;
    public static final int STRAIGHTEN_FORCE_DIRECTED = 1;
    protected int straightenMethod = 0;
    protected ForceDirectedLayouter forceDirectedLayouter = new ForceDirectedLayouter();
    protected int straightenIterationNum = 100;
    private boolean processNeighbours = false;
    protected int layerDeltaX = 30;
    protected int layerDeltaY = 30;
    protected int gridX = 10;
    protected int gridY = 10;
    protected int dummyGridX = 0;
    protected int dummyGridY = 0;
    protected int sameNameNodesWeight = 5;
    protected int dummyEdgesCoeff = 5;
    protected int scoreWeight = 10;
    protected int edgesCrossCoeff = 1000;
    public SelfLoopLayouter selfLoopLayouter = new SelfLoopLayouter();
    protected List<Edge> selfLoops;
    protected int maxLevel;
    protected ArrayList<List<Node>> levelNodes;
    protected LevelComparator levelComparator = new LevelComparator();
    protected ArrayList<List<Edge>> levelEdges;

    public ModHierarchicLayouter() {
        this.configureForceDirectedLayouter();
    }

    public boolean isVerticalOrientation() {
        return this.verticalOrientation;
    }

    public void setVerticalOrientation(boolean verticalOrientation) {
        this.verticalOrientation = verticalOrientation;
    }

    public boolean isHoistNodes() {
        return this.hoistNodes;
    }

    public void setHoistNodes(boolean hoistNodes) {
        this.hoistNodes = hoistNodes;
    }

    public int getLayerOrderIterationNum() {
        return this.layerOrderIterationNum;
    }

    public void setLayerOrderIterationNum(int layerOrderIterationNum) {
        this.layerOrderIterationNum = layerOrderIterationNum;
    }

    public int getStraightenMethod() {
        return this.straightenMethod;
    }

    public void setStraightenMethod(int straightenMethod) {
        this.straightenMethod = straightenMethod;
    }

    public ForceDirectedLayouter getForceDirectedLayouter() {
        return this.forceDirectedLayouter;
    }

    public void setForceDirectedLayouter(ForceDirectedLayouter forceDirectedLayouter) {
        this.forceDirectedLayouter = forceDirectedLayouter;
    }

    public int getStraightenIterationNum() {
        return this.straightenIterationNum;
    }

    public void setStraightenIterationNum(int straightenIterationNum) {
        this.straightenIterationNum = straightenIterationNum;
    }

    public boolean isProcessNeighbours() {
        return this.processNeighbours;
    }

    public void setProcessNeighbours(boolean processNeighbours) {
        this.processNeighbours = processNeighbours;
    }

    public int getLayerDeltaX() {
        return this.layerDeltaX;
    }

    public void setLayerDeltaX(int layerDeltaX) {
        this.layerDeltaX = layerDeltaX;
    }

    public int getLayerDeltaY() {
        return this.layerDeltaY;
    }

    public void setLayerDeltaY(int layerDeltaY) {
        this.layerDeltaY = layerDeltaY;
    }

    public int getsameNameNodesWeight() {
        return this.sameNameNodesWeight;
    }

    public void setsameNameNodesWeight(int sameNameNodesWeight) {
        this.sameNameNodesWeight = sameNameNodesWeight;
    }

    public int getdummyEdgesCoeff() {
        return this.dummyEdgesCoeff;
    }

    public void setdummyEdgesCoeff(int dummyEdgesCoeff) {
        this.dummyEdgesCoeff = dummyEdgesCoeff;
    }

    public int getscoreWeight() {
        return this.scoreWeight;
    }

    public void setscoreWeight(int scoreWeight) {
        this.scoreWeight = scoreWeight;
    }

    public int getedgesCrossCoeff() {
        return this.edgesCrossCoeff;
    }

    public void setedgesCrossCoeff(int edgesCrossCoeff) {
        this.edgesCrossCoeff = edgesCrossCoeff;
    }

    @Override
    protected void layoutNodes(Graph graph, LayoutJobControl lJC) {
        this.addAlignmentDummies(graph);
        this.makeLevels(graph);
        this.addSameNodeEdges(graph);
        this.initLevelEdges(graph);
        this.placeNodesInitial();
        for (int j = 0; j < this.layerOrderIterationNum; ++j) {
            this.orderNodes(graph, j);
        }
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl lJC) {
        for (Edge edge : graph.edgeList) {
            edge.path = new Path();
        }
        for (int i = 0; i < this.maxLevel; ++i) {
            List<Node> nodes = this.levelNodes.get(i);
            for (Node n : nodes) {
                List<Edge> outEdges = this.getOrderedEdgeSet(graph, n, false);
                int outEdgeNum = outEdges.size();
                for (int k = 0; k < outEdgeNum; ++k) {
                    if (outEdges.get(k) == null) continue;
                    Edge edge = outEdges.get(k);
                    if (!edge.master) continue;
                    if (this.verticalOrientation) {
                        edge.path.addPoint(n.x + n.width * (k + 1) / (outEdgeNum + 1), n.y + n.height);
                        continue;
                    }
                    edge.path.addPoint(n.x + n.width, n.y + n.height * (k + 1) / (outEdgeNum + 1));
                }
                List<Edge> inEdges = this.getOrderedEdgeSet(graph, n, true);
                int inEdgeNum = inEdges.size();
                for (int k = 0; k < inEdgeNum; ++k) {
                    Edge edge = inEdges.get(k);
                    if (edge == null || !edge.master) continue;
                    if (this.verticalOrientation) {
                        edge.path.addPoint(n.x + n.width * (k + 1) / (inEdgeNum + 1), n.y);
                        continue;
                    }
                    edge.path.addPoint(n.x, n.y + n.height * (k + 1) / (inEdgeNum + 1));
                }
            }
        }
        this.removeDummies(graph);
        for (Edge edge : graph.edgeList) {
            if (!edge.master || edge.slaves == null) continue;
            int inEdgeNum = 0;
            List<Edge> edgeIn = graph.getEdges(edge.from);
            for (Edge e : edgeIn) {
                if (e.from != edge.from) continue;
                ++inEdgeNum;
                if (e.slaves == null) continue;
                inEdgeNum += e.slaves.size();
            }
            int outEdgeNum = 0;
            List<Edge> edgeOut = graph.getEdges(edge.to);
            for (Edge e : edgeOut) {
                if (e.to != edge.to) continue;
                ++outEdgeNum;
                if (e.slaves == null) continue;
                outEdgeNum += e.slaves.size();
            }
            float span = 5.0f;
            span = this.verticalOrientation ? (float)Math.min(this.gridX, Math.min(edge.from.width / (inEdgeNum + 1), edge.to.width / (outEdgeNum + 1))) : (float)Math.min(this.gridY, Math.min(edge.from.height / (inEdgeNum + 1), edge.to.height / (outEdgeNum + 1)));
            for (int i = 0; i < edge.slaves.size(); ++i) {
                Edge slave = edge.slaves.get(i);
                slave.path = this.parallelPath(edge.path, Math.round(span * (float)(i + 1)));
            }
        }
        for (int i = 0; i < graph.edgeList.size(); ++i) {
            Edge edge;
            edge = graph.edgeList.get(i);
            if (!edge.reversed) continue;
            graph.removeEdge(edge);
            edge.reverseDirection();
            graph.addEdge(edge);
            --i;
        }
        if (this.selfLoopLayouter == null) {
            this.selfLoopLayouter = new SelfLoopLayouter();
        }
        for (Edge edge : this.selfLoops) {
            this.selfLoopLayouter.layoutPath(graph, edge, this.pathWeighter);
            graph.addEdge(edge);
        }
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl lJC) {
        this.forceDirectedLayouter.layoutPath(graph, edge, lJC);
    }

    protected List<Edge> getOrderedEdgeSet(Graph graph, Node n, boolean in) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int level = ModHierarchicLayouter.getLevel(n) + (in ? -2 : 0);
        if (level >= 0 && level < this.maxLevel) {
            for (Node u : this.levelNodes.get(level)) {
                Edge edge = in ? graph.getEdge(u, n) : graph.getEdge(n, u);
                if (edge == null) continue;
                edges.add(edge);
                if (!this.isDummy(n) && edge.slaves != null) {
                    for (Edge slave : edge.slaves) {
                        edges.add(slave);
                    }
                }
                if (!this.isDummy(n) || edge.data == null) continue;
                int slavesCount = ((List)edge.data).size();
                for (int i = 0; i < slavesCount; ++i) {
                    edges.add(null);
                }
            }
        }
        return edges;
    }

    protected Path parallelPath(Path originalPath, int offset) {
        Path path = new Path();
        int dx = this.verticalOrientation ? offset : 0;
        int dy = this.verticalOrientation ? 0 : offset;
        for (int i = 0; i < originalPath.npoints; ++i) {
            path.addPoint(originalPath.xpoints[i] + dx, originalPath.ypoints[i] + dy);
        }
        return path;
    }

    public void initLayoutData(Graph graph) {
        for (Node n : graph.nodeList) {
            n.data = new LayoutData();
        }
    }

    protected void unmarkNodes(Graph graph) {
        for (Node n : graph.nodeList) {
            ((LayoutData)n.data).marked = false;
        }
    }

    protected void printNodeLevels(Graph graph) {
        for (Node node : graph.nodeList) {
            System.out.print(node.name + ":" + ((LayoutData)node.data).level + ", ");
        }
    }

    protected static double getScore(Node node) {
        return ((LayoutData)node.data).score;
    }

    protected static void setScore(Node node, double score) {
        ((LayoutData)node.data).score = score;
    }

    protected static int getLevel(Node node) {
        return ((LayoutData)node.data).level;
    }

    protected static void setLevel(Node node, int level) {
        ((LayoutData)node.data).level = level;
    }

    protected static int getUsageLevel(Node node) {
        return ((LayoutData)node.data).usageLevel;
    }

    protected static void setUsageLevel(Node node, int level) {
        ((LayoutData)node.data).usageLevel = level;
    }

    protected boolean isDummy(Node node) {
        return ((LayoutData)node.data).dummy;
    }

    protected int getBarycenter(Node node) {
        return ((LayoutData)node.data).barycenter;
    }

    protected int calcBarycenter(Graph graph, Node node, boolean doIn, boolean doOut, boolean processSize) {
        Node u;
        int sum = 0;
        int n = 0;
        int center = 0;
        for (Edge edge : graph.getEdges(node)) {
            u = null;
            if (edge.to == node && doIn) {
                u = edge.from;
            } else if (edge.from == node && doOut) {
                u = edge.to;
            }
            if (u == null) continue;
            center = this.verticalOrientation ? u.x : u.y;
            if (processSize) {
                center = this.verticalOrientation ? (center += u.width / 2) : (center += u.height / 2);
            }
            sum += center;
            ++n;
        }
        if (processSize && this.processNeighbours) {
            int i;
            List<Node> level = this.levelNodes.get(ModHierarchicLayouter.getLevel(node) - 1);
            for (i = 0; i < level.size() && level.get(i) != node; ++i) {
            }
            if (i > 0) {
                u = level.get(i - 1);
                center = this.verticalOrientation ? u.x + u.width / 2 : u.y + u.height / 2;
                sum += center;
                ++n;
            }
            if (i < level.size() - 1) {
                u = level.get(i + 1);
                center = this.verticalOrientation ? u.x + u.width / 2 : u.y + u.height / 2;
                sum += center;
                ++n;
            }
        }
        sum = n != 0 ? (sum /= n) : (this.verticalOrientation ? node.x + (processSize ? node.width / 2 : 0) : node.y + (processSize ? node.height / 2 : 0));
        ((LayoutData)node.data).barycenter = sum;
        return sum;
    }

    protected void normalise(Graph graph) {
        this.selfLoops = new ArrayList<Edge>();
        for (int i = 0; i < graph.edgeList.size(); ++i) {
            Edge edge = graph.edgeList.get(i);
            if (edge.from != edge.to) continue;
            edge.path = null;
            this.selfLoops.add(edge);
            graph.removeEdge(edge);
            --i;
        }
        this.unmarkNodes(graph);
        for (Node node : graph.nodeList) {
            if (((LayoutData)node.data).marked) continue;
            this.breakCycles(graph, node);
        }
    }

    protected void breakCycles(Graph graph, Node curr) {
        ((LayoutData)curr.data).marked = true;
        ((LayoutData)curr.data).picked = true;
        List<Edge> edges = graph.getEdges(curr);
        if (edges == null) {
            return;
        }
        for (int j = 0; j < edges.size(); ++j) {
            Edge edge = edges.get(j);
            if (edge.from != curr) continue;
            Node n = edge.to;
            if (((LayoutData)n.data).picked) {
                log.log(Level.INFO, "reversed edge: " + edge + "<" + edge.slaves + ">");
                graph.removeEdge(edge);
                edge.reverseDirection();
                graph.addEdge(edge);
                --j;
                continue;
            }
            if (((LayoutData)n.data).marked) continue;
            this.breakCycles(graph, n);
        }
        ((LayoutData)curr.data).picked = false;
    }

    protected void assignNodeLevels(Graph graph) {
        ArrayList<Node> topoSortedNodes = new ArrayList<Node>();
        Node metaRoot = this.makeMetaRoot(graph);
        this.unmarkNodes(graph);
        ModHierarchicLayouter.topoSort(graph, metaRoot, topoSortedNodes);
        graph.removeNode(metaRoot);
        topoSortedNodes.remove(metaRoot);
        int toposize = topoSortedNodes.size();
        for (int i = 0; i < toposize; ++i) {
            Node v = topoSortedNodes.get(i);
            ModHierarchicLayouter.setLevel(v, Integer.parseInt(v.getAttribute("level").trim()));
            ModHierarchicLayouter.setScore(v, Double.parseDouble(v.getAttribute("score").trim()));
        }
    }

    public static void topoSort(Graph graph, Node curr, List<Node> topoSortedNodes) {
        ((LayoutData)curr.data).marked = true;
        List<Edge> edges = graph.getEdges(curr);
        for (Edge edge : edges) {
            if (edge.to != curr) continue;
            Node n = edge.from;
            if (((LayoutData)n.data).marked) continue;
            ModHierarchicLayouter.topoSort(graph, n, topoSortedNodes);
        }
        topoSortedNodes.add(curr);
    }

    protected void addSameNodeEdges(Graph graph) {
        block0: for (int j = 0; j < graph.nodeCount(); ++j) {
            Node v = graph.nodeAt(j);
            boolean flag = false;
            for (int i = ModHierarchicLayouter.getLevel(v); i < this.maxLevel; ++i) {
                List<Node> nodeList = this.levelNodes.get(i);
                for (Node u : nodeList) {
                    String toName;
                    String fromName;
                    if (v.getName().lastIndexOf("_") <= -1 || u.getName().lastIndexOf("_") <= -1 || !(fromName = v.getName().substring(0, v.getName().lastIndexOf("_"))).equalsIgnoreCase(toName = u.getName().substring(0, u.getName().lastIndexOf("_")))) continue;
                    Edge sameNameNodesEdge = new Edge(v, u);
                    sameNameNodesEdge.data = "dummyEdge";
                    graph.addEdge(sameNameNodesEdge);
                    flag = true;
                    break;
                }
                if (flag) continue block0;
            }
        }
    }

    protected void addAlignmentDummies(Graph graph) {
        int maxLayer = 0;
        for (int j = 0; j < graph.nodeCount(); ++j) {
            int layer = Integer.parseInt(graph.nodeAt(j).getAttribute("level"));
            maxLayer = Math.max(layer, maxLayer);
        }
        Node[] dummys = new Node[maxLayer];
        dummys[maxLayer - 1] = new Node("level" + (maxLayer - 1) + ".alinement");
        if (this.verticalOrientation) {
            dummys[maxLayer - 1].width = this.dummyGridX;
            dummys[maxLayer - 1].height = this.dummyGridY;
        } else {
            dummys[maxLayer - 1].width = this.dummyGridX;
            dummys[maxLayer - 1].height = this.dummyGridY;
        }
        graph.addNode(dummys[maxLayer - 1]);
        dummys[maxLayer - 1].data = new LayoutData();
        ((LayoutData)dummys[maxLayer - 1].data).dummy = true;
        ModHierarchicLayouter.setLevel(dummys[maxLayer - 1], maxLayer);
        dummys[maxLayer - 1].setAttribute("level", String.valueOf(maxLayer));
        for (int i = maxLayer - 2; i >= 0; --i) {
            dummys[i] = new Node("level" + i + ".alinement");
            if (this.verticalOrientation) {
                dummys[i].width = this.dummyGridX;
                dummys[i].height = this.dummyGridY;
            } else {
                dummys[i].width = this.dummyGridX;
                dummys[i].height = this.dummyGridY;
            }
            graph.addNode(dummys[i]);
            dummys[i].data = new LayoutData();
            ((LayoutData)dummys[i].data).dummy = true;
            ModHierarchicLayouter.setLevel(dummys[i], i + 1);
            dummys[i].setAttribute("level", String.valueOf(i + 1));
            Edge edge = new Edge(dummys[i], dummys[i + 1]);
            graph.addEdge(edge);
        }
    }

    protected void addDummies(Graph graph) {
        if (graph.edgeCount() != 0) {
            int dummyCount = 1;
            for (int i = 0; i < graph.nodeCount(); ++i) {
                Node to = graph.nodeList.get(i);
                if (((LayoutData)to.data).dummy) continue;
                List<Edge> edges = graph.getEdges(to);
                for (int j = 0; j < edges.size(); ++j) {
                    Edge edge = edges.get(j);
                    edge.path = new Path();
                    if (edge.to != to || ((LayoutData)edge.from.data).dummy) continue;
                    if (ModHierarchicLayouter.getLevel(to) > ModHierarchicLayouter.getLevel(edge.from) + 1) {
                        --j;
                    }
                    List<Edge> slaves = edge.slaves;
                    ArrayList<Edge> slavesCopy = null;
                    int edgeNum = 1;
                    if (slaves != null) {
                        edgeNum += slaves.size();
                        slavesCopy = new ArrayList<Edge>(slaves);
                    }
                    while (ModHierarchicLayouter.getLevel(to) > ModHierarchicLayouter.getLevel(edge.from) + 1) {
                        Node from = edge.from;
                        Node dummy = new Node("dummy." + dummyCount);
                        if (this.verticalOrientation) {
                            dummy.width = this.dummyGridX;
                            dummy.height = this.dummyGridY;
                        } else {
                            dummy.width = this.dummyGridX;
                            dummy.height = this.dummyGridY;
                        }
                        ++dummyCount;
                        graph.addNode(dummy);
                        dummy.data = new LayoutData();
                        ModHierarchicLayouter.setLevel(dummy, ModHierarchicLayouter.getLevel(from) + 1);
                        dummy.setAttribute("level", String.valueOf(ModHierarchicLayouter.getLevel(from) + 1));
                        if (edge.applicationData == null) {
                            System.out.println("Error here: " + edge.getFrom().getName() + " - " + edge.getTo().getName());
                        }
                        this.edgesToRestore.put(dummy.getName(), edge.applicationData);
                        ((LayoutData)dummy.data).dummy = true;
                        if (edgeNum > 1) {
                            if (this.verticalOrientation) {
                                dummy.width = this.dummyGridX * edgeNum;
                            } else {
                                dummy.height = this.dummyGridY * edgeNum;
                            }
                        }
                        Edge in = new Edge(from, dummy);
                        in.data = slavesCopy;
                        in.reversed = edge.reversed;
                        graph.addEdge(in);
                        Edge out = new Edge(dummy, to);
                        out.data = slavesCopy;
                        out.reversed = edge.reversed;
                        graph.addEdge(out);
                        if (slaves != null) {
                            while (slaves.size() > 0) {
                                graph.removeEdge(slaves.get(0));
                            }
                        }
                        graph.removeEdge(edge);
                        edge = out;
                    }
                }
            }
        }
    }

    protected void removeDummies(Graph graph) {
        for (int i = 0; i < graph.nodeCount(); ++i) {
            Node from = graph.nodeList.get(i);
            if (this.isDummy(from)) continue;
            List<Edge> edges = graph.getEdges(from);
            int j = 0;
            while (j < edges.size()) {
                Edge edge = edges.get(j++);
                if (edge.from != from || !this.isDummy(edge.to)) continue;
                Path line = new Path();
                line.addPoint(edge.path.xpoints[0], edge.path.ypoints[0]);
                line.addPoint(edge.path.xpoints[1], edge.path.ypoints[1]);
                ArrayList<Node> path = new ArrayList<Node>();
                path.add(edge.to);
                Node to = edge.to;
                while (true) {
                    List<Edge> dEdges = graph.getEdges(to);
                    for (int d = 0; d < 2; ++d) {
                        Edge e = dEdges.get(d);
                        if (e.from != to) continue;
                        to = e.to;
                        line.addPoint(e.path.xpoints[1], e.path.ypoints[1]);
                        break;
                    }
                    if (!this.isDummy(to)) break;
                    path.add(to);
                }
                Edge originalEdge = new Edge(from, to);
                originalEdge.applicationData = this.edgesToRestore.get(((Node)path.get(0)).getName());
                originalEdge.reversed = edge.reversed;
                originalEdge.path = line;
                graph.addEdge(originalEdge);
                originalEdge.master = true;
                List slaves = (List)edge.data;
                if (slaves != null) {
                    for (Object slave : slaves) {
                        graph.addEdge((Edge)slave);
                    }
                }
                for (Node aPath : path) {
                    graph.removeNode(aPath);
                }
                j = 0;
            }
        }
    }

    protected void makeLevels(Graph graph) {
        this.maxLevel = -1;
        Node maxLevelNode = null;
        for (Node n : graph.nodeList) {
            if (this.maxLevel >= ModHierarchicLayouter.getLevel(n)) continue;
            this.maxLevel = ModHierarchicLayouter.getLevel(n);
            maxLevelNode = n;
        }
        this.levelNodes = new ArrayList(this.maxLevel);
        for (int j = 0; j < this.maxLevel; ++j) {
            this.levelNodes.add(new ArrayList());
        }
        this.unmarkNodes(graph);
        this.initialOrderNodes(graph, maxLevelNode);
        for (Node n : graph.nodeList) {
            if (((LayoutData)n.data).marked) continue;
            this.initialOrderNodes(graph, n);
        }
    }

    public void initialOrderNodes(Graph graph, Node curr) {
        ((LayoutData)curr.data).marked = true;
        for (Edge edge : graph.getEdges(curr)) {
            if (edge.to != curr) continue;
            Node n = edge.from;
            if (((LayoutData)n.data).marked) continue;
            this.initialOrderNodes(graph, n);
        }
        this.levelNodes.get(ModHierarchicLayouter.getLevel(curr) - 1).add(curr);
    }

    protected void orderNodes(Graph graph, int op) {
        boolean doout;
        boolean doup = true;
        boolean doin = op < 5;
        boolean bl = doout = op > 3;
        if (doup) {
            for (int i = 0; i < this.maxLevel; ++i) {
                this.orderLevel(graph, this.levelNodes.get(i), doin, doout);
            }
        } else {
            for (int i = this.maxLevel - 1; i >= 0; --i) {
                this.orderLevel(graph, this.levelNodes.get(i), doin, doout);
            }
        }
        this.placeNodesInitial();
    }

    protected void orderLevel(Graph graph, List<Node> nodes, boolean doin, boolean doout) {
        for (Node node : nodes) {
            this.calcBarycenter(graph, node, doin, doout, false);
        }
        Collections.sort(nodes, this.levelComparator);
        int levelcnt = nodes.size();
        for (int i = 0; i < levelcnt; ++i) {
            Node node = nodes.get(i);
            if (this.verticalOrientation) {
                node.x = i * this.layerDeltaX;
                continue;
            }
            node.y = i * this.layerDeltaY;
        }
        for (int k = 0; k < 5; ++k) {
            boolean hasSwap = false;
            for (int i = 0; i < levelcnt - 1; ++i) {
                Node n1 = nodes.get(i);
                Node n2 = nodes.get(i + 1);
                int level = ModHierarchicLayouter.getLevel(n1);
                double w1 = this.calcLevelWeight(level, true, doout);
                this.swap(n1, n2);
                double w2 = this.calcLevelWeight(level, true, doout);
                if (w1 <= w2) {
                    this.swap(n1, n2);
                    continue;
                }
                nodes.remove(n2);
                nodes.add(i, n2);
                hasSwap = true;
            }
            if (!hasSwap) break;
        }
    }

    protected void swap(Node n1, Node n2) {
        if (this.verticalOrientation) {
            int t = n1.x;
            n1.x = n2.x;
            n2.x = t;
        } else {
            int t = n1.y;
            n1.y = n2.y;
            n2.y = t;
        }
    }

    protected void initLevelEdges(Graph graph) {
        this.levelEdges = new ArrayList(this.maxLevel);
        for (int i = 0; i < this.maxLevel; ++i) {
            ArrayList<Edge> edges = new ArrayList<Edge>();
            this.levelEdges.add(edges);
            List<Node> nodes = this.levelNodes.get(i);
            for (Node node : nodes) {
                List<Edge> nEdges = graph.getEdges(node);
                for (Edge edge : nEdges) {
                    if (edge.from != node) continue;
                    edges.add(edge);
                }
            }
        }
    }

    protected double calcLevelWeight(int level, boolean doIn, boolean doOut) {
        double weight = 0.0;
        List<Node> nodes = this.levelNodes.get(--level);
        for (Node node : nodes) {
            weight += (double)node.x * ModHierarchicLayouter.getScore(node) * (double)this.scoreWeight;
        }
        if (level > 0 && doIn) {
            weight += (double)this.calcEdgesWeight(this.levelEdges.get(level - 1));
        }
        if (doOut) {
            weight += (double)this.calcEdgesWeight(this.levelEdges.get(level));
        }
        return weight;
    }

    protected int calcEdgesWeight(List<Edge> edges) {
        int weight = 0;
        for (int i = 0; i < edges.size(); ++i) {
            String toName;
            String fromName;
            Edge e1 = edges.get(i);
            if (e1.from.getName().lastIndexOf("_") > -1 && e1.to.getName().lastIndexOf("_") > -1 && (fromName = e1.from.getName().substring(0, e1.from.getName().lastIndexOf("_"))).equalsIgnoreCase(toName = e1.to.getName().substring(0, e1.to.getName().lastIndexOf("_")))) {
                weight += this.sameNameNodesWeight * Math.abs(e1.from.x - e1.to.x);
            }
            if (((LayoutData)e1.from.data).dummy || ((LayoutData)e1.to.data).dummy) {
                weight += this.dummyEdgesCoeff * Math.abs(e1.from.x - e1.to.x);
            }
            weight = this.verticalOrientation ? (weight += Math.abs(e1.from.x - e1.to.x)) : (weight += Math.abs(e1.from.y - e1.to.y));
            if (e1.data != null && e1.data.equals("dummyEdge")) continue;
            for (int k = i + 1; k < edges.size(); ++k) {
                Edge e2 = edges.get(k);
                if (this.verticalOrientation) {
                    if ((e1.from.x >= e2.from.x || e1.to.x <= e2.to.x) && (e2.from.x >= e1.from.x || e2.to.x <= e1.to.x)) continue;
                    weight += this.edgesCrossCoeff;
                    continue;
                }
                if ((e1.from.y >= e2.from.y || e1.to.y <= e2.to.y) && (e2.from.y >= e1.from.y || e2.to.y <= e1.to.y)) continue;
                weight += this.edgesCrossCoeff;
            }
        }
        return weight;
    }

    protected void placeNodesInitial() {
        int levelSize = 0;
        int levelOffset = 0;
        for (int i = 0; i < this.maxLevel; ++i) {
            List<Node> nodes = this.levelNodes.get(i);
            levelSize = this.placeLevelInitial(nodes, levelOffset);
            if (this.verticalOrientation) {
                levelOffset += levelSize / this.gridY * this.gridY + this.gridY;
                levelOffset += this.layerDeltaY;
                continue;
            }
            levelOffset += levelSize / this.gridX * this.gridX + this.gridX;
            levelOffset += this.layerDeltaX;
        }
    }

    protected int placeLevelInitial(List<Node> level, int levelOffset) {
        int size = 0;
        int offset = 0;
        for (Node node : level) {
            if (this.verticalOrientation) {
                node.y = levelOffset;
                node.x = offset;
                offset += node.width / this.gridX * this.gridX + this.layerDeltaX;
                size = Math.max(size, node.height);
                continue;
            }
            node.x = levelOffset;
            node.y = offset;
            offset += node.height / this.gridY * this.gridY + this.layerDeltaY;
            size = Math.max(size, node.width);
        }
        return size;
    }

    protected void configureForceDirectedLayouter() {
        this.forceDirectedLayouter.setInitialPlacement(0);
        this.forceDirectedLayouter.setAttraction(0.2f);
        this.forceDirectedLayouter.setDistanceMethod(2);
        this.forceDirectedLayouter.setEdgeLength((this.layerDeltaX + this.layerDeltaY) / 3);
        this.forceDirectedLayouter.setRepulsion(7.0f);
        this.forceDirectedLayouter.setRepulsionDistance(2);
        this.forceDirectedLayouter.setGravity(0.0f);
        this.forceDirectedLayouter.setMaxTemperature(5.0f);
        this.forceDirectedLayouter.setMinTemperature(1.0f);
        this.forceDirectedLayouter.setIterationNumber(100);
    }

    protected void straightenLayout(Graph graph, LayoutJobControl lJC) {
        if (this.straightenMethod == 1) {
            int i;
            if (this.forceDirectedLayouter == null) {
                this.forceDirectedLayouter = new ForceDirectedLayouter();
            }
            this.forceDirectedLayouter.setHorisontalMovementAllowed(this.verticalOrientation);
            this.forceDirectedLayouter.setVerticalMovementAllowed(!this.verticalOrientation);
            Object[] data = new Object[graph.nodeCount()];
            List<Node> nodes = graph.nodeList;
            for (i = 0; i < graph.nodeCount(); ++i) {
                data[i] = nodes.get((int)i).data;
            }
            this.forceDirectedLayouter.layoutNodes(graph, lJC);
            for (i = 0; i < graph.nodeCount(); ++i) {
                nodes.get((int)i).data = data[i];
            }
            return;
        }
        for (int i = 0; i < this.straightenIterationNum; ++i) {
            for (int j = this.maxLevel - 1; j >= 0; --j) {
                this.straightenLevel(graph, this.levelNodes.get(j));
            }
        }
    }

    protected void straightenLevel(Graph graph, List<Node> nodes) {
        int levelcnt = nodes.size();
        block0: for (int i = 0; i < levelcnt; ++i) {
            Node curr;
            int k;
            int overlap;
            int shift;
            Node node = nodes.get(i);
            this.calcBarycenter(graph, node, true, true, true);
            if (this.verticalOrientation) {
                shift = node.x - (this.getBarycenter(node) - node.width / 2);
                shift = shift > 0 ? Math.min(shift, 5) : Math.max(shift, -5);
                node.x -= shift;
            } else {
                shift = node.y - (this.getBarycenter(node) - node.height / 2);
                shift = shift > 0 ? Math.min(shift, 5) : Math.max(shift, -5);
                node.y -= shift;
            }
            if (i <= 0) continue;
            Node prev = nodes.get(i - 1);
            if (this.verticalOrientation) {
                overlap = prev.x + prev.width + this.layerDeltaX - node.x;
                if (overlap <= 0) continue;
                node.x += overlap * (i - 1) / i;
                overlap /= i;
                for (k = i - 1; k >= 0; --k) {
                    curr = nodes.get(k);
                    curr.x -= overlap;
                    if (k <= 0) continue;
                    prev = nodes.get(k - 1);
                    overlap = prev.x + prev.width + this.layerDeltaX - curr.x;
                    if (overlap <= 0) continue block0;
                }
                continue;
            }
            overlap = prev.y + prev.height + this.layerDeltaY - node.y;
            if (overlap <= 0) continue;
            node.y += overlap * (i - 1) / i;
            overlap /= i;
            for (k = i - 1; k >= 0; --k) {
                curr = nodes.get(k);
                curr.y -= overlap;
                if (k <= 0) continue;
                prev = nodes.get(k - 1);
                overlap = prev.y + prev.height + this.layerDeltaY - curr.y;
                if (overlap <= 0) continue block0;
            }
        }
    }

    protected void straightenDummy(Graph graph, Node n) {
        List<Edge> edges = graph.getEdges(n);
        Node from = null;
        Node to = null;
        for (int i = 0; i < 2; ++i) {
            Edge edge = edges.get(i);
            if (edge.to == n) {
                from = edge.from;
                continue;
            }
            to = edge.to;
        }
        if (from == null || to == null) {
            log.log(Level.SEVERE, "One of the edge terminals is null");
            return;
        }
        if (this.verticalOrientation) {
            n.x = (n.x + from.x + from.width / 2 + to.x + to.width / 2) / 3;
        } else {
            n.y = (n.y + from.y + from.height / 2 + to.y + to.height / 2) / 3;
        }
    }

    protected Node makeMetaRoot(Graph graph) {
        Node metaRoot = new Node("meta-root");
        metaRoot.data = new LayoutData();
        for (Node n : graph.nodeList) {
            Edge e = new Edge(n, metaRoot);
            graph.addEdge(e);
        }
        graph.addNode(metaRoot);
        return metaRoot;
    }

    @Override
    public void doLayout(Graph graph, LayoutJobControl lJC) {
        int i;
        this.gridY = graph.nodeAt((int)0).height;
        this.gridX = graph.nodeAt((int)0).width;
        if (this.verticalOrientation) {
            this.dummyGridY = graph.nodeAt((int)0).height;
        } else {
            this.dummyGridX = graph.nodeAt((int)0).width;
        }
        this.initLayoutData(graph);
        this.normalise(graph);
        this.assignNodeLevels(graph);
        this.addDummies(graph);
        long time = System.currentTimeMillis();
        int oneNodeGraphCount = 0;
        List<Graph> graphs = graph.split();
        Graph[] grrs = new Graph[graphs.size()];
        int[] minLayers = new int[graphs.size()];
        int[] maxLayers = new int[graphs.size()];
        int k = 0;
        Iterator<Graph> iterator = graphs.iterator();
        while (iterator.hasNext()) {
            Graph gr;
            grrs[k] = gr = iterator.next();
            ++k;
        }
        Graph tempGraph = new Graph();
        for (i = 0; i < graphs.size(); ++i) {
            for (int j = 0; j < graphs.size() - 1; ++j) {
                if (grrs[j].nodeCount() >= grrs[j + 1].nodeCount()) continue;
                tempGraph = grrs[j];
                grrs[j] = grrs[j + 1];
                grrs[j + 1] = tempGraph;
            }
        }
        for (i = 0; i < graphs.size(); ++i) {
            int minLayer = 10000;
            int maxLayer = 0;
            for (int j = 0; j < grrs[i].nodeCount(); ++j) {
                Node v = grrs[i].nodeAt(j);
                if (Integer.parseInt(v.getAttribute("level").trim()) < minLayer) {
                    minLayer = Integer.parseInt(v.getAttribute("level").trim());
                }
                if (Integer.parseInt(v.getAttribute("level").trim()) <= maxLayer) continue;
                maxLayer = Integer.parseInt(v.getAttribute("level").trim());
            }
            minLayers[i] = minLayer;
            maxLayers[i] = maxLayer;
        }
        tempGraph = new Graph();
        Graph labelGraph = new Graph();
        int tempGraphMinLayer = 1000;
        for (int i2 = graphs.size() - 1; i2 >= 0 && grrs[i2].nodeCount() <= 1; --i2) {
            ++oneNodeGraphCount;
            if (grrs[i2].nodeAt(0).getAttribute("label").equalsIgnoreCase("true")) {
                labelGraph.addNode(grrs[i2].nodeAt(0));
                continue;
            }
            tempGraph.addNode(grrs[i2].nodeAt(0));
            if (minLayers[i2] >= tempGraphMinLayer) continue;
            tempGraphMinLayer = minLayers[i2];
        }
        int xcord = 0;
        this.initLayoutData(labelGraph);
        this.normalise(labelGraph);
        this.assignNodeLevels(labelGraph);
        this.layoutNodes(labelGraph, lJC);
        labelGraph.setLocation(xcord, 0);
        xcord = labelGraph.getBounds().x + labelGraph.getBounds().width + this.layerDeltaX;
        if (graphs.size() - oneNodeGraphCount > 0) {
            this.layoutNodes(grrs[0], lJC);
            grrs[0].setLocation(xcord, 0);
            this.layoutEdges(grrs[0], lJC);
            xcord = grrs[0].getBounds().x + grrs[0].getBounds().width + this.layerDeltaX;
        }
        for (int i3 = 1; i3 < graphs.size() - oneNodeGraphCount; ++i3) {
            this.layoutNodes(grrs[i3], lJC);
            grrs[i3].setLocation(xcord, 0);
            this.layoutEdges(grrs[i3], lJC);
            xcord = grrs[i3].getBounds().x + grrs[i3].getBounds().width + this.layerDeltaX;
        }
        if (tempGraph.nodeCount() != 0) {
            this.initLayoutData(tempGraph);
            this.normalise(tempGraph);
            this.assignNodeLevels(tempGraph);
            this.layoutNodes(tempGraph, lJC);
            tempGraph.setLocation(xcord, 0);
        }
        this.removeDummies(graph);
        log.log(Level.INFO, "Layout time " + (System.currentTimeMillis() - time));
    }

    @Override
    public LayouterInfo getInfo() {
        LayouterInfoSupport lis = new LayouterInfoSupport(true, true, false, false, false, true);
        return lis;
    }

    @Override
    public int estimate(Graph graph, int what) {
        return 0;
    }

    public class LayoutData {
        public int level = 0;
        public int usageLevel = 0;
        public int barycenter = 0;
        public double score = 0.0;
        public boolean marked = false;
        public boolean picked = false;
        public boolean dummy = false;
    }

    public class LevelComparator
    implements Comparator<Node> {
        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int compare(Node o1, Node o2) {
            int r = ModHierarchicLayouter.this.getBarycenter(o1) - ModHierarchicLayouter.this.getBarycenter(o2);
            if (r != 0) {
                return r;
            }
            return 0;
        }
    }
}

