/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.util.HashMap;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.PortFinder;

public class MapPortFinder
implements PortFinder {
    private final HashMap<String, Point> portMap = new HashMap();

    @Override
    public Point findPort(Node node, Edge edge, int x, int y) {
        String portName = null;
        if (edge.getFrom().equals(node)) {
            portName = edge.getAttribute("inputPortName");
        } else if (edge.getTo().equals(node)) {
            portName = edge.getAttribute("outputPortName");
        }
        if (portName == null || !this.portMap.containsKey(portName)) {
            return new Point(x, y);
        }
        Point relativePoint = this.portMap.get(portName);
        Point result = new Point(relativePoint);
        result.translate(node.x, node.y);
        return result;
    }

    public void addPort(String nodeName, Point p) {
        this.portMap.put(nodeName, p);
    }
}

