/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Rectangle;
import java.text.DecimalFormat;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Path;

public class LayoutQualityMetrics {
    public int nodeCount;
    public int edgeCount;
    public int width;
    public int height;
    public int bends;
    public int crossings;
    public int confluences;
    public int withoutPath;
    public double edgeLength;
    public double sigma;
    public static final DecimalFormat df = new DecimalFormat("#.###");
    public static final String SEPARATOR = ";";
    public static final String HEADER = "Nodes;Edges;Degree;Width;Height;Ratio;Bends;Crossings;Confluences;WithoutPath;EdgeLength;Sigma;";

    private LayoutQualityMetrics() {
    }

    public static LayoutQualityMetrics getMetrics(Graph g) {
        LayoutQualityMetrics result = new LayoutQualityMetrics();
        result.estimate(g);
        return result;
    }

    private void estimate(Graph g) {
        this.nodeCount = g.nodeCount();
        this.edgeCount = g.edgeCount();
        Rectangle r = g.getBounds();
        this.width = r.width;
        this.height = r.height;
        for (Edge eO : g.edgeList) {
            Edge e = eO;
            if (e.getPath() == null) {
                ++this.withoutPath;
                continue;
            }
            Path lp = e.getPath();
            this.estimatePath(g, lp);
            this.bends += lp.npoints - 2;
            float len = 0.0f;
            int dx = 0;
            int dy = 0;
            for (int i = 0; i < lp.npoints - 1; ++i) {
                dx = lp.xpoints[i] - lp.xpoints[i + 1];
                dy = lp.ypoints[i] - lp.ypoints[i + 1];
                len = (float)((double)len + Math.sqrt(dx * dx + dy * dy));
            }
            this.edgeLength += (double)len;
            this.sigma += (double)(len * len);
        }
        this.crossings /= 2;
        this.confluences /= 2;
        this.edgeLength /= (double)g.edgeCount();
        this.sigma = Math.sqrt(this.sigma / (double)g.edgeCount() - this.edgeLength * this.edgeLength) / this.edgeLength;
    }

    private void estimatePath(Graph g, Path lp) {
        for (int i = 0; i < lp.npoints - 1; ++i) {
            int xFrom = Math.min(lp.xpoints[i], lp.xpoints[i + 1]) - 1;
            int yFrom = Math.min(lp.ypoints[i], lp.ypoints[i + 1]) - 1;
            int width = Math.abs(lp.xpoints[i] - lp.xpoints[i + 1]) + 1;
            int height = Math.abs(lp.ypoints[i] - lp.ypoints[i + 1]) + 1;
            Rectangle r = new Rectangle(xFrom, yFrom, width, height);
            for (Edge eO : g.edgeList) {
                Edge e = eO;
                if (e.getPath() == null || e.getPath() == lp) continue;
                this.estimatePath(r, e.getPath());
            }
        }
    }

    private void estimatePath(Rectangle r, Path lp) {
        for (int i = 0; i < lp.npoints - 1; ++i) {
            int height;
            int width;
            int yFrom;
            int xFrom = Math.min(lp.xpoints[i], lp.xpoints[i + 1]) - 1;
            if (!r.intersects(xFrom, yFrom = Math.min(lp.ypoints[i], lp.ypoints[i + 1]) - 1, width = Math.abs(lp.xpoints[i] - lp.xpoints[i + 1]) + 1, height = Math.abs(lp.ypoints[i] - lp.ypoints[i + 1]) + 1)) continue;
            ++this.crossings;
            if (width == r.width && r.width == 1) {
                ++this.confluences;
            }
            if (height != r.height || r.height != 1) continue;
            ++this.confluences;
        }
    }

    public String getDebugInfo() {
        String INGROUP_SEPARATOR = ": ";
        String GROUP_SEPARATOR = ",   ";
        StringBuffer res = new StringBuffer();
        res.append("Width");
        res.append(INGROUP_SEPARATOR);
        res.append(this.width);
        res.append(GROUP_SEPARATOR);
        res.append("Height");
        res.append(INGROUP_SEPARATOR);
        res.append(this.height);
        res.append(GROUP_SEPARATOR);
        res.append("Ratio");
        res.append(INGROUP_SEPARATOR);
        res.append(df.format((float)this.width / (float)this.height));
        res.append(GROUP_SEPARATOR);
        res.append("Bends");
        res.append(INGROUP_SEPARATOR);
        res.append(this.bends);
        res.append(GROUP_SEPARATOR);
        res.append("Crossings");
        res.append(INGROUP_SEPARATOR);
        res.append(this.crossings);
        res.append(GROUP_SEPARATOR);
        res.append("Confluences");
        res.append(INGROUP_SEPARATOR);
        res.append(this.confluences);
        res.append(GROUP_SEPARATOR);
        res.append("WithoutPath");
        res.append(INGROUP_SEPARATOR);
        res.append(this.withoutPath);
        res.append(GROUP_SEPARATOR);
        res.append("EdgeLength");
        res.append(INGROUP_SEPARATOR);
        res.append(df.format(this.edgeLength));
        res.append(GROUP_SEPARATOR);
        res.append("Sigma");
        res.append(INGROUP_SEPARATOR);
        res.append(df.format(this.sigma));
        res.append(GROUP_SEPARATOR);
        return res.toString();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append(this.nodeCount);
        res.append(SEPARATOR);
        res.append(this.edgeCount);
        res.append(SEPARATOR);
        res.append(df.format((float)this.edgeCount / (float)this.nodeCount));
        res.append(SEPARATOR);
        res.append(this.width);
        res.append(SEPARATOR);
        res.append(this.height);
        res.append(SEPARATOR);
        res.append(df.format((float)this.width / (float)this.height));
        res.append(SEPARATOR);
        res.append(this.bends);
        res.append(SEPARATOR);
        res.append(this.crossings);
        res.append(SEPARATOR);
        res.append(this.confluences);
        res.append(SEPARATOR);
        res.append(this.withoutPath);
        res.append(SEPARATOR);
        res.append(df.format(this.edgeLength));
        res.append(SEPARATOR);
        res.append(df.format(this.sigma));
        res.append(SEPARATOR);
        return res.toString();
    }
}

