/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Rectangle;
import java.util.Iterator;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;

public class LabelLayouter
extends AbstractLayouter {
    public static final String LABEL_SIZE = "labelSize";
    public static final String LABEL_OFFSET = "labelOffset";
    public static final String LABEL_ANGLE = "labelAngle";
    public static final int NODE_INTERSECT_PENALTY = 10;
    public static final int EDGE_INTERSECT_PENALTY = 1;

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl lJC) {
        Iterator<Node> iter = graph.nodeIterator();
        while (iter.hasNext()) {
            String[] str;
            Node node = iter.next();
            if (!node.hasAttribute(LABEL_SIZE) || (str = node.getAttribute(LABEL_SIZE).split(";")).length != 2) continue;
            int width = Integer.parseInt(str[0]);
            int height = Integer.parseInt(str[1]);
            this.layoutLabel(graph, node, width, height);
        }
    }

    @Override
    void layoutNodes(Graph graph, LayoutJobControl lJC) {
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl lJC) {
    }

    protected void layoutLabel(Graph graph, Node node, int labelWidth, int labelHeight) {
        double distanceRecord = 0.0;
        Position positionRecord = null;
        int penaltyRecord = Integer.MAX_VALUE;
        for (Position position : this.getPosiblePositions()) {
            double distance = Math.sqrt(Math.cos(position.angle) * Math.cos(position.angle) * ((double)(node.height + labelHeight) / 2.0 + position.offset) * ((double)(node.height + labelHeight) / 2.0 + position.offset) + Math.sin(position.angle) * Math.sin(position.angle) * ((double)(node.width + labelWidth) / 2.0 + position.offset) * ((double)(node.width + labelWidth) / 2.0 + position.offset));
            int penalty = this.calculateLabelPenalty(graph, node, labelWidth, labelHeight, distance, position.angle, penaltyRecord);
            if (penalty >= penaltyRecord) continue;
            distanceRecord = distance;
            positionRecord = position;
            penaltyRecord = penalty;
            if (penalty == 0) break;
        }
        node.setAttribute(LABEL_ANGLE, "" + (positionRecord.angle - 1.5707963267948966));
        node.setAttribute(LABEL_OFFSET, "" + (int)distanceRecord);
    }

    protected Position[] getPosiblePositions() {
        Position p;
        int i;
        Position[] result = new Position[24];
        int pos = 0;
        for (i = 0; i < 4; ++i) {
            p = new Position();
            p.offset = 5.0;
            p.angle = Math.PI * 2 - (double)i * Math.PI / 2.0;
            result[pos++] = p;
        }
        for (i = 0; i < 4; ++i) {
            p = new Position();
            p.offset = 0.0;
            p.angle = 5.497787143782138 - (double)i * Math.PI / 2.0;
            result[pos++] = p;
        }
        for (i = 0; i < 16; ++i) {
            p = new Position();
            p.offset = 10.0;
            p.angle = Math.PI * 2 - (double)i * Math.PI / 8.0;
            result[pos++] = p;
        }
        return result;
    }

    protected int calculateLabelPenalty(Graph graph, Node node, int labelWidth, int labelHeight, double distance, double angle, int record) {
        int result = 0;
        Rectangle rect = new Rectangle();
        rect.x = node.x + (node.width - labelWidth) / 2 - (int)(distance * Math.sin(angle));
        rect.y = node.y + (node.height - labelHeight) / 2 + (int)(distance * Math.cos(angle));
        rect.width = labelWidth;
        rect.height = labelHeight;
        Iterator<Node> nodeIterator = graph.nodeIterator();
        while (nodeIterator.hasNext()) {
            Node n = nodeIterator.next();
            if (!rect.intersects(n.getBounds()) || (result += 10) < record) continue;
            return record + 1;
        }
        Iterator<Edge> edgeIterator = graph.edgeIterator();
        while (edgeIterator.hasNext()) {
            Edge e = edgeIterator.next();
            Path path = e.getPath();
            if (path == null) continue;
            for (int i = 0; i < path.npoints - 1; ++i) {
                int height;
                int width;
                int yFrom;
                int xFrom = Math.min(path.xpoints[i], path.xpoints[i + 1]) - 1;
                if (!new Rectangle(xFrom, yFrom = Math.min(path.ypoints[i], path.ypoints[i + 1]) - 1, width = Math.abs(path.xpoints[i] - path.xpoints[i + 1]) + 1, height = Math.abs(path.ypoints[i] - path.ypoints[i + 1]) + 1).intersects(rect) || ++result < record) continue;
                return record + 1;
            }
        }
        return result;
    }

    @Override
    public LayouterInfo getInfo() {
        LayouterInfoSupport lis = new LayouterInfoSupport(true, true, false, true, false, true);
        return lis;
    }

    @Override
    public int estimate(Graph graph, int what) {
        return 0;
    }

    protected class Position {
        public double angle;
        public double offset;

        protected Position() {
        }
    }
}

