/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.DiagonalPathLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.HierarchicPathLayouter;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.OrthogonalPathLayouter;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graph.SelfLoopLayouter;
import ru.biosoft.graph.Util;

public class HierarchicLayouter
extends AbstractLayouter {
    protected static final Logger log = Logger.getLogger(HierarchicLayouter.class.getName());
    int maxNodeOptimizationNum = 8;
    transient Map<Node, Node[]> upwards = null;
    transient Map<Node, Node[]> downwards = null;
    public SelfLoopLayouter selfLoopLayouter = new SelfLoopLayouter();
    protected boolean verticalOrientation = false;
    protected boolean hoistNodes = false;
    protected int layerOrderIterationNum = 10;
    public static final int STRAIGHTEN_DEFAULT = 0;
    public static final int STRAIGHTEN_FORCE_DIRECTED = 1;
    protected int straightenMethod = 0;
    protected int straightenIterationNum = 100;
    private boolean processNeighbours = false;
    protected int virtualNodesDistance = 10;
    protected int layerDeltaX = 50;
    protected int layerDeltaY = 50;
    protected boolean splineEdges = false;
    protected int gridX = 1;
    protected int gridY = 1;
    protected transient List<Edge> selfLoops;
    protected transient int maxLevel;
    protected transient ArrayList<List<Node>> levelNodes;
    private transient int[] levelSizes = null;
    protected transient ArrayList<List<Edge>> levelEdges;

    public HierarchicLayouter() {
        this.pathLayouterWrapper = new PathLayouterWrapper(new HierarchicPathLayouter());
    }

    @Override
    protected void layoutNodes(Graph graph, LayoutJobControl lJC) {
        this.initLayoutData(graph);
        this.normalise(graph);
        this.assignNodeLevels(graph);
        this.addDummies(graph);
        for (Edge edge : graph.getEdges()) {
            edge.path = new Path();
        }
        this.makeLevels(graph);
        this.initLevelEdges(graph);
        this.placeNodesInitial();
        for (int i = 0; i < this.layerOrderIterationNum; ++i) {
            this.orderNodes(graph, i, lJC);
            if (lJC == null || lJC.getStatus() != 5 && lJC.getStatus() != 4) continue;
            i = this.layerOrderIterationNum;
        }
        this.optimizeNodeCoordinates(graph, lJC);
        Util.adjustOrientations(graph);
    }

    protected int getEdgeOmegaValue(Edge e) {
        int dummyCount = (this.isDummy(e.getFrom()) ? 1 : 0) + (this.isDummy(e.getTo()) ? 1 : 0);
        switch (dummyCount) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 8;
    }

    protected int calcNodePositionsScore(Graph graph) {
        Iterator<Edge> edgeIterator = graph.edgeIterator();
        int weight = 0;
        while (edgeIterator.hasNext()) {
            Edge e = edgeIterator.next();
            weight += this.getEdgeOmegaValue(e) * Math.abs(this.getIntralevelCoord(e.from) - this.getIntralevelCoord(e.to));
        }
        return weight;
    }

    public int getMaxNodeOptimizationNum() {
        return this.maxNodeOptimizationNum;
    }

    public void setMaxNodeOptimizationNum(int maxNodeOptimizationNum) {
        this.maxNodeOptimizationNum = maxNodeOptimizationNum;
    }

    private void optimizeNodeCoordinates(Graph graph, LayoutJobControl lJC) {
        this.preprocessIntralevelCoords(graph);
        this.fillLinkedStructures(graph);
        int optimalWeight = this.calcNodePositionsScore(graph);
        int[] optimalPositions = this.getIntralevelCoords(graph);
        for (int i = 0; i < this.maxNodeOptimizationNum; ++i) {
            int weight;
            this.applyMedianPositions(graph);
            if (lJC != null) {
                this.operationsDone += 2;
                lJC.done(this.operationsDone);
                if (lJC.getStatus() == 5 || lJC.getStatus() == 4) break;
            }
            this.applyMinEdges(graph);
            if (lJC != null) {
                this.operationsDone += 2;
                lJC.done(this.operationsDone);
                if (lJC.getStatus() == 5 || lJC.getStatus() == 4) break;
            }
            this.applyMinNodes(graph);
            if (lJC != null) {
                this.operationsDone += 2;
                lJC.done(this.operationsDone);
                if (lJC.getStatus() == 5 || lJC.getStatus() == 4) break;
            }
            this.applyMinPath(graph);
            if (lJC != null) {
                this.operationsDone += 2;
                lJC.done(this.operationsDone);
                if (lJC.getStatus() == 5 || lJC.getStatus() == 4) break;
            }
            if ((weight = this.calcNodePositionsScore(graph)) < optimalWeight) {
                optimalWeight = weight;
                optimalPositions = this.getIntralevelCoords(graph);
            }
            if (lJC == null) continue;
            this.operationsDone += 2;
            lJC.done(this.operationsDone);
            if (lJC.getStatus() == 5 || lJC.getStatus() == 4) break;
        }
        this.saveIntralevelCoords(graph, optimalPositions);
        this.postprocessIntralevelCoords(graph);
    }

    private void applyMinNodes(Graph graph) {
        Set nodeSet = Collections.newSetFromMap(new IdentityHashMap());
        nodeSet.addAll(graph.getNodes());
        while (!nodeSet.isEmpty()) {
            Node[] downwardNodes;
            Node[] upwardNodes;
            Node[] nodes;
            Node node = (Node)nodeSet.iterator().next();
            nodeSet.remove(node);
            Span span = this.getNodeSpan(node);
            if (span == null || span.min >= span.max || (nodes = new Node[(upwardNodes = this.upwards.get(node)).length + (downwardNodes = this.downwards.get(node)).length]).length == 0) continue;
            System.arraycopy(upwardNodes, 0, nodes, 0, upwardNodes.length);
            System.arraycopy(downwardNodes, 0, nodes, upwardNodes.length, downwardNodes.length);
            int median = span.fitValue(this.getMedianIntralevelCoord(nodes));
            if (median == this.getIntralevelCoord(node)) continue;
            if (this.verticalOrientation) {
                node.x = median;
            } else {
                node.y = median;
            }
            nodeSet.addAll(Arrays.asList(nodes));
            nodeSet.addAll((Collection)this.levelNodes.get(HierarchicLayouter.getLevel(node) - 1));
            nodeSet.remove(node);
        }
    }

    private void applyMinPath(Graph graph) {
        boolean changed;
        List<List<Node>> chains = this.getVirtualChains(graph);
        do {
            changed = false;
            for (List<Node> ch : chains) {
                if (ch.size() < 2) continue;
                int prevIndex = 0;
                Span prevSpan = this.getNodeSpan(ch.get(0));
                for (int i = 1; i < ch.size(); ++i) {
                    Node n = ch.get(i);
                    Span span = this.getNodeSpan(n);
                    Span intersected = prevSpan.intersect(span);
                    if (intersected == null) {
                        if (i - prevIndex > 1) {
                            int newPos = prevSpan.min < 0 ? prevSpan.max : prevSpan.min;
                            for (int j = prevIndex; j < i; ++j) {
                                int oldPos = this.getIntralevelCoord(ch.get(j));
                                if (oldPos == newPos) continue;
                                changed = true;
                                if (this.verticalOrientation) {
                                    ch.get((int)j).x = newPos;
                                    continue;
                                }
                                ch.get((int)j).y = newPos;
                            }
                        }
                        prevSpan = span;
                        prevIndex = i;
                        continue;
                    }
                    prevSpan = intersected;
                }
                if (ch.size() - prevIndex <= 1) continue;
                int newPos = prevSpan.min < 0 ? prevSpan.max : prevSpan.min;
                for (int j = prevIndex; j < ch.size(); ++j) {
                    int oldPos = this.getIntralevelCoord(ch.get(j));
                    if (oldPos == newPos) continue;
                    changed = true;
                    if (this.verticalOrientation) {
                        ch.get((int)j).x = newPos;
                        continue;
                    }
                    ch.get((int)j).y = newPos;
                }
            }
        } while (changed);
    }

    private List<List<Node>> getVirtualChains(Graph graph) {
        ArrayList<List<Node>> virtualChains = new ArrayList<List<Node>>();
        this.unmarkNodes(graph);
        for (Node n : graph.getNodes()) {
            if (!this.isDummy(n) || this.isMarked(n)) continue;
            virtualChains.add(this.getChain(graph, n));
        }
        return virtualChains;
    }

    private List<Node> getChain(Graph graph, Node n) {
        ArrayList<Node> chain = new ArrayList<Node>();
        Set curNodes = Collections.newSetFromMap(new IdentityHashMap());
        chain.add(n);
        curNodes.add(n);
        while (!curNodes.isEmpty()) {
            Node node = (Node)curNodes.iterator().next();
            curNodes.remove(node);
            ((LayoutData)node.data).marked = true;
            for (Edge edge : graph.getEdges(node)) {
                Node to;
                Node from = edge.getFrom();
                if (this.isDummy(from) && !this.isMarked(from)) {
                    chain.add(from);
                    curNodes.add(from);
                }
                if (!this.isDummy(to = edge.getTo()) || this.isMarked(to)) continue;
                chain.add(to);
                curNodes.add(to);
            }
        }
        Collections.sort(chain, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                return HierarchicLayouter.getLevel(n1) - HierarchicLayouter.getLevel(n2);
            }
        });
        return chain;
    }

    private void preprocessIntralevelCoords(Graph graph) {
        for (Node node : graph.getNodes()) {
            if (this.verticalOrientation) {
                node.x += node.width / 2;
                continue;
            }
            node.y += node.height / 2;
        }
    }

    private void postprocessIntralevelCoords(Graph graph) {
        int minCoord = Integer.MAX_VALUE;
        for (Node node : graph.getNodes()) {
            minCoord = Math.min(minCoord, this.verticalOrientation ? node.x - node.width / 2 : node.y - node.height / 2);
        }
        for (Node node : graph.getNodes()) {
            if (this.verticalOrientation) {
                node.x = node.x - node.width / 2 - minCoord;
                continue;
            }
            node.y = node.y - node.height / 2 - minCoord;
        }
        for (int i = 0; i < this.maxLevel; ++i) {
            List<Node> nodes = this.levelNodes.get(i);
            int levelThickness = 0;
            for (Node node : nodes) {
                levelThickness = Math.max(levelThickness, this.verticalOrientation ? node.height : node.width);
            }
            for (Node node : nodes) {
                if (this.verticalOrientation) {
                    node.y += (levelThickness - node.height) / 2;
                    continue;
                }
                node.x += (levelThickness - node.width) / 2;
            }
        }
    }

    private int[] getIntralevelCoords(Graph graph) {
        List<Node> nodes = graph.getNodes();
        int[] coords = new int[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            coords[i] = this.getIntralevelCoord(nodes.get(i));
        }
        return coords;
    }

    private int getIntralevelCoord(Node node) {
        return this.verticalOrientation ? node.x : node.y;
    }

    private int getIntralevelWidth(Node node) {
        return this.verticalOrientation ? node.width + (this.isDummy(node) ? this.virtualNodesDistance : this.layerDeltaX) : node.height + (this.isDummy(node) ? this.virtualNodesDistance : this.layerDeltaY);
    }

    private void saveIntralevelCoords(Graph graph, int[] coords) {
        List<Node> nodes = graph.getNodes();
        if (this.verticalOrientation) {
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get((int)i).x = coords[i];
            }
        } else {
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get((int)i).y = coords[i];
            }
        }
    }

    private void fillLinkedStructures(Graph graph) {
        List<Node> nodes = graph.getNodes();
        this.upwards = new IdentityHashMap<Node, Node[]>();
        this.downwards = new IdentityHashMap<Node, Node[]>();
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            List<Edge> edges = graph.getEdges(n);
            ArrayList<Node> up = new ArrayList<Node>();
            ArrayList<Node> down = new ArrayList<Node>();
            int upEdgesWeight = 0;
            int downEdgesWeight = 0;
            for (Edge e : edges) {
                if (e.getFrom().equals(n)) {
                    up.add(e.getTo());
                    upEdgesWeight += this.getEdgeOmegaValue(e);
                    continue;
                }
                down.add(e.getFrom());
                downEdgesWeight += this.getEdgeOmegaValue(e);
            }
            this.upwards.put(n, up.toArray(new Node[up.size()]));
            this.downwards.put(n, down.toArray(new Node[down.size()]));
            ((LayoutData)n.data).upEdgesWeight = upEdgesWeight;
            ((LayoutData)n.data).downEdgesWeight = downEdgesWeight;
        }
    }

    private void applyMedianPositions(Graph graph) {
        Span span;
        int median;
        Node[] adjacent;
        Node n;
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(graph.getNodes());
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int c1 = ((LayoutData)n1.data).downEdgesWeight;
                int c2 = ((LayoutData)n2.data).downEdgesWeight;
                return c1 < c2 ? 1 : (c1 > c2 ? -1 : HierarchicLayouter.getLevel(n1) - HierarchicLayouter.getLevel(n2));
            }
        });
        this.unmarkNodes(graph);
        for (i = 0; i < nodes.size(); ++i) {
            n = (Node)nodes.get(i);
            adjacent = this.downwards.get(n);
            int n2 = median = this.verticalOrientation ? n.x : n.y;
            if (adjacent.length != 0) {
                median = this.getMedianIntralevelCoord(adjacent);
            }
            if ((span = this.getIntralevelNodeSpan(n)) == null) continue;
            median = span.fitValue(median);
            if (this.verticalOrientation) {
                n.x = median;
            } else {
                n.y = median;
            }
            ((LayoutData)n.data).marked = true;
        }
        nodes.clear();
        nodes.addAll(graph.getNodes());
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int c1 = ((LayoutData)n1.data).upEdgesWeight;
                int c2 = ((LayoutData)n2.data).upEdgesWeight;
                return c1 < c2 ? 1 : (c1 > c2 ? -1 : HierarchicLayouter.getLevel(n2) - HierarchicLayouter.getLevel(n1));
            }
        });
        this.unmarkNodes(graph);
        for (i = 0; i < nodes.size(); ++i) {
            n = (Node)nodes.get(i);
            adjacent = this.upwards.get(n);
            int n3 = median = this.verticalOrientation ? n.x : n.y;
            if (adjacent.length != 0) {
                median = this.getMedianIntralevelCoord(adjacent);
            }
            if ((span = this.getIntralevelNodeSpan(n)) == null) continue;
            median = span.fitValue(median);
            if (this.verticalOrientation) {
                n.x = median;
            } else {
                n.y = median;
            }
            ((LayoutData)n.data).marked = true;
        }
    }

    private int snapDown(int value) {
        return this.verticalOrientation ? value / this.gridX * this.gridX : value / this.gridY * this.gridY;
    }

    private int snapUp(int value) {
        return this.verticalOrientation ? (value + this.gridX - 1) / this.gridX * this.gridX : (value + this.gridY - 1) / this.gridY * this.gridY;
    }

    private Span getIntralevelNodeSpan(Node n) {
        List<Node> nodes = this.levelNodes.get(HierarchicLayouter.getLevel(n) - 1);
        for (int i = 0; i < nodes.size(); ++i) {
            int j;
            int unmarkedLen;
            if (nodes.get(i) != n) continue;
            Span span = new Span();
            boolean prev = true;
            boolean next = true;
            if (i == 0) {
                prev = false;
            }
            if (i == nodes.size() - 1) {
                next = false;
            }
            if (next) {
                unmarkedLen = 0;
                for (j = i + 1; j < nodes.size(); ++j) {
                    Node nextNode = nodes.get(j);
                    if (((LayoutData)nextNode.data).marked) break;
                    unmarkedLen += this.getIntralevelWidth(nextNode);
                    unmarkedLen = this.snapUp(unmarkedLen);
                }
                if (j < nodes.size()) {
                    int nextMarkedCoord = this.getIntralevelCoord(nodes.get(j)) - this.getIntralevelWidth(nodes.get(j)) / 2;
                    span.max = this.snapDown(nextMarkedCoord - unmarkedLen - this.getIntralevelWidth(nodes.get(i)) / 2);
                }
            }
            if (prev) {
                unmarkedLen = 0;
                for (j = i - 1; j >= 0; --j) {
                    Node prevNode = nodes.get(j);
                    if (((LayoutData)prevNode.data).marked) break;
                    unmarkedLen += this.getIntralevelWidth(prevNode);
                    unmarkedLen = this.snapUp(unmarkedLen);
                }
                int prevMarkedCoord = j >= 0 ? this.getIntralevelCoord(nodes.get(j)) + this.getIntralevelWidth(nodes.get(j)) / 2 : 0;
                span.min = this.snapUp(prevMarkedCoord + unmarkedLen + this.getIntralevelWidth(nodes.get(i)) / 2);
            } else {
                span.min = 0;
            }
            return span;
        }
        return null;
    }

    private int getMedianIntralevelCoord(Node[] adjacent) {
        Arrays.sort(adjacent, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int c2;
                int c1 = HierarchicLayouter.this.getIntralevelCoord(n1);
                return c1 > (c2 = HierarchicLayouter.this.getIntralevelCoord(n2)) ? 1 : (c1 < c2 ? -1 : 0);
            }
        });
        return adjacent.length % 2 == 0 ? (this.getIntralevelCoord(adjacent[adjacent.length / 2 - 1]) + this.getIntralevelCoord(adjacent[adjacent.length / 2])) / 2 : this.getIntralevelCoord(adjacent[adjacent.length / 2]);
    }

    private Span getNodeSpan(Node n) {
        List<Node> nodes = this.levelNodes.get(HierarchicLayouter.getLevel(n) - 1);
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i) != n) continue;
            Span span = new Span();
            if (i > 0) {
                span.min = this.snapUp(this.getIntralevelCoord(nodes.get(i - 1)) + (this.getIntralevelWidth(nodes.get(i - 1)) + this.getIntralevelWidth(nodes.get(i))) / 2);
            }
            if (i < nodes.size() - 1) {
                span.max = this.snapDown(this.getIntralevelCoord(nodes.get(i + 1)) - (this.getIntralevelWidth(nodes.get(i + 1)) + this.getIntralevelWidth(nodes.get(i))) / 2);
            }
            return span;
        }
        return null;
    }

    private void applyMinEdges(Graph graph) {
        for (Edge edge : graph.getEdges()) {
            Span span;
            Span spanTo;
            Span spanFrom;
            if (this.isDummy(edge.getFrom()) || this.isDummy(edge.getTo()) || this.getIntralevelCoord(edge.getFrom()) != this.getIntralevelCoord(edge.getTo())) continue;
            Set adjacentNodes = Collections.newSetFromMap(new IdentityHashMap());
            ArrayList<Edge> adjacentEdges = new ArrayList<Edge>();
            adjacentEdges.addAll(graph.getEdges(edge.getFrom()));
            adjacentEdges.addAll(graph.getEdges(edge.getTo()));
            for (Edge edge2 : adjacentEdges) {
                if (edge == edge2) continue;
                if (edge2.getFrom() == edge.getFrom()) {
                    adjacentNodes.add(edge2.getTo());
                }
                if (edge2.getTo() != edge.getTo()) continue;
                adjacentNodes.add(edge2.getFrom());
            }
            if (adjacentNodes.size() == 0) continue;
            int median = this.getMedianIntralevelCoord(adjacentNodes.toArray(new Node[adjacentNodes.size()]));
            if (this.getIntralevelCoord(edge.getFrom()) == median || (spanFrom = this.getNodeSpan(edge.getFrom())) == null || (spanTo = this.getNodeSpan(edge.getTo())) == null || (span = spanFrom.intersect(spanTo)) == null) continue;
            median = span.fitValue(median);
            if (this.verticalOrientation) {
                edge.getFrom().x = edge.getTo().x = median;
                continue;
            }
            edge.getFrom().y = edge.getTo().y = median;
        }
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl jobControl) {
        Edge edge2;
        for (Edge edge2 : graph.getEdges()) {
            edge2.path = new Path();
        }
        if (this.splineEdges) {
            this.layoutSplineEdges(graph);
            for (int i = 0; i < graph.edgeList.size(); ++i) {
                edge2 = graph.edgeList.get(i);
                if (!edge2.reversed) continue;
                edge2.reverseDirection();
            }
        } else {
            for (int i = 0; i < this.maxLevel; ++i) {
                List<Node> nodes = this.levelNodes.get(i);
                for (Node n : nodes) {
                    Point p;
                    Edge edge3;
                    Point finishPoint;
                    List<Edge> edgeCluster;
                    int j;
                    Point startPoint = this.verticalOrientation ? new Point(n.x, n.y + n.height) : new Point(n.x + n.width, n.y);
                    List<List<Edge>> edgeClusters = this.getOrderedEdgeSet(graph, n, false);
                    int clustersNum = edgeClusters.size();
                    for (j = 0; j < clustersNum; ++j) {
                        edgeCluster = edgeClusters.get(j);
                        int outEdgeNum = edgeCluster.size();
                        if (outEdgeNum == 1 && this.isFixed(edgeCluster.get(0), n)) {
                            Edge edge4 = edgeCluster.get(0);
                            Point outputPoint = this.verticalOrientation ? n.findPort(n.x + n.width / 2, n.y + n.height, edge4) : n.findPort(n.x + n.width, n.y + n.height / 2, edge4);
                            edge4.getPath().addPoint(outputPoint.x, outputPoint.y);
                            continue;
                        }
                        if (j < clustersNum - 1) {
                            List<Edge> nextCluster = edgeClusters.get(j + 1);
                            Edge nextEdge = nextCluster.get(0);
                            finishPoint = n.findPort(n.x, n.y, nextEdge);
                        } else {
                            finishPoint = new Point(n.x + n.width, n.y + n.height);
                        }
                        int step = this.verticalOrientation ? finishPoint.x - startPoint.x : finishPoint.y - startPoint.y;
                        step /= outEdgeNum + 1;
                        for (int k = 0; k < outEdgeNum; ++k) {
                            if (edgeCluster.get(k) == null) continue;
                            edge3 = edgeCluster.get(k);
                            if (!edge3.master) continue;
                            p = this.verticalOrientation ? n.findPort(startPoint.x + step * (k + 1), startPoint.y, edge3) : n.findPort(startPoint.x, startPoint.y + step * (k + 1), edge3);
                            edge3.path.addPoint(p.x, p.y);
                        }
                    }
                    startPoint = new Point(n.x, n.y);
                    edgeClusters = this.getOrderedEdgeSet(graph, n, true);
                    clustersNum = edgeClusters.size();
                    for (j = 0; j < clustersNum; ++j) {
                        edgeCluster = edgeClusters.get(j);
                        int edgeNum = edgeCluster.size();
                        if (edgeNum == 0) continue;
                        if (edgeNum == 1 && this.isFixed(edgeCluster.get(0), n)) {
                            Edge edge5 = edgeCluster.get(0);
                            Point inputPoint = this.verticalOrientation ? n.findPort(n.x + n.width / 2, n.y, edge5) : n.findPort(n.x, n.y + n.height / 2, edge5);
                            edge5.getPath().addPoint(inputPoint.x, inputPoint.y);
                            continue;
                        }
                        if (j < clustersNum - 1) {
                            List<Edge> nextCluster = edgeClusters.get(j + 1);
                            Edge nextEdge = nextCluster.get(0);
                            finishPoint = n.findPort(n.x, n.y, nextEdge);
                        } else {
                            finishPoint = this.verticalOrientation ? new Point(n.x + n.width, n.y) : new Point(n.x, n.y + n.height);
                        }
                        int step = this.verticalOrientation ? finishPoint.x - startPoint.x : finishPoint.y - startPoint.y;
                        step /= edgeNum + 1;
                        for (int k = 0; k < edgeNum; ++k) {
                            if (edgeCluster.get(k) == null) continue;
                            edge3 = edgeCluster.get(k);
                            if (!edge3.master) continue;
                            p = this.verticalOrientation ? n.findPort(startPoint.x + step * (k + 1), startPoint.y, edge3) : n.findPort(n.x, startPoint.y + step * (k + 1), edge3);
                            edge3.path.addPoint(p.x, p.y);
                        }
                    }
                }
            }
            this.removeDummies(graph);
            for (Edge edge2 : graph.edgeList) {
                if (!edge2.master || edge2.slaves == null || Math.abs(HierarchicLayouter.getLevel(edge2.from) - HierarchicLayouter.getLevel(edge2.to)) != 1) continue;
                for (int i = 0; i < edge2.slaves.size(); ++i) {
                    Edge slave = edge2.slaves.get(i);
                    slave.path = this.shiftParallelMidway(edge2, slave, i + 1, graph);
                }
                edge2.path = this.shiftParallelMidway(edge2, edge2, 0, graph);
            }
            for (int i = 0; i < graph.edgeList.size(); ++i) {
                edge2 = graph.edgeList.get(i);
                if (!edge2.reversed) continue;
                edge2.reverseDirection();
            }
            if (this.selfLoopLayouter == null) {
                this.selfLoopLayouter = new SelfLoopLayouter();
            }
            for (Edge edge2 : this.selfLoops) {
                this.selfLoopLayouter.layoutPath(graph, edge2, this.pathWeighter);
                graph.addEdge(edge2);
            }
            if (this.getPathLayouter() instanceof HierarchicPathLayouter) {
                for (Edge edge2 : graph.edgeList) {
                    this.computingControlPoints(edge2);
                }
            } else if (this.getPathLayouter() instanceof OrthogonalPathLayouter) {
                this.getPathLayouter().layoutEdges(graph, jobControl);
            }
        }
    }

    protected void layoutSplineEdges(Graph graph) {
        this.fillLevelsHeight(graph);
        this.removeDummiesForSpline(graph);
        LinkedList<Edge> neighboringEdges = new LinkedList<Edge>();
        LinkedList<Edge> notNeighboringEdges = new LinkedList<Edge>();
        LinkedList<Edge> selfEdges = new LinkedList<Edge>();
        for (Edge edge : graph.edgeList) {
            if (edge.from == edge.to) {
                selfEdges.add(edge);
                continue;
            }
            if (Math.abs(HierarchicLayouter.getLevel(edge.from) - HierarchicLayouter.getLevel(edge.to)) == 1) {
                neighboringEdges.add(edge);
                continue;
            }
            if (Math.abs(HierarchicLayouter.getLevel(edge.from) - HierarchicLayouter.getLevel(edge.to)) > 1) {
                notNeighboringEdges.add(edge);
                continue;
            }
            throw new RuntimeException("unrecognized edge");
        }
        for (Edge edge : neighboringEdges) {
            this.createStraightPath(edge);
        }
        for (Edge edge : notNeighboringEdges) {
            this.computeSpline(edge, graph);
        }
        for (Edge edge : selfEdges) {
            this.computeSelfLoop(edge, graph);
        }
    }

    protected void fillLevelsHeight(Graph graph) {
        ArrayList graphBannedSpace = new ArrayList(this.maxLevel);
        int[] downSide = new int[this.maxLevel];
        int[] upSide = new int[this.maxLevel];
        Arrays.fill(upSide, Integer.MAX_VALUE);
        for (Node node : graph.nodeList) {
            int level = HierarchicLayouter.getLevel(node) - 1;
            if (node.y + node.height > downSide[level]) {
                downSide[level] = node.y + node.height;
            }
            if (node.y >= upSide[level]) continue;
            upSide[level] = node.y;
        }
        for (int i = 0; i < this.maxLevel; ++i) {
            ArrayList<Rectangle> levelBannedSpace = new ArrayList<Rectangle>();
            Rectangle zeroRect = new Rectangle(Integer.MIN_VALUE, upSide[i], 0, downSide[i] - upSide[i]);
            levelBannedSpace.add(zeroRect);
            graphBannedSpace.add(i, levelBannedSpace);
        }
        graph.data = graphBannedSpace;
    }

    protected void removeDummiesForSpline(Graph graph) {
        for (int i = 0; i < graph.nodeCount(); ++i) {
            Node from = graph.nodeList.get(i);
            if (Util.isCompartment(from) || this.isDummy(from)) continue;
            List<Edge> edges = graph.getEdges(from);
            for (int j = 0; j < edges.size(); ++j) {
                Edge edge = edges.get(j);
                if (edge.from != from || !this.isDummy(edge.to)) continue;
                Path line = new Path();
                line.addPoint(edge.path.xpoints[0], edge.path.ypoints[0]);
                this.addDummyNodeToPath(edge.to, line, edge.path.xpoints[1], edge.path.ypoints[1]);
                ArrayList<Node> path = new ArrayList<Node>();
                path.add(edge.to);
                Node to = edge.to;
                int pathLen = 1;
                while (true) {
                    List<Edge> dEdges = graph.getEdges(to);
                    for (int d = 0; d < 2; ++d) {
                        Edge e = dEdges.get(d);
                        if (e.from != to) continue;
                        to = e.to;
                        if (this.isDummy(to)) {
                            this.addDummyNodeToPath(e.to, line, e.path.xpoints[1], e.path.ypoints[1]);
                            break;
                        }
                        line.addPoint(e.path.xpoints[1], e.path.ypoints[1]);
                        break;
                    }
                    if (!this.isDummy(to)) break;
                    path.add(to);
                    ++pathLen;
                }
                Edge originalEdge = new Edge(from, to);
                originalEdge.reversed = edge.reversed;
                originalEdge.path = line;
                Edge masterEdge = graph.getEdge(from, to, true);
                if (masterEdge == null) {
                    originalEdge.master = true;
                } else {
                    originalEdge.master = false;
                    masterEdge.addSlave(originalEdge);
                }
                graph.addEdge(originalEdge);
                List slaves = (List)edge.data;
                if (slaves != null) {
                    for (Object slave : slaves) {
                        graph.addEdge((Edge)slave);
                    }
                }
                LinkedList<Rectangle> boxes = new LinkedList<Rectangle>();
                for (Node dummy : path) {
                    Rectangle region = this.getRegionToNode(dummy, graph);
                    boxes.add(region);
                    graph.removeNode(dummy);
                }
                originalEdge.data = boxes;
                if ((j -= pathLen) >= 0) continue;
                j = 0;
            }
        }
    }

    protected Rectangle getRegionToNode(Node node, Graph graph) {
        int level = HierarchicLayouter.getLevel(node);
        int leftSide = 0;
        int rightSide = Integer.MAX_VALUE;
        for (Node sameLevelNode : graph.nodeList) {
            if (this.isDummy(sameLevelNode) || HierarchicLayouter.getLevel(sameLevelNode) != level) continue;
            if (sameLevelNode.x < node.x) {
                if (sameLevelNode.x + sameLevelNode.width <= leftSide || sameLevelNode.x + sameLevelNode.width >= node.x) continue;
                leftSide = sameLevelNode.x + sameLevelNode.width;
                continue;
            }
            if (sameLevelNode.x >= rightSide || sameLevelNode.x <= node.x + node.width) continue;
            rightSide = sameLevelNode.x;
        }
        Rectangle zeroRect = (Rectangle)((List)((List)graph.data).get(level - 1)).get(0);
        int upSide = zeroRect.y;
        int downSide = zeroRect.y + zeroRect.height;
        int indent = 10;
        Rectangle region = new Rectangle(leftSide += indent, upSide, (rightSide -= indent) - leftSide, downSide - upSide);
        return region;
    }

    protected void computeSelfLoop(Edge edge, Graph graph) {
    }

    protected void computeSpline(Edge edge, Graph graph) {
        List<Rectangle> boxes = this.computeBoxes(edge, graph);
        List<Line2D> LArray = this.computeLArray(boxes);
        AbstractList controlPoints = new LinkedList<Point>();
        Node fromNode = edge.from;
        Node toNode = edge.to;
        Point start = new Point(fromNode.x + fromNode.width / 2, fromNode.y + fromNode.height / 2);
        Point end = new Point(toNode.x + toNode.width / 2, toNode.y + toNode.height / 2);
        controlPoints.add(start);
        controlPoints.add(end);
        if (!this.computeControlPoints(start, end, boxes, LArray, controlPoints)) {
            controlPoints.clear();
            controlPoints.add((Point)start);
            controlPoints.add((Point)end);
        }
        controlPoints = new ArrayList<Point>(controlPoints);
        Collections.sort(controlPoints, new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                return p1.y - p2.y;
            }
        });
        edge.path = this.computeBezierSegments(edge, controlPoints, graph);
    }

    protected List<Line2D> computeLArray(List<Rectangle> boxes) {
        LinkedList<Line2D.Double> LArray = new LinkedList<Line2D.Double>();
        Rectangle firstBox = boxes.get(0);
        Line2D.Double firstLine = new Line2D.Double(firstBox.getMinX(), firstBox.getMinY(), firstBox.getWidth(), firstBox.getMinY());
        LArray.add(firstLine);
        for (int i = 1; i < boxes.size(); ++i) {
            Rectangle intersection = boxes.get(i - 1).intersection(boxes.get(i));
            if (intersection.height != 0) {
                return null;
            }
            Line2D.Double intersectionLine = new Line2D.Double(intersection.getMinX(), intersection.y, intersection.getMaxX(), intersection.y);
            LArray.add(intersectionLine);
        }
        Rectangle lastBox = boxes.get(boxes.size() - 1);
        LArray.add(new Line2D.Double(lastBox.getMinX(), lastBox.getMaxY(), lastBox.getMaxX(), lastBox.getMaxY()));
        return new ArrayList<Line2D>(LArray);
    }

    protected Path computeBezierSegments(Edge edge, List<Point> controlPoints, Graph graph) {
        Path newPath = new Path();
        newPath.addPoint(controlPoints.get((int)0).x, controlPoints.get((int)0).y, 0);
        newPath.addPoint(controlPoints.get((int)0).x, controlPoints.get((int)0).y, 2);
        double coefLength = 0.3;
        List<Point> oldControlTrio = new ArrayList<Point>();
        oldControlTrio.add(controlPoints.get(0));
        oldControlTrio.add(controlPoints.get(0));
        for (int i = 0; i < controlPoints.size() - 2; ++i) {
            List<Point> controlTrio = this.computeBezierTrio(controlPoints, i, 0.3);
            ArrayList<Point> bezierQuad = new ArrayList<Point>(4);
            bezierQuad.add((Point)oldControlTrio.get(oldControlTrio.size() - 2));
            bezierQuad.add((Point)oldControlTrio.get(oldControlTrio.size() - 1));
            bezierQuad.add(controlTrio.get(0));
            bezierQuad.add(controlTrio.get(1));
            this.calculateSpace(bezierQuad, (List)graph.data, edge);
            newPath.addPoint(controlTrio.get((int)0).x, controlTrio.get((int)0).y, 0);
            newPath.addPoint(controlTrio.get((int)1).x, controlTrio.get((int)1).y, 0);
            newPath.addPoint(controlTrio.get((int)2).x, controlTrio.get((int)2).y, 2);
            oldControlTrio = controlTrio;
        }
        ArrayList<Point> bezierQuad = new ArrayList<Point>(4);
        bezierQuad.add((Point)oldControlTrio.get(oldControlTrio.size() - 2));
        bezierQuad.add((Point)oldControlTrio.get(oldControlTrio.size() - 1));
        bezierQuad.add(controlPoints.get(controlPoints.size() - 1));
        bezierQuad.add(controlPoints.get(controlPoints.size() - 1));
        this.calculateSpace(bezierQuad, (List)graph.data, edge);
        newPath.addPoint(controlPoints.get((int)(controlPoints.size() - 1)).x, controlPoints.get((int)(controlPoints.size() - 1)).y, 0);
        newPath.addPoint(controlPoints.get((int)(controlPoints.size() - 1)).x, controlPoints.get((int)(controlPoints.size() - 1)).y, 0);
        return newPath;
    }

    protected void calculateSpace(List<Point> bezierQuad, List<List<Rectangle>> graphSpaceLevels, Edge edge) {
        int i;
        ArrayList<Line2D.Double> boundaryLines = new ArrayList<Line2D.Double>(4);
        for (int i2 = 0; i2 < bezierQuad.size() - 1; ++i2) {
            boundaryLines.add(new Line2D.Double(bezierQuad.get(i2), bezierQuad.get(i2 + 1)));
        }
        boundaryLines.add(new Line2D.Double(bezierQuad.get(0), bezierQuad.get(3)));
        int upSidePoint = Integer.MAX_VALUE;
        int downSidePoint = 0;
        for (Point p : bezierQuad) {
            if (p.y > downSidePoint) {
                downSidePoint = p.y;
            }
            if (p.y >= upSidePoint) continue;
            upSidePoint = p.y;
        }
        int upSideLevelInd = 0;
        for (int i3 = 0; i3 < this.maxLevel; ++i3) {
            if (graphSpaceLevels.get((int)i3).get((int)0).y + graphSpaceLevels.get((int)i3).get((int)0).height <= upSidePoint) continue;
            upSideLevelInd = i3;
            break;
        }
        int downSideLevelInd = this.maxLevel - 1;
        for (i = this.maxLevel - 1; i >= 0; --i) {
            if (graphSpaceLevels.get((int)i).get((int)0).y >= downSidePoint) continue;
            downSideLevelInd = i;
            break;
        }
        for (i = upSideLevelInd; i <= downSideLevelInd; ++i) {
            int n;
            if (HierarchicLayouter.getLevel(edge.from) - 1 == i || HierarchicLayouter.getLevel(edge.to) - 1 == i) continue;
            LinkedList<Integer> pretenders = new LinkedList<Integer>();
            Rectangle testRect = new Rectangle(graphSpaceLevels.get(i).get(0));
            testRect.x = 0;
            testRect.width = Integer.MAX_VALUE;
            for (Point point : bezierQuad) {
                if (!testRect.contains(point)) continue;
                pretenders.add(point.x);
            }
            for (Line2D line2D : boundaryLines) {
                int xIntersection;
                if (!testRect.intersectsLine(line2D)) continue;
                if (line2D.intersectsLine(new Line2D.Double(testRect.x, testRect.y, testRect.x + testRect.width, testRect.y))) {
                    xIntersection = (int)(((double)testRect.y - line2D.getY1()) * (line2D.getX2() - line2D.getX1()) / (line2D.getY2() - line2D.getY1()) + line2D.getX1());
                    pretenders.add(xIntersection);
                }
                if (!line2D.intersectsLine(new Line2D.Double(testRect.x, testRect.y + testRect.height, testRect.x + testRect.width, testRect.y + testRect.height))) continue;
                xIntersection = (int)(((double)(testRect.y + testRect.height) - line2D.getY1()) * (line2D.getX2() - line2D.getX1()) / (line2D.getY2() - line2D.getY1()) + line2D.getX1());
                pretenders.add(xIntersection);
            }
            int leftMost = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            Iterator xIntersection = pretenders.iterator();
            while (xIntersection.hasNext()) {
                int x = (Integer)xIntersection.next();
                if (x < leftMost) {
                    leftMost = x;
                }
                if (x <= n) continue;
                n = x;
            }
            Rectangle bannedRect = new Rectangle(leftMost, testRect.y, (int)(n - leftMost), testRect.height);
            graphSpaceLevels.get(i).add(bannedRect);
        }
    }

    protected List<Point> computeBezierTrio(List<Point> controlPoints, int ind, double coefLength) {
        Line2D.Double parLine = new Line2D.Double(controlPoints.get(ind), controlPoints.get(ind + 2));
        Line2D.Double seg1 = new Line2D.Double(controlPoints.get(ind), controlPoints.get(ind + 1));
        Line2D.Double seg2 = new Line2D.Double(controlPoints.get(ind + 1), controlPoints.get(ind + 2));
        double lengthParLine = Math.sqrt(Math.pow(((Line2D)parLine).getX1() - ((Line2D)parLine).getX2(), 2.0) + Math.pow(((Line2D)parLine).getY1() - ((Line2D)parLine).getY2(), 2.0));
        double lengthSeg1 = Math.sqrt(Math.pow(((Line2D)seg1).getX1() - ((Line2D)seg1).getX2(), 2.0) + Math.pow(((Line2D)seg1).getY1() - ((Line2D)seg1).getY2(), 2.0));
        double lengthSeg2 = Math.sqrt(Math.pow(((Line2D)seg2).getX1() - ((Line2D)seg2).getX2(), 2.0) + Math.pow(((Line2D)seg2).getY1() - ((Line2D)seg2).getY2(), 2.0));
        int dy1 = (int)(((Line2D)seg1).getY2() - ((Line2D)parLine).getY2());
        int dx1 = (int)(((Line2D)seg1).getX2() - ((Line2D)parLine).getX2());
        Line2D.Double controlLine1 = new Line2D.Double(((Line2D)parLine).getX1() + (double)dx1, ((Line2D)parLine).getY1() + (double)dy1, ((Line2D)parLine).getX2() + (double)dx1, ((Line2D)parLine).getY2() + (double)dy1);
        double k1 = lengthSeg1 * coefLength / lengthParLine;
        int dyParLine = (int)(((Line2D)parLine).getY2() - ((Line2D)parLine).getY1());
        int dxParLine = (int)(((Line2D)parLine).getX2() - ((Line2D)parLine).getX1());
        Point2D endSeg1 = ((Line2D)controlLine1).getP2();
        controlLine1.setLine(new Point2D.Double(endSeg1.getX() - k1 * (double)dxParLine, endSeg1.getY() - k1 * (double)dyParLine), endSeg1);
        int dy2 = (int)(((Line2D)seg2).getY1() - ((Line2D)parLine).getY1());
        int dx2 = (int)(((Line2D)seg2).getX1() - ((Line2D)parLine).getX1());
        Line2D.Double controlLine2 = new Line2D.Double(((Line2D)parLine).getX1() + (double)dx2, ((Line2D)parLine).getY1() + (double)dy2, ((Line2D)parLine).getX2() + (double)dx2, ((Line2D)parLine).getY2() + (double)dy2);
        double k2 = lengthSeg2 * coefLength / lengthParLine;
        Point2D startSeg2 = ((Line2D)controlLine2).getP1();
        controlLine2.setLine(startSeg2, new Point2D.Double(startSeg2.getX() + k2 * (double)dxParLine, startSeg2.getY() + k2 * (double)dyParLine));
        ArrayList<Point> resultTrio = new ArrayList<Point>(3);
        resultTrio.add(new Point((int)((Line2D)controlLine1).getP1().getX(), (int)((Line2D)controlLine1).getP1().getY()));
        resultTrio.add(controlPoints.get(ind + 1));
        resultTrio.add(new Point((int)((Line2D)controlLine2).getP2().getX(), (int)((Line2D)controlLine2).getP2().getY()));
        return resultTrio;
    }

    protected boolean computeControlPoints(Point start, Point end, List<Rectangle> boxes, List<Line2D> lArray, List<Point> controlPoints) {
        if (this.lineFits(start, end, lArray)) {
            return true;
        }
        Point p = this.computeLineSplit(start, end, boxes, lArray);
        controlPoints.add(p);
        boolean result = this.computeControlPoints(start, p, boxes, lArray, controlPoints);
        return result &= this.computeControlPoints(p, end, boxes, lArray, controlPoints);
    }

    protected Point computeLineSplit(Point start, Point end, List<Rectangle> boxes, List<Line2D> lArray) {
        int startIndex = 0;
        while (lArray.get(startIndex).getY1() <= (double)start.y) {
            ++startIndex;
        }
        int endIndex = lArray.size() - 1;
        while (lArray.get(endIndex).getY1() > (double)end.y) {
            --endIndex;
        }
        Line2D.Double edgeSegment = new Line2D.Double(start, end);
        Point2D p = null;
        for (int ind = startIndex; ind <= endIndex; ++ind) {
            if (edgeSegment.intersectsLine(lArray.get(ind))) continue;
            if (edgeSegment.ptSegDist(lArray.get(ind).getP1()) < edgeSegment.ptSegDist(lArray.get(ind).getP2())) {
                if (p != null && !(edgeSegment.ptSegDist(lArray.get(ind).getP1()) > edgeSegment.ptSegDist(p))) continue;
                p = lArray.get(ind).getP1();
                continue;
            }
            if (p != null && !(edgeSegment.ptSegDist(lArray.get(ind).getP2()) > edgeSegment.ptSegDist(p))) continue;
            p = lArray.get(ind).getP2();
        }
        return new Point((int)p.getX(), (int)p.getY());
    }

    private boolean lineFits(Point start, Point end, List<Line2D> lArray) {
        int startIndex = 0;
        while (lArray.get(startIndex).getY1() <= (double)start.y) {
            ++startIndex;
        }
        int endIndex = lArray.size() - 1;
        while (lArray.get(endIndex).getY1() > (double)end.y) {
            --endIndex;
        }
        Line2D.Double edgeSegment = new Line2D.Double(start, end);
        for (int ind = startIndex; ind <= endIndex; ++ind) {
            if (edgeSegment.intersectsLine(lArray.get(ind))) continue;
            return false;
        }
        return true;
    }

    protected List<Rectangle> computeBoxes(Edge edge, Graph graph) {
        int startLevel;
        List boxes = (List)edge.data;
        this.updateDummiesBoxes(boxes, (List)graph.data);
        Rectangle startRegion = this.getRegionToNode(edge.from, graph);
        startRegion.y += startRegion.height / 2;
        startRegion.height /= 2;
        boxes.add(0, startRegion);
        int endLevel = HierarchicLayouter.getLevel(edge.to);
        for (int currentLevel = startLevel = HierarchicLayouter.getLevel(edge.from); currentLevel < endLevel; ++currentLevel) {
            Rectangle regionBetweenLevels = this.getRegionBetweenLevels(currentLevel, graph);
            boxes.add((currentLevel - startLevel) * 2 + 1, regionBetweenLevels);
        }
        Rectangle endRegion = this.getRegionToNode(edge.to, graph);
        endRegion.height /= 2;
        boxes.add(endRegion);
        return new ArrayList<Rectangle>(boxes);
    }

    protected void updateDummiesBoxes(List<Rectangle> boxes, List<List<Rectangle>> graphBannedSpaceLevels) {
        int indent = 15;
        int shift = 0;
        while (boxes.get((int)0).y != graphBannedSpaceLevels.get((int)shift).get((int)0).y) {
            ++shift;
        }
        for (int level = 0; level < boxes.size(); ++level) {
            Rectangle curFreeBox = boxes.get(level);
            int startX = curFreeBox.x;
            int endX = curFreeBox.x + curFreeBox.width;
            List<Rectangle> curLevelBannedBoxes = graphBannedSpaceLevels.get(level + shift);
            if (curLevelBannedBoxes.size() <= 1) continue;
            Collections.sort(curLevelBannedBoxes, new Comparator<Rectangle>(){

                @Override
                public int compare(Rectangle r1, Rectangle r2) {
                    if (r1.x == Integer.MIN_VALUE) {
                        return -1;
                    }
                    if (r2.x == Integer.MIN_VALUE) {
                        return 1;
                    }
                    return r1.x - r2.x;
                }
            });
            int averageWidth = 0;
            for (Rectangle rec : curLevelBannedBoxes) {
                averageWidth += rec.width;
            }
            averageWidth = (int)((double)averageWidth / (double)(curLevelBannedBoxes.size() - 1));
            Iterator<Rectangle> boxItr = curLevelBannedBoxes.iterator();
            boxItr.next();
            int findingInterval = 30 + averageWidth;
            int tmpStartX = startX;
            while (tmpStartX < endX - findingInterval) {
                Rectangle curBox = null;
                if (!boxItr.hasNext()) break;
                curBox = boxItr.next();
                if (curBox.x >= tmpStartX + findingInterval) break;
                tmpStartX = tmpStartX > curBox.x + curBox.width ? tmpStartX : curBox.x + curBox.width;
            }
            if (tmpStartX < endX - findingInterval) {
                curFreeBox.x = tmpStartX + 15;
                continue;
            }
            throw new RuntimeException("no space for path");
        }
    }

    protected Rectangle getRegionBetweenLevels(int currentLevel, Graph graph) {
        int upSide = 0;
        int downSide = Integer.MAX_VALUE;
        for (Node node : graph.nodeList) {
            if (HierarchicLayouter.getLevel(node) == currentLevel) {
                if (node.y + node.height <= upSide) continue;
                upSide = node.y + node.height;
                continue;
            }
            if (HierarchicLayouter.getLevel(node) != currentLevel + 1 || node.y >= downSide) continue;
            downSide = node.y;
        }
        Rectangle region = new Rectangle(0, upSide, Integer.MAX_VALUE, downSide - upSide);
        return region;
    }

    protected void createStraightPath(Edge edge) {
        Node fromNode = edge.from;
        Node toNode = edge.to;
        Point start = new Point(fromNode.x + fromNode.width / 2, fromNode.y + fromNode.height / 2);
        Point end = new Point(toNode.x + toNode.width / 2, toNode.y + toNode.height / 2);
        edge.path.addPoint(start.x, start.y, 0);
        edge.path.addPoint(end.x, end.y, 0);
        Rectangle box = new Rectangle(start.x, start.y, end.x - start.x, end.y - start.y);
        edge.data = box;
    }

    protected Path shiftParallelMidway(Edge masterEdge, Edge actualEdge, int index, Graph graph) {
        int center;
        int diffNodes;
        int distanceThroughLevel;
        Path masterPath = masterEdge.path;
        Path newPath = new Path();
        int inEdgeNum = 0;
        List<Edge> edgeIn = graph.getEdges(masterEdge.from);
        for (Edge e : edgeIn) {
            if (e.from != masterEdge.from) continue;
            ++inEdgeNum;
            if (e.slaves == null) continue;
            inEdgeNum += e.slaves.size();
        }
        int outEdgeNum = 0;
        List<Edge> edgeOut = graph.getEdges(masterEdge.to);
        for (Edge e : edgeOut) {
            if (e.to != masterEdge.to) continue;
            ++outEdgeNum;
            if (e.slaves == null) continue;
            outEdgeNum += e.slaves.size();
        }
        float span = 5.0f;
        int numberParallelEdges = masterEdge.slaves.size() + 1;
        if (this.verticalOrientation) {
            span = Math.max(this.gridX, Math.min(masterEdge.from.width / (inEdgeNum + 1), masterEdge.to.width / (outEdgeNum + 1)));
            distanceThroughLevel = Math.abs(masterEdge.from.y - masterEdge.to.y);
            diffNodes = masterEdge.from.x - masterEdge.to.x;
            center = (masterEdge.from.x + masterEdge.to.x) / 2 + (masterEdge.from.width + masterEdge.to.width) / 4;
        } else {
            span = Math.max(this.gridY, Math.min(masterEdge.from.height / (inEdgeNum + 1), masterEdge.to.height / (outEdgeNum + 1)));
            distanceThroughLevel = Math.abs(masterEdge.from.x - masterEdge.to.x);
            diffNodes = masterEdge.from.y - masterEdge.to.y;
            center = (masterEdge.from.y + masterEdge.to.y) / 2 + (masterEdge.from.height + masterEdge.to.height) / 4;
        }
        double straightLength = Math.sqrt(distanceThroughLevel * distanceThroughLevel + diffNodes * diffNodes);
        int adaptedDistanceBetweenMidpoint = (int)Math.round((double)this.virtualNodesDistance * straightLength * 2.0 / (double)distanceThroughLevel);
        int startMidway = numberParallelEdges % 2 != 0 ? center - numberParallelEdges / 2 * adaptedDistanceBetweenMidpoint : center - (numberParallelEdges - 1) * adaptedDistanceBetweenMidpoint / 2;
        int offset = Math.round(span * (float)index);
        if (this.verticalOrientation) {
            Point start = actualEdge.from.findPort(masterPath.xpoints[0] + offset, masterPath.ypoints[0], actualEdge);
            newPath.addPoint(start.x, start.y, masterPath.pointTypes[0]);
            int midpoint = (masterPath.ypoints[0] + masterPath.ypoints[1]) / 2;
            newPath.addPoint(startMidway + adaptedDistanceBetweenMidpoint * index, midpoint, 0);
            Point end = actualEdge.to.findPort(masterPath.xpoints[masterPath.npoints - 1] + offset, masterPath.ypoints[masterPath.npoints - 1], actualEdge);
            newPath.addPoint(end.x, end.y, masterPath.pointTypes[masterPath.npoints - 1]);
        } else {
            Point start = actualEdge.from.findPort(masterPath.xpoints[0], masterPath.ypoints[0] + offset, actualEdge);
            newPath.addPoint(start.x, start.y, masterPath.pointTypes[0]);
            int midpoint = (masterPath.xpoints[0] + masterPath.xpoints[1]) / 2;
            newPath.addPoint(midpoint, startMidway + adaptedDistanceBetweenMidpoint * index, 0);
            Point end = actualEdge.to.findPort(masterPath.xpoints[masterPath.npoints - 1], masterPath.ypoints[masterPath.npoints - 1] + offset, actualEdge);
            newPath.addPoint(end.x, end.y, masterPath.pointTypes[masterPath.npoints - 1]);
        }
        return newPath;
    }

    private void computingControlPoints(Edge edge) {
        int start;
        int i;
        int distArrow;
        Path path = edge.path;
        Path bezierPath = new Path();
        if (edge.from == edge.to) {
            bezierPath.addPoint(path.xpoints[0], path.ypoints[0], 0);
            if (path.xpoints[2] == path.xpoints[1]) {
                int dx = (path.xpoints[3] - path.xpoints[2]) / 2;
                int dy = (path.ypoints[1] - path.ypoints[2]) / 2;
                int Lx = (int)Math.round((double)dx * 4.0 / 3.0 * Math.tan(0.39269908169872414));
                int Ly = (int)Math.round((double)dy * 4.0 / 3.0 * Math.tan(0.39269908169872414));
                bezierPath.addPoint(path.xpoints[2] + dx, path.ypoints[2] + 2 * dy, 0);
                bezierPath.addPoint(path.xpoints[2] + dx - Lx, path.ypoints[2] + 2 * dy, 2);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy + Ly, 0);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy, 0);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy, 0);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy - Ly, 2);
                bezierPath.addPoint(path.xpoints[2] + dx - Lx, path.ypoints[2], 0);
                bezierPath.addPoint(path.xpoints[2] + dx, path.ypoints[2], 0);
                bezierPath.addPoint(path.xpoints[2] + dx, path.ypoints[2], 0);
                bezierPath.addPoint(path.xpoints[2] + dx + Lx, path.ypoints[2], 2);
                bezierPath.addPoint(path.xpoints[2] + 2 * dx, path.ypoints[2] + dy - Ly, 0);
                bezierPath.addPoint(path.xpoints[2] + 2 * dx, path.ypoints[2] + dy, 0);
            } else {
                int dx = (path.xpoints[2] - path.xpoints[1]) / 2;
                int dy = (path.ypoints[3] - path.ypoints[2]) / 2;
                int Lx = (int)Math.round((double)dx * 4.0 / 3.0 * Math.tan(0.39269908169872414));
                int Ly = (int)Math.round((double)dy * 4.0 / 3.0 * Math.tan(0.39269908169872414));
                bezierPath.addPoint(path.xpoints[2] - 2 * dx, path.ypoints[2] + dy, 0);
                bezierPath.addPoint(path.xpoints[2] - 2 * dx, path.ypoints[2] + dy - Ly, 2);
                bezierPath.addPoint(path.xpoints[2] - dx - Lx, path.ypoints[2], 0);
                bezierPath.addPoint(path.xpoints[2] - dx, path.ypoints[2], 0);
                bezierPath.addPoint(path.xpoints[2] - dx, path.ypoints[2], 0);
                bezierPath.addPoint(path.xpoints[2] - dx + Lx, path.ypoints[2], 2);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy - Ly, 0);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy, 0);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy, 0);
                bezierPath.addPoint(path.xpoints[2], path.ypoints[2] + dy + Ly, 2);
                bezierPath.addPoint(path.xpoints[2] - dx + Lx, path.ypoints[2] + 2 * dy, 0);
                bezierPath.addPoint(path.xpoints[2] - dx, path.ypoints[2] + 2 * dy, 0);
            }
            bezierPath.addPoint(path.xpoints[4], path.ypoints[4], 0);
            edge.path = bezierPath;
            return;
        }
        if (this.verticalOrientation) {
            distArrow = (path.ypoints[1] - path.ypoints[0]) / 4;
            if (path.xpoints[0] != path.xpoints[1]) {
                bezierPath.addPoint(path.xpoints[0], path.ypoints[0], 0);
                path.ypoints[0] = path.ypoints[0] + distArrow;
            }
            for (i = 0; i < path.npoints - 1; ++i) {
                if (path.xpoints[i] == path.xpoints[i + 1]) {
                    bezierPath.addPoint(path.xpoints[i], path.ypoints[i], 0);
                    start = i;
                    while (i < path.npoints - 3 && path.xpoints[start] == path.xpoints[i + 2]) {
                        ++i;
                    }
                    continue;
                }
                int dy = (path.ypoints[i + 1] - path.ypoints[i]) / 2;
                bezierPath.addPoint(path.xpoints[i], path.ypoints[i], 0);
                bezierPath.addPoint(path.xpoints[i], path.ypoints[i] + dy, 2);
                bezierPath.addPoint(path.xpoints[i + 1], path.ypoints[i + 1] - dy, 0);
            }
            if (bezierPath.npoints > 1 && bezierPath.pointTypes[bezierPath.npoints - 2] == 2) {
                int n = bezierPath.npoints - 1;
                bezierPath.ypoints[n] = bezierPath.ypoints[n] - distArrow;
                bezierPath.addPoint(path.xpoints[path.npoints - 1], path.ypoints[path.npoints - 1] - distArrow, 0);
            }
            this.adjustArrowTipConnection(bezierPath);
        } else {
            distArrow = (path.xpoints[1] - path.xpoints[0]) / 4;
            if (path.ypoints[0] != path.ypoints[1]) {
                bezierPath.addPoint(path.xpoints[0], path.ypoints[0], 0);
                path.xpoints[0] = path.xpoints[0] + distArrow;
            }
            for (i = 0; i < path.npoints - 1; ++i) {
                if (path.ypoints[i] == path.ypoints[i + 1]) {
                    bezierPath.addPoint(path.xpoints[i], path.ypoints[i], 0);
                    start = i;
                    while (i < path.npoints - 3 && path.ypoints[start] == path.ypoints[i + 2]) {
                        ++i;
                    }
                    continue;
                }
                int dx = (path.xpoints[i + 1] - path.xpoints[i]) / 2;
                bezierPath.addPoint(path.xpoints[i], path.ypoints[i], 0);
                bezierPath.addPoint(path.xpoints[i] + dx, path.ypoints[i], 2);
                bezierPath.addPoint(path.xpoints[i + 1] - dx, path.ypoints[i + 1], 0);
            }
            if (bezierPath.npoints > 1 && bezierPath.pointTypes[bezierPath.npoints - 2] == 2) {
                int n = bezierPath.npoints - 1;
                bezierPath.xpoints[n] = bezierPath.xpoints[n] - distArrow;
                bezierPath.addPoint(path.xpoints[path.npoints - 1] - distArrow, path.ypoints[path.npoints - 1], 0);
            }
        }
        bezierPath.addPoint(path.xpoints[path.npoints - 1], path.ypoints[path.npoints - 1], 0);
        edge.path = bezierPath;
        if (Math.abs(HierarchicLayouter.getLevel(edge.from) - HierarchicLayouter.getLevel(edge.to)) == 1 && bezierPath.npoints == 9) {
            int levelDist;
            int pointDist = this.verticalOrientation ? bezierPath.ypoints[4] - bezierPath.ypoints[0] : bezierPath.xpoints[4] - bezierPath.xpoints[0];
            int n = levelDist = this.verticalOrientation ? this.layerDeltaY : this.layerDeltaX;
            if (pointDist <= levelDist / 2) {
                int pointDiff;
                int n2 = pointDiff = this.verticalOrientation ? bezierPath.xpoints[8] - bezierPath.xpoints[0] : bezierPath.ypoints[8] - bezierPath.ypoints[0];
                if (pointDiff != 0) {
                    Path newPath = new Path();
                    Point p0 = new Point(this.verticalOrientation ? bezierPath.xpoints[1] : bezierPath.ypoints[1], this.verticalOrientation ? bezierPath.ypoints[1] : bezierPath.xpoints[1]);
                    Point p2 = new Point(this.verticalOrientation ? bezierPath.xpoints[7] : bezierPath.ypoints[7], this.verticalOrientation ? bezierPath.ypoints[7] : bezierPath.xpoints[7]);
                    Point p1 = new Point(this.verticalOrientation ? bezierPath.xpoints[4] : bezierPath.ypoints[4], this.verticalOrientation ? bezierPath.ypoints[4] : bezierPath.xpoints[4]);
                    float koefLengthControl = 0.125f;
                    Point controlPoint1 = new Point(Math.round((float)p1.x - 0.125f * (float)(p2.x - p0.x)), Math.round((float)p1.y - 0.125f * (float)(p2.y - p0.y)));
                    Point controlPoint2 = new Point(Math.round((float)p1.x - 0.125f * (float)(p0.x - p2.x)), Math.round((float)p1.y - 0.125f * (float)(p0.y - p2.y)));
                    newPath.addPoint(bezierPath.xpoints[0], bezierPath.ypoints[0], 0);
                    newPath.addPoint(bezierPath.xpoints[1], bezierPath.ypoints[1], 0);
                    newPath.addPoint(bezierPath.xpoints[2], bezierPath.ypoints[2], 2);
                    if (this.verticalOrientation) {
                        newPath.addPoint(controlPoint1.x, controlPoint1.y, 0);
                        newPath.addPoint(p1.x, p1.y, 0);
                        newPath.addPoint(controlPoint2.x, controlPoint2.y, 2);
                    } else {
                        newPath.addPoint(controlPoint1.y, controlPoint1.x, 0);
                        newPath.addPoint(p1.y, p1.x, 0);
                        newPath.addPoint(controlPoint2.y, controlPoint2.x, 2);
                    }
                    newPath.addPoint(bezierPath.xpoints[6], bezierPath.ypoints[6], 0);
                    newPath.addPoint(bezierPath.xpoints[7], bezierPath.ypoints[7], 0);
                    newPath.addPoint(bezierPath.xpoints[8], bezierPath.ypoints[8], 2);
                    edge.path = newPath;
                }
                return;
            }
        }
    }

    public void adjustArrowTipConnection(Path path) {
        int shift = 10;
        boolean right = path.xpoints[path.npoints - 1] > path.xpoints[0];
        double middlePoint = (path.xpoints[path.npoints - 1] + path.xpoints[0]) / 2;
        for (int i = 0; i < path.npoints; ++i) {
            if ((double)path.xpoints[i] > middlePoint != right) continue;
            int n = i;
            path.ypoints[n] = path.ypoints[n] - shift;
        }
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl jobControl) {
        if (!(this.getPathLayouter() instanceof HierarchicPathLayouter)) {
            this.getPathLayouter().layoutPath(graph, edge, jobControl);
            return;
        }
        new DiagonalPathLayouter().layoutPath(graph, edge, this.pathWeighter);
    }

    protected List<List<Edge>> getOrderedEdgeSet(Graph graph, Node n, boolean in) {
        ArrayList<List<Edge>> result = new ArrayList<List<Edge>>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int level = HierarchicLayouter.getLevel(n) + (in ? -2 : 0);
        if (level < 0 || level >= this.maxLevel) {
            return result;
        }
        for (Node u : this.levelNodes.get(level)) {
            Edge edge = in ? graph.getEdge(u, n) : graph.getEdge(n, u);
            if (edge == null) continue;
            if (this.isFixed(edge, n)) {
                if (!edges.isEmpty()) {
                    result.add(edges);
                }
                ArrayList<Edge> singleEdge = new ArrayList<Edge>();
                singleEdge.add(edge);
                result.add(singleEdge);
                edges = new ArrayList();
            } else {
                edges.add(edge);
            }
            if (!this.isDummy(n) && edge.slaves != null) {
                for (Edge slave : edge.slaves) {
                    edges.add(slave);
                }
            }
            if (!this.isDummy(n) || edge.data == null) continue;
            int slavesCount = ((List)edge.data).size();
            for (int i = 0; i < slavesCount; ++i) {
                edges.add(null);
            }
        }
        if (!edges.isEmpty()) {
            result.add(edges);
        }
        return result;
    }

    protected boolean isFixed(Edge edge, Node node) {
        Point port = node.findPort(node.x, node.y, edge);
        return port.x != node.x || port.y != node.y;
    }

    public boolean isVerticalOrientation() {
        return this.verticalOrientation;
    }

    public void setVerticalOrientation(boolean verticalOrientation) {
        this.verticalOrientation = verticalOrientation;
    }

    public boolean isHoistNodes() {
        return this.hoistNodes;
    }

    public void setHoistNodes(boolean hoistNodes) {
        this.hoistNodes = hoistNodes;
    }

    public int getLayerOrderIterationNum() {
        return this.layerOrderIterationNum;
    }

    public void setLayerOrderIterationNum(int layerOrderIterationNum) {
        this.layerOrderIterationNum = layerOrderIterationNum;
    }

    public int getStraightenMethod() {
        return this.straightenMethod;
    }

    public void setStraightenMethod(int straightenMethod) {
        this.straightenMethod = straightenMethod;
    }

    public int getStraightenIterationNum() {
        return this.straightenIterationNum;
    }

    public void setStraightenIterationNum(int straightenIterationNum) {
        this.straightenIterationNum = straightenIterationNum;
    }

    public boolean isProcessNeighbours() {
        return this.processNeighbours;
    }

    public void setProcessNeighbours(boolean processNeighbours) {
        this.processNeighbours = processNeighbours;
    }

    public int getVirtualNodesDistance() {
        return this.virtualNodesDistance;
    }

    public void setVirtualNodesDistance(int virtualNodesDistance) {
        this.virtualNodesDistance = virtualNodesDistance;
    }

    public int getLayerDeltaX() {
        return this.layerDeltaX;
    }

    public void setLayerDeltaX(int layerDeltaX) {
        this.layerDeltaX = layerDeltaX;
    }

    public int getLayerDeltaY() {
        return this.layerDeltaY;
    }

    public void setLayerDeltaY(int layerDeltaY) {
        this.layerDeltaY = layerDeltaY;
    }

    public boolean isSplineEdges() {
        return this.splineEdges;
    }

    public void setSplineEdges(boolean splineEdges) {
        this.splineEdges = splineEdges;
    }

    public void initLayoutData(Graph graph) {
        for (Node n : graph.nodeList) {
            n.data = new LayoutData();
        }
    }

    protected void unmarkNodes(Graph graph) {
        for (Node n : graph.nodeList) {
            ((LayoutData)n.data).marked = false;
        }
    }

    protected void printNodeLevels(Graph graph) {
        for (Node node : graph.nodeList) {
            System.out.print(node.name + ":" + ((LayoutData)node.data).level + ", ");
        }
    }

    protected static int getLevel(Node node) {
        return ((LayoutData)node.data).level;
    }

    protected static void setLevel(Node node, int level) {
        ((LayoutData)node.data).level = level;
    }

    protected static int getUsageLevel(Node node) {
        return ((LayoutData)node.data).usageLevel;
    }

    protected static void setUsageLevel(Node node, int level) {
        ((LayoutData)node.data).usageLevel = level;
    }

    protected boolean isDummy(Node node) {
        return ((LayoutData)node.data).dummy;
    }

    protected boolean isMarked(Node node) {
        return ((LayoutData)node.data).marked;
    }

    protected int getBarycenter(Node node) {
        return ((LayoutData)node.data).barycenter;
    }

    protected int calcBarycenter(Graph graph, Node node, boolean doIn, boolean doOut, boolean processSize) {
        Node u;
        int sum = 0;
        int n = 0;
        int center = 0;
        for (Edge edge : graph.getEdges(node)) {
            u = null;
            if (edge.to == node && doIn) {
                u = edge.from;
            } else if (edge.from == node && doOut) {
                u = edge.to;
            }
            if (u == null) continue;
            center = this.verticalOrientation ? u.x : u.y;
            if (processSize) {
                center = this.verticalOrientation ? (center += u.width / 2) : (center += u.height / 2);
            }
            sum += center;
            ++n;
        }
        if (processSize && this.processNeighbours) {
            int i;
            List<Node> level = this.levelNodes.get(HierarchicLayouter.getLevel(node) - 1);
            for (i = 0; i < level.size() && level.get(i) != node; ++i) {
            }
            if (i > 0) {
                u = level.get(i - 1);
                center = this.verticalOrientation ? u.x + u.width / 2 : u.y + u.height / 2;
                sum += center;
                ++n;
            }
            if (i < level.size() - 1) {
                u = level.get(i + 1);
                center = this.verticalOrientation ? u.x + u.width / 2 : u.y + u.height / 2;
                sum += center;
                ++n;
            }
        }
        sum = n != 0 ? (sum /= n) : (this.verticalOrientation ? node.x + (processSize ? node.width / 2 : 0) : node.y + (processSize ? node.height / 2 : 0));
        ((LayoutData)node.data).barycenter = sum;
        return sum;
    }

    protected void normalise(Graph graph) {
        this.selfLoops = new ArrayList<Edge>();
        for (int i = 0; i < graph.edgeList.size(); ++i) {
            Edge edge = graph.edgeList.get(i);
            if (edge.from != edge.to) continue;
            edge.path = null;
            this.selfLoops.add(edge);
            graph.removeEdge(edge);
            --i;
        }
        this.unmarkNodes(graph);
        for (Node node : graph.nodeList) {
            if (((LayoutData)node.data).marked) continue;
            this.breakCycles(graph, node);
        }
    }

    protected void breakCycles(Graph graph, Node curr) {
        ((LayoutData)curr.data).marked = true;
        ((LayoutData)curr.data).picked = true;
        List<Edge> edges = graph.getEdges(curr);
        if (edges == null) {
            return;
        }
        for (int j = 0; j < edges.size(); ++j) {
            Edge edge = edges.get(j);
            if (edge.from != curr) continue;
            Node n = edge.to;
            if (((LayoutData)n.data).picked) {
                graph.removeEdge(edge);
                edge.reverseDirection();
                graph.addEdge(edge);
                --j;
                continue;
            }
            if (((LayoutData)n.data).marked) continue;
            j = 0;
            this.breakCycles(graph, n);
        }
        ((LayoutData)curr.data).picked = false;
    }

    protected void assignNodeLevels(Graph graph) {
        List<Edge> edges;
        Node v;
        int i;
        ArrayList<Node> topoSortedNodes = new ArrayList<Node>();
        Node metaRoot = this.makeMetaRoot(graph);
        this.unmarkNodes(graph);
        HierarchicLayouter.topoSort(graph, metaRoot, topoSortedNodes);
        graph.removeNode(metaRoot);
        topoSortedNodes.remove(metaRoot);
        int toposize = topoSortedNodes.size();
        this.maxLevel = 0;
        for (i = 0; i < toposize; ++i) {
            v = topoSortedNodes.get(i);
            int level = 0;
            edges = graph.getEdges(v);
            for (Edge edge : edges) {
                Node u;
                if (edge.to != v || HierarchicLayouter.getLevel(u = edge.from) <= level) continue;
                level = HierarchicLayouter.getLevel(u);
            }
            HierarchicLayouter.setLevel(v, level + 1);
            if (level + 1 <= this.maxLevel) continue;
            this.maxLevel = level + 1;
        }
        for (i = topoSortedNodes.size() - 1; i >= 0; --i) {
            v = topoSortedNodes.get(i);
            int minUsageLevel = this.maxLevel;
            edges = graph.getEdges(v);
            boolean hasOutEdges = false;
            for (Edge edge : edges) {
                if (edge.from != v) continue;
                hasOutEdges = true;
                break;
            }
            if (!this.hoistNodes && !hasOutEdges) {
                minUsageLevel = HierarchicLayouter.getLevel(v);
            } else {
                for (Edge edge : edges) {
                    Node u;
                    int usageLevel;
                    if (edge.from != v || (usageLevel = HierarchicLayouter.getUsageLevel(u = edge.to) - 1) >= minUsageLevel) continue;
                    minUsageLevel = usageLevel;
                }
            }
            HierarchicLayouter.setUsageLevel(v, minUsageLevel);
        }
        for (i = 0; i < toposize; ++i) {
            v = topoSortedNodes.get(i);
            HierarchicLayouter.setLevel(v, HierarchicLayouter.getUsageLevel(v));
        }
    }

    public static void topoSort(Graph graph, Node curr, List<Node> topoSortedNodes) {
        ((LayoutData)curr.data).marked = true;
        List<Edge> edges = graph.getEdges(curr);
        for (Edge edge : edges) {
            if (edge.to != curr) continue;
            Node n = edge.from;
            if (((LayoutData)n.data).marked) continue;
            HierarchicLayouter.topoSort(graph, n, topoSortedNodes);
        }
        topoSortedNodes.add(curr);
    }

    protected void addDummies(Graph graph) {
        int dummyCount = 1;
        for (int i = 0; i < graph.nodeCount(); ++i) {
            Node to = graph.nodeList.get(i);
            if (((LayoutData)to.data).dummy) continue;
            List<Edge> edges = graph.getEdges(to);
            for (int j = 0; j < edges.size(); ++j) {
                Edge edge = edges.get(j);
                edge.path = new Path();
                if (edge.to != to || ((LayoutData)edge.from.data).dummy) continue;
                if (HierarchicLayouter.getLevel(to) > HierarchicLayouter.getLevel(edge.from) + 1) {
                    --j;
                }
                while (HierarchicLayouter.getLevel(to) > HierarchicLayouter.getLevel(edge.from) + 1) {
                    Node from = edge.from;
                    Node dummy = new Node("dummy_" + dummyCount);
                    ++dummyCount;
                    graph.addNode(dummy);
                    dummy.data = new LayoutData();
                    HierarchicLayouter.setLevel(dummy, HierarchicLayouter.getLevel(from) + 1);
                    ((LayoutData)dummy.data).dummy = true;
                    Edge in = new Edge(from, dummy);
                    in.data = null;
                    in.reversed = edge.reversed;
                    if (edge.getAttribute("inputPortName") != null) {
                        in.setAttribute("inputPortName", edge.getAttribute("inputPortName"));
                    }
                    graph.addEdge(in);
                    Edge out = new Edge(dummy, to);
                    out.data = null;
                    out.reversed = edge.reversed;
                    if (edge.getAttribute("outputPortName") != null) {
                        out.setAttribute("outputPortName", edge.getAttribute("outputPortName"));
                    }
                    graph.addEdge(out);
                    graph.removeEdge(edge);
                    edge = out;
                }
            }
        }
    }

    protected void removeDummies(Graph graph) {
        for (int i = 0; i < graph.nodeCount(); ++i) {
            Node from = graph.nodeList.get(i);
            if (Util.isCompartment(from) || this.isDummy(from)) continue;
            List<Edge> edges = graph.getEdges(from);
            for (int j = 0; j < edges.size(); ++j) {
                Edge edge = edges.get(j);
                if (edge.from != from || !this.isDummy(edge.to)) continue;
                Path line = new Path();
                line.addPoint(edge.path.xpoints[0], edge.path.ypoints[0]);
                this.addDummyNodeToPath(edge.to, line, edge.path.xpoints[1], edge.path.ypoints[1]);
                ArrayList<Node> path = new ArrayList<Node>();
                path.add(edge.to);
                Node to = edge.to;
                int pathLen = 1;
                while (true) {
                    List<Edge> dEdges = graph.getEdges(to);
                    for (int d = 0; d < 2; ++d) {
                        Edge e = dEdges.get(d);
                        if (e.from != to) continue;
                        to = e.to;
                        if (this.isDummy(to)) {
                            this.addDummyNodeToPath(e.to, line, e.path.xpoints[1], e.path.ypoints[1]);
                            break;
                        }
                        line.addPoint(e.path.xpoints[1], e.path.ypoints[1]);
                        break;
                    }
                    if (!this.isDummy(to)) break;
                    path.add(to);
                    ++pathLen;
                }
                Edge originalEdge = new Edge(from, to);
                originalEdge.reversed = edge.reversed;
                originalEdge.path = line;
                Edge masterEdge = graph.getEdge(from, to, true);
                if (masterEdge == null) {
                    originalEdge.master = true;
                } else {
                    originalEdge.master = false;
                    masterEdge.addSlave(originalEdge);
                }
                graph.addEdge(originalEdge);
                List slaves = (List)edge.data;
                if (slaves != null) {
                    for (Object slave : slaves) {
                        graph.addEdge((Edge)slave);
                    }
                }
                for (Node aPath : path) {
                    graph.removeNode(aPath);
                }
                if ((j -= pathLen) >= 0) continue;
                j = 0;
            }
        }
    }

    private void addDummyNodeToPath(Node dummyNode, Path path, int x, int y) {
        int levelSize = this.levelSizes[HierarchicLayouter.getLevel(dummyNode) - 1];
        if (levelSize > 20) {
            int virtualPointDeltaY = this.verticalOrientation ? levelSize / 2 : 0;
            int virtualPointDeltaX = this.verticalOrientation ? 0 : levelSize / 2;
            path.addPoint(x - virtualPointDeltaX, y - virtualPointDeltaY);
            path.addPoint(x + virtualPointDeltaX, y + virtualPointDeltaY);
        } else {
            path.addPoint(x, y, 2);
        }
    }

    protected void makeLevels(Graph graph) {
        this.maxLevel = -1;
        Node maxLevelNode = null;
        for (Node n : graph.nodeList) {
            if (this.maxLevel >= HierarchicLayouter.getLevel(n)) continue;
            this.maxLevel = HierarchicLayouter.getLevel(n);
            maxLevelNode = n;
        }
        if (this.maxLevel == -1) {
            return;
        }
        this.levelNodes = new ArrayList(this.maxLevel);
        for (int j = 0; j < this.maxLevel; ++j) {
            this.levelNodes.add(new ArrayList());
        }
        this.levelSizes = new int[this.maxLevel];
        this.unmarkNodes(graph);
        this.initialOrderNodes(graph, maxLevelNode);
        for (Node n : graph.nodeList) {
            if (((LayoutData)n.data).marked) continue;
            this.initialOrderNodes(graph, n);
        }
    }

    public void initialOrderNodes(Graph graph, Node curr) {
        ((LayoutData)curr.data).marked = true;
        for (Edge edge : graph.getEdges(curr)) {
            if (edge.to != curr) continue;
            Node n = edge.from;
            if (((LayoutData)n.data).marked) continue;
            this.initialOrderNodes(graph, n);
        }
        this.levelNodes.get(HierarchicLayouter.getLevel(curr) - 1).add(curr);
    }

    protected void orderNodes(Graph graph, int op, LayoutJobControl lJC) {
        boolean doout;
        boolean doup = true;
        boolean doin = op < 5;
        boolean bl = doout = op > 3;
        if (doup) {
            for (int i = 0; i < this.maxLevel; ++i) {
                this.orderLevel(graph, this.levelNodes.get(i), doin, doout);
                if (lJC == null) continue;
                lJC.done(++this.operationsDone);
                if (lJC.getStatus() != 5 && lJC.getStatus() != 4) continue;
                i = this.maxLevel;
            }
        } else {
            for (int i = this.maxLevel - 1; i >= 0; --i) {
                this.orderLevel(graph, this.levelNodes.get(i), doin, doout);
                if (lJC == null) continue;
                lJC.done(++this.operationsDone);
                if (lJC.getStatus() != 5 && lJC.getStatus() != 4) continue;
                i = -1;
            }
        }
        this.placeNodesInitial();
    }

    protected void orderLevel(Graph graph, List<Node> nodes, boolean doin, boolean doout) {
        for (Node node : nodes) {
            this.calcBarycenter(graph, node, doin, doout, false);
        }
        Collections.sort(nodes, new LevelComparator());
        int levelcnt = nodes.size();
        for (int i = 0; i < levelcnt; ++i) {
            Node node = nodes.get(i);
            if (this.verticalOrientation) {
                node.x = i * this.layerDeltaX;
                continue;
            }
            node.y = i * this.layerDeltaY;
        }
        for (int k = 0; k < 5; ++k) {
            boolean hasSwap = false;
            for (int i = 0; i < levelcnt - 1; ++i) {
                Node n1 = nodes.get(i);
                Node n2 = nodes.get(i + 1);
                int level = HierarchicLayouter.getLevel(n1);
                int w1 = this.calcLevelWeight(level, true, doout);
                this.swap(n1, n2);
                int w2 = this.calcLevelWeight(level, true, doout);
                if (w1 <= w2) {
                    this.swap(n1, n2);
                    continue;
                }
                nodes.remove(n2);
                nodes.add(i, n2);
                hasSwap = true;
            }
            if (!hasSwap) break;
        }
    }

    protected void swap(Node n1, Node n2) {
        if (this.verticalOrientation) {
            int t = n1.x;
            n1.x = n2.x;
            n2.x = t;
        } else {
            int t = n1.y;
            n1.y = n2.y;
            n2.y = t;
        }
    }

    protected void initLevelEdges(Graph graph) {
        this.levelEdges = new ArrayList(this.maxLevel);
        for (int i = 0; i < this.maxLevel; ++i) {
            ArrayList<Edge> edges = new ArrayList<Edge>();
            this.levelEdges.add(edges);
            List<Node> nodes = this.levelNodes.get(i);
            for (Node node : nodes) {
                List<Edge> nEdges = graph.getEdges(node);
                for (Edge edge : nEdges) {
                    if (edge.from != node) continue;
                    edges.add(edge);
                }
            }
        }
    }

    protected int calcLevelWeight(int level, boolean doIn, boolean doOut) {
        int weight = 0;
        if (--level > 0 && doIn) {
            weight += this.calcEdgesWeight(this.levelEdges.get(level - 1));
        }
        if (doOut) {
            weight += this.calcEdgesWeight(this.levelEdges.get(level));
        }
        return weight;
    }

    protected int calcEdgesWeight(List<Edge> edges) {
        int weight = 0;
        for (int i = 0; i < edges.size(); ++i) {
            Edge e1 = edges.get(i);
            weight = this.verticalOrientation ? (weight += Math.abs(e1.from.x - e1.to.x)) : (weight += Math.abs(e1.from.y - e1.to.y));
            for (int k = i + 1; k < edges.size(); ++k) {
                Edge e2 = edges.get(k);
                if (this.verticalOrientation) {
                    if ((e1.from.x >= e2.from.x || e1.to.x <= e2.to.x) && (e2.from.x >= e1.from.x || e2.to.x <= e1.to.x)) continue;
                    weight += 1000;
                    continue;
                }
                if ((e1.from.y >= e2.from.y || e1.to.y <= e2.to.y) && (e2.from.y >= e1.from.y || e2.to.y <= e1.to.y)) continue;
                weight += 1000;
            }
        }
        return weight;
    }

    protected void placeNodesInitial() {
        int levelSize = 0;
        int levelOffset = 0;
        for (int i = 0; i < this.maxLevel; ++i) {
            List<Node> nodes = this.levelNodes.get(i);
            this.levelSizes[i] = levelSize = this.placeLevelInitial(nodes, levelOffset);
            if (this.verticalOrientation) {
                levelOffset += levelSize / this.gridY * this.gridY + this.gridY;
                levelOffset += this.layerDeltaY;
                continue;
            }
            levelOffset += levelSize / this.gridX * this.gridX + this.gridX;
            levelOffset += this.layerDeltaX;
        }
    }

    protected int placeLevelInitial(List<Node> level, int levelOffset) {
        int size = 0;
        int offset = 0;
        for (Node node : level) {
            if (this.verticalOrientation) {
                node.y = levelOffset;
                node.x = offset;
                offset += this.snapUp(this.getIntralevelWidth(node));
                size = Math.max(size, node.height);
                continue;
            }
            node.x = levelOffset;
            node.y = offset;
            offset += this.snapUp(this.getIntralevelWidth(node));
            size = Math.max(size, node.width);
        }
        return size;
    }

    protected void straightenDummy(Graph graph, Node n) {
        List<Edge> edges = graph.getEdges(n);
        Node from = null;
        Node to = null;
        for (int i = 0; i < 2; ++i) {
            Edge edge = edges.get(i);
            if (edge.to == n) {
                from = edge.from;
                continue;
            }
            to = edge.to;
        }
        if (from == null || to == null) {
            log.log(Level.SEVERE, "One of the edge terminals is null");
            return;
        }
        if (this.verticalOrientation) {
            n.x = (n.x + from.x + from.width / 2 + to.x + to.width / 2) / 3;
        } else {
            n.y = (n.y + from.y + from.height / 2 + to.y + to.height / 2) / 3;
        }
    }

    protected Node makeMetaRoot(Graph graph) {
        Node metaRoot = new Node("meta-root");
        metaRoot.data = new LayoutData();
        for (Node n : graph.nodeList) {
            Edge e = new Edge(n, metaRoot);
            graph.addEdge(e);
        }
        graph.addNode(metaRoot);
        return metaRoot;
    }

    @Override
    public LayouterInfo getInfo() {
        LayouterInfoSupport lis = new LayouterInfoSupport(true, true, false, false, false, false);
        return lis;
    }

    @Override
    public int estimate(Graph graph, int what) {
        int operations = 0;
        if (graph.isConnected()) {
            return this.estimateConnected(graph, what);
        }
        List<Graph> graphs = graph.split();
        for (Graph gr : graphs) {
            boolean notSimpleNodeFlag = true;
            for (Node n : gr.nodeList) {
                String type = n.getAttribute("Type");
                if (Util.isCompartment(n) || type != null && (type.equals("Event") || type.equals("Equation") || type.equals("Function"))) continue;
                notSimpleNodeFlag = false;
            }
            if (notSimpleNodeFlag) continue;
            operations += this.estimateConnected(gr, what);
        }
        return operations;
    }

    public int estimateConnected(Graph graph, int what) {
        this.initLayoutData(graph);
        this.normalise(graph);
        ArrayList<Node> topoSortedNodes = new ArrayList<Node>();
        Node metaRoot = this.makeMetaRoot(graph);
        this.unmarkNodes(graph);
        HierarchicLayouter.topoSort(graph, metaRoot, topoSortedNodes);
        graph.removeNode(metaRoot);
        topoSortedNodes.remove(metaRoot);
        int toposize = topoSortedNodes.size();
        this.maxLevel = 0;
        for (int i = 0; i < toposize; ++i) {
            Node v = topoSortedNodes.get(i);
            int level = 0;
            List<Edge> edges = graph.getEdges(v);
            for (Edge edge : edges) {
                Node u;
                if (edge.to != v || HierarchicLayouter.getLevel(u = edge.from) <= level) continue;
                level = HierarchicLayouter.getLevel(u);
            }
            HierarchicLayouter.setLevel(v, level + 1);
            if (level + 1 <= this.maxLevel) continue;
            this.maxLevel = level + 1;
        }
        for (Edge edge : this.selfLoops) {
            graph.addEdge(edge);
        }
        for (int i = 0; i < graph.edgeList.size(); ++i) {
            Edge edge;
            edge = graph.edgeList.get(i);
            if (!edge.reversed) continue;
            graph.removeEdge(edge);
            edge.reverseDirection();
            graph.addEdge(edge);
            --i;
        }
        return this.layerOrderIterationNum * this.maxLevel + this.maxNodeOptimizationNum * 10;
    }

    public static class LayoutData {
        public int level = 0;
        public int usageLevel = 0;
        public int barycenter = 0;
        public boolean marked = false;
        public boolean picked = false;
        public boolean dummy = false;
        public int upEdgesWeight = 0;
        public int downEdgesWeight = 0;
    }

    public class LevelComparator
    implements Comparator<Node> {
        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int compare(Node o1, Node o2) {
            int r = HierarchicLayouter.this.getBarycenter(o1) - HierarchicLayouter.this.getBarycenter(o2);
            if (r != 0) {
                return r;
            }
            return 0;
        }
    }

    private static class Span {
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;

        private Span() {
        }

        Span intersect(Span s) {
            Span result = new Span();
            result.min = Math.max(this.min, s.min);
            result.max = Math.min(this.max, s.max);
            if (result.min > result.max) {
                return null;
            }
            return result;
        }

        int fitValue(int value) {
            return value > this.max ? this.max : (value < this.min ? this.min : value);
        }
    }
}

