/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.OrthogonalPathLayouter;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graph.Util;

public class GreedyLayouter
extends AbstractLayouter {
    protected static final Logger log = Logger.getLogger(GreedyLayouter.class.getName());
    public static final int ALIGN_MODE_LEFT = 0;
    public static final int ALIGN_MODE_CENTER = 1;
    public static final int ALIGN_MODE_RIGHT = 2;
    protected int gridX = 5;
    protected int gridY = 5;
    protected int layerDeltaX = 75;
    protected int layerDeltaY = 75;
    public int align = 1;
    private static final int LOCATE_ITERATIONS_MAX_COUNT = 20;
    protected int processedWeight = -1;
    protected int unprocessedWeight = 1;
    protected List<Node> processedNodes = new ArrayList<Node>();
    protected List<Node> unprocessedNodes = new ArrayList<Node>();
    protected Node center;
    protected List<Rectangle> pathRectangles = new ArrayList<Rectangle>();
    static Direction N = new Direction(0, -1, "N");
    static Direction NE = new Direction(1, -1, "NE");
    static Direction E = new Direction(1, 0, "E");
    static Direction SE = new Direction(1, 1, "SE");
    static Direction S = new Direction(0, 1, "S");
    static Direction SW = new Direction(-1, 1, "SW");
    static Direction W = new Direction(-1, 0, "W");
    static Direction NW = new Direction(-1, -1, "NW");
    static Direction[] directions = new Direction[]{S, E, W, N, SE, SW, NE, NW};

    public GreedyLayouter() {
        this.pathLayouterWrapper = new PathLayouterWrapper(new OrthogonalPathLayouter());
    }

    public GreedyLayouter(int gridX, int gridY) {
        this.gridX = gridX;
        this.gridY = gridY;
        this.pathLayouterWrapper = new PathLayouterWrapper(new OrthogonalPathLayouter());
    }

    protected void init(Graph graph) {
        LayoutData ld;
        this.processedNodes.clear();
        this.unprocessedNodes.clear();
        this.pathRectangles.clear();
        this.center = null;
        for (Node node : graph.nodeList) {
            if (node.fixed) {
                if (node.data == null) {
                    ld = new LayoutData();
                    ld.fixed = true;
                    ld.processed = true;
                    ld.weight = this.processedWeight;
                    node.data = ld;
                }
                this.processedNodes.add(node);
                continue;
            }
            this.unprocessedNodes.add(node);
        }
        for (Node node : this.unprocessedNodes) {
            ld = new LayoutData();
            node.data = ld;
            List<Edge> edges = graph.getEdges(node);
            if (edges != null) {
                for (Edge edge : edges) {
                    if (edge.from == edge.to || !edge.master) continue;
                    Node u = node == edge.from ? edge.to : edge.from;
                    ld.weight = ld.weight + (this.processedNodes.contains(u) ? this.processedWeight : this.unprocessedWeight);
                }
            }
            if (this.center != null && ((LayoutData)this.center.data).weight >= ld.weight) continue;
            this.center = node;
        }
        for (Edge edge : graph.edgeList) {
            if (edge.path != null && edge.path.npoints > 0 && this.processedNodes.contains(edge.from) && this.processedNodes.contains(edge.to)) {
                for (int i = 0; i < edge.path.npoints - 1; ++i) {
                    this.pathRectangles.add(new Rectangle(Math.min(edge.path.xpoints[i], edge.path.xpoints[i + 1]) - 1, Math.min(edge.path.ypoints[i], edge.path.ypoints[i + 1]) - 1, Math.abs(edge.path.xpoints[i] - edge.path.xpoints[i + 1]) + 2, Math.abs(edge.path.ypoints[i] - edge.path.ypoints[i + 1]) + 2));
                }
                continue;
            }
            edge.path = null;
            edge.data = null;
        }
    }

    @Override
    void layoutNodes(Graph graph, LayoutJobControl jobControl) {
        int counter = 0;
        this.init(graph);
        log.log(Level.FINE, "Center node groups:" + this.center);
        if (this.center == null) {
            return;
        }
        if (this.processedNodes.size() == 0) {
            this.center.x = 0;
            this.center.y = 0;
            ((LayoutData)this.center.data).processed = true;
            this.unprocessedNodes.remove(this.center);
            this.processedNodes.add(this.center);
        } else {
            Node firstCenter = this.selectNextCenter(graph);
            if (firstCenter != null) {
                this.center = firstCenter;
                this.processNode(graph, firstCenter);
            }
        }
        while (this.unprocessedNodes.size() > 0) {
            Node node;
            if (jobControl != null) {
                jobControl.done(counter++);
                if (jobControl.getStatus() != 1) {
                    return;
                }
            }
            if ((node = this.selectNode(graph)) == null) {
                log.log(Level.SEVERE, "UNPROCESSED nodes: " + this.unprocessedNodes);
                break;
            }
            this.processNode(graph, node);
        }
        Util.adjustOrientations(graph);
    }

    public void refineNodes(Graph graph, int n) {
        ArrayList<Edge> edgesUnderConsideration = new ArrayList<Edge>();
        for (int k = 0; k < n; ++k) {
            boolean changed = false;
            for (Node node : graph.nodeList) {
                if (node.fixed) continue;
                edgesUnderConsideration.clear();
                List<Edge> edges = graph.getEdges(node);
                if (edges != null) {
                    for (Edge edge : edges) {
                        if (k <= n / 2) {
                            Node u;
                            Node node2 = u = edge.getFrom() == node ? edge.getTo() : edge.getFrom();
                            if (graph.getEdges(u).size() == 1) continue;
                        }
                        edgesUnderConsideration.add(edge);
                    }
                }
                int weight = this.calcNodeWeight(graph, node, edgesUnderConsideration, Integer.MAX_VALUE);
                int x = node.x;
                int y = node.y;
                if (this.locateNode(graph, node, edgesUnderConsideration) < weight) {
                    changed = true;
                    continue;
                }
                node.x = x;
                node.y = y;
            }
            if (k > n / 2 && !changed) break;
        }
    }

    protected Node selectNode(Graph graph) {
        Node bestNode = this.selectNode(graph, this.center);
        if (bestNode != null) {
            return bestNode;
        }
        this.center = this.selectNextCenter(graph);
        return this.center;
    }

    protected Node selectNextCenter(Graph graph) {
        Node bestNode = null;
        for (Node node : this.processedNodes) {
            Node u = this.selectNode(graph, node);
            if (u == null) continue;
            int weight = ((LayoutData)u.data).weight;
            if (bestNode != null && weight >= ((LayoutData)bestNode.data).weight) continue;
            bestNode = u;
        }
        return bestNode;
    }

    protected Node selectNode(Graph graph, Node centerNode) {
        Node bestNode = null;
        List<Edge> edges = graph.getEdges(centerNode);
        if (edges == null) {
            return null;
        }
        for (Edge edge : edges) {
            Node u = edge.from == centerNode ? edge.to : edge.from;
            if (u == null || u.data == null || ((LayoutData)u.data).processed) continue;
            int weight = ((LayoutData)u.data).weight;
            if (bestNode != null && weight >= ((LayoutData)bestNode.data).weight) continue;
            bestNode = u;
        }
        return bestNode;
    }

    protected void processNode(Graph graph, Node node) {
        log.log(Level.FINE, "Process node:" + node);
        if (node == null) {
            return;
        }
        ((LayoutData)node.data).weight = 0;
        ArrayList<Edge> edgesUnderConsideration = new ArrayList<Edge>();
        List<Edge> edges = graph.getEdges(node);
        for (Edge edge : edges) {
            Node u = edge.from == node ? edge.to : edge.from;
            if (u == null || u.data == null) continue;
            if (!((LayoutData)u.data).processed) {
                ((LayoutData)u.data).weight += this.processedWeight;
                continue;
            }
            edgesUnderConsideration.add(edge);
            log.log(Level.FINE, "  edge:" + edge);
        }
        this.locateNode(graph, node, edgesUnderConsideration);
        ((LayoutData)node.data).processed = true;
        this.unprocessedNodes.remove(node);
        this.processedNodes.add(node);
    }

    public int locateNode(Graph graph, Node node, List<Edge> edges) {
        int bestWeight = Integer.MAX_VALUE;
        Node bestCenter = null;
        for (Edge edge : edges) {
            int weight;
            Node center = edge.getFrom() == node ? edge.getTo() : edge.getFrom();
            if (!this.processedNodes.contains(center) || (weight = this.locateNode(graph, node, edges, center)) >= bestWeight) continue;
            bestWeight = weight;
            bestCenter = center;
        }
        if (bestCenter != null) {
            this.locateNode(graph, node, edges, bestCenter);
        } else {
            log.log(Level.SEVERE, "Can not locate node=" + node.getName());
        }
        return bestWeight;
    }

    public int locateNode(Graph graph, Node node, List<Edge> edges, Node center) {
        int d = 0;
        int bestWeight = Integer.MAX_VALUE;
        Direction bestDirection = null;
        while (bestWeight > 100000 && d < 20) {
            ++d;
            for (Direction direction : directions) {
                this.locateNode(node, direction, center, d);
                int weight = this.calcNodeWeight(graph, node, edges, bestWeight);
                if (bestDirection != null && weight >= bestWeight) continue;
                bestDirection = direction;
                bestWeight = weight;
            }
        }
        this.locateNode(node, bestDirection, center, d);
        return bestWeight;
    }

    protected void locateNode(Node node, Direction dir, Node center, int d) {
        if (center == null || node == null) {
            return;
        }
        node.x = center.x;
        if (dir.dx != 0) {
            node.x += dir.dx * this.layerDeltaX * d;
            node.x = dir.dx < 0 ? (node.x -= node.width) : (node.x += center.width);
        }
        node.y = center.y;
        if (dir.dy != 0) {
            node.y += dir.dy * this.layerDeltaY * d;
            node.y = dir.dy < 0 ? (node.y -= node.height) : (node.y += center.height);
        }
        if (this.align > 0) {
            if (dir.dx == 0) {
                node.x = this.align == 1 ? center.x + (center.width - node.width) / 2 / this.gridX * this.gridX : center.x + (center.width - node.width);
            }
            if (dir.dy == 0) {
                node.y = this.align == 1 ? center.y + (center.height - node.height) / 2 / this.gridY * this.gridY : center.y + (center.height - node.height);
            }
        }
    }

    private int calcNodeWeight(Graph graph, Node node, List<Edge> edges, int bestWeight) {
        int weight = 0;
        int dx = this.layerDeltaX / 2;
        int dy = this.layerDeltaY / 2;
        Rectangle rect = new Rectangle(node.x - dx, node.y - dy, node.width + 2 * dx, node.height + 2 * dy);
        for (Node p : this.processedNodes) {
            Rectangle r = new Rectangle(p.x, p.y, p.width, p.height);
            if (!rect.intersects(r) || (weight += 100000) <= bestWeight) continue;
            return weight;
        }
        for (Edge edge : edges) {
            if ((weight += this.calcEdgeWeight(graph, edge, bestWeight - weight)) <= bestWeight) continue;
            return weight;
        }
        for (Rectangle r : this.pathRectangles) {
            if (!rect.intersects(r) || (weight += 5000) <= bestWeight) continue;
            return weight;
        }
        return weight;
    }

    protected int calcEdgeWeight(Graph graph, Edge edge, int bestWeight) {
        int dx = edge.from.x + edge.from.width / 2 - (edge.to.x + edge.to.width / 2);
        int dy = edge.from.y + edge.from.height / 2 - (edge.to.y + edge.to.height / 2);
        int weight = (int)Math.sqrt(dx * dx + dy * dy);
        return weight;
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl lJC) {
        this.getPathLayouter().layoutEdges(graph, lJC);
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl lJC) {
        this.getPathLayouter().layoutPath(graph, edge, lJC);
    }

    @Override
    public LayouterInfo getInfo() {
        LayouterInfoSupport lis = new LayouterInfoSupport(true, true, false, false, false, true);
        return lis;
    }

    @Override
    public int estimate(Graph graph, int what) {
        return graph.nodeCount();
    }

    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
    }

    public int getLayerDeltaX() {
        return this.layerDeltaX;
    }

    public void setLayerDeltaX(int deltaX) {
        this.layerDeltaX = deltaX;
    }

    public int getLayerDeltaY() {
        return this.layerDeltaY;
    }

    public void setLayerDeltaY(int deltaY) {
        this.layerDeltaY = deltaY;
    }

    static class LayoutData {
        int width = 0;
        int height = 0;
        boolean fixed = false;
        float n = 1.0f;
        int weight = 0;
        boolean processed = false;

        LayoutData() {
        }
    }

    static class Direction {
        String name;
        int dx;
        int dy;

        public Direction(int dx, int dy, String name) {
            this.dx = dx;
            this.dy = dy;
            this.name = name;
        }
    }
}

