/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.HasCyclesException;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;

public class Graph
implements Cloneable {
    protected static final Logger log = Logger.getLogger(Graph.class.getName());
    protected Map<String, Node> nodeMap = new HashMap<String, Node>();
    protected List<Node> nodeList = new ArrayList<Node>();
    protected Map<Node, List<Edge>> edgeMap = new IdentityHashMap<Node, List<Edge>>();
    protected List<Edge> edgeList = new ArrayList<Edge>();
    Object data;

    public int nodeCount() {
        return this.nodeMap.size();
    }

    public Node nodeAt(int i) {
        return this.nodeList.get(i);
    }

    public Iterator<Node> nodeIterator() {
        return this.nodeList.iterator();
    }

    public Iterator<Edge> edgeIterator() {
        return this.edgeList.iterator();
    }

    public void addNode(Node node) {
        if (this.getNode(node.getName()) != null) {
            throw new IllegalArgumentException("Graph already contains node with name '" + node.getName() + "'");
        }
        this.nodeMap.put(node.getName(), node);
        this.nodeList.add(node);
    }

    public void addEdge(Edge edge) {
        if (edge.master) {
            for (Edge master : this.edgeList) {
                if (!master.master || master.from != edge.from || master.to != edge.to) continue;
                edge.master = false;
                master.addSlave(edge);
                break;
            }
        }
        this.edgeList.add(edge);
        if (!edge.master) {
            return;
        }
        List<Edge> nodes = this.edgeMap.get(edge.from);
        if (nodes == null) {
            nodes = new ArrayList<Edge>();
            this.edgeMap.put(edge.from, nodes);
        }
        nodes.add(edge);
        nodes = this.edgeMap.get(edge.to);
        if (nodes == null) {
            nodes = new ArrayList<Edge>();
            this.edgeMap.put(edge.to, nodes);
        }
        nodes.add(edge);
    }

    public Node getNode(String name) {
        return this.nodeMap.get(name);
    }

    public List<Edge> getEdges(Node node) {
        if (!this.edgeMap.containsKey(node)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.edgeMap.get(node));
    }

    public List<Edge> getEdges() {
        return this.edgeList;
    }

    public List<Node> getNodes() {
        return this.nodeList;
    }

    public Edge getEdge(Node from, Node to) {
        List<Edge> edges = this.getEdges(from);
        if (edges == null) {
            return null;
        }
        for (Edge edge : edges) {
            if (edge.from != from || edge.to != to) continue;
            return edge;
        }
        return null;
    }

    public Edge getEdge(Node from, Node to, boolean undirected) {
        if (!undirected) {
            return this.getEdge(from, to);
        }
        List<Edge> edges = this.getEdges(from);
        if (edges == null) {
            return null;
        }
        for (Edge edge : edges) {
            if ((edge.from != from || edge.to != to) && (edge.from != to || edge.to != from)) continue;
            return edge;
        }
        return null;
    }

    public int edgeCount() {
        return this.edgeList.size();
    }

    public void removeNode(Node node) {
        if (this.getNode(node.getName()) == null) {
            return;
        }
        List<Edge> edges = this.edgeMap.get(node);
        if (edges != null) {
            while (edges.size() > 0) {
                this.removeEdge(edges.get(0));
            }
        }
        this.nodeMap.remove(node.getName());
        this.nodeList.remove(node);
        this.edgeMap.remove(node);
    }

    public void removeEdge(Edge edge) {
        this.edgeMap.get(edge.from).remove(edge);
        this.edgeMap.get(edge.to).remove(edge);
        this.edgeList.remove(edge);
        if (!edge.master) {
            Edge master = this.getEdge(edge.from, edge.to);
            master.slaves.remove(edge);
        } else if (edge.slaves != null && edge.slaves.size() > 0) {
            Edge master = edge.slaves.get(0);
            master.master = true;
            master.slaves = edge.slaves;
            master.slaves.remove(master);
            this.edgeMap.get(edge.from).add(master);
            this.edgeMap.get(edge.to).add(master);
        }
        edge.master = true;
    }

    public Rectangle getBounds() {
        Rectangle rect = null;
        for (Node node : this.nodeList) {
            Rectangle r = node.getBounds();
            if (rect == null) {
                rect = r;
                continue;
            }
            rect = rect.union(r);
        }
        for (Edge edge : this.edgeList) {
            Path path = edge.path;
            if (path == null) continue;
            Rectangle r = path.getBounds();
            if (rect == null) {
                rect = r;
                continue;
            }
            rect = rect.union(r);
        }
        if (rect == null) {
            rect = new Rectangle();
        }
        return rect;
    }

    public void setLocation(int x, int y) {
        Rectangle rect = this.getBounds();
        this.move(x - rect.x, y - rect.y);
    }

    public void setLocationForced(int x, int y) {
        Rectangle rect = this.getBounds();
        this.move(x - rect.x, y - rect.y, false);
    }

    public void move(int dx, int dy) {
        this.move(dx, dy, true);
    }

    public void move(int dx, int dy, boolean supportFixed) {
        for (Node node : this.nodeList) {
            if (supportFixed && node.fixed) continue;
            node.x += dx;
            node.y += dy;
        }
        for (Edge e : this.edgeList) {
            Path path;
            if (supportFixed && e.fixed || (path = e.path) == null) continue;
            path.translate(dx, dy);
        }
    }

    public void zoom(float k) {
        for (Node node : this.nodeList) {
            node.x = (int)(k * (float)node.x);
            node.y = (int)(k * (float)node.y);
            node.width = (int)(k * (float)node.width);
            node.height = (int)(k * (float)node.height);
        }
        for (Edge edge : this.edgeList) {
            Path path = edge.path;
            if (path == null) continue;
            for (int n = 0; n < path.npoints; ++n) {
                path.xpoints[n] = (int)(k * (float)path.xpoints[n]);
                path.ypoints[n] = (int)(k * (float)path.ypoints[n]);
            }
        }
    }

    public Node getIntersectedNode(int x1, int y1, int x2, int y2, Set<Node> exclusions) {
        if (x1 > x2) {
            int x = x2;
            x2 = x1;
            x1 = x;
        }
        if (y1 > y2) {
            int y = y2;
            y2 = y1;
            y1 = y;
        }
        Rectangle rect = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        for (Node node : this.nodeList) {
            if (exclusions.contains(node) || !rect.intersects(node.x, node.y, node.width, node.height)) continue;
            return node;
        }
        return null;
    }

    boolean isOccupied(Edge edge, Point p) {
        if (edge.getPath() != null) {
            Path path = edge.getPath();
            if (p.x == path.xpoints[0] && p.y == path.ypoints[0]) {
                return true;
            }
            if (p.x == path.xpoints[path.npoints - 1] && p.y == path.ypoints[path.npoints - 1]) {
                return true;
            }
        }
        return false;
    }

    boolean isFree(Node node, Point point) {
        List<Edge> nodeEdges = this.getEdges(node);
        for (Edge e : nodeEdges) {
            if (this.isOccupied(e, point)) {
                return false;
            }
            if (e.slaves == null) continue;
            for (Edge slave : e.slaves) {
                if (!this.isOccupied(slave, point)) continue;
                return false;
            }
        }
        return true;
    }

    public List<Graph> split() {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (Node node : this.nodeList) {
            if (Graph.contains(graphs.iterator(), node)) continue;
            graphs.add(this.subgraph(node));
        }
        return graphs;
    }

    public boolean isConnected() {
        if (this.nodeList.size() <= 1) {
            return true;
        }
        Graph sub = this.subgraph(this.nodeList.get(0));
        return sub.nodeList.size() == this.nodeList.size();
    }

    public Graph subgraph(Node node) {
        Graph subgraph = new Graph();
        subgraph.addNode(node);
        this.addEdges(subgraph, this.getEdges(node));
        return subgraph;
    }

    protected void addEdges(Graph subgraph, List<Edge> edges) {
        if (edges == null) {
            return;
        }
        for (Edge edge : edges) {
            boolean addFrom = false;
            boolean addTo = false;
            if (subgraph.getNode(edge.from.getName()) == null) {
                addFrom = true;
                subgraph.addNode(edge.from);
            }
            if (subgraph.getNode(edge.to.getName()) == null) {
                addTo = true;
                subgraph.addNode(edge.to);
            }
            boolean addEdge = true;
            for (Edge edge_k : subgraph.edgeList) {
                if (edge_k.from != edge.from || edge_k.to != edge.to) continue;
                addEdge = false;
                break;
            }
            if (addEdge) {
                subgraph.addEdge(edge);
                if (edge.slaves != null) {
                    for (Edge slave : edge.slaves.toArray(new Edge[edge.slaves.size()])) {
                        subgraph.addEdge(slave);
                    }
                }
            }
            if (addFrom) {
                this.addEdges(subgraph, this.getEdges(edge.from));
            }
            if (!addTo) continue;
            this.addEdges(subgraph, this.getEdges(edge.to));
        }
    }

    protected static boolean contains(Iterator<Graph> graphs, Node node) {
        while (graphs.hasNext()) {
            Graph graph = graphs.next();
            if (graph.getNode(node.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public List<Node> getRoots() throws HasCyclesException {
        if (this.nodeCount() == 0 || !this.isConnected()) {
            return null;
        }
        ArrayList<Node> roots = new ArrayList<Node>();
        HashSet<Node> globallyVisitedNodes = new HashSet<Node>();
        Iterator<Node> nodeIterator = this.nodeIterator();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            if (globallyVisitedNodes.contains(node)) continue;
            this.fillRoots(node, globallyVisitedNodes, new HashSet<Node>(), roots);
        }
        return roots;
    }

    private void fillRoots(Node node, Set<Node> globallyVisitedNodes, Set<Node> oneStageVisitedNodes, List<Node> roots) throws HasCyclesException {
        oneStageVisitedNodes.add(node);
        globallyVisitedNodes.add(node);
        List<Edge> edges = this.getEdges(node);
        boolean found = false;
        if (edges != null) {
            for (Edge edge : edges) {
                if (edge.to != node) continue;
                boolean thisStageVisited = oneStageVisitedNodes.contains(edge.from);
                boolean globallyVisited = globallyVisitedNodes.contains(edge.from);
                if (thisStageVisited) {
                    throw new HasCyclesException(oneStageVisitedNodes);
                }
                if (!globallyVisited) {
                    this.fillRoots(edge.from, globallyVisitedNodes, oneStageVisitedNodes, roots);
                    oneStageVisitedNodes.remove(edge.from);
                }
                found = true;
            }
            if (!found) {
                roots.add(node);
            }
        }
    }

    public String generateText() {
        return this.generateText(true);
    }

    public String generateText(boolean includeLayout) {
        StringBuffer result = new StringBuffer();
        result.append("// Nodes: ").append(this.nodeList.size()).append("\n");
        for (Node node : this.nodeList) {
            result.append("N: ").append(node.getName()).append(", ").append(node.width).append(", ").append(node.height);
            if (includeLayout) {
                result.append(", ").append(node.x).append(", ").append(node.y);
            }
            result.append("\n");
            if (node.attributes == null) continue;
            for (String key : node.attributes.keySet()) {
                result.append("A: " + node.getName() + ", " + key + "=" + node.getAttribute(key) + "\n");
            }
        }
        result.append("//\n");
        result.append("// Edges: ").append(this.edgeList.size()).append("\n");
        for (Edge edge : this.edgeList) {
            result.append("E: ").append(edge.from.getName()).append(", ").append(edge.to.getName());
            if (includeLayout && edge.path != null) {
                for (int i = 0; i < edge.path.npoints; ++i) {
                    result.append(", ").append(edge.path.xpoints[i]).append(", ").append(edge.path.ypoints[i]);
                }
            }
            result.append("\n");
        }
        return result.toString();
    }

    public void fillFromText(String text) {
        if (text.indexOf("N:") >= 0) {
            this.fillFromText1(text);
        } else {
            this.fillFromText2(text);
        }
    }

    public void fillFromText1(String text) {
        StringTokenizer lines = new StringTokenizer(text, "\r\n");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            try {
                StringTokenizer tokens = new StringTokenizer(line, " ,=");
                String token = tokens.nextToken();
                if ("//".equals(token)) continue;
                if ("N:".equals(token)) {
                    this.addNode(Graph.parseNode(tokens));
                    continue;
                }
                if ("E:".equals(token)) {
                    this.addEdge(Graph.parseEdge(tokens, this));
                    continue;
                }
                if ("A:".equals(token)) {
                    if (this.parseAttribute(tokens)) continue;
                    log.log(Level.SEVERE, "\n  line: " + line);
                    continue;
                }
                log.log(Level.SEVERE, "Error: - unknown directive '" + token + "'.\n  line: " + line);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error during parsing: " + t + "\n  line: " + line);
            }
        }
    }

    static Node parseNode(StringTokenizer tokens) {
        Node node = new Node(tokens.nextToken());
        node.width = Integer.parseInt(tokens.nextToken());
        node.height = Integer.parseInt(tokens.nextToken());
        if (tokens.hasMoreTokens()) {
            node.x = Integer.parseInt(tokens.nextToken());
            node.y = Integer.parseInt(tokens.nextToken());
        }
        return node;
    }

    boolean parseAttribute(StringTokenizer tokens) {
        String nodeName = tokens.nextToken();
        Node node = this.getNode(nodeName);
        if (node == null) {
            log.log(Level.SEVERE, "Graph has not node with name '" + nodeName + "'");
            return false;
        }
        if (!tokens.hasMoreTokens()) {
            log.log(Level.SEVERE, "Attribute key absents");
            return false;
        }
        String key = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            log.log(Level.SEVERE, "Attribute value absents");
            return false;
        }
        String value = tokens.nextToken();
        node.setAttribute(key, value);
        return true;
    }

    static Edge parseEdge(StringTokenizer tokens, Graph graph) {
        String fromName = tokens.nextToken();
        String toName = tokens.nextToken();
        Node from = graph.getNode(fromName);
        Node to = graph.getNode(toName);
        if (from == null) {
            throw new NoSuchElementException("Graph has not node with name '" + fromName + "'");
        }
        if (to == null) {
            throw new NoSuchElementException("Graph has not node with name '" + toName + "'");
        }
        Edge edge = new Edge(from, to);
        if (tokens.hasMoreTokens()) {
            edge.path = new Path();
            while (tokens.hasMoreTokens()) {
                edge.path.addPoint(Integer.parseInt(tokens.nextToken()), Integer.parseInt(tokens.nextToken()));
            }
        }
        return edge;
    }

    public static Edge parseEdge(String text, Graph graph) {
        return Graph.parseEdge(new StringTokenizer(text, " ,"), graph);
    }

    public void fillFromText2(String text) {
        StringTokenizer tokens = new StringTokenizer(text, ", \n");
        while (tokens.hasMoreTokens()) {
            Node outNode;
            String edgeStr = tokens.nextToken();
            int d = edgeStr.indexOf(45);
            if (d == -1) {
                log.log(Level.SEVERE, "Invalid edge: '" + edgeStr + "'.");
                continue;
            }
            String in = edgeStr.substring(0, d);
            String out = edgeStr.substring(d + 2);
            Node inNode = this.getNode(in);
            if (inNode == null) {
                inNode = new Node(in);
                inNode.width = 30;
                inNode.height = 20;
                this.addNode(inNode);
            }
            if ((outNode = this.getNode(out)) == null) {
                outNode = new Node(out);
                outNode.width = 30;
                outNode.height = 20;
                this.addNode(outNode);
            }
            Edge edge = new Edge(inNode, outNode);
            this.addEdge(edge);
        }
    }

    public void addLables(Object[] labelesData, int maxLayer, int width, int height) {
        Node[] labeles = new Node[maxLayer];
        for (int i = maxLayer - 1; i >= 0; --i) {
            labeles[i] = new Node("level." + i);
            labeles[i].width = width;
            labeles[i].height = height;
            this.addNode(labeles[i]);
            labeles[i].setAttribute("label", "true");
            labeles[i].setAttribute("level", String.valueOf(i + 1));
            labeles[i].setAttribute("score", String.valueOf(0));
            labeles[i].applicationData = labelesData[i];
        }
    }

    public Graph clone() {
        Graph result = new Graph();
        for (Node node : this.nodeList) {
            result.addNode(node.clone());
        }
        for (Edge edge : this.edgeList) {
            Node from = result.getNode(edge.from.name);
            Node to = result.getNode(edge.to.name);
            Edge newEdge = new Edge(from, to);
            newEdge.path = edge.path;
            newEdge.reversed = edge.reversed;
            newEdge.data = edge.data;
            newEdge.master = edge.master;
            newEdge.applicationData = edge.applicationData;
            if (edge.slaves != null) {
                for (Edge slave : edge.slaves) {
                    newEdge.addSlave(slave);
                }
            }
            result.addEdge(newEdge);
        }
        return result;
    }
}

