/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.geom.Point2D;
import java.util.List;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.DiagonalPathLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graph.Util;

public class ForceDirectedLayouter
extends AbstractLayouter {
    public static final int PLACEMENT_AS_IS = 0;
    public static final int PLACEMENT_RANDOM = 1;
    protected int initialPlacement = 1;
    protected int edgeLength = 75;
    protected float repulsion = 1.0f;
    protected int repulsionDistance = 5;
    public float gravity = 0.06f;
    public static final int TOP_TO_BOTTOM = 0;
    public static final int BOTTOM_TO_TOP = 1;
    public static final int LEFT_TO_RIGHT = 2;
    public static final int RIGHT_TO_LEFT = 3;
    protected int orientation = 0;
    public static final int DISTANCE_MINIMAL = 0;
    public static final int DISTANCE_CENTER = 1;
    public static final int DISTANCE_DIAGONAL = 2;
    protected int distanceMethod = 0;
    protected float attraction = 1.0f;
    protected float magneticIntencity = 0.0f;
    protected int iterationNumber = 300;
    protected float minTemperature = 0.0f;
    protected float maxTemperature = 0.0f;
    protected boolean horisontalMovementAllowed = true;
    protected boolean verticalMovementAllowed = true;

    public ForceDirectedLayouter() {
        this.pathLayouterWrapper = new PathLayouterWrapper(new DiagonalPathLayouter());
    }

    public ForceDirectedLayouter(int edgeLength) {
        this.edgeLength = edgeLength;
        this.pathLayouterWrapper = new PathLayouterWrapper(new DiagonalPathLayouter());
    }

    @Override
    void layoutNodes(Graph graph, LayoutJobControl lJC) {
        if (this.initialPlacement == 1) {
            this.randomLayout(graph);
        }
        this.initLayoutData(graph);
        for (int i = 0; i < this.iterationNumber; ++i) {
            float temp = (float)(graph.nodeCount() * 3) / (1.0f + (float)Math.exp(i / 8 - 5)) + this.minTemperature;
            if (this.maxTemperature > 0.0f && temp > this.maxTemperature) {
                temp = this.maxTemperature;
            }
            this.relax(graph, temp);
            if (lJC == null) continue;
            lJC.done(++this.operationsDone);
            if (lJC.getStatus() != 4 && lJC.getStatus() != 5) continue;
            i = this.iterationNumber;
        }
        float x = Float.MAX_VALUE;
        float y = Float.MAX_VALUE;
        for (Node node : graph.nodeList) {
            if (this.x(node) < x) {
                x = this.x(node);
            }
            if (!(this.y(node) < y)) continue;
            y = this.y(node);
        }
        for (Node node : graph.nodeList) {
            if (node.fixed) continue;
            node.x = Math.round(this.x(node) - x);
            node.y = Math.round(this.y(node) - y);
        }
        Util.adjustOrientations(graph);
        for (Edge edge : graph.getEdges()) {
            if (edge.fixed) continue;
            edge.path = new Path();
        }
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl lJC) {
        for (Edge edge : graph.edgeList) {
            if (edge.fixed) continue;
            this.layoutPath(graph, edge, lJC);
        }
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl lJC) {
        this.getPathLayouter().layoutPath(graph, edge, lJC);
    }

    protected float x(Node node) {
        return ((LayoutData)node.data).x;
    }

    protected void x(Node node, float value) {
        ((LayoutData)node.data).x = value;
    }

    protected float y(Node node) {
        return ((LayoutData)node.data).y;
    }

    protected void y(Node node, float value) {
        ((LayoutData)node.data).y = value;
    }

    protected float dx(Node node) {
        return ((LayoutData)node.data).dx;
    }

    protected void dx(Node node, float value) {
        ((LayoutData)node.data).dx = value;
    }

    protected float dy(Node node) {
        return ((LayoutData)node.data).dy;
    }

    protected void dy(Node node, float value) {
        ((LayoutData)node.data).dy = value;
    }

    protected void randomLayout(Graph graph) {
        int len = this.edgeLength * ((int)Math.sqrt(graph.nodeCount()) + 2);
        for (Node node : graph.nodeList) {
            if (node.fixed) continue;
            node.x = (int)(Math.random() * (double)len);
            node.y = (int)(Math.random() * (double)len);
        }
    }

    protected void initLayoutData(Graph graph) {
        for (Node n : graph.nodeList) {
            n.data = new LayoutData(n);
        }
    }

    protected void relax(Graph graph, float temp) {
        float dy;
        for (Edge edge : graph.edgeList) {
            Point2D.Float p = this.distance(edge.from, edge.to);
            float L = p.x * p.x + p.y * p.y;
            float l = (float)Math.sqrt(L);
            if (L < 0.01f) {
                l = 0.01f;
            }
            float fa = this.attraction * L / (float)this.edgeLength;
            float dx = fa * p.x / l;
            float dy2 = fa * p.y / l;
            ((LayoutData)edge.from.data).dx += dx;
            ((LayoutData)edge.from.data).dy += dy2;
            ((LayoutData)edge.to.data).dx -= dx;
            ((LayoutData)edge.to.data).dy -= dy2;
            if (this.magneticIntencity == 0.0f || !(l > 1.0f)) continue;
            float d = this.orientation == 2 || this.orientation == 3 ? p.y / l : p.x / l;
            d = Math.abs(d);
            if (this.orientation == 1 || this.orientation == 3) {
                d = -d;
            }
            float fm = d * l * this.magneticIntencity;
            if (this.orientation == 2 || this.orientation == 3) {
                ((LayoutData)edge.from.data).dx -= fm;
                ((LayoutData)edge.to.data).dx += fm;
                continue;
            }
            ((LayoutData)edge.from.data).dy -= fm;
            ((LayoutData)edge.to.data).dy += fm;
        }
        for (int i = 1; i < graph.nodeCount(); ++i) {
            Node n1 = graph.nodeList.get(i);
            for (int j = 0; j < i; ++j) {
                Node n2 = graph.nodeList.get(j);
                Point2D.Float p = this.distance(n1, n2);
                float L = p.x * p.x + p.y * p.y;
                float l = (float)Math.sqrt(L);
                if (L < 0.01f) {
                    l = 0.01f;
                    p.x += l;
                    p.x += l;
                    continue;
                }
                if (!(l < (float)(this.repulsionDistance * this.edgeLength))) continue;
                float fr = this.repulsion * (float)(this.edgeLength * this.edgeLength) / l;
                float dx = fr * p.x / l;
                float dy3 = fr * p.y / l;
                ((LayoutData)n1.data).dx -= dx;
                ((LayoutData)n1.data).dy -= dy3;
                ((LayoutData)n2.data).dx += dx;
                ((LayoutData)n2.data).dy += dy3;
            }
        }
        float bcx = 0.0f;
        float bcy = 0.0f;
        for (Node node : graph.nodeList) {
            bcx += this.x(node) + (float)node.width / 2.0f;
            bcy += this.y(node) + (float)node.height / 2.0f;
        }
        bcx /= (float)graph.nodeCount();
        bcy /= (float)graph.nodeCount();
        for (Node node : graph.nodeList) {
            float dx = bcx - this.x(node) - (float)node.width / 2.0f;
            dy = bcy - this.y(node) - (float)node.height / 2.0f;
            float L = dx * dx + dy * dy;
            float l = (float)Math.sqrt(L);
            int degree = 5;
            List<Edge> edges_ = graph.getEdges(node);
            if (!edges_.isEmpty()) {
                degree = edges_.size();
            }
            float fg = this.gravity * (float)(1 + degree) * l;
            dx = fg * dx / l;
            dy = fg * dy / l;
            ((LayoutData)node.data).dx += fg * dx / l;
            ((LayoutData)node.data).dy += fg * dy / l;
        }
        for (Node node : graph.nodeList) {
            float dx;
            float force;
            if (node.fixed || (double)(force = (float)Math.sqrt((dx = ((LayoutData)node.data).dx) * dx + (dy = ((LayoutData)node.data).dy) * dy)) < 0.001) continue;
            float f = Math.min(force, temp) / force;
            if (this.horisontalMovementAllowed) {
                this.x(node, this.x(node) + this.dx(node) * f);
            }
            if (this.verticalMovementAllowed) {
                this.y(node, this.y(node) + this.dy(node) * f);
            }
            this.dx(node, 0.0f);
            this.dy(node, 0.0f);
        }
    }

    protected Point2D.Float distance(Node from, Node to) {
        if (this.distanceMethod == 0) {
            return this.distanceMin(from, to);
        }
        if (this.distanceMethod == 2) {
            return this.distanceDiagonal(from, to);
        }
        return this.distanceBetweenCenters(from, to);
    }

    protected Point2D.Float distanceBetweenCenters(Node from, Node to) {
        return new Point2D.Float(this.x(to) - this.x(from) + (float)(to.width - from.width) / 2.0f, this.y(to) - this.y(from) + (float)(to.height - from.height) / 2.0f);
    }

    protected Point2D.Float distanceMin(Node from, Node to) {
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.x(from) + (float)from.width < this.x(to)) {
            dx = this.x(to) - this.x(from) - (float)from.width;
        } else if (this.x(to) + (float)to.width < this.x(from)) {
            dx = this.x(to) - this.x(from) + (float)to.width;
        }
        if (this.y(from) + (float)from.height < this.y(to)) {
            dy = this.y(to) - this.y(from) - (float)from.height;
        } else if (this.y(to) + (float)to.height < this.y(from)) {
            dy = this.y(to) - this.y(from) + (float)to.height;
        }
        return new Point2D.Float(dx, dy);
    }

    protected Point2D.Float distanceDiagonal(Node from, Node to) {
        Point2D.Float d = this.distanceMin(from, to);
        float vx = this.x(to) - this.x(from) + (float)(to.width - from.width) / 2.0f;
        float vy = this.y(to) - this.y(from) + (float)(to.height - from.height) / 2.0f;
        if (d.x == 0.0f && d.y != 0.0f) {
            return new Point2D.Float(vx * d.y / vy, d.y);
        }
        if (d.y == 0.0f && d.x != 0.0f) {
            return new Point2D.Float(d.x, d.y * d.x / vx);
        }
        return d;
    }

    @Override
    public LayouterInfo getInfo() {
        LayouterInfoSupport lis = new LayouterInfoSupport(true, true, false, false, false, false);
        return lis;
    }

    @Override
    public int estimate(Graph graph, int what) {
        int operations = 0;
        if (graph.isConnected()) {
            return this.iterationNumber;
        }
        List<Graph> graphs = graph.split();
        for (Graph gr : graphs) {
            boolean notSimpleNodeFlag = true;
            for (Node n : gr.nodeList) {
                String type = n.getAttribute("Type");
                if (Util.isCompartment(n) || type != null && (type.equals("Event") || type.equals("Equation") || type.equals("Function"))) continue;
                notSimpleNodeFlag = false;
            }
            if (notSimpleNodeFlag) continue;
            operations += this.iterationNumber;
        }
        return operations;
    }

    public int getInitialPlacement() {
        return this.initialPlacement;
    }

    public void setInitialPlacement(int initialPlacement) {
        this.initialPlacement = initialPlacement;
    }

    public boolean isHorisontalMovementAllowed() {
        return this.horisontalMovementAllowed;
    }

    public void setHorisontalMovementAllowed(boolean horisontalMovementAllowed) {
        this.horisontalMovementAllowed = horisontalMovementAllowed;
    }

    public boolean isVerticalMovementAllowed() {
        return this.verticalMovementAllowed;
    }

    public void setVerticalMovementAllowed(boolean verticalMovementAllowed) {
        this.verticalMovementAllowed = verticalMovementAllowed;
    }

    public int getDistanceMethod() {
        return this.distanceMethod;
    }

    public void setDistanceMethod(int distanceMethod) {
        this.distanceMethod = distanceMethod;
    }

    public int getEdgeLength() {
        return this.edgeLength;
    }

    public void setEdgeLength(int edgeLength) {
        this.edgeLength = edgeLength;
    }

    public float getAttraction() {
        return this.attraction;
    }

    public void setAttraction(float attraction) {
        this.attraction = attraction;
    }

    public float getRepulsion() {
        return this.repulsion;
    }

    public void setRepulsion(float repulsion) {
        this.repulsion = repulsion;
    }

    public int getRepulsionDistance() {
        return this.repulsionDistance;
    }

    public void setRepulsionDistance(int repulsionDistance) {
        this.repulsionDistance = repulsionDistance;
    }

    public float getGravity() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public float getMagneticIntencity() {
        return this.magneticIntencity;
    }

    public void setMagneticIntencity(float magneticIntencity) {
        this.magneticIntencity = magneticIntencity;
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public void setIterationNumber(int iterationNumber) {
        this.iterationNumber = iterationNumber;
    }

    public float getMinTemperature() {
        return this.minTemperature;
    }

    public void setMinTemperature(float minTemperature) {
        this.minTemperature = minTemperature;
    }

    public float getMaxTemperature() {
        return this.maxTemperature;
    }

    public void setMaxTemperature(float maxTemperature) {
        this.maxTemperature = maxTemperature;
    }

    public class LayoutData {
        public float x;
        public float y;
        public float dx;
        public float dy;

        public LayoutData(Node n) {
            this.x = n.x;
            this.y = n.y;
        }
    }
}

