/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.OrthogonalPathLayouter;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graph.Util;

public class FastGridLayouter
extends AbstractLayouter {
    private int threadCount = 2;
    private int tMax;
    private final double tMin = 0.1;
    private int iterations = 4;
    private double cool = 0.6;
    private double stochasticRate = 0.3;
    private boolean isStartingFromThisLayout = true;
    private boolean keepCompartmentSize = false;
    private boolean shouldPermutateGraph = false;
    private boolean isEstimationDone = false;
    private boolean isScaled = false;
    private int h;
    private int w;
    private final int sd = 6;
    private int gridX = 70;
    private int gridY = 60;
    private Map<String, Node> fixedNodes = null;
    private int edgeEdgeCrossCost = 300;
    private int edgeNodeCrossCost = 500;
    private int nodeNodeCrossCost = 1000;
    private int strongAttraction = 4;
    private int averageAttraction = 3;
    private int weakAttraction = 0;
    private int weakRepulsion = -1;
    private int averageRepulsion = -1;
    private int strongRepulsion = -3;
    private final Map<String, Integer> nodeInteractionMap = new HashMap<String, Integer>();
    private final Map<String, List<Point>> allowedPoints = new HashMap<String, List<Point>>();

    public FastGridLayouter() {
        this.pathLayouterWrapper = new PathLayouterWrapper(new OrthogonalPathLayouter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout(Graph graph, LayoutJobControl jobControl) {
        try {
            if (!this.isEstimationDone) {
                this.estimate(graph, 1);
            }
            this.layoutNodes(graph, jobControl);
            this.layoutEdges(graph, jobControl);
        }
        catch (Exception ex) {
            log.info("Error during layout: " + ex.getMessage());
        }
        finally {
            System.out.println("Flags reset");
            this.isScaled = false;
            this.isEstimationDone = false;
        }
    }

    @Override
    public void layoutNodes(Graph graph, LayoutJobControl jobControl) {
        this.setAllowedPoints(graph);
        this.distributedAnnealing(graph, jobControl);
        this.restore(graph);
        Util.adjustOrientations(graph);
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl jobControl) {
        this.getPathLayouter().layoutEdges(graph, jobControl);
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl jobControl) {
        this.getPathLayouter().layoutPath(graph, edge, jobControl);
    }

    private void shift(Graph graph) {
        int dx = 0;
        int dy = 0;
        for (Node node : graph.nodeList) {
            dx = Math.min(node.x, dx);
            dy = Math.min(node.y, dy);
        }
        for (Node node : graph.nodeList) {
            node.x -= dx;
            node.y -= dy;
        }
        for (Edge edge : graph.edgeList) {
            int i = 0;
            while (i < edge.getPath().npoints) {
                int n = i;
                edge.path.xpoints[n] = edge.path.xpoints[n] - dx;
                int n2 = i++;
                edge.path.ypoints[n2] = edge.path.ypoints[n2] - dy;
            }
        }
    }

    private void checkInitialPostitions(Graph graph) {
        for (Node node : graph.nodeList) {
            Point p = new Point(node.x, node.y);
            if (this.allowedPoints.get(node.name).contains(p)) continue;
            Point newP = this.getNearestAllowedPoint(node);
            if (newP == null) {
                node.fixed = true;
                log.info("Node " + node + " was fixed becase no allowed place was found.");
                continue;
            }
            this.moveNode(node, newP);
        }
    }

    private void distributedAnnealing(Graph graph, LayoutJobControl jobControl) {
        double temperature;
        this.checkInitialPostitions(graph);
        if (!this.shouldPermutateGraph) {
            Layouting thread = new Layouting(graph);
            temperature = thread.getCost();
        } else {
            temperature = this.calulateMaximumTemperature(graph);
        }
        this.tMax = (int)temperature;
        int cost = this.distributedProcess(graph);
        Graph optimal = graph.clone();
        Graph temp = graph.clone();
        int minCost = cost;
        int operations = 0;
        while (temperature > 0.1) {
            for (int i = 0; i < this.iterations - 1; ++i) {
                if (jobControl != null) {
                    jobControl.done(operations++);
                    if (jobControl.getStatus() != 1) {
                        temperature = 0.1;
                        break;
                    }
                }
                this.copyNodeLayout(temp, graph);
                int tempCost = this.distributedProcess(graph);
                if (tempCost < minCost) {
                    minCost = tempCost;
                    this.copyNodeLayout(optimal, graph);
                }
                if (!(Math.random() >= Math.exp((double)(cost - tempCost) / temperature))) continue;
                cost = tempCost;
                this.copyNodeLayout(graph, temp);
            }
            temperature *= this.cool;
        }
        this.copyNodeLayout(graph, optimal);
    }

    private int distributedProcess(Graph graph) {
        int i;
        Layouting[] threads = new Layouting[this.threadCount];
        int minCost = this.tMax;
        int winner = 0;
        for (i = 0; i < threads.length; ++i) {
            Graph nextGraph = graph.clone();
            double stochasticRate = 0.3;
            this.permutate(nextGraph, stochasticRate);
            threads[i] = new Layouting(nextGraph);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                int currentCost = threads[i].cost;
                if (currentCost >= minCost) continue;
                winner = i;
                minCost = currentCost;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.copyNodeLayout(graph, threads[winner].graph);
        return minCost;
    }

    private int calulateMaximumTemperature(Graph graph) {
        int t = 0;
        for (int i = 0; i < 10; ++i) {
            this.permutate(graph, 1.0);
            Layouting thread = new Layouting(graph);
            t += thread.calculateCost();
            thread.interrupt();
        }
        return t;
    }

    private void moveNode(Node node, Point p) {
        if (node != null && p != null && !node.fixed) {
            node.x = p.x;
            node.y = p.y;
        }
    }

    private Set<Node> multiply(Set<Node> list, Graph graph) {
        HashSet<Node> result = new HashSet<Node>();
        for (Node node : list) {
            result.addAll(Util.getNodes(node, graph));
        }
        return result;
    }

    private void initNodeInteractionMap(Graph graph) {
        this.nodeInteractionMap.clear();
        List<Graph> subGraphs = graph.split();
        for (Node node1 : graph.nodeList) {
            for (Node node2 : graph.nodeList) {
                this.nodeInteractionMap.put(node1.name + node2.name, 0);
            }
        }
        HashSet<Node> lonelyNodes = new HashSet<Node>();
        for (Node node : graph.nodeList) {
            if (!graph.getEdges(node).isEmpty()) continue;
            lonelyNodes.add(node);
        }
        for (Node node1 : lonelyNodes) {
            for (Node node2 : lonelyNodes) {
                if (Util.getCompartments(node1, graph).contains(node2) || Util.getCompartments(node2, graph).contains(node1)) continue;
                this.nodeInteractionMap.put(node1.name + node2.name, this.strongAttraction);
            }
        }
        for (Graph subGraph : subGraphs) {
            if (subGraph.nodeList.size() == 1) continue;
            for (Node node1 : subGraph.nodeList) {
                Set<Node> compartments2;
                Set<Node> compartments1 = Util.getCompartments(node1, graph);
                Set<Node> nodeSet1 = Util.getNodes(node1, graph);
                Set<Node> nodeSet2 = this.multiply(nodeSet1, graph);
                Set<Node> nodeSet3 = this.multiply(nodeSet2, graph);
                Set<Node> nodeSet4 = this.multiply(nodeSet3, graph);
                HashSet<Node> nodeSet5 = new HashSet<Node>(subGraph.nodeList);
                HashSet<Node> nodeSet6 = new HashSet<Node>(graph.nodeList);
                nodeSet6.removeAll(nodeSet5);
                nodeSet5.removeAll(nodeSet4);
                nodeSet6.removeAll(compartments1);
                nodeSet4.removeAll(nodeSet3);
                nodeSet3.removeAll(nodeSet2);
                nodeSet2.removeAll(nodeSet1);
                for (Node node2 : nodeSet6) {
                    this.nodeInteractionMap.put(node1.name + node2.name, this.strongRepulsion);
                }
                for (Node node2 : nodeSet5) {
                    this.nodeInteractionMap.put(node1.name + node2.name, this.averageRepulsion);
                }
                for (Node node2 : nodeSet4) {
                    this.nodeInteractionMap.put(node1.name + node2.name, this.weakRepulsion);
                }
                for (Node node2 : nodeSet3) {
                    this.nodeInteractionMap.put(node1.name + node2.name, this.weakAttraction);
                }
                for (Node node2 : nodeSet2) {
                    compartments2 = Util.getCompartments(node2, graph);
                    for (Node compartment1 : compartments1) {
                        for (Node compartment2 : compartments2) {
                            this.nodeInteractionMap.put(compartment1.name + compartment2.name, this.averageAttraction);
                        }
                    }
                    this.nodeInteractionMap.put(node1.name + node2.name, this.averageAttraction);
                }
                for (Node node2 : nodeSet1) {
                    compartments2 = Util.getCompartments(node2, graph);
                    for (Node compartment1 : compartments1) {
                        for (Node compartment2 : compartments2) {
                            this.nodeInteractionMap.put(compartment1.name + compartment2.name, this.strongAttraction);
                        }
                    }
                    this.nodeInteractionMap.put(node1.name + node2.name, this.strongAttraction);
                }
            }
        }
    }

    private void setAllowedPoints(Graph graph) {
        this.allowedPoints.clear();
        int iLeft = 0;
        int iRight = 0;
        int jUp = 0;
        int jDown = 0;
        for (Node node : graph.nodeList) {
            double height;
            double width;
            ArrayList<Point> points = new ArrayList<Point>();
            Node compartment = Util.getCompartment(node, graph);
            if (compartment != null) {
                width = (double)(-node.width + compartment.width) / 2.0;
                height = (double)(-node.height + compartment.height) / 2.0;
                iLeft = compartment.x - (int)Math.ceil(width / (double)this.gridX);
                iRight = compartment.x + (int)Math.floor(width / (double)this.gridX);
                jUp = compartment.y - (int)Math.ceil(height / (double)this.gridY);
                jDown = compartment.y + (int)Math.ceil(height / (double)this.gridY);
                if (height % (double)this.gridY == 0.0) {
                    ++jDown;
                }
            } else {
                width = (double)node.width / 2.0;
                height = (double)node.height / 2.0;
                iLeft = (int)Math.ceil(width / (double)this.gridX - 0.5);
                iRight = (int)Math.floor((double)this.w - width / (double)this.gridX - 0.5);
                jUp = (int)Math.ceil(height / (double)this.gridY - 0.5);
                jDown = (int)Math.floor((double)this.h - height / (double)this.gridY + 0.5);
            }
            for (int i = iLeft; i <= iRight; ++i) {
                for (int j = jUp; j < jDown; ++j) {
                    points.add(new Point(i, j));
                }
            }
            this.allowedPoints.put(node.name, points);
        }
    }

    private void layoutCompartments(Graph graph) {
        HashMap<Object, HashSet<Node>> levelToCompartmentMap = new HashMap<Object, HashSet<Node>>();
        Set compartments = new HashSet<Node>();
        for (Node node : graph.nodeList) {
            if (!Util.isCompartment(node)) continue;
            compartments.add(node);
            Integer i = Util.getLevel(node);
            HashSet<Node> nodes = (HashSet<Node>)levelToCompartmentMap.get(i);
            if (nodes == null) {
                nodes = new HashSet<Node>();
            }
            nodes.add(node);
            levelToCompartmentMap.put(i, nodes);
        }
        int levelsCount = levelToCompartmentMap.size();
        for (int k = levelsCount - 1; k >= 0; --k) {
            compartments = (Set)levelToCompartmentMap.get(k);
            if (compartments == null) continue;
            for (Node compartment : compartments) {
                Rectangle r;
                if (this.keepCompartmentSize || compartment.fixed) continue;
                this.setCompartmentSize(compartment, graph);
                compartment.width += (levelsCount - k) * 10;
                compartment.height += (levelsCount - k) * 10;
                if (!this.isStartingFromThisLayout || (r = Util.getBounds(graph, compartment, 10)) == null) continue;
                int oldX = compartment.x;
                int oldY = compartment.y;
                compartment.x = Math.min(compartment.x, r.x);
                compartment.y = Math.min(compartment.y, r.y);
                compartment.width = Math.max(oldX + compartment.width, r.x + r.width) - compartment.x;
                compartment.height = Math.max(oldY + compartment.height, r.y + r.height) - compartment.y;
            }
        }
        this.setGridSize(graph);
        this.storeCompartments(graph);
        Graph compartmentsGraph = new Graph();
        for (int k = 0; k < levelsCount; ++k) {
            Set addCompartments = (Set)levelToCompartmentMap.get(k);
            for (Node compartment : addCompartments) {
                compartmentsGraph.addNode(compartment);
            }
            this.setAllowedPoints(compartmentsGraph);
            this.distributedAnnealing(compartmentsGraph, null);
            for (Node compartment : addCompartments) {
                compartment.fixed = true;
            }
        }
    }

    private Point getCenter(Node node) {
        Point result = new Point();
        result.x = (node.x + 1) * this.gridX;
        result.y = (node.y + 1) * this.gridY;
        return result;
    }

    private void permutate(Graph graph, double stochasticRate) {
        for (Node node : graph.nodeList) {
            if (node.fixed || !(Math.random() < stochasticRate)) continue;
            this.moveNode(node, this.getRandomAllowedPoint(node));
        }
    }

    private void copyFixedNodes(Graph graph) {
        this.fixedNodes = new HashMap<String, Node>();
        for (Node node : graph.nodeList) {
            if (!node.fixed) continue;
            this.fixedNodes.put(node.name, node.clone());
        }
    }

    private void storeCompartments(Graph graph) {
        for (Node node : graph.nodeList) {
            if (!Util.isCompartment(node)) continue;
            this.store(node);
        }
    }

    private void storeNodes(Graph graph) {
        for (Node node : graph.nodeList) {
            if (Util.isCompartment(node)) continue;
            this.store(node);
        }
        this.isScaled = true;
    }

    private void restore(Graph graph) {
        for (Node node : graph.nodeList) {
            this.restore(node);
        }
        this.isScaled = false;
    }

    private void store(Node node) {
        int oldX = node.x;
        int oldY = node.y;
        node.x = (int)Math.round(((double)node.x + (double)node.width / 2.0) / (double)this.gridX);
        node.y = (int)Math.round(((double)node.y + (double)node.height / 2.0) / (double)this.gridY);
        if (node.fixed && !Util.isCompartment(node)) {
            node.width = 2 * (node.x * this.gridX - oldX);
            node.height = 2 * (node.y * this.gridY - oldY);
        }
    }

    private void restore(Node node) {
        Node originalNode;
        node.x = (node.x + 1) * this.gridX - node.width / 2;
        node.y = (node.y + 1) * this.gridY - node.height / 2;
        if (node.fixed && (originalNode = this.fixedNodes.get(node.getName())) != null) {
            node.width = originalNode.width;
            node.height = originalNode.height;
            node.x = originalNode.x;
            node.y = originalNode.y;
        }
    }

    private void copyNodeLayout(Graph graphTo, Graph graphFrom) {
        for (Node nodeTo : graphTo.nodeList) {
            Node nodeFrom = graphFrom.getNode(nodeTo.name);
            if (nodeFrom == null) continue;
            nodeTo.x = nodeFrom.x;
            nodeTo.y = nodeFrom.y;
            nodeTo.width = nodeFrom.width;
            nodeTo.height = nodeFrom.height;
        }
    }

    private Point getRandomAllowedPoint(Node node) {
        Random rand = new Random();
        List<Point> points = this.allowedPoints.get(node.name);
        if (points.size() == 0) {
            log.severe("There are no place for node " + node.getName() + ". Layout will be terminated!");
        }
        int i = rand.nextInt(points.size());
        return points.get(i);
    }

    private Point getNearestAllowedPoint(Node node) {
        List<Point> points = this.allowedPoints.get(node.name);
        if (points.isEmpty()) {
            return null;
        }
        int x = node.x;
        int y = node.y;
        Point result = points.get(0);
        int distance = Math.abs(result.x - x) + Math.abs(result.y - y);
        for (Point p : points) {
            int newDistance = Math.abs(p.x - x) + Math.abs(p.y - y);
            if (newDistance >= distance) continue;
            result = new Point(p.x, p.y);
            distance = newDistance;
        }
        return result;
    }

    private void setGridSize(Graph graph) {
        int maximumWidth = 0;
        int maximumHeight = 0;
        int width = 0;
        int height = 0;
        int maxX = 0;
        int maxY = 0;
        for (Node n : graph.nodeList) {
            if (Util.getCompartment(n, graph) != null) continue;
            int addWidth = 2 * (int)Math.ceil((double)n.width / (double)(2 * this.gridX) - 0.5) + 1;
            int addHeight = 2 * (int)Math.ceil((double)n.height / (double)(2 * this.gridY) - 0.5) + 1;
            if (addWidth > maximumWidth) {
                width += maximumWidth;
                maximumWidth = addWidth;
            } else {
                width += addWidth;
            }
            if (addHeight > maximumHeight) {
                height += maximumHeight;
                maximumHeight = addHeight;
            } else {
                height += addHeight;
            }
            maxX = Math.max(maxX, (int)Math.ceil((double)(n.x + n.width) / (double)this.gridX));
            maxY = Math.max(maxY, (int)Math.ceil((double)(n.y + n.height) / (double)this.gridY));
        }
        this.w = maximumWidth + 2 * (int)Math.round(Math.sqrt(width));
        this.h = maximumHeight + 3 * (int)Math.round(Math.sqrt(height));
        if (!this.shouldPermutateGraph) {
            this.w = Math.max(this.w, maxX);
            this.h = Math.max(this.h, maxY);
        }
    }

    private void setCompartmentSize(Node compartment, Graph graph) {
        int width = 0;
        int height = 0;
        int nodeWidth = 0;
        int nodeHeight = 0;
        for (Node node : graph.nodeList) {
            Node nodeCompartment = Util.getCompartment(node, graph);
            if (nodeCompartment == null || !nodeCompartment.equals(compartment)) continue;
            double addWidth = 2.0 * Math.ceil((double)node.width / (double)(2 * this.gridX) - 0.5) + 1.0;
            double addHeight = 2.0 * Math.ceil((double)node.height / (double)(2 * this.gridY) - 0.5) + 1.0;
            boolean incWidth = false;
            boolean incHeight = false;
            if (addWidth > addHeight) {
                incWidth = true;
            } else if (addWidth < addHeight) {
                incHeight = true;
            } else if (width <= height) {
                incWidth = true;
            } else {
                incHeight = true;
            }
            if (incWidth) {
                if (addWidth > 3.0) {
                    nodeWidth = (int)((double)nodeWidth + addWidth);
                } else {
                    width = (int)((double)width + addWidth);
                }
            }
            if (incHeight) {
                if (addHeight > 3.0) {
                    nodeHeight = (int)((double)nodeHeight + addHeight);
                } else {
                    height = (int)((double)height + addHeight);
                }
            }
            if (addWidth > (double)nodeWidth) {
                nodeWidth = (int)((double)nodeWidth + addWidth);
            }
            if (!(addHeight > (double)nodeHeight)) continue;
            nodeHeight = (int)((double)nodeHeight + addHeight);
        }
        width = nodeWidth + 3 * (int)Math.round(Math.sqrt(width));
        height = nodeHeight + 3 * (int)Math.round(Math.sqrt(height));
        if (width == 0) {
            ++width;
        } else if (width % 2 == 0) {
            --width;
        }
        if (height == 0) {
            ++height;
        } else if (height % 2 == 0) {
            --height;
        }
        compartment.width = width * this.gridX;
        compartment.height = height * this.gridY;
    }

    @Override
    public LayouterInfo getInfo() {
        LayouterInfoSupport lis = new LayouterInfoSupport(true, true, true, true, false, true);
        return lis;
    }

    @Override
    public int estimate(Graph graph, int what) {
        try {
            boolean bl = this.shouldPermutateGraph = !this.isStartingFromThisLayout;
            if (!this.isStartingFromThisLayout && Util.hasFixedNodes(graph)) {
                this.shouldPermutateGraph = false;
                log.info("Diagram have fixed elements, \"isStartingFromThisLayout = false\" option will be ignored.");
            }
            if (!this.shouldPermutateGraph) {
                this.shift(graph);
            }
            this.copyFixedNodes(graph);
            this.initNodeInteractionMap(graph);
            this.layoutCompartments(graph);
            if (!this.isScaled) {
                this.storeNodes(graph);
            }
            this.setAllowedPoints(graph);
            this.tMax = !this.shouldPermutateGraph ? new Layouting(graph).getCost() : this.calulateMaximumTemperature(graph);
            double steps = Math.log(0.1 / (double)this.tMax);
            this.isEstimationDone = true;
            System.out.println("Estimation done");
            return (int)(steps /= Math.log(this.cool)) * this.iterations;
        }
        catch (Exception ex) {
            log.severe("Error during preliminary phase " + ex.getMessage());
            ex.printStackTrace();
            this.restore(graph);
            this.isScaled = false;
            this.isEstimationDone = false;
            return 0;
        }
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public double getCool() {
        return this.cool;
    }

    public void setCool(double cool) {
        this.cool = cool;
    }

    public double getPerturbationRate() {
        return this.stochasticRate;
    }

    public void setPerturbationRate(double rate) {
        this.stochasticRate = rate;
    }

    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int count) {
        this.threadCount = count;
    }

    public boolean isStartingFromThisLayout() {
        return this.isStartingFromThisLayout;
    }

    public void setStartingFromThisLayout(boolean val) {
        this.isStartingFromThisLayout = val;
    }

    public int getEdgeEdgeCrossCost() {
        return this.edgeEdgeCrossCost;
    }

    public void setEdgeEdgeCrossCost(int wEE) {
        this.edgeEdgeCrossCost = wEE;
    }

    public int getEdgeNodeCrossCost() {
        return this.edgeNodeCrossCost;
    }

    public void setEdgeNodeCrossCost(int wNE) {
        this.edgeNodeCrossCost = wNE;
    }

    public int getNodeNodeCrossCost() {
        return this.nodeNodeCrossCost;
    }

    public void setNodeNodeCrossCost(int wNN) {
        this.nodeNodeCrossCost = wNN;
    }

    public int getStrongAttraction() {
        return this.strongAttraction;
    }

    public void setStrongAttraction(int wD1) {
        this.strongAttraction = wD1;
    }

    public int getAverageAttraction() {
        return this.averageAttraction;
    }

    public void setAverageAttraction(int wD2) {
        this.averageAttraction = wD2;
    }

    public int getWeakAttraction() {
        return this.weakAttraction;
    }

    public void setWeakAttraction(int wD3) {
        this.weakAttraction = wD3;
    }

    public int getWeakRepulsion() {
        return this.weakRepulsion;
    }

    public void setWeakRepulsion(int wD4) {
        this.weakRepulsion = wD4;
    }

    public int getAverageRepulsion() {
        return this.averageRepulsion;
    }

    public void setAverageRepulsion(int wD5) {
        this.averageRepulsion = wD5;
    }

    public int getStrongRepulsion() {
        return this.strongRepulsion;
    }

    public void setStrongRepulsion(int wD6) {
        this.strongRepulsion = wD6;
    }

    public boolean isKeepCompartmentSize() {
        return this.keepCompartmentSize;
    }

    public void setKeepCompartmentSize(boolean keepCompartmentSize) {
        this.keepCompartmentSize = keepCompartmentSize;
    }

    private class Layouting
    extends Thread {
        private final int[][] boundMatrix;
        private final int[][] costMatrix;
        private Node nodeMin;
        private Point pointMin;
        Map<String, Integer[][]> deltaMap = new HashMap<String, Integer[][]>();
        private int cost;
        private final Graph graph;

        public Layouting(Graph graph) {
            this.boundMatrix = new int[FastGridLayouter.this.w][FastGridLayouter.this.h + 1];
            this.costMatrix = new int[FastGridLayouter.this.w][FastGridLayouter.this.h];
            this.graph = graph;
        }

        @Override
        public void run() {
            this.cost = this.process();
        }

        public int calculateCost() {
            return this.getCost();
        }

        private int process() {
            int dMin = this.initDeltaMap();
            if (this.nodeMin == null || this.pointMin == null) {
                return this.getCost();
            }
            int count = 0;
            double iteartionsLimit = 1.5 * (double)this.graph.nodeCount();
            while (dMin < 0) {
                int n = count++;
                if (!((double)n < iteartionsLimit)) break;
                Point tempPoint = this.pointMin;
                String tempNodeName = this.nodeMin.name;
                Point prevPoint = new Point(this.nodeMin.x, this.nodeMin.y);
                FastGridLayouter.this.moveNode(this.nodeMin, this.pointMin);
                dMin = 0;
                for (Node node : this.graph.nodeList) {
                    if (node.fixed) continue;
                    this.resetPenaltyMatrix();
                    if (!node.name.equals(this.nodeMin.name)) {
                        HashSet<Node> nodes = new HashSet<Node>(this.graph.nodeList);
                        HashSet<Edge> notConnectedEdges = new HashSet<Edge>(this.graph.edgeList);
                        HashSet<Node> connectedNodes = new HashSet<Node>(Util.getNodes(node, this.graph));
                        HashSet<Edge> connectedToMinEdges = new HashSet<Edge>();
                        List<Edge> edges = this.graph.getEdges(this.nodeMin);
                        if (edges != null) {
                            connectedToMinEdges.addAll(edges);
                        }
                        nodes.remove(node);
                        nodes.remove(this.nodeMin);
                        nodes.removeAll(Util.getCompartments(node, this.graph));
                        nodes.removeAll(Util.getCompartments(this.nodeMin, this.graph));
                        connectedNodes.remove(node);
                        connectedNodes.remove(this.nodeMin);
                        if (this.graph.getEdges(node) != null) {
                            connectedToMinEdges.removeAll(this.graph.getEdges(node));
                            notConnectedEdges.removeAll(this.graph.getEdges(node));
                        }
                        this.setDistance(node, this.nodeMin, 1);
                        this.setEdgeEdge(connectedNodes, connectedToMinEdges, (Integer)FastGridLayouter.this.edgeEdgeCrossCost);
                        this.setNodeEdge(node, connectedToMinEdges, FastGridLayouter.this.edgeNodeCrossCost);
                        this.setEdgeNode(connectedNodes, this.nodeMin, FastGridLayouter.this.edgeNodeCrossCost);
                        this.setNodeNode(node, this.nodeMin, FastGridLayouter.this.nodeNodeCrossCost);
                        if (Util.areConnected(node, this.nodeMin, this.graph)) {
                            this.setEdgeEdge(this.nodeMin, notConnectedEdges, (Integer)FastGridLayouter.this.edgeEdgeCrossCost);
                            this.setEdgeNode(this.nodeMin, nodes, FastGridLayouter.this.edgeNodeCrossCost);
                        }
                        FastGridLayouter.this.moveNode(this.nodeMin, prevPoint);
                        this.setDistance(node, this.nodeMin, -1);
                        this.setEdgeEdge(connectedNodes, connectedToMinEdges, (Integer)(-FastGridLayouter.this.edgeEdgeCrossCost));
                        this.setNodeEdge(node, connectedToMinEdges, -FastGridLayouter.this.edgeNodeCrossCost);
                        this.setEdgeNode(connectedNodes, this.nodeMin, -FastGridLayouter.this.edgeNodeCrossCost);
                        this.setNodeNode(node, this.nodeMin, -FastGridLayouter.this.nodeNodeCrossCost);
                        if (Util.areConnected(node, this.nodeMin, this.graph)) {
                            this.setEdgeEdge(this.nodeMin, notConnectedEdges, (Integer)(-FastGridLayouter.this.edgeEdgeCrossCost));
                            this.setEdgeNode(this.nodeMin, nodes, -FastGridLayouter.this.edgeNodeCrossCost);
                        }
                        FastGridLayouter.this.moveNode(this.nodeMin, this.pointMin);
                    }
                    this.setPenaltyMatrix();
                    Integer[][] deltaValues = new Integer[FastGridLayouter.this.w][FastGridLayouter.this.h];
                    Integer[][] oldValues = this.deltaMap.get(node.name);
                    for (Point p : (List)FastGridLayouter.this.allowedPoints.get(node.name)) {
                        int i = p.x;
                        int j = p.y;
                        deltaValues[i][j] = oldValues[i][j] - oldValues[node.x][node.y] + this.costMatrix[i][j] - this.costMatrix[node.x][node.y];
                        if (deltaValues[i][j] >= dMin) continue;
                        tempNodeName = node.name;
                        dMin = deltaValues[i][j];
                        tempPoint = new Point(i, j);
                    }
                    this.deltaMap.put(node.name, deltaValues);
                }
                this.pointMin = (Point)tempPoint.clone();
                this.nodeMin = this.graph.getNode(tempNodeName);
            }
            FastGridLayouter.this.moveNode(this.nodeMin, this.pointMin);
            return this.getCost();
        }

        private int initDeltaMap() {
            this.deltaMap.clear();
            int dMin = 0;
            for (Node node : this.graph.nodeList) {
                if (node.fixed) continue;
                this.resetPenaltyMatrix();
                HashSet<Edge> notConnectedEdges = new HashSet<Edge>(this.graph.edgeList);
                Set<Node> connectedNodes = Util.getNodes(node, this.graph);
                HashSet<Node> nodes = new HashSet<Node>(this.graph.nodeList);
                if (this.graph.getEdges(node) != null) {
                    notConnectedEdges.removeAll(this.graph.getEdges(node));
                }
                connectedNodes.remove(node);
                nodes.remove(node);
                nodes.removeAll(Util.getCompartments(node, this.graph));
                this.setEdgeEdge(connectedNodes, notConnectedEdges, (Integer)FastGridLayouter.this.edgeEdgeCrossCost);
                this.setEdgeNode(connectedNodes, nodes, FastGridLayouter.this.edgeNodeCrossCost);
                this.setNodeEdge(node, notConnectedEdges, FastGridLayouter.this.edgeNodeCrossCost);
                this.setNodeNode(node, this.graph, FastGridLayouter.this.nodeNodeCrossCost);
                this.setDistance(node, this.graph, 1);
                this.setPenaltyMatrix();
                Integer[][] deltaValues = new Integer[FastGridLayouter.this.w][FastGridLayouter.this.h];
                for (Point p : (List)FastGridLayouter.this.allowedPoints.get(node.name)) {
                    int i = p.x;
                    int j = p.y;
                    deltaValues[i][j] = this.costMatrix[i][j] - this.costMatrix[node.x][node.y];
                    if (deltaValues[i][j] >= dMin) continue;
                    this.nodeMin = node;
                    dMin = deltaValues[i][j];
                    this.pointMin = new Point(i, j);
                }
                this.deltaMap.put(node.name, deltaValues);
            }
            return dMin;
        }

        private int getCost() {
            int cost = 0;
            int floatCost = 0;
            Graph tempGraph = new Graph();
            for (Node node : this.graph.nodeList) {
                tempGraph.addNode(node);
            }
            for (Edge e : this.graph.edgeList) {
                tempGraph.addEdge(e);
            }
            for (Node node : this.graph.nodeList) {
                if (node.fixed) continue;
                this.resetPenaltyMatrix();
                HashSet<Edge> notConnectedEdges = new HashSet<Edge>();
                HashSet<Node> nodes = new HashSet<Node>(tempGraph.nodeList);
                Set<Node> connectedNodes = Util.getNodes(node, tempGraph);
                notConnectedEdges.addAll(tempGraph.edgeList);
                List<Edge> edges = tempGraph.getEdges(node);
                if (edges != null) {
                    notConnectedEdges.removeAll(edges);
                }
                connectedNodes.remove(node);
                nodes.remove(node);
                nodes.removeAll(Util.getCompartments(node, this.graph));
                this.setEdgeEdge(connectedNodes, notConnectedEdges, (Integer)FastGridLayouter.this.edgeEdgeCrossCost);
                this.setEdgeNode(connectedNodes, nodes, FastGridLayouter.this.edgeNodeCrossCost);
                this.setNodeEdge(node, notConnectedEdges, FastGridLayouter.this.edgeNodeCrossCost);
                this.setNodeNode(node, tempGraph, FastGridLayouter.this.nodeNodeCrossCost);
                this.setDistance(node, tempGraph, 1);
                this.setPenaltyMatrix();
                cost += this.costMatrix[node.x][node.y];
                floatCost = (int)((double)floatCost + this.getFloatCost(node, this.graph.getEdges(node)));
                tempGraph.removeNode(node);
            }
            return cost;
        }

        public double getFloatCost(Node node, List<Edge> connectedEdges) {
            if (connectedEdges == null) {
                return 0.0;
            }
            double x1 = 0.0;
            double x2 = 0.0;
            double y1 = 0.0;
            double y2 = 0.0;
            Point p = FastGridLayouter.this.getCenter(node);
            for (Edge edge : connectedEdges) {
                double length;
                double y;
                double x;
                Point q;
                if (edge.to.name == node.name) {
                    q = FastGridLayouter.this.getCenter(edge.from);
                    x = p.x - q.x;
                    y = p.y - q.y;
                    length = Math.hypot(x, y);
                    x1 += x / length;
                    y1 += y / length;
                    continue;
                }
                q = FastGridLayouter.this.getCenter(edge.to);
                x = q.x - p.x;
                y = q.y - p.y;
                length = Math.hypot(x, y);
                x2 += x / length;
                y2 += y / length;
            }
            return -(x1 * x2 + y1 * y2);
        }

        private void setDistance(Node n1, Graph graph, int sgn) {
            for (Node n2 : graph.nodeList) {
                this.setDistance(n1, n2, sgn);
            }
        }

        private void setDistance(Node n1, Node n2, int sgn) {
            if (n2.name == n1.name) {
                return;
            }
            int weight = (Integer)FastGridLayouter.this.nodeInteractionMap.get(n1.name + n2.name);
            if (weight > 0) {
                this.setDistanceBoundary(n2, sgn * weight);
            } else {
                this.setSaturationDistanceBoundary(n2, sgn * weight);
            }
        }

        private void setSaturationDistanceBoundary(Node n, Integer weight) {
            for (int i = 0; i < FastGridLayouter.this.w; ++i) {
                int[] nArray = this.boundMatrix[i];
                nArray[0] = nArray[0] + 6 * weight;
            }
            int start = n.x - 6 + 1;
            int end = n.x + 6 - 1;
            start = Math.max(start, 0);
            end = Math.min(end, FastGridLayouter.this.w - 1);
            for (int i = start; i <= end; ++i) {
                int j;
                int d = 6 - Math.abs(n.x - i);
                for (j = n.y - d + 1; j <= n.y; ++j) {
                    int[] nArray = this.boundMatrix[i];
                    int n2 = Math.max(j, 0);
                    nArray[n2] = nArray[n2] - weight;
                }
                j = Math.min(n.y + 1, FastGridLayouter.this.h);
                while (j <= Math.min(n.y + d, FastGridLayouter.this.h)) {
                    int[] nArray = this.boundMatrix[i];
                    int n3 = j++;
                    nArray[n3] = nArray[n3] + weight;
                }
            }
        }

        private void setDistanceBoundary(Node n, int weight) {
            for (int i = 0; i < FastGridLayouter.this.w; ++i) {
                int val = (Math.abs(i - n.x) + n.y) * weight;
                int[] nArray = this.boundMatrix[i];
                nArray[0] = nArray[0] + val;
                int j = 1;
                while (j <= n.y) {
                    int[] nArray2 = this.boundMatrix[i];
                    int n2 = j++;
                    nArray2[n2] = nArray2[n2] - weight;
                }
                j = n.y + 1;
                while (j < FastGridLayouter.this.h) {
                    int[] nArray3 = this.boundMatrix[i];
                    int n3 = j++;
                    nArray3[n3] = nArray3[n3] + weight;
                }
            }
        }

        private void setNodeNode(Node n1, Graph graph, int weight) {
            for (Node n2 : graph.nodeList) {
                this.setNodeNode(n1, n2, weight);
            }
        }

        private void setNodeNode(Node n1, Node n2, int weight) {
            if (n1.equals(n2)) {
                return;
            }
            String compartment1 = n1.getAttribute("compartmentName");
            compartment1 = compartment1 != null ? compartment1.substring(compartment1.lastIndexOf(".") + 1) : "";
            String compartment2 = n1.getAttribute("compartmentName");
            String string = compartment2 = compartment2 != null ? compartment2.substring(compartment2.lastIndexOf(".") + 1) : "";
            if (n2.name.equals(compartment1) || n1.name.equals(compartment2)) {
                return;
            }
            int width = (n1.width + n2.width) / 2 + 10;
            int height = (n1.height + n2.height) / 2 + 10;
            double x = (n2.x + 1) * FastGridLayouter.this.gridX;
            double y = (n2.y + 1) * FastGridLayouter.this.gridY;
            int iLeft = (int)Math.ceil((x - (double)width) / (double)FastGridLayouter.this.gridX - 1.0);
            int iRight = (int)Math.floor((x + (double)width) / (double)FastGridLayouter.this.gridX - 1.0);
            int jUp = (int)Math.ceil((y - (double)height) / (double)FastGridLayouter.this.gridY - 1.0);
            int jDown = (int)Math.ceil((y + (double)height) / (double)FastGridLayouter.this.gridY - 1.0);
            if (jDown == (int)Math.floor((y + (double)height) / (double)FastGridLayouter.this.gridY - 1.0)) {
                ++jDown;
            }
            iLeft = Math.max(0, iLeft);
            iRight = Math.min(FastGridLayouter.this.w - 1, iRight);
            jUp = Math.max(0, jUp);
            jDown = Math.min(FastGridLayouter.this.h, jDown);
            for (int i = iLeft; i <= iRight; ++i) {
                int[] nArray = this.boundMatrix[i];
                int n = jUp;
                nArray[n] = nArray[n] + weight;
                int[] nArray2 = this.boundMatrix[i];
                int n3 = jDown;
                nArray2[n3] = nArray2[n3] - weight;
            }
        }

        private void setEdgeEdge(Set<Node> connectedNodes, Set<Edge> edges, Integer weight) {
            for (Node node : connectedNodes) {
                this.setEdgeEdge(node, edges, weight);
            }
        }

        private void setEdgeEdge(Node connectedNode, Set<Edge> edges, Integer weight) {
            Point p = FastGridLayouter.this.getCenter(connectedNode);
            for (Edge edge : edges) {
                Point p1 = FastGridLayouter.this.getCenter(edge.from);
                Point p2 = FastGridLayouter.this.getCenter(edge.to);
                this.setCrossingZoneBoundary(p, p1, p2, weight);
            }
        }

        private void setEdgeNode(Set<Node> connectedNodes, Set<Node> otherNodes, int weight) {
            for (Node node : connectedNodes) {
                Point p = FastGridLayouter.this.getCenter(node);
                for (Node otherNode : otherNodes) {
                    this.setEdgeNode(p, otherNode, weight);
                }
            }
        }

        private void setEdgeNode(Set<Node> connectedNodes, Node otherNode, int weight) {
            for (Node node : connectedNodes) {
                this.setEdgeNode(FastGridLayouter.this.getCenter(node), otherNode, weight);
            }
        }

        private void setEdgeNode(Node connectedNode, Set<Node> otherNode, int weight) {
            Point p = FastGridLayouter.this.getCenter(connectedNode);
            for (Node node : otherNode) {
                this.setEdgeNode(p, node, weight);
            }
        }

        private void setEdgeNode(Point p, Node targetNode, int weight) {
            Point p2;
            Point p1;
            int x = (targetNode.x + 1) * FastGridLayouter.this.gridX;
            int y = (targetNode.y + 1) * FastGridLayouter.this.gridY;
            int px = p.x;
            int py = p.y;
            int height = targetNode.height / 2;
            int width = targetNode.width / 2;
            if (x - width < px && px < x + width && y - height < py && py < y + height) {
                for (int i = 0; i < FastGridLayouter.this.w; ++i) {
                    int[] nArray = this.boundMatrix[i];
                    nArray[0] = nArray[0] + weight;
                }
                return;
            }
            if (px == x) {
                p1 = new Point(x - width, y + (height *= (int)Math.signum(py - y)));
                p2 = new Point(x + width, y + height);
            } else if (py == y) {
                p1 = new Point(x + (width *= (int)Math.signum(px - x)), y - height);
                p2 = new Point(x + width, y + height);
            } else if ((px - x) * (py - y) > 0) {
                p1 = new Point(x - width, y + height);
                p2 = new Point(x + width, y - height);
            } else {
                p1 = new Point(x - width, y - height);
                p2 = new Point(x + width, y + height);
            }
            this.setCrossingZoneBoundary(p, p1, p2, weight);
        }

        public void setCrossingZoneBoundary(Point p, Point p1, Point p2, Integer weight) {
            if (p.equals(p1) || p.equals(p2)) {
                return;
            }
            boolean edgeIsLower = this.getYByX(p1, p2, p.x, true) >= (double)p.y;
            boolean wideAngle = (p1.x - p.x) * (p2.x - p.x) <= 0;
            boolean isUpOriented = wideAngle && !edgeIsLower;
            boolean isDownOriented = wideAngle && edgeIsLower;
            for (int i = 0; i < FastGridLayouter.this.w; ++i) {
                int x = (i + 1) * FastGridLayouter.this.gridX;
                TreeSet<Double> vals = new TreeSet<Double>();
                double y1 = this.getYByX(p, p1, x, false);
                double y2 = this.getYByX(p, p2, x, false);
                double y3 = this.getYByX(p1, p2, x, true);
                int count = 0;
                if (y1 != -1.0) {
                    vals.add(y1);
                    ++count;
                }
                if (y2 != -1.0) {
                    vals.add(y2);
                    ++count;
                }
                if (y3 != -1.0) {
                    vals.add(y3);
                    ++count;
                }
                if (count == 0) continue;
                double yMax = (Double)vals.last() / (double)FastGridLayouter.this.gridY - 1.0;
                int jMax = (int)Math.ceil(yMax);
                if (isDownOriented || !isUpOriented && count == 1 && jMax > 0) {
                    if (Math.floor(yMax) == Math.ceil(yMax)) {
                        ++jMax;
                    }
                    jMax = Math.min(Math.max(jMax, 0), FastGridLayouter.this.h);
                    int[] nArray = this.boundMatrix[i];
                    int n = jMax;
                    nArray[n] = nArray[n] + weight;
                    continue;
                }
                if (isUpOriented && jMax > 0) {
                    int[] nArray = this.boundMatrix[i];
                    nArray[0] = nArray[0] + weight;
                    jMax = Math.min(jMax, FastGridLayouter.this.h);
                    int[] nArray2 = this.boundMatrix[i];
                    int n = jMax;
                    nArray2[n] = nArray2[n] - weight;
                    continue;
                }
                double yMin = (Double)vals.first() / (double)FastGridLayouter.this.gridY - 1.0;
                int jMin = (int)Math.ceil(yMin);
                if ((int)Math.floor(yMin) == jMin && jMin != jMax && jMin != 0) {
                    ++jMin;
                }
                jMax = Math.min(Math.max(jMax, 0), FastGridLayouter.this.h);
                jMin = Math.min(Math.max(jMin, 0), FastGridLayouter.this.h);
                int[] nArray = this.boundMatrix[i];
                int n = jMin;
                nArray[n] = nArray[n] + weight;
                int[] nArray3 = this.boundMatrix[i];
                int n2 = jMax;
                nArray3[n2] = nArray3[n2] - weight;
            }
        }

        private double getYByX(Point p1, Point p2, int x, boolean inner) {
            if (p1.x == p2.x && p1.x != x) {
                return -1.0;
            }
            if (x == p2.x) {
                return p2.y;
            }
            double t = x - p1.x;
            if (inner != (t /= (double)(p2.x - p1.x)) < 1.0 || t < 0.0) {
                return -1.0;
            }
            return (double)p1.y + t * (double)(p2.y - p1.y);
        }

        private void setNodeEdge(Node n, Set<Edge> edges, int weight) {
            for (Edge edge : edges) {
                Point p1 = FastGridLayouter.this.getCenter(edge.from);
                Point p2 = FastGridLayouter.this.getCenter(edge.to);
                this.setCrossingZoneBoundary(n.width, n.height, p1, p2, weight);
            }
        }

        public void setCrossingZoneBoundary(int width, int height, Point p1, Point p2, int weight) {
            Point p2Down;
            Point p1Down;
            Point p2Up;
            Point p1Up;
            int x1 = p1.x;
            int y1 = p1.y;
            int x2 = p2.x;
            int y2 = p2.y;
            height /= 2;
            int iLeft = (int)Math.ceil(((double)Math.min(x1, x2) - (double)(width /= 2)) / (double)FastGridLayouter.this.gridX - 1.0);
            int iRight = (int)Math.floor(((double)Math.max(x1, x2) + (double)width) / (double)FastGridLayouter.this.gridX - 1.0);
            iLeft = Math.max(iLeft, 0);
            iRight = Math.min(iRight, FastGridLayouter.this.w - 1);
            if (x1 == x2 || y1 == y2) {
                int jUp = (int)Math.ceil(((double)Math.min(y1, y2) - (double)height) / (double)FastGridLayouter.this.gridY - 1.0);
                int jDown = (int)Math.floor(((double)Math.max(y1, y2) + (double)height) / (double)FastGridLayouter.this.gridY - 1.0);
                jUp = Math.max(jUp, 0);
                jDown = Math.min(jDown, FastGridLayouter.this.h - 1);
                for (int i = iLeft; i <= iRight; ++i) {
                    int[] nArray = this.boundMatrix[i];
                    int n = jUp;
                    nArray[n] = nArray[n] + weight;
                    int[] nArray2 = this.boundMatrix[i];
                    int n2 = jDown + 1;
                    nArray2[n2] = nArray2[n2] - weight;
                }
                return;
            }
            if ((x1 - x2) * (y1 - y2) < 0) {
                p1Up = new Point(x1 - width, y1 - height);
                p2Up = new Point(x2 - width, y2 - height);
                p1Down = new Point(x1 + width, y1 + height);
                p2Down = new Point(x2 + width, y2 + height);
            } else {
                p1Up = new Point(x1 + width, y1 - height);
                p2Up = new Point(x2 + width, y2 - height);
                p1Down = new Point(x1 - width, y1 + height);
                p2Down = new Point(x2 - width, y2 + height);
            }
            for (int i = iLeft; i <= iRight; ++i) {
                int x = (i + 1) * FastGridLayouter.this.gridX;
                double yUp = this.getYByX2(p1Up, p2Up, x);
                double yDown = this.getYByX2(p1Down, p2Down, x);
                int jUp = (int)Math.ceil(yUp / (double)FastGridLayouter.this.gridY - 1.0);
                int jDown = (int)Math.ceil(yDown / (double)FastGridLayouter.this.gridY - 1.0);
                if (yUp == -1.0) {
                    jUp = (int)Math.ceil((double)Math.min(y1, y2) / (double)FastGridLayouter.this.gridY - 1.0);
                }
                if (yDown == -1.0) {
                    jDown = (int)Math.ceil((double)Math.max(y1, y2) / (double)FastGridLayouter.this.gridY);
                }
                if (jUp == (int)(yUp / (double)FastGridLayouter.this.gridY - 1.0)) {
                    ++jUp;
                }
                jUp = Math.min(Math.max(jUp, 0), FastGridLayouter.this.h);
                jDown = Math.min(jDown, FastGridLayouter.this.h);
                int[] nArray = this.boundMatrix[i];
                int n = jUp;
                nArray[n] = nArray[n] + weight;
                int[] nArray3 = this.boundMatrix[i];
                int n3 = jDown;
                nArray3[n3] = nArray3[n3] - weight;
            }
        }

        private double getYByX2(Point p1, Point p2, int x) {
            if (p2.x == p1.x) {
                return Math.min(p1.y, p2.y);
            }
            double t = x - p1.x;
            if ((t /= (double)(p2.x - p1.x)) < 0.0 || t > 1.0) {
                return -1.0;
            }
            return (double)p1.y + t * (double)(p2.y - p1.y);
        }

        private void resetPenaltyMatrix() {
            for (int i = 0; i < FastGridLayouter.this.w; ++i) {
                for (int j = 0; j < FastGridLayouter.this.h + 1; ++j) {
                    this.boundMatrix[i][j] = 0;
                }
            }
        }

        private void setPenaltyMatrix() {
            for (int i = 0; i < FastGridLayouter.this.w; ++i) {
                int sum = 0;
                for (int j = 0; j < FastGridLayouter.this.h; ++j) {
                    this.costMatrix[i][j] = sum += this.boundMatrix[i][j];
                }
            }
        }
    }
}

