/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.OrthogonalPathLayouter;

public class Face {
    List<Point> points = new ArrayList<Point>();
    protected HashMap<Point, Point> startPoints = new HashMap();
    protected List<Point> occupied = new ArrayList<Point>();
    protected Edge edge;
    private boolean oneEdgeToPoint = true;

    int size() {
        return this.points.size();
    }

    public Face(Graph graph, Node node, Edge edge, int gridX, int gridY, boolean oneEdgeToPoint, OrthogonalPathLayouter.Orientation orientation) {
        this.edge = edge;
        this.oneEdgeToPoint = oneEdgeToPoint;
        boolean edgeInput = edge.getFrom().equals(node);
        for (Edge e : graph.getEdges(node)) {
            if (e.getPath() == null || !oneEdgeToPoint) continue;
            if (e.from == node) {
                this.occupied.add(new Point(e.getPath().xpoints[0], e.getPath().ypoints[0]));
                continue;
            }
            this.occupied.add(new Point(e.getPath().xpoints[e.getPath().npoints - 1], e.getPath().ypoints[e.getPath().npoints - 1]));
        }
        if (orientation == OrthogonalPathLayouter.Orientation.NONE || edgeInput && orientation == OrthogonalPathLayouter.Orientation.BOTTOM || !edgeInput && orientation == OrthogonalPathLayouter.Orientation.TOP) {
            int x = (node.x + node.width / 2) / gridX * gridX;
            int y = node.y;
            this.checkPoint(node, new Point(x, y), false, gridX);
        }
        if (orientation == OrthogonalPathLayouter.Orientation.NONE || edgeInput && orientation == OrthogonalPathLayouter.Orientation.RIGHT || !edgeInput && orientation == OrthogonalPathLayouter.Orientation.LEFT) {
            int x = node.x + node.width;
            int y = (node.y + node.height / 2) / gridY * gridY;
            this.checkPoint(node, new Point(x, y), true, gridY);
        }
        if (orientation == OrthogonalPathLayouter.Orientation.NONE || edgeInput && orientation == OrthogonalPathLayouter.Orientation.BOTTOM || !edgeInput && orientation == OrthogonalPathLayouter.Orientation.TOP) {
            int x = (node.x + node.width / 2) / gridX * gridX;
            int y = node.y + node.height;
            this.checkPoint(node, new Point(x, y), false, gridX);
        }
        if (orientation == OrthogonalPathLayouter.Orientation.NONE || edgeInput && orientation == OrthogonalPathLayouter.Orientation.LEFT || !edgeInput && orientation == OrthogonalPathLayouter.Orientation.RIGHT) {
            int x = node.x;
            int y = (node.y + node.height / 2) / gridY * gridY;
            this.checkPoint(node, new Point(x, y), true, gridY);
        }
    }

    protected void checkPoint(Node node, Point ip, boolean vertical, int step) {
        Point p = node.findPort(ip.x, ip.y, this.edge);
        if (!this.isOccupied(p, Math.abs(step))) {
            this.addPoint(node, p, vertical, step);
            return;
        }
        int from = 0;
        int to = 0;
        int center = 0;
        if (vertical) {
            from = node.y;
            to = node.y + node.height;
            center = p.y;
        } else {
            from = node.x;
            to = node.x + node.width;
            center = p.x;
        }
        this.checkInterval(node, p, center, from, vertical, -step);
        this.checkInterval(node, p, center, to, vertical, step);
    }

    protected void checkInterval(Node node, Point p, int from, int to, boolean vertical, int step) {
        p = new Point(p.x, p.y);
        int k = (to - from) / step;
        if (k < 0) {
            k = -k;
        }
        for (int i = 0; i < k; ++i) {
            if (vertical) {
                p.y += step;
            } else {
                p.x += step;
            }
            Point pp = node.findPort(p.x, p.y, this.edge);
            if (this.isOccupied(pp, Math.abs(step))) continue;
            this.addPoint(node, pp, vertical, step);
            return;
        }
    }

    protected void addPoint(Node node, Point p, boolean vertical, int grid) {
        grid = Math.abs(grid);
        Point dp = new Point(p.x, p.y);
        if (vertical) {
            dp.x = dp.x / grid * grid;
            dp.x = dp.x <= node.x ? (dp.x -= 2 * grid) : (dp.x += 2 * grid);
        } else {
            dp.y = dp.y / grid * grid;
            dp.y = dp.y <= node.y ? (dp.y -= 2 * grid) : (dp.y += 2 * grid);
        }
        this.points.add(dp);
        this.startPoints.put(dp, p);
        this.occupied.add(p);
    }

    protected boolean isOccupied(Point point, int grid) {
        if (this.oneEdgeToPoint) {
            return false;
        }
        for (Point ocPoint : this.occupied) {
            if (Math.abs(point.x - ocPoint.x) >= grid / 2 || Math.abs(point.y - ocPoint.y) >= grid / 2) continue;
            return true;
        }
        return false;
    }
}

