/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.Path;

public class Edge {
    protected Node from;
    protected Node to;
    protected Path path;
    protected boolean reversed = false;
    Object data;
    public Object applicationData;
    protected HashMap<String, String> attributes;
    public boolean master = true;
    public List<Edge> slaves;
    public boolean fixed;

    public Edge(Node from, Node to) {
        this.from = from;
        this.to = to;
        this.path = new Path();
        this.path.addPoint(from.x + from.width / 2, from.y + from.height / 2);
        this.path.addPoint(to.x + to.width / 2, to.y + to.height / 2);
    }

    public void createPath(int x1, int y1, int x2, int y2) {
        this.path = new Path();
        if (x1 >= this.from.x && x1 <= this.from.x + this.from.width && y1 >= this.from.y && y1 <= this.from.y + this.from.height) {
            this.path.addPoint(x1, y1);
            this.path.addPoint(x2, y2);
        } else {
            this.path.addPoint(x2, y2);
            this.path.addPoint(x1, y1);
        }
    }

    protected void reverseDirection() {
        Node t = this.from;
        this.from = this.to;
        this.to = t;
        boolean bl = this.reversed = !this.reversed;
        if (this.path != null) {
            Path reversedPath = new Path();
            for (int i = this.path.npoints - 1; i >= 0; --i) {
                reversedPath.addPoint(this.path.xpoints[i], this.path.ypoints[i], this.path.pointTypes[i]);
            }
            this.path = reversedPath;
        }
    }

    public String toString() {
        return this.from.getName() + "->" + this.to.getName();
    }

    public Node getFrom() {
        return this.from;
    }

    public Node getTo() {
        return this.to;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public String getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public void addSlave(Edge slave) {
        if (this.slaves == null) {
            this.slaves = new ArrayList<Edge>();
        }
        this.slaves.add(slave);
    }
}

