/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.PathWeighter;
import ru.biosoft.graph.SelfLoopLayouter;

public class DiagonalPathLayouter
extends AbstractLayouter {
    public int lineDistance = 10;
    public SelfLoopLayouter selfLoopLayouter = new SelfLoopLayouter();

    public void layoutPath(Graph graph, Edge edge, PathWeighter pathWeighter) {
        if (edge.getFrom() == edge.getTo()) {
            this.selfLoopLayouter.layoutPath(graph, edge, pathWeighter);
            return;
        }
        if (!edge.master) {
            edge = graph.getEdge(edge.from, edge.to);
        }
        if (edge.slaves == null || edge.slaves.size() == 0) {
            this.makePath(edge, 0, 0);
            return;
        }
        int n = 1 + edge.slaves.size();
        int dx = edge.getFrom().x + edge.getFrom().width / 2 - edge.getTo().x - edge.getTo().width / 2;
        int dy = edge.getFrom().y + edge.getFrom().height / 2 - edge.getTo().y - edge.getTo().height / 2;
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        if (len == 0) {
            len = 1;
        }
        int sx = 0;
        if (dy != 0) {
            sx = dy / Math.abs(dy) * Math.min(Math.abs(this.lineDistance * dy / len), Math.min(edge.getFrom().width, edge.getTo().width) / n);
        }
        int sy = 0;
        if (dx != 0) {
            sy = -dx / Math.abs(dx) * Math.min(Math.abs(this.lineDistance * dx / len), Math.min(edge.getFrom().height, edge.getTo().height) / n);
        }
        for (int i = 0; i < n; ++i) {
            dx = (int)(((double)i - (double)n / 2.0) * (double)sx);
            dy = (int)(((double)i - (double)n / 2.0) * (double)sy);
            if (n / 2 * 2 == n) {
                dx += sx / 2;
                dy += sy / 2;
            }
            if (i == 0) {
                this.makePath(edge, dx, dy);
                continue;
            }
            this.makePath(edge.slaves.get(i - 1), dx, dy);
        }
    }

    protected void makePath(Edge edge, int dx, int dy) {
        edge.path = new Path();
        int x1 = dx + edge.getFrom().x + edge.getFrom().width / 2;
        int x2 = dx + edge.getTo().x + edge.getTo().width / 2;
        int y1 = dy + edge.getFrom().y + edge.getFrom().height / 2;
        int y2 = dy + edge.getTo().y + edge.getTo().height / 2;
        Point from = this.intersection(x1, y1, x2, y2, edge.getFrom().getBounds());
        Point to = this.intersection(x2, y2, x1, y1, edge.getTo().getBounds());
        Point portFrom = edge.getFrom().findPort(from.x, from.y, edge);
        Point portTo = edge.getTo().findPort(to.x, to.y, edge);
        edge.path.addPoint(portFrom.x, portFrom.y);
        edge.path.addPoint(portTo.x, portTo.y);
    }

    protected Point intersection(int x1, int y1, int x2, int y2, Rectangle rect) {
        int dy;
        int ix = 0;
        int iy = 0;
        int dx = x2 - x1;
        if (dx == 0) {
            dx = 1;
        }
        if ((dy = y2 - y1) == 0) {
            dy = 1;
        }
        if (x2 >= rect.x && x2 <= rect.x + rect.width) {
            iy = y2 < rect.y ? rect.y : rect.y + rect.height;
            ix = x1 + (x2 - x1) * (iy - y1) / dy;
        } else {
            ix = x2 < rect.x ? rect.x : rect.x + rect.width;
            iy = y1 + (y2 - y1) * (ix - x1) / dx;
            if (iy < rect.y) {
                iy = rect.y;
                ix = x1 + (x2 - x1) * (iy - y1) / dy;
            } else if (iy > rect.y + rect.height) {
                iy = rect.y + rect.height;
                ix = y1 + (y2 - y1) * (iy - y1) / dy;
            }
            if (iy == rect.y || iy == rect.y + rect.height) {
                ix = x1 + (x2 - x1) * (iy - y1) / dy;
            }
        }
        return new Point(ix, iy);
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl jobControl) {
        for (Edge edge : graph.edgeList) {
            if (edge.fixed) continue;
            this.layoutPath(graph, edge, jobControl);
        }
    }

    @Override
    void layoutNodes(Graph graph, LayoutJobControl jobControl) {
    }

    @Override
    public int estimate(Graph graph, int what) {
        return 0;
    }

    @Override
    public LayouterInfo getInfo() {
        return new LayouterInfoSupport(true, false, false, false, false, false);
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl jobControl) {
        this.layoutPath(graph, edge, this.pathWeighter);
    }
}

