/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import ru.biosoft.graph.AbstractLayouter;
import ru.biosoft.graph.DiagonalPathLayouter;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.ForceDirectedLayouter;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.GridPoint;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.LayouterInfo;
import ru.biosoft.graph.LayouterInfoSupport;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graph.Util;

public class CompartmentCrossCostGridLayouter
extends AbstractLayouter {
    protected static final char PATH_DELIMITER = '.';
    protected int gridX = 70;
    protected int gridY = 70;
    protected static int nodeWidth = 30;
    protected static int nodeHeight = 30;
    protected int gridSize = 3;
    protected int gridWidth = 3;
    protected int gridHeight = 3;
    protected boolean setGridAutomatically = true;
    protected boolean setCompSizesAutomatically = true;
    protected Node[][] gridLayout;
    protected GridPoint[][] grid;
    protected double[][] deltaMatrix;
    protected Vector<Node> nodeVector = new Vector();
    protected int edgeCrossPenalty = 50;
    protected int nodeCrossPenalty = 100;
    protected int nodeOverlapPenalty = 1000;
    protected int connectedNodesWeight = 5;
    protected List<Edge> edgeList = new ArrayList<Edge>();
    protected Map<String, Node> nodeMap = new HashMap<String, Node>();
    protected Map<String, Integer> nodeIndexMap = new HashMap<String, Integer>();
    protected int[][] weightMap;
    protected Map<Node, List<Edge>> edgeMap = new HashMap<Node, List<Edge>>();
    protected Map<String, List<GridPoint>> compartmentPointMap = new HashMap<String, List<GridPoint>>();
    Map<String, List<Node>> compartmentMap = new HashMap<String, List<Node>>();
    protected Graph withoutCompartmentGraph = new Graph();
    double tMax = 0.11;
    double tMin = 0.1;
    int ne = 4;
    double rc = 0.2;
    double probabilityThreshold = 0.3;
    int saturationDist = 4;
    protected static int shiftMultiplyCoeff = 8;
    protected static int nodeShift = 2;
    protected static int nodeOffset = 4;
    private final Random rnd = new Random(0L);
    protected static int compartmentAnnealingSteps = 3;
    protected ForceDirectedLayouter forceDirectedLayouter = new ForceDirectedLayouter();

    public CompartmentCrossCostGridLayouter() {
        this.pathLayouterWrapper = new PathLayouterWrapper(new DiagonalPathLayouter());
    }

    protected double makeTmax(Graph graph) {
        double maxCost = -9999.0;
        double minCost = 9.9999999E7;
        double cost = 0.0;
        for (int i = 0; i < 10; ++i) {
            this.layoutPermutation();
            cost = this.layoutCostFunction();
            if (cost > maxCost) {
                maxCost = cost;
            }
            if (!(cost < minCost)) continue;
            minCost = cost;
        }
        if (maxCost == minCost) {
            return 0.11;
        }
        return (maxCost - minCost) / 2.0;
    }

    protected int checkEdgeCross(Edge e1, Edge e2) {
        if (e1.from == e2.from || e1.from == e2.to || e1.to == e2.from || e1.to == e2.to) {
            return 0;
        }
        int e1x1 = e1.from.x * this.gridX;
        int e1y1 = e1.from.y * this.gridY;
        int e1x2 = e1.to.x * this.gridX;
        int e1y2 = e1.to.y * this.gridY;
        int e2x1 = e2.from.x * this.gridX;
        int e2y1 = e2.from.y * this.gridY;
        int e2x2 = e2.to.x * this.gridX;
        int e2y2 = e2.to.y * this.gridY;
        return this.segmentIntersect(e1x1, e1y1, e1x2, e1y2, e2x1, e2y1, e2x2, e2y2, this.edgeCrossPenalty);
    }

    protected int distance(int x1, int y1, int x2, int y2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2);
    }

    protected int checkNodesOverlap(Node n1, Node n2) {
        Rectangle rect2;
        Rectangle rect1;
        if (this.checkForAttachment(n1, n2)) {
            return 0;
        }
        int offset1 = 0;
        int shift1 = 0;
        int offset2 = 0;
        int shift2 = 0;
        int n1X = n1.x * this.gridX;
        int n1Y = n1.y * this.gridY;
        int n1Width = n1.width;
        int n1Height = n1.height;
        int n2X = n2.x * this.gridX;
        int n2Y = n2.y * this.gridY;
        int n2Width = n2.width;
        int n2Height = n2.height;
        if (!Util.isCompartment(n1)) {
            n1X = (int)((double)n1X - (double)n1Width / 2.0);
            n1Y = (int)((double)n1Y - (double)n1Height / 2.0);
            offset1 = nodeOffset;
            shift1 = nodeShift;
        }
        if (!Util.isCompartment(n2)) {
            n2X = (int)((double)n2X - (double)n2Width / 2.0);
            n2Y = (int)((double)n2Y - (double)n2Height / 2.0);
            offset2 = nodeOffset;
            shift2 = nodeShift;
        }
        if ((rect1 = new Rectangle(n1X - shift1, n1Y - shift1, n1Width + offset1, n1Height + offset1)).intersects(rect2 = new Rectangle(n2X - shift2, n2Y - shift2, n2Width + offset2, n2Height + offset2))) {
            return this.nodeOverlapPenalty;
        }
        return 0;
    }

    protected int checkNodeCross(Edge e, Node n) {
        if (e.from == n || e.to == n) {
            return 0;
        }
        if (Util.isCompartment(n) && (this.checkForAttachment(n, e.from) || this.checkForAttachment(n, e.to))) {
            return 0;
        }
        int ex1 = e.from.x * this.gridX;
        int ey1 = e.from.y * this.gridY;
        int ex2 = e.to.x * this.gridX;
        int ey2 = e.to.y * this.gridY;
        int nx1 = n.x * this.gridX - (int)((double)n.width / 2.0);
        int ny1 = n.y * this.gridY - (int)((double)n.height / 2.0);
        int nx2 = n.x * this.gridX - (int)((double)n.width / 2.0);
        int ny2 = n.y * this.gridY - (int)((double)n.height / 2.0);
        if ((ex1 - ex2) * (ey1 - ey2) >= 0) {
            return this.segmentIntersect(nx1, ny1 += n.height, nx2 += n.width, ny2, ex1, ey1, ex2, ey2, this.nodeCrossPenalty);
        }
        return this.segmentIntersect(nx1, ny1, nx2 += n.width, ny2 += n.height, ex1, ey1, ex2, ey2, this.nodeCrossPenalty);
    }

    protected void defineCompartments(Graph graph, LayoutJobControl lJC) {
        this.compartmentMap = new HashMap<String, List<Node>>();
        HashMap<String, Integer> compartmentNodeNumberMap = new HashMap<String, Integer>();
        HashMap<String, Integer[]> compartmentNodeSizeMap = new HashMap<String, Integer[]>();
        HashMap<String, List<Node>> compartmentNodeMap = new HashMap<String, List<Node>>();
        int maxAttachment = 0;
        for (Node n : graph.nodeList) {
            Integer[] dim;
            n.fixed = false;
            ArrayList<Node> tempList = new ArrayList<Node>();
            if (Util.isCompartment(n)) {
                String compName;
                if (n.getAttribute("compartmentName") == null || n.getAttribute("compartmentName").equals("root")) {
                    if (!this.compartmentMap.containsKey("0")) {
                        tempList.add(n);
                        this.compartmentMap.put("0", tempList);
                    } else {
                        this.compartmentMap.get("0").add(n);
                    }
                    n.setAttribute("compartmentName", "root");
                    continue;
                }
                int delimiterCount = n.getAttribute("compartmentName").length() - n.getAttribute("compartmentName").replaceAll("\\.", "").length();
                if (delimiterCount > maxAttachment) {
                    maxAttachment = delimiterCount;
                }
                if (!this.compartmentMap.containsKey("" + delimiterCount)) {
                    tempList.add(n);
                    this.compartmentMap.put("" + delimiterCount, tempList);
                } else {
                    this.compartmentMap.get("" + delimiterCount).add(n);
                }
                if ((compName = n.getAttribute("compartmentName")).startsWith("root")) continue;
                n.setAttribute("compartmentName", "root." + n.getAttribute("compartmentName"));
                continue;
            }
            String compName = "root";
            if (n.getAttribute("compartmentName") == null) {
                n.setAttribute("compartmentName", compName);
            } else {
                compName = !n.getAttribute("compartmentName").startsWith("root") ? compName + "." + n.getAttribute("compartmentName") : n.getAttribute("compartmentName");
            }
            n.setAttribute("compartmentName", compName);
            if (!compartmentNodeNumberMap.containsKey(compName)) {
                compartmentNodeNumberMap.put(compName, 1);
                Integer[] dim2 = new Integer[]{n.width, n.height};
                compartmentNodeSizeMap.put(compName, dim2);
                tempList.add(n);
                compartmentNodeMap.put(compName, tempList);
                continue;
            }
            int tempInt = compartmentNodeNumberMap.get(compName) + 1;
            compartmentNodeNumberMap.put(compName, tempInt);
            Integer[] integerArray = dim = compartmentNodeSizeMap.get(compName);
            Integer.valueOf(integerArray[0] + n.width);
            integerArray = dim;
            Integer.valueOf(integerArray[1] + n.height);
            compartmentNodeSizeMap.put(compName, dim);
            compartmentNodeMap.get(compName).add(n);
        }
        if (this.setCompSizesAutomatically) {
            this.defineCompartmentsSizes(maxAttachment, compartmentNodeNumberMap, compartmentNodeSizeMap);
        }
        this.setGrid(compartmentNodeNumberMap, compartmentNodeSizeMap, graph);
        this.setCompartments();
        this.layoutCompartments(compartmentNodeMap, lJC);
    }

    protected void defineCompartmentsSizes(int maxAttachment, HashMap<String, Integer> compartmentNodeNumberMap, HashMap<String, Integer[]> compartmentNodeSizeMap) {
        List<Node> tempList;
        int counter;
        for (counter = maxAttachment; counter > -1; --counter) {
            tempList = this.compartmentMap.get("" + counter);
            for (Node n : tempList) {
                n.width = 0;
                n.height = 0;
            }
        }
        for (counter = maxAttachment; counter > -1; --counter) {
            tempList = this.compartmentMap.get("" + counter);
            for (Node n : tempList) {
                String compName = this.getFullName(n.name);
                boolean innerCompartment = false;
                if (n.width == 0) {
                    innerCompartment = true;
                }
                int newWidthDimentionInc = 0;
                int newHeightDimentionInc = 0;
                int upperNodeWidth = 0;
                int upperNodeHeight = 0;
                if (!innerCompartment) continue;
                int innerNodeNumber = 0;
                do {
                    n = this.nodeMap.get(this.getNodeName(compName));
                    int nodeNumber = 1;
                    int avWidth = 0;
                    int avHeight = 0;
                    if (compartmentNodeNumberMap.containsKey(compName)) {
                        nodeNumber = compartmentNodeNumberMap.get(compName);
                        avWidth = compartmentNodeSizeMap.get(compName)[0];
                        avHeight = compartmentNodeSizeMap.get(compName)[1];
                    }
                    if (innerCompartment) {
                        n.width = 2 * (int)Math.sqrt(nodeNumber) * (int)((double)(1 + avWidth / (this.gridX * nodeNumber)) + 2.0 * (double)(nodeOffset + nodeShift) / (double)this.gridX) + (int)((double)avWidth / (double)(this.gridX * nodeNumber));
                        n.height = 2 * (int)Math.sqrt(nodeNumber) * (int)((double)(1 + avHeight / (this.gridY * nodeNumber)) + 2.0 * (double)(nodeOffset + nodeShift) / (double)this.gridY) + (int)((double)avHeight / (double)(this.gridY * nodeNumber));
                        if (nodeNumber < 4) {
                            // empty if block
                        }
                        newWidthDimentionInc = ++n.width;
                        newHeightDimentionInc = ++n.height;
                        upperNodeWidth = newWidthDimentionInc;
                        upperNodeHeight = newHeightDimentionInc;
                        innerNodeNumber = nodeNumber;
                    } else {
                        if (n.width == 0 && n.height == 0) {
                            n.width += (newWidthDimentionInc += (int)(-2.0 * Math.sqrt(innerNodeNumber) + Math.sqrt((double)(4 * innerNodeNumber) + 4.0 * Math.sqrt(innerNodeNumber) + 1.0 + (double)(4 * nodeNumber))) * (int)((double)(1 + avWidth / (this.gridX * nodeNumber)) + (double)(nodeOffset + nodeShift) / (double)this.gridX) + (int)((double)avWidth / (double)(this.gridX * nodeNumber)));
                            n.height += (newHeightDimentionInc += (int)(-2.0 * Math.sqrt(innerNodeNumber) + Math.sqrt((double)(4 * innerNodeNumber) + 4.0 * Math.sqrt(innerNodeNumber) + 1.0 + (double)(4 * nodeNumber))) * (int)((double)(1 + avHeight / (this.gridY * nodeNumber)) + (double)(nodeOffset + nodeShift) / (double)this.gridY) + (int)((double)avHeight / (double)(this.gridY * nodeNumber)));
                        } else if (upperNodeWidth >= n.width || upperNodeHeight >= n.height) {
                            n.width += newWidthDimentionInc;
                            n.height += newHeightDimentionInc;
                        } else if (newWidthDimentionInc >= newHeightDimentionInc) {
                            n.width += newWidthDimentionInc;
                        } else {
                            n.height += newHeightDimentionInc;
                        }
                        upperNodeWidth = n.width;
                        upperNodeHeight = n.height;
                        innerNodeNumber += nodeNumber;
                    }
                    innerCompartment = false;
                } while (!(compName = n.getAttribute("compartmentName")).equalsIgnoreCase("root"));
            }
        }
    }

    protected String getNodeName(String compName) {
        if (compName.indexOf(46) != -1) {
            return compName.replace("root.", "");
        }
        return compName;
    }

    protected String getFullName(String nodeName) {
        return "root." + nodeName;
    }

    protected void layoutCompartments(HashMap<String, List<Node>> compartmentNodeMap, LayoutJobControl lJC) {
        this.makeWeightMatrix(compartmentNodeMap);
        for (int i = 0; i < this.compartmentMap.size(); ++i) {
            ArrayList<Node> compList = new ArrayList<Node>();
            for (int j = i; j >= 0; --j) {
                compList.addAll((Collection<Node>)this.compartmentMap.get("" + j));
            }
            Graph g = CompartmentCrossCostGridLayouter.createGraph(compList, null);
            if (i != 0) {
                this.nonBaseLevelFirstLayout(g);
            } else {
                this.baseLevelFirstLayout(g);
            }
            this.doCompLayout(g, lJC);
            this.setNodesFixed(this.compartmentMap.get("" + i), true);
            this.formatGrid(i);
            this.renewCompartmentPointMap();
        }
    }

    protected void makeWeightMatrix(HashMap<String, List<Node>> compartmentNodeMap) {
        int nodeCount = this.nodeVector.size();
        this.weightMap = new int[nodeCount][nodeCount];
        HashMap totalNodeMap = new HashMap();
        ArrayList compTotalNodeList = new ArrayList();
        ArrayList tempTotalNodeList = new ArrayList();
        for (int i = this.compartmentMap.size() - 1; i >= 0; --i) {
            List<Node> nodeList = this.compartmentMap.get("" + i);
            for (Node n : nodeList) {
                String compName = this.getFullName(n.name);
                if (totalNodeMap.containsKey(compName)) continue;
                do {
                    n = this.nodeMap.get(this.getNodeName(compName));
                    if (totalNodeMap.containsKey(compName)) {
                        compTotalNodeList.addAll((Collection)totalNodeMap.get(compName));
                        tempTotalNodeList.addAll(compTotalNodeList);
                        totalNodeMap.put(compName, tempTotalNodeList);
                        tempTotalNodeList = new ArrayList();
                        compName = "";
                        continue;
                    }
                    if (compartmentNodeMap.containsKey(compName)) {
                        compTotalNodeList.addAll(compartmentNodeMap.get(compName));
                    }
                    tempTotalNodeList.addAll(compTotalNodeList);
                    totalNodeMap.put(compName, tempTotalNodeList);
                    tempTotalNodeList = new ArrayList();
                } while (!(compName = n.getAttribute("compartmentName")).equalsIgnoreCase("root"));
                compTotalNodeList = new ArrayList();
            }
        }
        ArrayList compList = new ArrayList();
        ArrayList tempList = new ArrayList();
        for (int j = 0; j < this.compartmentMap.size(); ++j) {
            compList.addAll(this.compartmentMap.get("" + j));
        }
        tempList.addAll(compList);
        for (Node nC : compList) {
            for (Node n : tempList) {
                Integer nCIndex = this.nodeIndexMap.get(nC.name);
                Integer nIndex = this.nodeIndexMap.get(n.name);
                if (this.checkForAttachment(nC, n)) {
                    if (nCIndex == null || nIndex == null) continue;
                    this.weightMap[nCIndex.intValue()][nIndex.intValue()] = 0;
                    continue;
                }
                List compNodeList = (List)totalNodeMap.get(this.getFullName(nC.name));
                List tempNodeList = (List)totalNodeMap.get(this.getFullName(n.name));
                int weight = 1;
                HashSet compEdgeList = new HashSet();
                HashSet tempEdgeList = new HashSet();
                for (Node compartmentN : compNodeList) {
                    if (!this.edgeMap.containsKey(compartmentN)) continue;
                    compEdgeList.addAll(this.edgeMap.get(compartmentN));
                }
                for (Node tempN : tempNodeList) {
                    if (!this.edgeMap.containsKey(tempN)) continue;
                    tempEdgeList.addAll(this.edgeMap.get(tempN));
                }
                for (Edge edge : tempEdgeList) {
                    if (!compEdgeList.contains(edge)) continue;
                    ++weight;
                }
                if (nCIndex == null || nIndex == null) continue;
                this.weightMap[nCIndex.intValue()][nIndex.intValue()] = weight;
            }
        }
    }

    protected boolean checkForAttachment(Node node1, Node node2) {
        String name1 = node1.name;
        String name2 = node2.name;
        if (name1.length() > name2.length()) {
            return name1.startsWith(name2) && name1.charAt(name2.length()) == '.';
        }
        if (name1.length() < name2.length()) {
            return name2.startsWith(name1) && name2.charAt(name1.length()) == '.';
        }
        return false;
    }

    protected void setNodesFixed(List<Node> nodeList, boolean fix) {
        for (Node n : nodeList) {
            n.fixed = fix;
        }
    }

    protected void changeLayout(Graph graph) {
        Node tempNode;
        int i;
        int nodeCount = graph.nodeCount();
        this.nodeVector = new Vector();
        for (i = 0; i < nodeCount; ++i) {
            tempNode = graph.nodeAt(i);
            this.nodeVector.addElement(tempNode);
            this.nodeIndexMap.put(tempNode.getName(), i);
        }
        for (i = 0; i < nodeCount; ++i) {
            tempNode = graph.nodeAt(i);
            if (tempNode.fixed) continue;
            GridPoint position = this.getRandomVacantPoint(tempNode);
            this.gridLayout[position.y][position.x] = tempNode;
            tempNode.x = position.x;
            tempNode.y = position.y;
        }
    }

    protected void baseLevelFirstLayout(Graph graph) {
        List<Node> nodeList = graph.nodeList;
        int nodeCount = graph.nodeCount();
        this.nodeVector = new Vector();
        this.gridLayout = new Node[this.gridHeight][this.gridWidth];
        for (int i = 0; i < nodeCount; ++i) {
            Node tempNode = graph.nodeAt(i);
            this.nodeVector.addElement(tempNode);
            this.nodeIndexMap.put(tempNode.getName(), i);
        }
        ArrayList<Node> arrangedNodeList = new ArrayList<Node>();
        while (nodeList.size() > 0) {
            Node maxNode = nodeList.get(0);
            int squareN1 = maxNode.width * maxNode.height;
            for (Node n2 : nodeList) {
                int squareN2 = n2.width * n2.height;
                if (squareN2 <= squareN1) continue;
                maxNode = n2;
            }
            arrangedNodeList.add(maxNode);
            nodeList.remove(maxNode);
        }
        int xPoint = 0;
        int yPoint = 0;
        for (Node n : arrangedNodeList) {
            if (xPoint == 0 && yPoint == 0) {
                this.gridLayout[yPoint][xPoint] = n;
                n.x = xPoint;
                n.y = yPoint;
                xPoint += (int)((double)n.width + 0.001) / this.gridX;
                yPoint += (int)((double)n.height + 0.001) / this.gridY;
                continue;
            }
            if (xPoint + (int)((double)n.width + 0.001) / this.gridX <= this.gridWidth) {
                this.gridLayout[0][xPoint] = n;
                n.x = xPoint;
                n.y = 0;
                xPoint += (int)((double)n.width + 0.001) / this.gridX;
                continue;
            }
            this.gridLayout[yPoint][0] = n;
            n.x = 0;
            n.y = yPoint;
            yPoint += (int)((double)n.height + 0.001) / this.gridY;
        }
    }

    protected void nonBaseLevelFirstLayout(Graph graph) {
        HashMap compNamesMap = new HashMap();
        ArrayList<String> compNamesList = new ArrayList<String>();
        int nodeCount = graph.nodeCount();
        this.nodeVector = new Vector();
        ArrayList<Node> tempCompList = new ArrayList<Node>();
        for (Node n : graph.nodeList) {
            if (n.fixed) continue;
            String compName = n.getAttribute("compartmentName");
            if (compName == null) {
                compName = "root";
            }
            if (compNamesMap.containsKey(compName)) {
                ((List)compNamesMap.get(compName)).add(n);
                continue;
            }
            tempCompList.add(n);
            compNamesMap.put(compName, tempCompList);
            tempCompList = new ArrayList();
            compNamesList.add(compName);
        }
        for (int i = 0; i < nodeCount; ++i) {
            Node tempNode = graph.nodeAt(i);
            this.nodeVector.addElement(tempNode);
            this.nodeIndexMap.put(tempNode.getName(), i);
        }
        for (String cN : compNamesList) {
            Node cNnode = this.nodeMap.get(this.getNodeName(cN));
            List nodeList = (List)compNamesMap.get(cN);
            ArrayList<Node> arrangedNodeList = new ArrayList<Node>();
            while (nodeList.size() > 0) {
                Node maxNode = (Node)nodeList.get(0);
                int squareN1 = maxNode.width * maxNode.height;
                for (Node n2 : nodeList) {
                    int squareN2 = n2.width * n2.height;
                    if (squareN2 <= squareN1) continue;
                    maxNode = n2;
                }
                arrangedNodeList.add(maxNode);
                nodeList.remove(maxNode);
            }
            int xPoint = cNnode.x + 1;
            int yPoint = cNnode.y;
            for (Node n : arrangedNodeList) {
                if (xPoint == cNnode.x + 1 && yPoint == cNnode.y) {
                    this.gridLayout[yPoint][xPoint] = n;
                    n.x = xPoint;
                    n.y = yPoint;
                    xPoint += (int)((double)n.width + 0.001) / this.gridX;
                    yPoint += (int)((double)n.height + 0.001) / this.gridY;
                    continue;
                }
                if (xPoint + (int)((double)n.width + 0.001) / this.gridX <= (int)((double)cNnode.width + 0.001) / this.gridX + cNnode.x) {
                    this.gridLayout[cNnode.y][xPoint] = n;
                    n.x = xPoint;
                    n.y = cNnode.y;
                    xPoint += (int)((double)n.width + 0.001) / this.gridX;
                    continue;
                }
                this.gridLayout[yPoint][cNnode.x] = n;
                n.x = cNnode.x;
                n.y = yPoint;
                yPoint += (int)((double)n.height + 0.001) / this.gridY;
            }
        }
    }

    protected void formatGrid(int upCompLevel) {
        List<Node> currentLevelCompList = this.compartmentMap.get("" + upCompLevel);
        for (Node n : currentLevelCompList) {
            for (int i = n.y; i < n.y + (int)((double)n.height + 0.001) / this.gridY; ++i) {
                for (int j = n.x; j < n.x + (int)((double)n.width + 0.001) / this.gridX; ++j) {
                    this.grid[i][j].compartmentName = this.getFullName(n.name);
                }
            }
        }
    }

    protected void renewCompartmentPointMap() {
        this.compartmentPointMap = new HashMap<String, List<GridPoint>>();
        ArrayList<GridPoint> tempGP = new ArrayList<GridPoint>();
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                String compName = this.grid[i][j].compartmentName;
                if (!this.compartmentPointMap.containsKey(compName)) {
                    tempGP.add(this.grid[i][j]);
                    this.compartmentPointMap.put(compName, tempGP);
                    tempGP = new ArrayList();
                    continue;
                }
                this.compartmentPointMap.get(compName).add(this.grid[i][j]);
            }
        }
    }

    protected void setGrid(HashMap<String, Integer> compartmentNodeNumberMap, HashMap<String, Integer[]> compartmentNodeSizeMap, Graph graph) {
        List<Node> baseComp = this.compartmentMap.get("0");
        ArrayList<GridPoint> tempGP = new ArrayList<GridPoint>();
        this.gridWidth = 0;
        this.gridHeight = 0;
        for (Node n : baseComp) {
            if (n.width >= this.gridWidth || n.height >= this.gridHeight) {
                this.gridWidth += n.width;
                this.gridHeight += n.height;
                continue;
            }
            if (n.width >= n.height) {
                this.gridWidth += n.width;
                continue;
            }
            this.gridHeight += n.height;
        }
        if (compartmentNodeNumberMap.containsKey("root")) {
            int nodeNumber = compartmentNodeNumberMap.get("root");
            this.gridWidth = (int)((double)this.gridWidth + (2.0 * Math.sqrt(nodeNumber) * (double)((int)((double)(1 + compartmentNodeSizeMap.get("root")[0] / (this.gridX * nodeNumber)) + (double)(nodeOffset + nodeShift) / (double)this.gridX)) + (double)((int)((double)compartmentNodeSizeMap.get("root")[0].intValue() / (double)(this.gridX * nodeNumber)))));
            this.gridHeight = (int)((double)this.gridHeight + (2.0 * Math.sqrt(nodeNumber) * (double)((int)((double)(1 + compartmentNodeSizeMap.get("root")[1] / (this.gridY * nodeNumber)) + (double)(nodeOffset + nodeShift) / (double)this.gridY)) + (double)((int)((double)compartmentNodeSizeMap.get("root")[1].intValue() / (double)(this.gridY * nodeNumber)))));
        }
        this.gridLayout = new Node[this.gridHeight][this.gridWidth];
        this.grid = new GridPoint[this.gridHeight][this.gridWidth];
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                this.gridLayout[i][j] = null;
                this.grid[i][j] = new GridPoint(j, i);
                this.grid[i][j].compartmentName = "root";
                tempGP.add(this.grid[i][j]);
            }
        }
        this.compartmentPointMap.put("root", tempGP);
    }

    protected void makeGrid(Graph graph) {
        int nodeCount = graph.nodeCount();
        if (this.setGridAutomatically) {
            this.gridSize = 2 * (int)Math.sqrt(nodeCount);
        }
        int sumWidth = 0;
        int sumHeight = 0;
        for (int i = 0; i < nodeCount; ++i) {
            sumWidth += graph.nodeAt((int)i).width;
            sumHeight += graph.nodeAt((int)i).height;
        }
        this.gridWidth = this.gridSize * (int)(1.0 + (double)sumWidth / (double)(this.gridX * nodeCount) + (double)(nodeOffset + nodeShift) / (double)this.gridX);
        this.gridHeight = this.gridSize * (int)(1.0 + (double)sumHeight / (double)(this.gridY * nodeCount) + (double)(nodeOffset + nodeShift) / (double)this.gridY);
        this.gridLayout = new Node[this.gridHeight][this.gridWidth];
        this.grid = new GridPoint[this.gridHeight][this.gridWidth];
        for (int i = 0; i < nodeCount; ++i) {
            Node tempNode = graph.nodeAt(i);
            this.nodeVector.addElement(tempNode);
            this.nodeIndexMap.put(tempNode.getName(), i);
        }
        ArrayList<GridPoint> tempGP = new ArrayList<GridPoint>();
        int k = 0;
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                this.gridLayout[i][j] = null;
                if (k < nodeCount) {
                    this.gridLayout[i][j] = this.nodeVector.get(k);
                    if (this.gridLayout[i][j].getAttribute("compartmentName") == null) {
                        this.gridLayout[i][j].setAttribute("compartmentName", "root");
                    }
                    this.gridLayout[i][j].x = j;
                    this.gridLayout[i][j].y = i;
                    ++k;
                }
                this.grid[i][j] = new GridPoint(j, i);
                this.grid[i][j].compartmentName = "root";
                tempGP.add(this.grid[i][j]);
            }
        }
        this.compartmentPointMap.put("root", tempGP);
    }

    protected void setWeightMatrix(Graph graph) {
        int nodeCount = graph.nodeCount();
        this.weightMap = new int[nodeCount][nodeCount];
        double[][] m1 = new double[nodeCount][nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            m1[i][i] = 1.0;
            Node tempNode = this.nodeVector.get(i);
            List<Edge> edgeList = graph.getEdges(tempNode);
            if (edgeList == null) continue;
            for (Edge edge : edgeList) {
                if (edge.from.equals(tempNode)) {
                    m1[i][this.nodeVector.indexOf((Object)edge.to)] = 1.0;
                    continue;
                }
                m1[i][this.nodeVector.indexOf((Object)edge.from)] = 1.0;
            }
        }
        try {
            double[][] m2 = CompartmentCrossCostGridLayouter.matrixMultiply(m1, m1);
            double[][] m3 = CompartmentCrossCostGridLayouter.matrixMultiply(m1, m2);
            double[][] m4 = CompartmentCrossCostGridLayouter.matrixMultiply(m2, m2);
            for (int i = 0; i < nodeCount; ++i) {
                for (int j = 0; j < nodeCount; ++j) {
                    this.weightMap[i][j] = m1[i][j] > 0.0 ? this.connectedNodesWeight : (m1[i][j] == 0.0 && m2[i][j] > 0.0 ? 2 : (m2[i][j] == 0.0 && m3[i][j] > 0.0 ? 1 : (m3[i][j] == 0.0 && m4[i][j] > 0.0 ? 0 : -1)));
                }
            }
        }
        catch (Exception m2) {
            // empty catch block
        }
        String attractorName = "";
        if (this.compartmentMap.size() > 0) {
            List<Node> nl = this.compartmentMap.get("0");
            int minCoord = 696969;
            for (Node n : nl) {
                if (n.x + n.y >= minCoord) continue;
                minCoord = n.x + n.y;
                attractorName = n.name;
            }
        }
        for (int i = 0; i < nodeCount; ++i) {
            for (int j = 0; j < nodeCount; ++j) {
                Node node1 = this.nodeVector.get(i);
                Node node2 = this.nodeVector.get(j);
                if (node1.name.equalsIgnoreCase(attractorName) || node2.name.equalsIgnoreCase(attractorName)) {
                    this.weightMap[i][j] = 1;
                    continue;
                }
                if (Util.isCompartment(node1) || Util.isCompartment(node2)) {
                    this.weightMap[i][j] = 0;
                    continue;
                }
                if (this.edgeMap.get(node1) != null || this.edgeMap.get(node2) != null) continue;
                this.weightMap[i][j] = 1;
            }
        }
    }

    public void layoutPermutation() {
        for (Node node : this.nodeVector) {
            if (node.fixed) continue;
            GridPoint gp2 = this.getRandomVacantPoint(node);
            this.moveNodeToPoint(gp2, node);
        }
    }

    protected GridPoint getGridPosition(Node node) {
        GridPoint position = this.grid[node.y][node.x];
        return position;
    }

    protected int getDistance(Node ri, Node rj) {
        return Math.abs(ri.x - rj.x) + Math.abs(ri.y - rj.y);
    }

    protected double CostFunction(Node ri, Node rj) {
        double cost = 0.0;
        double weight = this.weightMap[this.nodeIndexMap.get(ri.getName())][this.nodeIndexMap.get(rj.getName())];
        cost = weight >= 0.0 ? weight * (double)this.getDistance(ri, rj) : weight * (double)Math.min(this.getDistance(ri, rj), this.saturationDist);
        return cost;
    }

    protected double edgeEdgeCrossCostFunction(Node alpha, Node betta) {
        double cost;
        block7: {
            block6: {
                cost = 0.0;
                if (this.weightMap[this.nodeIndexMap.get(alpha.getName())][this.nodeIndexMap.get(betta.getName())] != this.connectedNodesWeight) break block6;
                Edge alphaBetta = new Edge(alpha, betta);
                for (Edge e1 : this.edgeMap.get(alpha)) {
                    if (e1.from.equals(betta) || e1.to.equals(betta)) {
                        alphaBetta = e1;
                        continue;
                    }
                    for (Edge e2 : this.edgeMap.get(betta)) {
                        cost += (double)this.checkEdgeCross(e1, e2);
                    }
                }
                for (Edge e : this.edgeList) {
                    cost += (double)this.checkEdgeCross(alphaBetta, e);
                }
                break block7;
            }
            if (this.edgeMap.get(alpha) == null || this.edgeMap.get(betta) == null) break block7;
            for (Edge e1 : this.edgeMap.get(alpha)) {
                for (Edge e2 : this.edgeMap.get(betta)) {
                    cost += (double)this.checkEdgeCross(e1, e2);
                }
            }
        }
        return cost;
    }

    protected double nodeEdgeCrossCostFunction(Node alpha, Node betta) {
        double cost;
        block8: {
            block7: {
                cost = 0.0;
                if (this.weightMap[this.nodeIndexMap.get(alpha.getName())][this.nodeIndexMap.get(betta.getName())] != this.connectedNodesWeight) break block7;
                Edge alphaBetta = new Edge(alpha, betta);
                for (Edge e : this.edgeMap.get(alpha)) {
                    if (e.from.equals(betta) || e.to.equals(betta)) {
                        alphaBetta = e;
                        continue;
                    }
                    cost += (double)this.checkNodeCross(e, betta);
                }
                for (Edge e : this.edgeMap.get(betta)) {
                    cost += (double)this.checkNodeCross(e, alpha);
                }
                int nodeCount = this.nodeVector.size();
                for (int i = 0; i < nodeCount; ++i) {
                    cost += (double)this.checkNodeCross(alphaBetta, this.nodeVector.get(i));
                }
                break block8;
            }
            if (this.edgeMap.get(alpha) != null) {
                for (Edge e : this.edgeMap.get(alpha)) {
                    cost += (double)this.checkNodeCross(e, betta);
                }
            }
            if (this.edgeMap.get(betta) == null) break block8;
            for (Edge e : this.edgeMap.get(betta)) {
                cost += (double)this.checkNodeCross(e, alpha);
            }
        }
        return cost;
    }

    protected double nodeCostFunction(Node node) {
        double cost = 0.0;
        int nodeCount = this.nodeVector.size();
        for (Node rj : this.nodeVector) {
            cost += this.CostFunction(node, rj);
            cost += (double)this.checkNodesOverlap(node, rj);
        }
        if (this.edgeMap.get(node) != null) {
            for (Edge e1 : this.edgeMap.get(node)) {
                for (Edge e2 : this.edgeList) {
                    cost += (double)this.checkEdgeCross(e1, e2);
                }
                for (int i = 0; i < nodeCount; ++i) {
                    cost += (double)this.checkNodeCross(e1, this.nodeVector.get(i));
                }
            }
        }
        for (Edge e : this.edgeList) {
            cost += (double)this.checkNodeCross(e, node);
        }
        return cost;
    }

    protected double layoutCostFunction() {
        int i;
        double cost = 0.0;
        int nodeCount = this.nodeVector.size();
        for (i = 0; i < nodeCount - 1; ++i) {
            Node ri = this.nodeVector.get(i);
            for (int j = i + 1; j < nodeCount; ++j) {
                Node rj = this.nodeVector.get(j);
                cost += this.CostFunction(ri, rj);
                cost += (double)this.checkNodesOverlap(ri, rj);
            }
        }
        for (i = 0; i < this.edgeList.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                Edge e1 = this.edgeList.get(i);
                Edge e2 = this.edgeList.get(j);
                cost += (double)this.checkEdgeCross(e1, e2);
            }
        }
        for (i = 0; i < nodeCount; ++i) {
            for (Edge e : this.edgeList) {
                cost += (double)this.checkNodeCross(e, this.nodeVector.get(i));
            }
        }
        return cost;
    }

    protected void neighbour(String[][] stringArray) {
        this.gridLayout = this.makeLayoutFromStringArray(stringArray);
        double rand = 0.0;
        for (Node node : this.nodeVector) {
            if (node.fixed) continue;
            rand = this.rnd.nextDouble();
            Node tempNode = node;
            if (!(rand < this.probabilityThreshold)) continue;
            GridPoint position = this.getRandomVacantPoint(tempNode);
            this.moveNodeToPoint(position, tempNode);
        }
    }

    protected Node[][] makeLayoutFromStringArray(String[][] stringArray) {
        int strNumber = stringArray.length;
        int colNumber = stringArray[0].length;
        Node[][] nodeMatrix = new Node[strNumber][colNumber];
        for (int i = 0; i < strNumber; ++i) {
            for (int j = 0; j < colNumber; ++j) {
                if (stringArray[i][j] == null) {
                    nodeMatrix[i][j] = null;
                    continue;
                }
                nodeMatrix[i][j] = this.nodeMap.get(stringArray[i][j]);
                nodeMatrix[i][j].x = j;
                nodeMatrix[i][j].y = i;
            }
        }
        return nodeMatrix;
    }

    protected void moveNodeToPoint(GridPoint gp, Node node) {
        int yCord = gp.y;
        int xCord = gp.x;
        if (this.gridLayout[yCord][xCord] == null || this.gridLayout[yCord][xCord].fixed) {
            GridPoint position = this.getGridPosition(node);
            this.gridLayout[yCord][xCord] = node;
            node.x = xCord;
            node.y = yCord;
            this.gridLayout[position.y][position.x] = null;
        }
    }

    protected void changePointNodes(GridPoint gp1, GridPoint gp2) {
        int xCord1 = gp1.x;
        int yCord1 = gp1.y;
        int xCord2 = gp2.x;
        int yCord2 = gp2.y;
        Node tempNode = this.gridLayout[yCord1][xCord1];
        this.gridLayout[yCord1][xCord1] = this.gridLayout[yCord2][xCord2];
        this.gridLayout[yCord2][xCord2] = tempNode;
        if (this.gridLayout[yCord1][xCord1] != null) {
            this.gridLayout[yCord1][xCord1].x = xCord1;
            this.gridLayout[yCord1][xCord1].y = yCord1;
        }
        if (this.gridLayout[yCord2][xCord2] != null) {
            this.gridLayout[yCord2][xCord2].x = xCord2;
            this.gridLayout[yCord2][xCord2].y = yCord2;
        }
    }

    protected GridPoint[] getVacantPointList() {
        int vacantCount = this.gridLayout.length * this.gridLayout[0].length - this.nodeVector.size();
        GridPoint[] vacantPositionList = new GridPoint[vacantCount];
        int vacantPointNumber = 0;
        for (int i = 0; i < this.gridLayout.length; ++i) {
            for (int j = 0; j < this.gridLayout[0].length; ++j) {
                if (this.gridLayout[i][j] != null) continue;
                vacantPositionList[vacantPointNumber] = this.grid[i][j];
                ++vacantPointNumber;
            }
        }
        return vacantPositionList;
    }

    /*
     * WARNING - void declaration
     */
    protected GridPoint getRandomCompartmentPoint(Node node) {
        void var6_11;
        String compartmentName = node.getAttribute("compartmentName");
        if (compartmentName == null) {
            compartmentName = "root";
        }
        List<GridPoint> compartment = this.compartmentPointMap.get(compartmentName);
        ArrayList<GridPoint> notNullCompartment = new ArrayList<GridPoint>();
        for (GridPoint gridPoint : compartment) {
            if (gridPoint == null) continue;
            notNullCompartment.add(gridPoint);
        }
        int compVacantGridPointQuantity = 0;
        for (GridPoint gridPoint : notNullCompartment) {
            if (this.gridLayout[gridPoint.y][gridPoint.x] != null) continue;
            ++compVacantGridPointQuantity;
        }
        GridPoint gridPoint = new GridPoint(0, 0);
        int n = this.randInt(compVacantGridPointQuantity - 1);
        int count = 0;
        for (GridPoint gridPoint2 : notNullCompartment) {
            if (this.gridLayout[gridPoint2.y][gridPoint2.x] != null) continue;
            if (count == n) {
                GridPoint gridPoint3 = this.grid[gridPoint2.y][gridPoint2.x];
                break;
            }
            ++count;
        }
        return var6_11;
    }

    protected GridPoint getRandomVacantPoint(Node node) {
        if (node.fixed) {
            return this.getGridPosition(node);
        }
        String compartmentName = node.getAttribute("compartmentName");
        if (compartmentName == null) {
            compartmentName = "root";
        }
        List<GridPoint> compartment = this.compartmentPointMap.get(compartmentName);
        int compartmentVacantPointCount = 0;
        for (GridPoint gp : compartment) {
            if (gp == null || this.gridLayout[gp.y][gp.x] != null || !this.isIn(node, gp)) continue;
            ++compartmentVacantPointCount;
        }
        if (compartmentVacantPointCount == 0) {
            return this.getRandomCompartmentPoint(node);
        }
        int randint = this.randInt(compartmentVacantPointCount - 1);
        int count = 0;
        GridPoint position = this.getRandomCompartmentPoint(node);
        for (GridPoint gp : compartment) {
            if (gp == null || this.gridLayout[gp.y][gp.x] != null || !this.isIn(node, gp)) continue;
            if (count == randint) {
                position = this.grid[gp.y][gp.x];
                break;
            }
            ++count;
        }
        return position;
    }

    protected void initDeltaMatrix(Graph graph) {
        int vacantCount = this.gridLayout.length * this.gridLayout[0].length - this.nodeVector.size();
        int nodeCount = graph.nodeCount();
        this.deltaMatrix = new double[nodeCount][vacantCount];
    }

    protected double localMin(LayoutJobControl lJC) {
        double dMin = 0.0;
        GridPoint[] vacantPointList = this.getVacantPointList();
        double[][] newDeltaMatrix = new double[this.deltaMatrix.length][this.deltaMatrix[0].length];
        GridPoint newPosition = new GridPoint(0, 0);
        int newPositionNumber = 0;
        Node newNode = null;
        for (Node node : this.nodeVector) {
            if (!node.fixed) {
                GridPoint currentNodePosition = this.getGridPosition(node);
                for (int vacantPointNumber = 0; vacantPointNumber < vacantPointList.length; ++vacantPointNumber) {
                    GridPoint tempGP = vacantPointList[vacantPointNumber];
                    if (node.getAttribute("compartmentName").equalsIgnoreCase(vacantPointList[vacantPointNumber].compartmentName) && this.isIn(node, tempGP)) {
                        this.moveNodeToPoint(vacantPointList[vacantPointNumber], node);
                        this.deltaMatrix[this.nodeIndexMap.get((Object)node.getName()).intValue()][vacantPointNumber] = this.nodeCostFunction(node);
                        this.moveNodeToPoint(currentNodePosition, node);
                        double[] dArray = this.deltaMatrix[this.nodeIndexMap.get(node.getName())];
                        int n = vacantPointNumber;
                        dArray[n] = dArray[n] - this.nodeCostFunction(node);
                        if (!(this.deltaMatrix[this.nodeIndexMap.get(node.getName())][vacantPointNumber] < dMin)) continue;
                        dMin = this.deltaMatrix[this.nodeIndexMap.get(node.getName())][vacantPointNumber];
                        newPosition = vacantPointList[vacantPointNumber];
                        newPositionNumber = vacantPointNumber;
                        newNode = node;
                        continue;
                    }
                    this.deltaMatrix[this.nodeIndexMap.get((Object)node.getName()).intValue()][vacantPointNumber] = 69.0;
                }
                continue;
            }
            for (int vacantPointNumber = 0; vacantPointNumber < vacantPointList.length; ++vacantPointNumber) {
                this.deltaMatrix[this.nodeIndexMap.get((Object)node.getName()).intValue()][vacantPointNumber] = 69.0;
            }
        }
        if (newNode == null) {
            return this.layoutCostFunction();
        }
        Node tempNewNode = null;
        GridPoint tempNewPosition = new GridPoint(0, 0);
        int tempNewPositionNumber = 0;
        try {
            while (dMin < 0.0) {
                int vacantPointNumber;
                GridPoint oldBettaPosition;
                vacantPointList[newPositionNumber] = oldBettaPosition = this.getGridPosition(newNode);
                double dMinTemp = 0.0;
                for (Node node : this.nodeVector) {
                    if (!node.fixed) {
                        for (vacantPointNumber = 0; vacantPointNumber < vacantPointList.length; ++vacantPointNumber) {
                            if (vacantPointNumber == newPositionNumber && node == newNode) continue;
                            GridPoint tempGP = vacantPointList[vacantPointNumber];
                            if (node.getAttribute("compartmentName").equalsIgnoreCase(vacantPointList[vacantPointNumber].compartmentName) && this.isIn(node, tempGP)) {
                                newDeltaMatrix[this.nodeIndexMap.get((Object)node.getName()).intValue()][vacantPointNumber] = this.deltaMatrixFastCalculate(node, newNode, vacantPointNumber, newPositionNumber, newPosition, vacantPointList);
                                if (!(newDeltaMatrix[this.nodeIndexMap.get(node.getName())][vacantPointNumber] < dMinTemp)) continue;
                                dMinTemp = newDeltaMatrix[this.nodeIndexMap.get(node.getName())][vacantPointNumber];
                                tempNewNode = node;
                                tempNewPosition = vacantPointList[vacantPointNumber];
                                tempNewPositionNumber = vacantPointNumber;
                                continue;
                            }
                            newDeltaMatrix[this.nodeIndexMap.get((Object)node.getName()).intValue()][vacantPointNumber] = 69.0;
                        }
                        continue;
                    }
                    for (vacantPointNumber = 0; vacantPointNumber < vacantPointList.length; ++vacantPointNumber) {
                        newDeltaMatrix[this.nodeIndexMap.get((Object)node.getName()).intValue()][vacantPointNumber] = 69.0;
                    }
                }
                this.deltaMatrix[this.nodeIndexMap.get((Object)newNode.getName()).intValue()][newPositionNumber] = -dMin;
                this.moveNodeToPoint(newPosition, newNode);
                for (Node node : this.nodeVector) {
                    for (vacantPointNumber = 0; vacantPointNumber < vacantPointList.length; ++vacantPointNumber) {
                        if (vacantPointNumber == newPositionNumber && node == newNode) continue;
                        this.deltaMatrix[this.nodeIndexMap.get((Object)node.getName()).intValue()][vacantPointNumber] = newDeltaMatrix[this.nodeIndexMap.get(node.getName())][vacantPointNumber];
                    }
                }
                newNode = tempNewNode;
                newPosition = tempNewPosition;
                newPositionNumber = tempNewPositionNumber;
                dMin = dMinTemp;
                if (lJC == null || lJC.getStatus() != 4 && lJC.getStatus() != 5) continue;
                dMin = 69.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        double cost = this.layoutCostFunction();
        return cost;
    }

    protected double deltaMatrixFastCalculate(Node alpha, Node betta, int positionPnumber, int positionQnumber, GridPoint positionQ, GridPoint[] vacantPointList) {
        double deltaAP = 0.0;
        GridPoint bettaPosition = this.getGridPosition(betta);
        GridPoint alphaPosition = this.getGridPosition(alpha);
        GridPoint positionP = vacantPointList[positionPnumber];
        if (alpha != betta && positionP != bettaPosition) {
            double term = this.CostFunction(alpha, betta);
            term += this.edgeEdgeCrossCostFunction(alpha, betta);
            term += this.nodeEdgeCrossCostFunction(alpha, betta);
            term += (double)this.checkNodesOverlap(alpha, betta);
            this.moveNodeToPoint(positionP, alpha);
            term -= this.CostFunction(alpha, betta);
            term -= this.edgeEdgeCrossCostFunction(alpha, betta);
            term -= this.nodeEdgeCrossCostFunction(alpha, betta);
            term += (double)this.checkNodesOverlap(alpha, betta);
            this.moveNodeToPoint(alphaPosition, alpha);
            this.moveNodeToPoint(positionQ, betta);
            term -= this.CostFunction(alpha, betta);
            term -= this.edgeEdgeCrossCostFunction(alpha, betta);
            term -= this.nodeEdgeCrossCostFunction(alpha, betta);
            term += (double)this.checkNodesOverlap(alpha, betta);
            this.moveNodeToPoint(positionP, alpha);
            term += this.CostFunction(alpha, betta);
            term += this.edgeEdgeCrossCostFunction(alpha, betta);
            term += this.nodeEdgeCrossCostFunction(alpha, betta);
            this.moveNodeToPoint(alphaPosition, alpha);
            this.moveNodeToPoint(bettaPosition, betta);
            deltaAP = this.deltaMatrix[this.nodeIndexMap.get(alpha.getName())][positionPnumber] + (term += (double)this.checkNodesOverlap(alpha, betta));
        } else if (alpha == betta) {
            deltaAP = this.deltaMatrix[this.nodeIndexMap.get(betta.getName())][positionPnumber] - this.deltaMatrix[this.nodeIndexMap.get(betta.getName())][positionQnumber];
        } else {
            this.moveNodeToPoint(positionQ, betta);
            deltaAP -= this.nodeCostFunction(alpha);
            this.moveNodeToPoint(positionP, alpha);
            deltaAP += this.nodeCostFunction(alpha);
            this.moveNodeToPoint(alphaPosition, alpha);
            this.moveNodeToPoint(bettaPosition, betta);
        }
        return deltaAP;
    }

    protected Node[][] gridLayout(double tMax, double tMin, int ne, double rc, boolean comp, LayoutJobControl lJC) {
        double temperature = tMax;
        double f = this.localMin(lJC);
        if (lJC != null) {
            lJC.done(++this.operationsDone);
        }
        double fMin = f;
        String[][] rMin = CompartmentCrossCostGridLayouter.nodeMatrixClone(this.gridLayout);
        String[][] tempGridLayout = CompartmentCrossCostGridLayouter.nodeMatrixClone(this.gridLayout);
        while (temperature > tMin) {
            for (int i = 0; i < ne; ++i) {
                this.neighbour(tempGridLayout);
                double tempF = this.localMin(lJC);
                double probability = this.rnd.nextDouble();
                if (probability < Math.exp((f - tempF) / temperature)) {
                    f = tempF;
                    tempGridLayout = CompartmentCrossCostGridLayouter.nodeMatrixClone(this.gridLayout);
                }
                if (!(tempF < fMin)) continue;
                fMin = tempF;
                rMin = CompartmentCrossCostGridLayouter.nodeMatrixClone(this.gridLayout);
            }
            temperature = rc * temperature;
            if (lJC == null) continue;
            if (lJC.getStatus() == 4 || lJC.getStatus() == 5) {
                temperature = tMin;
            }
            lJC.done(++this.operationsDone);
        }
        return this.makeLayoutFromStringArray(rMin);
    }

    @Override
    protected void layoutNodes(Graph graph, LayoutJobControl lJC) {
        this.gridLayout = this.gridLayout(this.tMax, this.tMin, this.ne, this.rc, false, lJC);
    }

    protected void setCoordinates(Node[][] gridLayout) {
        for (int i = 0; i < gridLayout.length; ++i) {
            for (int j = 0; j < gridLayout[0].length; ++j) {
                if (gridLayout[i][j] == null) continue;
                if (!Util.isCompartment(gridLayout[i][j])) {
                    gridLayout[i][j].x = j * this.gridX - (int)((double)gridLayout[i][j].width / 2.0);
                    gridLayout[i][j].y = i * this.gridY - (int)((double)gridLayout[i][j].height / 2.0);
                    continue;
                }
                gridLayout[i][j].x = j * this.gridX;
                gridLayout[i][j].y = i * this.gridY;
            }
        }
    }

    @Override
    public void layoutEdges(Graph graph, LayoutJobControl lJC) {
        for (Edge edge : graph.edgeList) {
            this.layoutPath(graph, edge, lJC);
        }
    }

    protected int getRange(int[] point1, int[] point2) {
        return Math.abs(point1[0] - point2[0]) + Math.abs(point1[1] - point2[1]);
    }

    @Override
    public void layoutPath(Graph graph, Edge edge, LayoutJobControl lJC) {
        this.getPathLayouter().layoutPath(graph, edge, lJC);
    }

    protected void doCompLayout(Graph graph, LayoutJobControl lJC) {
        this.tMax = this.tMin / Math.pow(this.rc, compartmentAnnealingSteps);
        if (this.rc == 0.0) {
            this.tMax = this.tMin + 1.0E-8;
        }
        this.setWeightMatrix(graph);
        this.initDeltaMatrix(graph);
        this.layoutNodes(graph, lJC);
    }

    protected void setCompartments() {
        ArrayList nodeList = new ArrayList();
        for (int currLevel = this.compartmentMap.size() - 1; currLevel > -1; --currLevel) {
            nodeList.addAll(this.compartmentMap.get("" + currLevel));
        }
        for (Node n : nodeList) {
            n.width *= this.gridX;
            n.height *= this.gridY;
        }
    }

    @Override
    public void doLayout(Graph graph, LayoutJobControl lJC) {
        long time = System.currentTimeMillis();
        if (lJC != null) {
            lJC.begin();
        }
        this.operationsDone = 0;
        this.edgeList = new ArrayList<Edge>();
        this.nodeMap = new HashMap<String, Node>();
        this.nodeIndexMap = new HashMap<String, Integer>();
        this.edgeMap = new HashMap<Node, List<Edge>>();
        this.compartmentPointMap = new HashMap<String, List<GridPoint>>();
        this.compartmentMap = new HashMap<String, List<Node>>();
        this.nodeVector = new Vector();
        this.nodeMap = graph.nodeMap;
        this.edgeMap = graph.edgeMap;
        this.edgeList = graph.edgeList;
        if (this.checkForCompartments(graph)) {
            this.defineCompartments(graph, lJC);
            this.changeLayout(graph);
        } else {
            this.makeGrid(graph);
        }
        this.setWeightMatrix(graph);
        this.tMax = this.makeTmax(graph);
        this.initDeltaMatrix(graph);
        this.layoutNodes(graph, lJC);
        this.setCoordinates(this.gridLayout);
        Util.adjustOrientations(graph);
        this.layoutEdges(graph, lJC);
        this.setNodesFixed(graph.nodeList, false);
        log.log(Level.INFO, "Layout time " + (System.currentTimeMillis() - time));
    }

    public int randInt(int k) {
        return this.rnd.nextInt(k + 1);
    }

    public static double[][] matrixMultiply(double[][] matrix1, double[][] matrix2) throws Exception {
        if (matrix1[0].length != matrix2.length) {
            throw new Exception("matrices dimensions doesn't match");
        }
        double[][] result = new double[matrix1.length][matrix2[0].length];
        double[][] conMatrix2 = CompartmentCrossCostGridLayouter.matrixConjugate(matrix2);
        for (int i = 0; i < matrix1.length; ++i) {
            for (int j = 0; j < matrix2[0].length; ++j) {
                result[i][j] = CompartmentCrossCostGridLayouter.scalarMultiply(matrix1[i], conMatrix2[j]);
            }
        }
        return result;
    }

    public static double[][] matrixConjugate(double[][] matrix) throws Exception {
        double[][] conMatrix = new double[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                conMatrix[j][i] = matrix[i][j];
            }
        }
        return conMatrix;
    }

    public static double scalarMultiply(double[] vector1, double[] vector2) throws Exception {
        if (vector1.length != vector2.length) {
            throw new Exception("vectors are with different lengths");
        }
        double result = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            result += vector1[i] * vector2[i];
        }
        return result;
    }

    public static String[][] nodeMatrixClone(Node[][] nodeMatrix) {
        int strNumber = nodeMatrix.length;
        int colNumber = nodeMatrix[0].length;
        String[][] clonedNameMatrix = new String[strNumber][colNumber];
        for (int i = 0; i < strNumber; ++i) {
            for (int j = 0; j < colNumber; ++j) {
                clonedNameMatrix[i][j] = nodeMatrix[i][j] == null ? null : nodeMatrix[i][j].getName();
            }
        }
        return clonedNameMatrix;
    }

    protected static Graph createGraph(List<Node> nodes, List<Edge> edges) {
        Graph graph = new Graph();
        for (Node n : nodes) {
            graph.addNode(n);
        }
        if (edges != null) {
            for (Edge e : edges) {
                graph.addEdge(e);
            }
        }
        return graph;
    }

    protected void addCompartments(Graph graph) {
        int counter = 0;
        while (this.compartmentMap.containsKey("" + counter)) {
            List<Node> compList = this.compartmentMap.get("" + counter);
            for (Node n : compList) {
                graph.addNode(n);
            }
            ++counter;
        }
    }

    protected boolean checkForCompartments(Graph graph) {
        for (Node n : graph.nodeList) {
            if (!Util.isCompartment(n)) continue;
            return true;
        }
        return false;
    }

    protected static int setShift(Node n) {
        int shift = 0;
        int pointEntry = 0;
        String compName = n.getAttribute("compartmentName");
        if (compName.equalsIgnoreCase("")) {
            return shift;
        }
        pointEntry = compName.length() - compName.replaceAll("\\.", "").length() + 1;
        shift = pointEntry * shiftMultiplyCoeff;
        return shift;
    }

    protected boolean isIn(Node node, GridPoint gp) {
        int leftX = 0;
        int leftY = 0;
        int rightX = this.gridWidth * this.gridX;
        int rightY = this.gridHeight * this.gridY;
        int nodeLeftX = gp.x * this.gridX;
        int nodeLeftY = gp.y * this.gridY;
        int nodeRightX = gp.x * this.gridX;
        int nodeRightY = gp.y * this.gridY;
        if (!Util.isCompartment(node)) {
            nodeLeftX -= (int)((double)node.width / 2.0);
            nodeLeftY -= (int)((double)node.height / 2.0);
            nodeRightX += (int)((double)node.width / 2.0);
            nodeRightY += (int)((double)node.height / 2.0);
        } else {
            nodeRightX += node.width;
            nodeRightY += node.height;
        }
        if (!node.getAttribute("compartmentName").equalsIgnoreCase("root")) {
            Node tempNode = this.nodeMap.get(this.getNodeName(node.getAttribute("compartmentName")));
            leftX = tempNode.x * this.gridX;
            leftY = tempNode.y * this.gridY;
            rightX = tempNode.x * this.gridX + tempNode.width;
            rightY = tempNode.y * this.gridY + tempNode.height;
        }
        return leftX <= nodeLeftX && leftY <= nodeLeftY && rightX >= nodeRightX && rightY >= nodeRightY;
    }

    protected int segmentIntersect(int p1x1, int p1y1, int p1x2, int p1y2, int p2x1, int p2y1, int p2x2, int p2y2, int penalty) {
        if (!this.rectIntersect(p1x1, p1y1, p1x2, p1y2, p2x1, p2y1, p2x2, p2y2)) {
            return 0;
        }
        int s1 = this.area(p2x1, p2y1, p2x2, p2y2, p1x1, p1y1);
        int s2 = this.area(p2x1, p2y1, p2x2, p2y2, p1x2, p1y2);
        int s3 = this.area(p1x1, p1y1, p1x2, p1y2, p2x1, p2y1);
        int s4 = this.area(p1x1, p1y1, p1x2, p1y2, p2x2, p2y2);
        if ((s1 > 0 && s2 < 0 || s1 < 0 && s2 > 0) && (s3 < 0 && s4 > 0 || s3 > 0 && s4 < 0)) {
            return penalty;
        }
        if (s1 == 0 && this.between(p2x1, p2y1, p2x2, p2y2, p1x1, p1y1)) {
            return penalty;
        }
        if (s2 == 0 && this.between(p2x1, p2y1, p2x2, p2y2, p1x2, p1y2)) {
            return penalty;
        }
        if (s3 == 0 && this.between(p1x1, p1y1, p1x2, p1y2, p2x1, p2y1)) {
            return penalty;
        }
        if (s4 == 0 && this.between(p1x1, p1y1, p1x2, p1y2, p2x2, p2y2)) {
            return penalty;
        }
        return 0;
    }

    protected boolean rectIntersect(int p1x1, int p1y1, int p1x2, int p1y2, int p2x1, int p2y1, int p2x2, int p2y2) {
        int rect1X1 = Math.min(p1x1, p1x2);
        int rect1Y1 = Math.min(p1y1, p1y2);
        int rect1X2 = Math.max(p1x1, p1x2);
        int rect1Y2 = Math.max(p1y1, p1y2);
        int rect2X1 = Math.min(p2x1, p2x2);
        int rect2Y1 = Math.min(p2y1, p2y2);
        int rect2X2 = Math.max(p2x1, p2x2);
        int rect2Y2 = Math.max(p2y1, p2y2);
        return rect1X2 >= rect2X1 && rect2X2 >= rect1X1 && rect1Y2 >= rect2Y1 && rect2Y2 >= rect1Y1;
    }

    protected boolean between(int p1x1, int p1y1, int p1x2, int p1y2, int p2x1, int p2y1) {
        return Math.min(p1x1, p1x2) <= p2x1 && p2x1 <= Math.max(p1x1, p1x2) && Math.min(p1y1, p1y2) <= p2y1 && p2y1 <= Math.max(p1y1, p1y2);
    }

    protected int area(int p1x1, int p1y1, int p1x2, int p1y2, int p2x1, int p2y1) {
        return (p1x2 - p1x1) * (p2y1 - p1y1) - (p1y2 - p1y1) * (p2x1 - p1x1);
    }

    @Override
    public LayouterInfo getInfo() {
        LayouterInfoSupport lis = new LayouterInfoSupport(true, true, false, true, false, true);
        return lis;
    }

    @Override
    public int estimate(Graph gr, int what) {
        Graph graph = CompartmentCrossCostGridLayouter.createGraph(gr.nodeList, gr.edgeList);
        this.edgeList = new ArrayList<Edge>();
        this.nodeMap = new HashMap<String, Node>();
        this.nodeIndexMap = new HashMap<String, Integer>();
        this.edgeMap = new HashMap<Node, List<Edge>>();
        this.compartmentPointMap = new HashMap<String, List<GridPoint>>();
        this.compartmentMap = new HashMap<String, List<Node>>();
        this.nodeVector = new Vector();
        this.nodeMap = graph.nodeMap;
        this.edgeMap = graph.edgeMap;
        this.edgeList = graph.edgeList;
        if (this.checkForCompartments(graph)) {
            this.estimateCompartments(graph);
            this.changeLayout(graph);
        } else {
            this.makeGrid(graph);
        }
        this.setWeightMatrix(graph);
        double maxTemp = this.makeTmax(graph);
        int maxAttachment = 0;
        int compNumberOfAnnealingSteps = 0;
        if (this.checkForCompartments(graph)) {
            ++compNumberOfAnnealingSteps;
            for (Node n : graph.nodeList) {
                int delimiterCount;
                if (!n.getAttribute("compartmentName").equals("root") || (delimiterCount = n.getAttribute("compartmentName").length() - n.getAttribute("compartmentName").replaceAll("\\.", "").length() + 1) <= maxAttachment) continue;
                maxAttachment = delimiterCount;
            }
        }
        this.clearRoots(graph);
        int apprNumberOfAnnealingSteps = (int)((Math.log(this.tMin) - Math.log(maxTemp)) / Math.log(this.rc) + 1.0) + 1;
        return apprNumberOfAnnealingSteps + (compNumberOfAnnealingSteps += maxAttachment * compartmentAnnealingSteps + maxAttachment);
    }

    protected void estimateCompartments(Graph graph) {
        this.compartmentMap = new HashMap<String, List<Node>>();
        HashMap<String, Integer> compartmentNodeNumberMap = new HashMap<String, Integer>();
        HashMap<String, Integer[]> compartmentNodeSizeMap = new HashMap<String, Integer[]>();
        HashMap<String, List<Node>> compartmentNodeMap = new HashMap<String, List<Node>>();
        int maxAttachment = 0;
        for (Node n : graph.nodeList) {
            Integer[] dim;
            ArrayList<Node> tempList = new ArrayList<Node>();
            if (Util.isCompartment(n)) {
                String compName;
                if (n.getAttribute("compartmentName") == null || n.getAttribute("compartmentName").equals("root")) {
                    if (!this.compartmentMap.containsKey("0")) {
                        tempList.add(n);
                        this.compartmentMap.put("0", tempList);
                    } else {
                        this.compartmentMap.get("0").add(n);
                    }
                    n.setAttribute("compartmentName", "root");
                    continue;
                }
                int delimiterCount = n.getAttribute("compartmentName").length() - n.getAttribute("compartmentName").replaceAll("\\.", "").length();
                if (delimiterCount > maxAttachment) {
                    maxAttachment = delimiterCount;
                }
                if (!this.compartmentMap.containsKey("" + delimiterCount)) {
                    tempList.add(n);
                    this.compartmentMap.put("" + delimiterCount, tempList);
                } else {
                    this.compartmentMap.get("" + delimiterCount).add(n);
                }
                if ((compName = n.getAttribute("compartmentName")).startsWith("root")) continue;
                n.setAttribute("compartmentName", "root." + n.getAttribute("compartmentName"));
                continue;
            }
            String compName = "root";
            if (n.getAttribute("compartmentName") != null) {
                compName = compName + "." + n.getAttribute("compartmentName");
            }
            n.setAttribute("compartmentName", compName);
            if (!compartmentNodeNumberMap.containsKey(compName)) {
                compartmentNodeNumberMap.put(compName, 1);
                Integer[] dim2 = new Integer[]{n.width, n.height};
                compartmentNodeSizeMap.put(compName, dim2);
                tempList.add(n);
                compartmentNodeMap.put(compName, tempList);
                continue;
            }
            int tempInt = compartmentNodeNumberMap.get(compName) + 1;
            compartmentNodeNumberMap.put(compName, tempInt);
            Integer[] integerArray = dim = compartmentNodeSizeMap.get(compName);
            Integer.valueOf(integerArray[0] + n.width);
            integerArray = dim;
            Integer.valueOf(integerArray[1] + n.height);
            compartmentNodeSizeMap.put(compName, dim);
            compartmentNodeMap.get(compName).add(n);
        }
        if (this.setCompSizesAutomatically) {
            this.defineCompartmentsSizes(maxAttachment, compartmentNodeNumberMap, compartmentNodeSizeMap);
        }
        this.setGrid(compartmentNodeNumberMap, compartmentNodeSizeMap, graph);
        this.setCompartments();
        this.makeWeightMatrix(compartmentNodeMap);
        for (int i = 0; i < this.compartmentMap.size(); ++i) {
            ArrayList<Node> compList = new ArrayList<Node>();
            for (int j = i; j >= 0; --j) {
                compList.addAll((Collection<Node>)this.compartmentMap.get("" + j));
            }
            Graph g = CompartmentCrossCostGridLayouter.createGraph(compList, null);
            if (i != 0) {
                this.nonBaseLevelFirstLayout(g);
            } else {
                this.baseLevelFirstLayout(g);
            }
            this.setNodesFixed(this.compartmentMap.get("" + i), true);
            this.formatGrid(i);
            this.renewCompartmentPointMap();
        }
    }

    protected void clearRoots(Graph graph) {
        for (Node n : graph.nodeList) {
            String compName = n.getAttribute("compartmentName");
            if (compName == null || !compName.startsWith("root")) continue;
            if (compName.equals("root")) {
                n.setAttribute("compartmentName", null);
                continue;
            }
            n.setAttribute("compartmentName", compName.replaceFirst("root.", ""));
        }
    }

    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
    }

    public int getNe() {
        return this.ne;
    }

    public void setNe(int ne) {
        this.ne = ne;
    }

    public double getRc() {
        return this.rc;
    }

    public void setRc(double rc) {
        this.rc = rc;
    }

    public double getProbabilityThreshold() {
        return this.probabilityThreshold;
    }

    public void setProbabilityThreshold(double probabilityThreshold) {
        this.probabilityThreshold = probabilityThreshold;
    }

    public int getSaturationDist() {
        return this.saturationDist;
    }

    public void setSaturationDist(int saturationDist) {
        this.saturationDist = saturationDist;
    }
}

