/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.util.ArrayList;
import java.util.Iterator;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.GreedyLayouter;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.Node;

public class ClusteredGreedyLayouter
extends GreedyLayouter {
    public int threshold = 50;
    protected Graph graph;
    protected ArrayList<StackUnit> stack = new ArrayList();
    protected int averageWidth;
    protected int averageHeight;
    protected boolean shouldCollapse;

    protected void initLayoutData(Graph graph) {
        double sHeight;
        for (Node node : graph.nodeList) {
            GreedyLayouter.LayoutData data = new GreedyLayouter.LayoutData();
            node.data = data;
            data.width = node.width;
            data.height = node.height;
            data.fixed = node.fixed;
        }
        this.averageWidth = 0;
        this.averageHeight = 0;
        int dWidth = 0;
        int dHeight = 0;
        int nodeCount = graph.nodeCount();
        for (Node node : graph.nodeList) {
            this.averageWidth += node.width;
            this.averageHeight += node.height;
            dWidth += node.width * node.width;
            dHeight += node.height * node.height;
        }
        this.averageWidth /= nodeCount;
        this.averageHeight /= nodeCount;
        double sWidth = Math.sqrt(dWidth / nodeCount - this.averageWidth * this.averageWidth) / (double)this.averageWidth;
        this.shouldCollapse = Math.max(sWidth, sHeight = Math.sqrt(dHeight / nodeCount - this.averageHeight * this.averageHeight) / (double)this.averageHeight) < 0.5;
        this.averageWidth = (this.averageWidth + this.layerDeltaX / 2) / this.layerDeltaX * this.layerDeltaX;
        this.averageHeight = (this.averageHeight + this.layerDeltaY / 2) / this.layerDeltaY * this.layerDeltaY;
    }

    protected void collapse() {
        for (int k = 0; k < 20 && this.graph.nodeCount() > this.threshold; ++k) {
            boolean changed = false;
            for (int i = 0; i < this.graph.nodeCount(); ++i) {
                Iterator<Edge> edges;
                Node node = this.graph.nodeAt(i);
                int edgeCount = this.graph.getEdges(node).size();
                if (!this.canCollapse(node, k)) continue;
                if (edgeCount == 1) {
                    changed = true;
                    edges = this.graph.getEdges(node).iterator();
                    Edge edge = edges.next();
                    this.removeEdge(edge);
                    this.removeNode(node);
                    this.updateClusterSize(edge, node, 1.0f);
                    --i;
                    continue;
                }
                if (edgeCount != 2 || k <= 5) continue;
                changed = true;
                edges = this.graph.getEdges(node).iterator();
                Edge e1 = edges.next();
                Edge e2 = edges.next();
                Node from = e1.getFrom() == node ? e1.getTo() : e1.getFrom();
                Node to = e2.getFrom() == node ? e2.getTo() : e2.getFrom();
                this.removeEdge(e1);
                this.removeEdge(e2);
                this.removeNode(node);
                this.addEdge(from, to);
                this.updateClusterSize(e1, node, 0.5f);
                this.updateClusterSize(e2, node, 0.5f);
                --i;
            }
            if (!changed) break;
        }
        for (Node node : this.graph.nodeList) {
            float n = ((GreedyLayouter.LayoutData)node.data).n;
            if (!(n >= 2.0f)) continue;
            node.width += (int)Math.sqrt(n - 1.0f) * (this.averageWidth + this.layerDeltaX);
            node.height += (int)Math.sqrt(n - 1.0f) * (this.averageHeight + this.layerDeltaY);
        }
    }

    protected void removeNode(Node node) {
        this.graph.removeNode(node);
        this.stack.add(new StackUnit(node, true));
    }

    protected void removeEdge(Edge edge) {
        if (edge.slaves != null) {
            for (Edge slave : edge.slaves) {
                this.graph.removeEdge(slave);
                this.stack.add(new StackUnit(slave, true));
            }
        }
        this.graph.removeEdge(edge);
        this.stack.add(new StackUnit(edge, true));
    }

    protected void addEdge(Node from, Node to) {
        if (from == to) {
            return;
        }
        Edge edge = new Edge(from, to);
        this.graph.addEdge(edge);
        this.stack.add(new StackUnit(edge, false));
    }

    protected void updateClusterSize(Edge edge, Node collapsedNode, float weight) {
        Node cluster = edge.getFrom() == collapsedNode ? edge.getTo() : edge.getFrom();
        ((GreedyLayouter.LayoutData)cluster.data).n += ((GreedyLayouter.LayoutData)collapsedNode.data).n * weight;
    }

    protected boolean canCollapse(Node node, int i) {
        float n = ((GreedyLayouter.LayoutData)node.data).n;
        double t = (double)(3 + i * 2) + 0.2 * (double)i * (double)i;
        if ((double)n > t) {
            return false;
        }
        int edgeCount = this.graph.getEdges(node).size();
        if (edgeCount == 1) {
            Iterator<Edge> edges = this.graph.getEdges(node).iterator();
            Edge edge = edges.next();
            Node cluster = edge.getFrom() == node ? edge.getTo() : edge.getFrom();
            return (double)(n += ((GreedyLayouter.LayoutData)cluster.data).n) < t;
        }
        if (edgeCount == 2) {
            Iterator<Edge> edges = this.graph.getEdges(node).iterator();
            Edge e1 = edges.next();
            Edge e2 = edges.next();
            if (!e1.master || !e2.master) {
                return false;
            }
            Node from = e1.getFrom() == node ? e1.getTo() : e1.getFrom();
            Node to = e2.getFrom() == node ? e2.getTo() : e2.getFrom();
            float n1 = n / 2.0f + ((GreedyLayouter.LayoutData)from.data).n;
            float n2 = n / 2.0f + ((GreedyLayouter.LayoutData)to.data).n;
            return (double)n1 < t && (double)n2 < t;
        }
        return false;
    }

    protected void fixNodes() {
        for (Node node : this.graph.nodeList) {
            if (node.data != null) {
                GreedyLayouter.LayoutData data = (GreedyLayouter.LayoutData)node.data;
                int dx = (node.width - data.width) / 2 / this.gridX * this.gridX;
                int dy = (node.height - data.height) / 2 / this.gridY * this.gridY;
                node.x += dx;
                node.y += dy;
                node.width = data.width;
                node.height = data.height;
            }
            node.fixed = true;
        }
    }

    protected void restore() {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            StackUnit unit = this.stack.get(i);
            if (unit.removed) {
                if (unit.node != null) {
                    this.graph.addNode(unit.node);
                    continue;
                }
                this.graph.addEdge(unit.edge);
                continue;
            }
            if (unit.node != null) {
                this.graph.removeNode(unit.node);
                continue;
            }
            this.graph.removeEdge(unit.edge);
        }
        this.stack.clear();
    }

    @Override
    public void doLayout(Graph g, LayoutJobControl lJC) {
        this.graph = g;
        this.initLayoutData(this.graph);
        if (!this.shouldCollapse || this.graph.nodeCount() <= this.threshold) {
            this.layoutNodes(this.graph, lJC);
            this.refineNodes(this.graph, 3);
            this.layoutEdges(this.graph, lJC);
            return;
        }
        this.collapse();
        this.layoutNodes(this.graph, lJC);
        this.fixNodes();
        this.refineNodes(this.graph, 5);
        this.restore();
        this.layoutNodes(this.graph, lJC);
        for (Node node : this.graph.nodeList) {
            if (node.data == null) continue;
            node.fixed = ((GreedyLayouter.LayoutData)node.data).fixed;
        }
        this.refineNodes(this.graph, 5);
        this.layoutEdges(this.graph, lJC);
    }

    protected class StackUnit {
        boolean removed;
        Node node;
        Edge edge;

        StackUnit(Node node, boolean removed) {
            this.node = node;
            this.edge = null;
            this.removed = removed;
        }

        StackUnit(Edge edge, boolean removed) {
            this.node = null;
            this.edge = edge;
            this.removed = removed;
        }
    }
}

