/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import ru.biosoft.graph.Edge;
import ru.biosoft.graph.Node;
import ru.biosoft.graph.PortFinder;

public class CenterPointFinder
implements PortFinder {
    List<Point> points;

    public CenterPointFinder(Rectangle r) {
        int xc = r.width / 2;
        int yc = r.height / 2;
        this.points = new ArrayList<Point>();
        this.points.add(new Point(0, yc));
        this.points.add(new Point(r.width, yc));
        this.points.add(new Point(xc, 0));
        this.points.add(new Point(xc, r.height));
    }

    @Override
    public Point findPort(Node node, Edge edge, int x, int y) {
        Rectangle r = node.getBounds();
        double d = Double.MAX_VALUE;
        Point point = new Point(x, y);
        Point result = new Point(this.points.get((int)0).x + r.x, this.points.get((int)0).y + r.y);
        for (Point availableP : this.points) {
            Point availablePoint = new Point(availableP.x + r.x, availableP.y + r.y);
            double d1 = point.distance(availablePoint);
            if (d1 < d) {
                result = availablePoint;
                d = d1;
                continue;
            }
            if (d1 != d) continue;
            Node node2 = edge.getFrom().equals(node) ? edge.getTo() : edge.getFrom();
            Node anotherNode = node2;
            Rectangle r2 = anotherNode.getBounds();
            Point p2 = new Point((int)r2.getCenterX(), (int)r2.getCenterY());
            if (!(availablePoint.distance(p2) < result.distance(p2))) continue;
            result = availablePoint;
            d = d1;
        }
        return result;
    }
}

