/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.graph;

import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.LayoutJobControl;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graph.PathWeighter;
import ru.biosoft.graph.SubgraphLayouter;

public abstract class AbstractLayouter
implements Layouter {
    protected static final Logger log = Logger.getLogger(AbstractLayouter.class.getName());
    protected boolean adjustReactions = true;
    protected int operationsDone = 0;
    protected PathWeighter pathWeighter = new PathWeighter();
    protected SubgraphLayouter sl = new SubgraphLayouter();
    protected PathLayouterWrapper pathLayouterWrapper = null;

    public PathWeighter getPathWeighter() {
        return this.pathWeighter;
    }

    public void setPathWeighter(PathWeighter pathWeighter) {
        this.pathWeighter = pathWeighter;
    }

    public SubgraphLayouter getSubgraphLayouter() {
        return this.sl;
    }

    public void setSubgraphLayouter(SubgraphLayouter subgraphLayouter) {
        this.sl = subgraphLayouter;
    }

    protected Layouter getPathLayouter() {
        return this.pathLayouterWrapper.getPathLayouter();
    }

    public PathLayouterWrapper getPathLayouterWrapper() {
        return this.pathLayouterWrapper;
    }

    public void setPathLayouterWrapper(PathLayouterWrapper pathLayouterWrapper) {
        this.pathLayouterWrapper = pathLayouterWrapper;
    }

    public boolean isAdjustReactions() {
        return this.adjustReactions;
    }

    public void setAdjustReactions(boolean adjustReactions) {
        this.adjustReactions = adjustReactions;
    }

    @Override
    public void doLayout(Graph graph, LayoutJobControl lJC) {
        long time = System.currentTimeMillis();
        if (lJC != null) {
            lJC.begin();
        }
        this.operationsDone = 0;
        if (graph.isConnected()) {
            this.layoutNodes(graph, lJC);
            this.layoutEdges(graph, lJC);
        } else {
            this.sl.doLayout(this, graph, lJC);
        }
        log.log(Level.FINE, "Layout time " + (System.currentTimeMillis() - time));
    }

    abstract void layoutNodes(Graph var1, LayoutJobControl var2);

    @Override
    public abstract void layoutEdges(Graph var1, LayoutJobControl var2);
}

