/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.web;

import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.web.ActionInitializer;
import com.developmentontheedge.beans.web.HtmlBeanGenerator;
import com.developmentontheedge.beans.web.HtmlFormatter;
import com.developmentontheedge.beans.web.HtmlPane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;

public class HtmlPropertyInspector
extends HtmlPane {
    private static final long serialVersionUID = 1L;
    public static final String SUBSTITUTE_BY_CHILD = "html-substitute-by-child";
    public static final String SUBSTITUTE_BY_CHILD_VALUE = "html-substitute-by-child-value";
    public static final String DISPLAY_NAME = "html-display-name";
    public static final String HTML_GENERATOR_METHOD = "html-genertor-method";
    public static final String PROPERTY_EDITOR_CLASS = "html-property-editor";
    protected JToolBar toolbar = new JToolBar();
    protected HtmlBeanGenerator htmlGenerator;
    protected Object bean;
    private ComponentModel model;
    public static final String SHOW_EXPERT_ACTION = "SHOW_EXPERT_ACTION";
    protected Action showExpertAction;

    public static String getDisplayName(FeatureDescriptor pd) {
        return (String)pd.getValue(DISPLAY_NAME);
    }

    public static void setDisplayName(FeatureDescriptor pd, String displayName) {
        pd.setValue(DISPLAY_NAME, displayName);
    }

    public static Method getHtmlGeneratorMethod(FeatureDescriptor pd) {
        return (Method)pd.getValue(HTML_GENERATOR_METHOD);
    }

    public static void setHtmlGeneratorMethod(FeatureDescriptor pd, Method method) {
        pd.setValue(HTML_GENERATOR_METHOD, method);
    }

    public static Class<?> getPropertyEditorClass(FeatureDescriptor pd) {
        return (Class)pd.getValue(PROPERTY_EDITOR_CLASS);
    }

    public static void setPropertyEditorClass(FeatureDescriptor pd, Class propertyEditorClass) {
        pd.setValue(PROPERTY_EDITOR_CLASS, propertyEditorClass);
    }

    public HtmlPropertyInspector() {
        this.toolbar.setVisible(false);
        this.toolbar.setFloatable(false);
        this.fillToolbar();
        this.add("North", this.toolbar);
        this.htmlGenerator = new HtmlBeanGenerator();
    }

    public void explore(Object bean) {
        this.bean = bean;
        String result = "";
        if (bean != null) {
            try {
                this.model = ComponentFactory.getModel(bean, ComponentFactory.Policy.DEFAULT, true);
                Method method = HtmlPropertyInspector.getHtmlGeneratorMethod(this.model.getDescriptor());
                result = method != null ? (String)method.invoke(bean, (Object[])null) : this.htmlGenerator.generate(this.model);
            }
            catch (Throwable t) {
                Logger.getLogger().error("Bean explore error, bean=" + bean + ". ", t);
            }
        }
        this.setInitialText(result);
    }

    public void setInitialText(String text) {
        super.setInitialText(text);
        this.toolbar.setVisible(text != null && !"".equals(text.trim()));
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        String link = e.getDescription();
        if (link.startsWith("property_description")) {
            String text = this.getPropertyDesription(link);
            if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                this.editor.setToolTipText("<html><body>" + text + "</body></html>");
            } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.followHyperlink(text);
            } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.editor.setToolTipText(null);
            }
            return;
        }
        super.hyperlinkUpdate(e);
    }

    protected String getPropertyDesription(String link) {
        int pos = link.indexOf("/");
        String name = link.substring(pos + 1);
        Property property = this.model.findProperty(name);
        if (property != null) {
            return property.getDescriptor().getShortDescription();
        }
        return "Error: property description for property " + name + " not found.";
    }

    public JComponent getView() {
        return this.scrollPane;
    }

    @Override
    public Action[] getActions() {
        return this.actions;
    }

    public Object getExploredBean() {
        return this.bean;
    }

    public int getPropertyShowMode() {
        return this.htmlGenerator.getPropertyShowMode();
    }

    public void setPropertyShowMode(int propertyShowMode) {
        this.htmlGenerator.setPropertyShowMode(propertyShowMode);
        this.explore(this.bean);
    }

    public boolean isShowEmptyValues() {
        return this.htmlGenerator.isShowEmptyValues();
    }

    public void setShowEmptyValues(boolean showEmptyValues) {
        this.htmlGenerator.setShowEmptyValues(showEmptyValues);
    }

    public HtmlFormatter getHtmlFormatter() {
        return this.htmlGenerator.getHtmlFormatter();
    }

    public void setHtmlFormatter(HtmlFormatter formatter) {
        this.htmlGenerator.setHtmlFormatter(formatter);
        this.explore(this.bean);
    }

    private void fillToolbar() {
        for (int i = 0; i < this.actions.length; ++i) {
            Action action = this.actions[i];
            AbstractButton button = action == this.showExpertAction ? new JToggleButton(action) : new JButton(action);
            button.setAlignmentY(0.5f);
            Dimension btnSize = new Dimension(25, 25);
            button.setSize(btnSize);
            button.setPreferredSize(btnSize);
            button.setMinimumSize(btnSize);
            button.setMaximumSize(btnSize);
            if (button.getIcon() != null) {
                button.setText(null);
            }
            this.toolbar.add(button);
        }
    }

    @Override
    protected void initActions() {
        super.initActions();
        this.showExpertAction = new ShowExpertAction(SHOW_EXPERT_ACTION);
        this.showExpertAction.setEnabled(false);
        ActionInitializer.initAction(this.showExpertAction, SHOW_EXPERT_ACTION);
        this.actions = new Action[]{this.backwardAction, this.forwardAction};
    }

    class ShowExpertAction
    extends AbstractAction {
        public ShowExpertAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mode = HtmlPropertyInspector.this.getPropertyShowMode();
            if (mode == 0) {
                HtmlPropertyInspector.this.setPropertyShowMode(0);
            } else {
                HtmlPropertyInspector.this.setPropertyShowMode(1);
            }
        }
    }
}

