/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.web;

import com.developmentontheedge.beans.web.ActionInitializer;
import com.developmentontheedge.beans.web.resources.MessageBundle;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlPane
extends JPanel
implements HyperlinkListener {
    protected JEditorPane editor;
    protected JScrollPane scrollPane;
    protected ArrayList<Object> hyperlinkList = new ArrayList();
    protected int curListIndex;
    public static final String FORWARD_ACTION = "FORWARD_ACTION";
    public static final String BACKWARD_ACTION = "BACKWARD_ACTION";
    protected Action[] actions;
    protected Action forwardAction;
    protected Action backwardAction;

    public HtmlPane() {
        this.initActions();
        this.editor = new JEditorPane("text/html", ""){

            @Override
            public void doLayout() {
                try {
                    super.doLayout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        this.editor.addHyperlinkListener(this);
        this.editor.setEditable(false);
        this.scrollPane = new JScrollPane(this.editor);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane);
    }

    public void setInitialText(Object data) {
        this.setText(data);
        this.hyperlinkList.clear();
        this.hyperlinkList.add(data);
        this.curListIndex = 0;
        this.forwardAction.setEnabled(false);
        this.backwardAction.setEnabled(false);
    }

    protected void setText(Object data) {
        if (data instanceof String) {
            this.editor.setText((String)data);
            this.editor.setCaretPosition(0);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            try {
                this.editor.setPage((URL)data);
            }
            catch (Throwable t) {
                String text = "Invalid link: " + url + "<br>Error: " + t;
                this.editor.setText(text);
            }
        } else {
            this.editor.setText("Data=" + data);
            this.editor.setCaretPosition(0);
        }
    }

    public Action getForwardAction() {
        return this.forwardAction;
    }

    public boolean isForwardActionEnabled() {
        return this.curListIndex < this.hyperlinkList.size() - 1;
    }

    public Action getBackwardAction() {
        return this.backwardAction;
    }

    public boolean isBackwardActionEnabled() {
        return this.curListIndex > 0;
    }

    public JEditorPane getEditor() {
        return this.editor;
    }

    public Action[] getActions() {
        return this.actions;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
            this.followHyperlink(e.getURL());
        }
    }

    protected void followHyperlink(Object data) {
        if (this.curListIndex + 1 < this.hyperlinkList.size()) {
            for (int i = this.hyperlinkList.size() - 1; i > this.curListIndex; --i) {
                this.hyperlinkList.remove(i);
            }
        }
        this.setText(data);
        this.hyperlinkList.add(data);
        ++this.curListIndex;
        this.backwardAction.setEnabled(this.isBackwardActionEnabled());
        this.forwardAction.setEnabled(this.isForwardActionEnabled());
    }

    protected void initActions() {
        this.backwardAction = new BackwardAction(BACKWARD_ACTION);
        this.forwardAction = new ForwardAction(FORWARD_ACTION);
        ActionInitializer.init(MessageBundle.class.getName(), MessageBundle.class);
        ActionInitializer.initAction(this.backwardAction, BACKWARD_ACTION);
        ActionInitializer.initAction(this.forwardAction, FORWARD_ACTION);
        this.actions = new Action[]{this.backwardAction, this.forwardAction};
        for (int i = 0; i < this.actions.length; ++i) {
            Action action = this.actions[i];
            action.setEnabled(false);
        }
    }

    class ForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ForwardAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HtmlPane.this.curListIndex < HtmlPane.this.hyperlinkList.size() - 1) {
                ++HtmlPane.this.curListIndex;
                HtmlPane.this.setText(HtmlPane.this.hyperlinkList.get(HtmlPane.this.curListIndex));
                HtmlPane.this.backwardAction.setEnabled(true);
            }
            HtmlPane.this.forwardAction.setEnabled(HtmlPane.this.curListIndex < HtmlPane.this.hyperlinkList.size() - 1);
        }
    }

    class BackwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public BackwardAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HtmlPane.this.curListIndex > 0) {
                --HtmlPane.this.curListIndex;
                HtmlPane.this.setText(HtmlPane.this.hyperlinkList.get(HtmlPane.this.curListIndex));
                HtmlPane.this.forwardAction.setEnabled(true);
            }
            HtmlPane.this.backwardAction.setEnabled(HtmlPane.this.curListIndex > 0);
        }
    }
}

