/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.web;

import com.developmentontheedge.beans.editors.PropertyEditorEx;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.web.HtmlFormatter;
import com.developmentontheedge.beans.web.HtmlPropertyInspector;
import com.developmentontheedge.beans.web.SimpleHtmlFormatter;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.io.StringWriter;
import java.io.Writer;

public class HtmlBeanGenerator {
    HtmlFormatter formatter = new SimpleHtmlFormatter();
    private int propertyShowMode = 4;
    boolean showEmptyValues = false;

    public HtmlFormatter getHtmlFormatter() {
        return this.formatter;
    }

    public void setHtmlFormatter(HtmlFormatter formatter) {
        this.formatter = formatter;
    }

    public int getPropertyShowMode() {
        return this.propertyShowMode;
    }

    public void setPropertyShowMode(int propertyShowMode) {
        this.propertyShowMode = propertyShowMode;
    }

    public boolean isShowEmptyValues() {
        return this.showEmptyValues;
    }

    public void setShowEmptyValues(boolean showEmptyValues) {
        this.showEmptyValues = showEmptyValues;
    }

    public String generate(Object bean) throws Exception {
        StringWriter writer = new StringWriter();
        this.generate(bean, (Writer)writer);
        return writer.toString();
    }

    public void generate(Object bean, Writer out) throws Exception {
        if (bean == null) {
            return;
        }
        ComponentModel model = ComponentFactory.getModel(bean, ComponentFactory.Policy.DEFAULT, true);
        this.generate(model, out);
    }

    String generate(ComponentModel model) throws Exception {
        StringWriter writer = new StringWriter();
        this.generate(model, (Writer)writer);
        return writer.toString();
    }

    void generate(ComponentModel model, Writer out) throws Exception {
        this.formatter.generateHeader(out, model.getDisplayName());
        int limit = model.getVisibleCount(this.propertyShowMode);
        for (int i = 0; i < limit; ++i) {
            Property property = model.getVisiblePropertyAt(i, this.propertyShowMode);
            if (HtmlBeanGenerator.isJavaClassProperty(property)) continue;
            this.generateProperty(out, property, 0);
        }
        this.formatter.generateFooter(out);
    }

    void generateProperty(Writer out, Property prop, int level) throws Exception {
        Object propertyValue;
        Property childProp;
        FeatureDescriptor pd = prop.getDescriptor();
        String stringValue = "&nbsp;";
        String displayName = HtmlPropertyInspector.getDisplayName(pd);
        if (displayName == null) {
            displayName = prop.getDisplayName();
        }
        boolean readOnly = prop.isReadOnly();
        boolean canBeNull = prop.getBooleanAttribute("can-be-null");
        String child = (String)pd.getValue("html-substitute-by-child");
        if (child != null) {
            childProp = prop.findProperty(child);
            if (childProp != null) {
                this.generateProperty(out, childProp, level);
                return;
            }
            Logger.getLogger().error("Can not find property '" + child + "' to substitute parent '" + prop.getName());
        }
        if ((child = (String)pd.getValue("html-substitute-by-child-value")) != null) {
            childProp = prop.findProperty(child);
            if (childProp != null) {
                prop = childProp;
            } else {
                Logger.getLogger().error("Can not find property '" + child + "' to substitute parent '" + prop.getName());
            }
        }
        if ((propertyValue = prop.getValue()) == null && !this.showEmptyValues) {
            return;
        }
        if (propertyValue != null) {
            PropertyEditor editor = this.getPropertyEditor(prop);
            if (editor != null) {
                stringValue = editor.getAsText();
            } else if (prop.isLeaf()) {
                stringValue = propertyValue.toString();
            }
        }
        this.formatter.generateProperty(out, level, displayName, prop.getCompleteName(), stringValue, readOnly, canBeNull);
        int count = prop.getVisibleCount(this.propertyShowMode);
        if (count > 0) {
            this.formatter.generateLevelStart(out, ++level);
            for (int i = 0; i < count; ++i) {
                Property property = prop.getVisiblePropertyAt(i, this.propertyShowMode);
                if (property.getName().equals("class")) continue;
                this.generateProperty(out, property, level);
            }
            this.formatter.generateLevelEnd(out, level);
            --level;
        }
    }

    PropertyEditor getPropertyEditor(Property property) {
        FeatureDescriptor fd = property.getDescriptor();
        Class<?> editorClass = HtmlPropertyInspector.getPropertyEditorClass(fd);
        if (editorClass == null) {
            editorClass = property.getPropertyEditorClass();
        }
        if (editorClass != null) {
            try {
                PropertyEditor editor = (PropertyEditor)editorClass.newInstance();
                Object value = property.getValue();
                editor.setValue(value);
                if (editor instanceof PropertyEditorEx) {
                    Object owner = property.getOwner();
                    if (owner instanceof Property.PropWrapper) {
                        owner = ((Property.PropWrapper)owner).getOwner();
                    }
                    ((PropertyEditorEx)editor).setBean(owner);
                    ((PropertyEditorEx)editor).setDescriptor(property.getDescriptor());
                }
                return editor;
            }
            catch (Exception ex) {
                Logger.getLogger().error("Error when getting editor", ex);
            }
        }
        return null;
    }

    public static boolean isJavaClassProperty(Property property) {
        if (!property.getName().equals("class")) {
            return false;
        }
        return !(property.getOwner() instanceof Property.PropWrapper) || ((Property.PropWrapper)property.getOwner()).getOwner() == null;
    }
}

