/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.web;

import com.developmentontheedge.beans.log.Logger;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ActionInitializer {
    protected static ResourceBundle resources;
    protected static Class<?> loader;

    public static void init(String resourceBundleName, Class<?> l) {
        ActionInitializer.initResourceBundle(resourceBundleName, l);
    }

    public static void init(ResourceBundle r, Class<?> l) {
        resources = r;
        loader = l;
    }

    public static void initAction(Action action, String key) {
        Object obj;
        URL url;
        ActionInitializer.initActionValue(action, "Name", key + "Name");
        ActionInitializer.initActionValue(action, "ShortDescription", key + "ShortDescription");
        ActionInitializer.initActionValue(action, "LongDescription", key + "LongDescription");
        ActionInitializer.initActionValue(action, "ActionCommandKey", key + "ActionCommandKey");
        String value = ActionInitializer.getResourceString(key + "MnemonicKey");
        if (value != null) {
            action.putValue("MnemonicKey", new Integer(value.charAt(0)));
        }
        if ((url = ActionInitializer.getResource(key + "SmallIcon")) != null) {
            action.putValue("SmallIcon", new ImageIcon(url));
        }
        if ((obj = ActionInitializer.getResourceObject(key + "AcceleratorKey")) instanceof KeyStroke) {
            action.putValue("AcceleratorKey", obj);
        }
    }

    public static void initActionValue(Action action, String actionKey, String resourceKey) {
        String value = ActionInitializer.getResourceString(resourceKey);
        if (value != null) {
            action.putValue(actionKey, value);
        }
    }

    public static void initResourceBundle(String resourceBundlename, Class<?> l) {
        try {
            loader = l;
            resources = ResourceBundle.getBundle(resourceBundlename, Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            Logger.getLogger().error(ActionInitializer.class + " properties not found. " + mre);
        }
    }

    protected static Object getResourceObject(String nm) {
        Object obj = null;
        if (resources == null) {
            Logger.getLogger().error(ActionInitializer.class + " resource bundle not init.");
        } else {
            try {
                obj = resources.getObject(nm);
            }
            catch (MissingResourceException mre) {
                Logger.getLogger().warn("Missing resource <" + nm + "> in " + ActionInitializer.class);
            }
        }
        return obj;
    }

    protected static String getResourceString(String nm) {
        String str = null;
        if (resources == null) {
            Logger.getLogger().error(ActionInitializer.class + " resource bundle not init.");
        } else {
            try {
                str = resources.getString(nm);
            }
            catch (MissingResourceException mre) {
                Logger.getLogger().warn("Missing resource <" + nm + "> in " + ActionInitializer.class);
            }
        }
        return str;
    }

    public static URL getResource(String key) {
        String name = ActionInitializer.getResourceString(key);
        if (name != null) {
            URL url = loader.getResource(name);
            return url;
        }
        return null;
    }
}

