/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.util;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Entity;
import javax.swing.text.html.parser.ParserDelegator;

public class HtmlUtil {
    private static DTD dtd;
    private static final Pattern entityPattern;
    private static final Pattern stripHtmlPattern;

    public static String convertEntity(String entity) {
        if (entity.startsWith("#")) {
            try {
                int code = entity.startsWith("#x") ? Integer.parseInt(entity.substring(2), 16) : Integer.parseInt(entity.substring(1));
                return new String(new int[]{code}, 0, 1);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        Entity entityValue = dtd.getEntity(entity);
        if (entityValue != null) {
            return entityValue.getString();
        }
        return null;
    }

    public static String stripHtml(String html) {
        Matcher matcher;
        if (html == null) {
            return null;
        }
        html = stripHtmlPattern.matcher(html).replaceAll("");
        while ((matcher = entityPattern.matcher(html)).find()) {
            String entity = matcher.group(1);
            String entityValue = HtmlUtil.convertEntity(entity);
            if (entityValue != null) {
                html = matcher.replaceFirst(entityValue);
                continue;
            }
            html = matcher.replaceFirst("[" + entity + "]");
        }
        return html;
    }

    static {
        entityPattern = Pattern.compile("&(\\#?[\\w]+);");
        stripHtmlPattern = Pattern.compile("<[^>]+>");
        try {
            new ParserDelegator();
            dtd = DTD.getDTD("html32");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

