/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.util;

import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Beans {
    private static ConcurrentHashMap<Class<?>, Map<String, BeanPropertyAccessor>> accessors = new ConcurrentHashMap();

    public static void copyBean(Object src, Object dst) {
        if (src == null || dst == null) {
            return;
        }
        ComponentModel srcModel = ComponentFactory.getModel(src, ComponentFactory.Policy.DEFAULT);
        ComponentModel dstModel = ComponentFactory.getModel(dst, ComponentFactory.Policy.DEFAULT);
        for (int i = 0; i < srcModel.getPropertyCount(); ++i) {
            Property srcProperty = srcModel.getPropertyAt(i);
            Property dstProperty = dstModel.findProperty(srcProperty.getName());
            if (dstProperty == null) continue;
            try {
                dstProperty.setValue(srcProperty.getValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectPropertyAccessor getBeanPropertyAccessor(Object bean, String propertyName) throws IntrospectionException {
        String[] components = propertyName.split("/", -1);
        BeanPropertyAccessor accessor = null;
        for (String component : components) {
            if (accessor != null) {
                try {
                    bean = accessor.get(bean);
                }
                catch (Exception e) {
                    throw new IntrospectionException("Unable to read property from bean " + bean + " (path: " + propertyName + "); error: " + e.getMessage());
                }
            }
            if (bean == null) {
                throw new IntrospectionException("Null object encountered during the property introspection (path: " + propertyName + ")");
            }
            if (bean instanceof DynamicPropertySet) {
                accessor = new DynamicPropertyAccessor(component);
                continue;
            }
            if (bean.getClass().isArray()) {
                accessor = new ArrayAccessor(component);
                continue;
            }
            Map<String, BeanPropertyAccessor> classAccessors = accessors.get(bean.getClass());
            if (classAccessors == null) {
                classAccessors = new HashMap<String, BeanPropertyAccessor>();
                Map<String, BeanPropertyAccessor> oldClassAccessors = accessors.putIfAbsent(bean.getClass(), classAccessors);
                if (oldClassAccessors != null) {
                    classAccessors = oldClassAccessors;
                }
            }
            Map<String, BeanPropertyAccessor> map = classAccessors;
            synchronized (map) {
                accessor = classAccessors.get(component);
                if (accessor == null) {
                    ComponentModel model = ComponentFactory.getModel(bean, ComponentFactory.Policy.DEFAULT);
                    Property property = model.findProperty(component);
                    if (property == null) {
                        throw new IntrospectionException("Cannot find property " + component + " in object of class " + bean.getClass() + " (full requested property path: " + propertyName + ")");
                    }
                    accessor = new ReflectionAccessor((PropertyDescriptor)property.getDescriptor());
                    classAccessors.put(propertyName, accessor);
                }
            }
        }
        return new ObjectPropertyAccessor(accessor, bean);
    }

    public static Object getBeanPropertyValue(Object bean, String propertyName) throws BeanException {
        try {
            return Beans.getBeanPropertyAccessor(bean, propertyName).get();
        }
        catch (Exception e) {
            throw new BeanException(e, bean, propertyName, "reading");
        }
    }

    public static void setBeanPropertyValue(Object bean, String propertyName, Object value) throws BeanException {
        try {
            Beans.getBeanPropertyAccessor(bean, propertyName).set(value);
        }
        catch (Exception e) {
            throw new BeanException(e, bean, propertyName, "writing");
        }
    }

    public static Class<?> getBeanPropertyType(Object bean, String propertyName) throws BeanException {
        try {
            return Beans.getBeanPropertyAccessor(bean, propertyName).getType();
        }
        catch (IntrospectionException e) {
            throw new BeanException(e, bean, propertyName, "reading type of");
        }
    }

    public static class ObjectPropertyAccessor {
        private final Object bean;
        private final BeanPropertyAccessor primary;

        public ObjectPropertyAccessor(BeanPropertyAccessor primary, Object bean) {
            this.bean = bean;
            this.primary = primary;
        }

        public Object get() throws Exception {
            return this.primary.get(this.bean);
        }

        public void set(Object value) throws Exception {
            this.primary.set(this.bean, value);
        }

        public Class<?> getType() {
            return this.primary.getType(this.bean);
        }
    }

    private static class DynamicPropertyAccessor
    implements BeanPropertyAccessor {
        private final String propertyName;

        public DynamicPropertyAccessor(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public Object get(Object bean) throws Exception {
            return ((DynamicPropertySet)bean).getValue(this.propertyName);
        }

        @Override
        public void set(Object bean, Object value) throws Exception {
            ((DynamicPropertySet)bean).setValue(this.propertyName, value);
        }

        @Override
        public Class<?> getType(Object bean) {
            return ((DynamicPropertySet)bean).getType(this.propertyName);
        }
    }

    private static class ArrayAccessor
    implements BeanPropertyAccessor {
        int index;

        public ArrayAccessor(String propertyName) {
            if (!propertyName.startsWith("[") || !propertyName.endsWith("]")) {
                throw new RuntimeException("Trying to access array property with invalid property name " + propertyName);
            }
            try {
                this.index = Integer.parseInt(propertyName.substring(1, propertyName.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Trying to access array property with invalid property name " + propertyName);
            }
        }

        @Override
        public Object get(Object bean) throws Exception {
            return Array.get(bean, this.index);
        }

        @Override
        public void set(Object bean, Object value) throws Exception {
            Array.set(bean, this.index, value);
        }

        @Override
        public Class<?> getType(Object bean) {
            return bean.getClass().getComponentType();
        }
    }

    private static class ReflectionAccessor
    implements BeanPropertyAccessor {
        private final Method readMethod;
        private final Method writeMethod;

        public ReflectionAccessor(PropertyDescriptor pd) {
            this.readMethod = pd.getReadMethod();
            if (this.readMethod != null) {
                this.readMethod.setAccessible(true);
            }
            this.writeMethod = pd.getWriteMethod();
            if (this.writeMethod != null) {
                this.writeMethod.setAccessible(true);
            }
        }

        @Override
        public Object get(Object bean) throws ReflectiveOperationException {
            if (this.readMethod == null) {
                throw new IllegalArgumentException("Read method is not found");
            }
            return this.readMethod.invoke(bean, new Object[0]);
        }

        @Override
        public void set(Object bean, Object value) throws ReflectiveOperationException {
            if (this.writeMethod == null) {
                throw new IllegalArgumentException("Write method is not found");
            }
            this.writeMethod.invoke(bean, value);
        }

        @Override
        public Class<?> getType(Object bean) {
            if (this.readMethod == null) {
                throw new IllegalArgumentException("Read method is not found");
            }
            return this.readMethod.getReturnType();
        }
    }

    private static interface BeanPropertyAccessor {
        public Object get(Object var1) throws Exception;

        public void set(Object var1, Object var2) throws Exception;

        public Class<?> getType(Object var1);
    }

    public static class BeanException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BeanException(Throwable cause, Object bean, String propertyName, String what) {
            super("Error " + what + " property '" + propertyName + "' of " + bean + ": " + cause.getMessage(), cause);
        }
    }
}

