/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.undo;

import com.developmentontheedge.beans.undo.Transaction;
import com.developmentontheedge.beans.undo.TransactionEvent;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class TransactionUndoManager
extends UndoManager
implements TransactionListener {
    protected Transaction currentTransaction;
    protected boolean undoInProgress = false;

    protected Transaction createTransaction(TransactionEvent te) {
        return new Transaction(te);
    }

    protected TransactionEvent createTransactionEvent(String name) {
        return new TransactionEvent(this, name);
    }

    public boolean hasTransaction() {
        return this.currentTransaction != null;
    }

    @Override
    public synchronized void startTransaction(TransactionEvent te) {
        if (this.currentTransaction != null && !this.currentTransaction.isEmpty()) {
            this.completeTransaction();
        }
        this.currentTransaction = this.createTransaction(te);
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (this.undoInProgress) {
            return false;
        }
        if (this.currentTransaction != null) {
            return this.currentTransaction.addEdit(anEdit);
        }
        if (anEdit instanceof Transaction) {
            return super.addEdit(anEdit);
        }
        this.startTransaction(this.createTransactionEvent(anEdit.getPresentationName()));
        this.currentTransaction.addEdit(anEdit);
        this.completeTransaction();
        return true;
    }

    @Override
    public synchronized void completeTransaction() {
        if (this.currentTransaction != null) {
            this.currentTransaction.end();
            if (this.currentTransaction.getEdits().size() > 0) {
                super.addEdit(this.currentTransaction);
            }
            this.currentTransaction = null;
        }
    }

    public List<UndoableEdit> getEdits() {
        return Collections.unmodifiableList(this.edits);
    }

    public void setTransactionComment(String comment) {
        if (this.currentTransaction != null) {
            this.currentTransaction.setComment(comment);
        }
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        this.completeTransaction();
        this.undoInProgress = true;
        try {
            super.redo();
        }
        finally {
            this.undoInProgress = false;
        }
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        this.completeTransaction();
        this.undoInProgress = true;
        try {
            super.undo();
        }
        finally {
            this.undoInProgress = false;
        }
    }
}

