/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.undo;

import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import java.beans.PropertyChangeEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class PropertyChangeUndo
extends AbstractUndoableEdit {
    PropertyChangeEvent pce;

    public PropertyChangeUndo(Object source, String propertyName, Object oldValue, Object newValue) {
        this(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
    }

    public PropertyChangeUndo(PropertyChangeEvent pce) {
        this.pce = pce;
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            super.undo();
            this.getProperty().setValue(this.pce.getOldValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            super.redo();
            this.getProperty().setValue(this.pce.getNewValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getSource() {
        return this.pce.getSource();
    }

    public Object getOldValue() {
        return this.pce.getOldValue();
    }

    public Object getNewValue() {
        return this.pce.getNewValue();
    }

    public String getPropertyName() {
        return this.pce.getPropertyName();
    }

    public Property getProperty() {
        Object source = this.pce.getSource();
        ComponentModel model = ComponentFactory.getModel(source, ComponentFactory.Policy.UI, true);
        String name = this.pce.getPropertyName();
        return model.findProperty(name);
    }

    @Override
    public String getPresentationName() {
        return "Change property '" + this.pce.getPropertyName() + "' of '" + this.pce.getSource() + "'";
    }

    public void setUndone() {
        try {
            super.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }
}

