/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing.table;

import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.table.BeanTableModelAdapter;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnModel;
import com.developmentontheedge.beans.swing.table.RowHeaderBean;
import com.developmentontheedge.beans.swing.table.RowModel;
import com.developmentontheedge.beans.swing.table.RowModelEvent;
import com.developmentontheedge.beans.swing.table.SortedTableModel;
import com.developmentontheedge.beans.swing.table.TableSorter;
import java.beans.PropertyChangeEvent;
import javax.swing.event.TableModelEvent;

public class SortedBeanTableModelAdapter
extends BeanTableModelAdapter
implements SortedTableModel {
    private Integer[] indices = null;
    private TableSorter sorter = null;

    public SortedBeanTableModelAdapter(RowModel rm, ColumnModel columnModel) {
        super(rm, columnModel);
        if (columnModel != null) {
            columnModel.setSortEnabled(true);
        }
    }

    public Integer[] getIndices() {
        int n = this.rm.size();
        if (this.indices == null || this.indices.length != n) {
            this.indices = new Integer[n];
            for (int i = 0; i < n; ++i) {
                this.indices[i] = new Integer(i);
            }
        }
        return this.indices;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Property property = null;
        if (column == 0 && this.getRowHeader()) {
            RowHeaderBean rowHeaderBean = new RowHeaderBean();
            rowHeaderBean.setNumber(row);
            ComponentModel rowHeaderModel = ComponentFactory.getModel(rowHeaderBean, ComponentFactory.Policy.UI);
            property = rowHeaderModel.findProperty("number");
        } else {
            if (this.indices != null) {
                row = this.indices[row];
            }
            property = this.getPropertyAt(row, column);
        }
        return property;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.indices != null) {
            row = this.indices[row];
        }
        super.setValueAt(aValue, row, column);
    }

    public int getVisibleColumnIndex(Column column) {
        Column[] columns;
        int cnt;
        int n = cnt = this.getRowHeader() ? 1 : 0;
        if (this.columnModel != null && (columns = this.columnModel.getColumns()) != null) {
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].getEnabled()) continue;
                if (columns[i] == column) {
                    return cnt;
                }
                ++cnt;
            }
        }
        return -1;
    }

    @Override
    public Object getModelForRow(int row) {
        row = this.indices == null ? row : this.indices[row];
        return row < 0 ? null : this.rm.getBean(row);
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String name = evt.getPropertyName();
        if (evt.getSource() != this.columnModel && name.equals("sorting")) {
            Column column = (Column)evt.getSource();
            if (!column.getEnabled()) {
                return;
            }
            this.sort();
        }
    }

    @Override
    public synchronized void tableChanged(RowModelEvent evt) {
        this.indices = null;
        super.tableChanged(evt);
        this.sort();
    }

    @Override
    public void sort() {
        if (this.sorter == null) {
            this.sorter = new TableSorter(this);
        }
        this.sorter.sort();
        this.fireTableDataChanged();
        this.fireTableChanged(new TableModelEvent(this, -1));
    }
}

