/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing.table;

import com.developmentontheedge.beans.swing.table.BevelArrowIcon;
import com.developmentontheedge.beans.swing.table.BlankIcon;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnWithSort;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    private static int FONT_SIZE = 12;
    private final JButton downButton;
    private final JButton upButton;
    private final Column fieldOptions;

    public SortButtonRenderer(Column fieldOptions) {
        this.fieldOptions = fieldOptions;
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(2);
        this.setIcon(new BlankIcon());
        Font font = new Font("Arial", 0, FONT_SIZE);
        this.setFont(font);
        this.downButton = new JButton();
        this.downButton.setFont(font);
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.setHorizontalTextPosition(2);
        this.downButton.setIcon(new BevelArrowIcon(1, false, false));
        this.downButton.setPressedIcon(new BevelArrowIcon(1, false, true));
        this.upButton = new JButton();
        this.upButton.setFont(font);
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setHorizontalTextPosition(2);
        this.upButton.setIcon(new BevelArrowIcon(0, false, false));
        this.upButton.setPressedIcon(new BevelArrowIcon(0, false, true));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JButton button = this;
        if (this.fieldOptions instanceof ColumnWithSort) {
            switch (((ColumnWithSort)this.fieldOptions).getSorting()) {
                case 1: {
                    button = this.upButton;
                    break;
                }
                case 2: {
                    button = this.downButton;
                }
            }
        }
        button.setText(value == null ? "" : value.toString());
        return button;
    }
}

