/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing.table;

import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnWithSort;
import com.developmentontheedge.beans.swing.table.SortedBeanTableModelAdapter;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class RowComparator
implements Comparator {
    private final SortedBeanTableModelAdapter model;
    private final Vector<Column> sortFieldOptions = new Vector();

    public RowComparator(SortedBeanTableModelAdapter model) {
        this.model = model;
    }

    public void add(Column column) {
        if (this.sortFieldOptions.indexOf(column) == -1) {
            this.sortFieldOptions.add(column);
        }
    }

    public int compare(Object o1, Object o2) {
        int result = 0;
        Integer i1 = (Integer)o1;
        Integer i2 = (Integer)o2;
        Iterator<Column> iter = this.sortFieldOptions.iterator();
        while (result == 0 && iter.hasNext()) {
            ColumnWithSort column = (ColumnWithSort)iter.next();
            int colIndex = this.model.getVisibleColumnIndex(column);
            int asc = column.getSorting() == 2 ? -1 : 1;
            Property property1 = this.model.getPropertyAt(i1, colIndex);
            Property property2 = this.model.getPropertyAt(i2, colIndex);
            result = asc * this.compare(property1, property2);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    protected int compare(Property o1, Property o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Object value1 = o1.getValue();
        Object value2 = o2.getValue();
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        Class<?> type = value1.getClass();
        if (type.getSuperclass() == Number.class) {
            return this.compare((Number)value1, (Number)value2);
        }
        if (type == String.class) {
            return ((String)value1).compareTo((String)value2);
        }
        if (type == Date.class) {
            return this.compare((Date)value1, (Date)value2);
        }
        if (type == Boolean.class) {
            return this.compare((Boolean)value1, (Boolean)value2);
        }
        return value1.toString().compareTo(value2.toString());
    }

    private final int compare(Number o1, Number o2) {
        return Double.compare(o1.doubleValue(), o2.doubleValue());
    }

    private final int compare(Date o1, Date o2) {
        long n2;
        long n1 = o1.getTime();
        if (n1 < (n2 = o2.getTime())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    private final int compare(Boolean o1, Boolean o2) {
        boolean b2;
        boolean b1 = o1;
        if (b1 == (b2 = o2.booleanValue())) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }
}

