/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing.table;

import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.swing.table.AbstractRowModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class DefaultRowModel
extends AbstractRowModel
implements PropertyChangeListener {
    private static final int INITIAL_CAPACITY = 64;
    private final Vector beans = new Vector(64);

    @Override
    public int size() {
        return this.beans.size();
    }

    @Override
    public Object getBean(int row) {
        return this.beans.get(row);
    }

    public void add(Object bean) {
        this.add(this.size(), bean);
    }

    public void add(int row, Object bean) {
        this.beans.add(row, bean);
        this.addListener(bean);
        this.fireTableRowsInserted(row, row);
    }

    public void change(int row, Object bean) {
        Object oldBean = this.beans.get(row);
        this.removeListener(oldBean);
        this.beans.setElementAt(bean, row);
        this.addListener(bean);
        this.fireTableRowsUpdated(row, row);
    }

    public void remove(int row) {
        Object bean = this.beans.get(row);
        this.removeListener(bean);
        this.beans.remove(bean);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }

    protected void addListener(Object bean) {
        ComponentModel model = ComponentFactory.getModel(bean, ComponentFactory.Policy.UI);
        if (model != null) {
            model.addPropertyChangeListener(this);
        }
    }

    protected void removeListener(Object bean) {
        ComponentModel model = ComponentFactory.getModel(bean, ComponentFactory.Policy.UI);
        if (model != null) {
            model.removePropertyChangeListener(this);
        }
    }
}

