/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing.table;

import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnWithSort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ColumnModel
extends Option
implements PropertyChangeListener {
    private ComponentModel columnsModel = null;
    private boolean rowNumbersVisible;
    private Column[] columns = new Column[0];
    private boolean sortEnabled;

    ColumnModel(ComponentModel model, int showMode) {
        this.initColumnNames(model, showMode);
    }

    ColumnModel(ComponentModel model) {
        this(model, 0);
    }

    public ColumnModel(Column[] fields) {
        this.setColumns(fields);
    }

    public ColumnModel(Object templateBean, int showMode) {
        this(ComponentFactory.getModel(templateBean, ComponentFactory.Policy.UI), showMode);
    }

    public ColumnModel(Class<?> templateBeanClass, int showMode) {
        this(ComponentFactory.getModel(templateBeanClass, ComponentFactory.Policy.UI), showMode);
    }

    public ColumnModel(Object templateBean) {
        this(ComponentFactory.getModel(templateBean, ComponentFactory.Policy.UI));
    }

    ComponentModel getColumnsModel() {
        return this.columnsModel;
    }

    public boolean isRowNumbersVisible() {
        return this.rowNumbersVisible;
    }

    public void setRowNumbersVisible(boolean value) {
        boolean oldValue = this.rowNumbersVisible;
        this.rowNumbersVisible = value;
        this.firePropertyChange("rowNumbersVisible", oldValue, value);
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void setColumns(Column[] fields) {
        this.columns = fields;
        for (int i = fields.length - 1; i >= 0; --i) {
            fields[i].removePropertyChangeListener(this);
            fields[i].addPropertyChangeListener(this);
        }
    }

    public Column getColumns(int i) {
        return this.getColumns()[i];
    }

    public void setColumns(int i, Column field) {
        this.getColumns()[i] = field;
        field.removePropertyChangeListener(this);
        field.addPropertyChangeListener(this);
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
        this.firePropertyChange("sortEnabled", null, null);
        this.firePropertyChange("fieldOptions", null, null);
    }

    public void setShowMode(int showMode) {
        if (this.columnsModel == null) {
            return;
        }
        int num = this.columnsModel.getPropertyCount();
        for (int i = 0; i < num; ++i) {
            boolean isVisible = this.columnsModel.getPropertyAt(i).isVisible(showMode);
            this.columns[i].setEnabled(isVisible);
        }
    }

    protected void initColumnNames(ComponentModel columnsModel, int showMode) {
        this.columnsModel = columnsModel;
        this.columns = new Column[0];
        if (columnsModel == null) {
            return;
        }
        int num = columnsModel.getPropertyCount();
        this.columns = new Column[num];
        for (int i = 0; i < num; ++i) {
            Property property = columnsModel.getPropertyAt(i);
            boolean isVisible = property.isVisible(showMode);
            this.columns[i] = new ColumnWithSort((Option)this, property.getName(), property.getDisplayName(), isVisible);
        }
    }

    public String calcEntryNameInArray(Integer index, Object obj) {
        return this.getColumns(index).getName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }
}

