/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing.table;

import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnModel;
import com.developmentontheedge.beans.swing.table.RowHeaderBean;
import com.developmentontheedge.beans.swing.table.RowModel;
import com.developmentontheedge.beans.swing.table.RowModelEvent;
import com.developmentontheedge.beans.swing.table.RowModelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class BeanTableModelAdapter
extends AbstractTableModel
implements RowModelListener,
PropertyChangeListener {
    protected RowModel rm;
    protected ColumnModel columnModel;
    private boolean rowHeader = false;

    public BeanTableModelAdapter(RowModel rm, ColumnModel columnModel) {
        this.rm = rm;
        this.columnModel = columnModel;
        this.registerListeners();
    }

    public void registerListeners() {
        this.unregisterListeners();
        if (this.rm != null) {
            if (PropertyChangeListener.class.isAssignableFrom(this.rm.getClass())) {
                for (int i = this.rm.size() - 1; i >= 0; --i) {
                    ComponentModel model = ComponentFactory.getModel(this.rm.getBean(i), ComponentFactory.Policy.UI);
                    model.addPropertyChangeListener((PropertyChangeListener)((Object)this.rm));
                }
            }
            this.rm.addRowModelListener(this);
        }
        if (this.columnModel != null) {
            this.columnModel.addPropertyChangeListener(this);
        }
    }

    public void unregisterListeners() {
        if (this.rm != null) {
            if (PropertyChangeListener.class.isAssignableFrom(this.rm.getClass())) {
                for (int i = this.rm.size() - 1; i >= 0; --i) {
                    ComponentModel model = ComponentFactory.getModel(this.rm.getBean(i), ComponentFactory.Policy.UI);
                    model.removePropertyChangeListener((PropertyChangeListener)((Object)this.rm));
                }
            }
            this.rm.removeRowModelListener(this);
        }
        if (this.columnModel != null) {
            this.columnModel.removePropertyChangeListener(this);
        }
    }

    public RowModel getRowModel() {
        return this.rm;
    }

    public ColumnModel getColumnModel() {
        return this.columnModel;
    }

    public boolean getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(boolean rowHeader) {
        this.rowHeader = rowHeader;
        if (this.columnModel != null) {
            this.columnModel.setRowNumbersVisible(rowHeader);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.rm != null ? this.rm.size() : 0;
    }

    @Override
    public synchronized int getColumnCount() {
        int cnt = 0;
        if (this.columnModel != null) {
            Column[] fieldOptions = this.columnModel.getColumns();
            for (int i = 0; i < fieldOptions.length; ++i) {
                if (!fieldOptions[i].getEnabled()) continue;
                ++cnt;
            }
        }
        return cnt + (this.getRowHeader() ? 1 : 0);
    }

    @Override
    public synchronized String getColumnName(int index) {
        index -= this.getRowHeader() ? 1 : 0;
        int cnt = 0;
        if (this.columnModel != null) {
            Column[] columns = this.columnModel.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].getEnabled()) continue;
                if (cnt == index) {
                    String name = columns[i].getName();
                    return name.replaceAll("\\|", " ");
                }
                ++cnt;
            }
        }
        return null;
    }

    protected synchronized String getColumnKey(int index) {
        index -= this.getRowHeader() ? 1 : 0;
        int cnt = 0;
        if (this.columnModel != null) {
            Column[] columns = this.columnModel.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].getEnabled()) continue;
                if (cnt == index) {
                    return columns[i].getColumnKey();
                }
                ++cnt;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return ComponentFactory.getPropertyClassInObfuscatedVersion().getSuperclass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Property property = (Property)this.getValueAt(row, column);
        return property == null ? true : !property.isReadOnly();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getPropertyAt(row, column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Property property = this.getPropertyAt(row, column);
        try {
            if (aValue instanceof Property) {
                aValue = ((Property)aValue).getValue();
            }
            property.setValue(aValue);
            this.fireTableDataChanged();
        }
        catch (Exception e) {
            Logger.getLogger().error("BeanTableModelAdapter:", e);
        }
    }

    protected Property getPropertyAt(int row, int column) {
        try {
            if (column == 0 && this.getRowHeader()) {
                RowHeaderBean rowHeaderBean = new RowHeaderBean();
                rowHeaderBean.setNumber(row + 1);
                ComponentModel rowHeaderModel = ComponentFactory.getModel(rowHeaderBean, ComponentFactory.Policy.UI);
                return rowHeaderModel.findProperty("number");
            }
            String propertyName = this.getColumnKey(column);
            if (propertyName == null) {
                throw new ArrayIndexOutOfBoundsException("Name for column " + column + " not found.");
            }
            Object bean = this.rm.getBean(row);
            if (bean == null) {
                throw new ArrayIndexOutOfBoundsException("Bean for row " + row + " not found.");
            }
            Property property = ComponentFactory.getModel(bean, ComponentFactory.Policy.UI).findProperty(propertyName);
            return property;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            Logger.getLogger().error("BeanTableModelAdapter:", exc);
            throw exc;
        }
        catch (Exception e) {
            Logger.getLogger().error("BeanTableModelAdapter:", e);
            return null;
        }
    }

    public Object getModelForRow(int row) {
        return row < 0 ? null : this.rm.getBean(row);
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (evt.getSource() == this.columnModel) {
            if (name.equals("rowNumbersVisible")) {
                this.setRowHeader((Boolean)evt.getNewValue());
            }
            if (name.equals("sortEnabled")) {
                this.fireTableChanged(new TableModelEvent(this, -1));
            }
        } else {
            String sourceName = ((Column)evt.getSource()).getName();
            if (name.equals("enabled")) {
                this.fireTableStructureChanged();
            }
        }
    }

    @Override
    public synchronized void tableChanged(RowModelEvent evt) {
        if (evt == null) {
            this.fireTableChanged(new TableModelEvent(this));
        } else {
            this.fireTableChanged(new TableModelEvent(this, evt.getFirstRow(), evt.getLastRow(), -1, evt.getType()));
        }
    }
}

