/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing.table;

import com.developmentontheedge.beans.swing.table.RowModel;
import com.developmentontheedge.beans.swing.table.RowModelEvent;
import com.developmentontheedge.beans.swing.table.RowModelListener;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractRowModel
implements RowModel {
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public Class getBeanClass() {
        if (this.size() != 0) {
            return this.getBean(0).getClass();
        }
        return Object.class;
    }

    @Override
    public void addRowModelListener(RowModelListener l) {
        this.listenerList.add(RowModelListener.class, l);
    }

    @Override
    public void removeRowModelListener(RowModelListener l) {
        this.listenerList.remove(RowModelListener.class, l);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new RowModelEvent(this));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new RowModelEvent(this, firstRow, lastRow, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new RowModelEvent(this, firstRow, lastRow, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new RowModelEvent(this, firstRow, lastRow, -1));
    }

    public void fireTableChanged(RowModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RowModelListener.class) continue;
            ((RowModelListener)listeners[i + 1]).tableChanged(e);
        }
    }
}

