/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.editors.BooleanEditor;
import com.developmentontheedge.beans.editors.PropertyEditorEx;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.AbstractPropertyInspector;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyEditor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ValueRenderer
implements TableCellRenderer {
    protected AbstractPropertyInspector propertyInspector;
    protected RendererPool pool = new RendererPool();
    protected JComponent compositeView;
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected boolean variableRowHeight = false;
    private final LocalMouseListener mouseListener = new LocalMouseListener();
    int currentRow;
    int[] cellHeights = new int[100];
    protected static final DecimalFormat customNumberFormat = new DecimalFormat();
    protected NumberFormat defaultNumberFormat = NumberFormat.getNumberInstance(Locale.US);
    private PropertyEditor curEditor;
    private Property curProperty;
    private Rectangle lastRect;
    private Point lastPoint;

    public ValueRenderer() {
        this.compositeView = new LightJPanel();
    }

    public ValueRenderer(AbstractPropertyInspector inspector) {
        this();
        this.propertyInspector = inspector;
    }

    public void registerListeners() {
        this.propertyInspector.addMouseListener(this.mouseListener);
        this.propertyInspector.addMouseMotionListener(this.mouseListener);
    }

    public void unregisterListeners() {
        this.propertyInspector.removeMouseListener(this.mouseListener);
        this.propertyInspector.removeMouseMotionListener(this.mouseListener);
    }

    protected void formatReadOnly(Property property, Component view) {
        view.setForeground(property.isReadOnly() ? Color.gray : Color.black);
    }

    public Component getViewForNullValue(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.pool.nextDefaultRenderer().getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
    }

    protected Component getViewFromPropertyEditor(JTable table, Property property, boolean isSelected, boolean hasFocus, int row, int column) {
        Component view = null;
        PropertyEditor editor = this.getEditor(property);
        if (editor != null) {
            if (editor.isPaintable() && editor instanceof PropertyEditorEx) {
                view = ((PropertyEditorEx)editor).getCustomRenderer(table, isSelected, hasFocus);
            } else {
                Object value = property.getValue();
                String text = value instanceof String ? (String)value : editor.getAsText();
                view = this.pool.nextDefaultRenderer().getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                this.formatReadOnly(property, view);
            }
        }
        return view;
    }

    public Component getCompositeView(JTable table, Property property, boolean isSelected, boolean hasFocus, int row, int column) {
        String propertyNameList = (String)property.getDescriptor().getValue("composite-editor: property list");
        if (propertyNameList == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(propertyNameList, ";, ");
        LayoutManager layoutManager = (LayoutManager)property.getDescriptor().getValue("composite-editor: layout manager");
        if (layoutManager == null) {
            layoutManager = new GridLayout(1, tokens.countTokens());
        }
        this.compositeView.removeAll();
        this.compositeView.setLayout(layoutManager);
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            Property p = property.findProperty(name);
            if (p == null) {
                Logger.getLogger().error("ValueRenderer#composite editor: property " + name + " not found in " + property.getCompleteName());
                continue;
            }
            Component view = this.getPropertyView(table, p, false, false, row, column);
            this.compositeView.add(view);
        }
        this.compositeView.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        this.compositeView.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (!hasFocus) {
            this.compositeView.setBorder(noFocusBorder);
        } else {
            this.compositeView.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.compositeView.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.compositeView.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        }
        Color back = this.compositeView.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.compositeView.setOpaque(!colorMatch);
        return this.compositeView;
    }

    public Component getPropertyView(JTable table, Property property, boolean isSelected, boolean hasFocus, int row, int column) {
        Component view = this.getCompositeView(table, property, isSelected, hasFocus, row, column);
        if (view != null) {
            return view;
        }
        view = this.getViewFromPropertyEditor(table, property, isSelected, hasFocus, row, column);
        if (view != null) {
            return view;
        }
        Object value = property.getValue();
        if (Boolean.parseBoolean(String.valueOf(property.getDescriptor().getValue("password-field")))) {
            value = "";
        }
        if (value != null && value instanceof Boolean) {
            BooleanEditor editor = new BooleanEditor();
            editor.setValue(value);
            view = editor.getCustomRenderer(table, isSelected, hasFocus);
        } else if (value != null && value instanceof Image) {
            view = new JLabel(new ImageIcon((Image)value));
        } else if (value != null && value instanceof ImageIcon) {
            view = new JLabel((ImageIcon)value);
        } else {
            if (value == null || !(value instanceof String) && !(value instanceof Number)) {
                value = "";
            } else if (value instanceof Number) {
                value = this.formatNumber((Number)value, property);
            }
            view = this.pool.nextDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        this.formatReadOnly(property, view);
        return view;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.pool.flush();
        if (value == null || !(value instanceof Property)) {
            return this.getViewForNullValue(table, value, isSelected, hasFocus, row, column);
        }
        Component c = this.getPropertyView(table, (Property)value, isSelected, hasFocus, row, column);
        if (this.variableRowHeight && column < table.getColumnModel().getColumnCount()) {
            if (row != this.currentRow) {
                this.updateRowHeight(table, this.currentRow);
                this.currentRow = row;
            }
            c.setSize(table.getColumnModel().getColumn(column).getWidth(), c.getPreferredSize().height);
            if (table.getRowHeight(row) < c.getPreferredSize().height) {
                table.setRowHeight(row, c.getPreferredSize().height);
            }
            if (column >= 0 && column < 100) {
                this.cellHeights[column] = c.getPreferredSize().height;
            }
        }
        return c;
    }

    protected void updateRowHeight(JTable table, int row) {
        int max = 16;
        for (int i = 0; i < this.cellHeights.length; ++i) {
            max = Math.max(max, this.cellHeights[i]);
            this.cellHeights[i] = 0;
        }
        if (table.getRowHeight(row) - max > 5) {
            table.setRowHeight(row, max);
        }
    }

    protected String formatNumber(Number number, Property property) {
        Object format = property.getDescriptor().getValue("number-format");
        if (format instanceof NumberFormat) {
            return ((NumberFormat)format).format(number);
        }
        if (format instanceof String) {
            if ("none".equals(format)) {
                return number.toString();
            }
            customNumberFormat.applyPattern((String)format);
            return customNumberFormat.format(number);
        }
        if (this.defaultNumberFormat != null) {
            return this.defaultNumberFormat.format(number);
        }
        return number.toString();
    }

    private PropertyEditor getEditor(Property property) {
        PropertyEditor editor = null;
        try {
            Class<?> c = property.getPropertyEditorClass();
            if (c != null) {
                editor = (PropertyEditor)c.newInstance();
                if (editor instanceof PropertyEditorEx) {
                    Object owner = property.getOwner();
                    if (owner instanceof Property.PropWrapper) {
                        owner = ((Property.PropWrapper)owner).getOwner();
                    }
                    ((PropertyEditorEx)editor).setBean(owner);
                    ((PropertyEditorEx)editor).setDescriptor(property.getDescriptor());
                }
                Object value = property.getValue();
                editor.setValue(value);
            }
        }
        catch (Exception ex) {
            Logger.getLogger().error("Error when getting editor", ex);
        }
        return editor;
    }

    private void dispatchEvent(MouseEvent e) {
        int type = e.getID();
        Point pt = e.getPoint();
        MouseEvent newEvent = null;
        Property property = this.propertyInspector.getProperty(pt);
        if (property == null) {
            return;
        }
        Rectangle rect = this.propertyInspector.getCellRect(pt);
        if (property != null && rect != null) {
            int x = pt.x - rect.x;
            int y = pt.y - rect.y;
            newEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getClickCount(), e.isPopupTrigger());
        }
        if (property != this.curProperty || type == 505) {
            this.curProperty = property;
            if (this.curEditor != null && this.curEditor instanceof MouseListener) {
                int xx = 0;
                int yy = 0;
                if (this.lastPoint != null && this.lastRect != null) {
                    xx = this.lastPoint.x - this.lastRect.x;
                    yy = this.lastPoint.y - this.lastRect.y;
                }
                e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), xx, yy, e.getClickCount(), e.isPopupTrigger());
                ((MouseListener)((Object)this.curEditor)).mouseExited(e);
                if (type == 505) {
                    return;
                }
            }
            this.curEditor = this.getEditor(property);
            if (this.curEditor != null && this.curEditor instanceof MouseListener) {
                ((MouseListener)((Object)this.curEditor)).mouseEntered(newEvent);
                if (type == 504) {
                    return;
                }
            }
        }
        this.lastRect = rect;
        this.lastPoint = pt;
        if (this.curEditor == null) {
            return;
        }
        if (this.curEditor instanceof MouseListener) {
            switch (type) {
                case 500: {
                    ((MouseListener)((Object)this.curEditor)).mouseClicked(newEvent);
                    break;
                }
                case 501: {
                    ((MouseListener)((Object)this.curEditor)).mousePressed(newEvent);
                    break;
                }
                case 502: {
                    ((MouseListener)((Object)this.curEditor)).mouseReleased(newEvent);
                    break;
                }
                case 504: {
                    ((MouseListener)((Object)this.curEditor)).mouseEntered(newEvent);
                }
            }
        }
        if (this.curEditor instanceof MouseMotionListener) {
            switch (type) {
                case 506: {
                    ((MouseMotionListener)((Object)this.curEditor)).mouseDragged(newEvent);
                    break;
                }
                case 503: {
                    ((MouseMotionListener)((Object)this.curEditor)).mouseMoved(newEvent);
                }
            }
        }
    }

    static class LightJPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        LightJPanel() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    static class RendererPool {
        int current = 0;
        TableCellRenderer[] pool = new TableCellRenderer[]{new DefaultTableCellRenderer(), new DefaultTableCellRenderer(), new DefaultTableCellRenderer(), new DefaultTableCellRenderer(), new DefaultTableCellRenderer()};

        public TableCellRenderer nextDefaultRenderer() {
            return this.pool[this.current++];
        }

        public void flush() {
            this.current = 0;
        }
    }

    class LocalMouseListener
    implements MouseMotionListener,
    MouseListener {
        LocalMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ValueRenderer.this.dispatchEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ValueRenderer.this.dispatchEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ValueRenderer.this.dispatchEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ValueRenderer.this.dispatchEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ValueRenderer.this.dispatchEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ValueRenderer.this.dispatchEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ValueRenderer.this.dispatchEvent(e);
        }
    }
}

