/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.editors.BooleanEditor;
import com.developmentontheedge.beans.editors.ColorEditor;
import com.developmentontheedge.beans.editors.DoubleEditor;
import com.developmentontheedge.beans.editors.FloatEditor;
import com.developmentontheedge.beans.editors.IntegerEditor;
import com.developmentontheedge.beans.editors.LongEditor;
import com.developmentontheedge.beans.editors.PropertyEditorEx;
import com.developmentontheedge.beans.editors.StringEditor;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.model.PropertyChangeUndo;
import com.developmentontheedge.beans.swing.AbstractPropertyInspector;
import com.developmentontheedge.beans.swing.PropertyInspector;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import com.developmentontheedge.beans.undo.TransactionEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class ValueEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    protected AbstractPropertyInspector propertyInspector;
    protected int clickCountToStart = 1;
    protected Property editingProperty;
    protected boolean isEditorComposite;
    protected Component editor;

    public ValueEditor() {
    }

    public ValueEditor(AbstractPropertyInspector propertyInspector) {
        this.propertyInspector = propertyInspector;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editingProperty;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof Property)) {
            this.editor = null;
        } else {
            this.editingProperty = (Property)value;
            this.editor = this.getCompositeEditor(table, this.editingProperty, isSelected, row, column);
            if (this.editor == null) {
                this.editor = this.getEditorComponent(table, this.editingProperty, isSelected, row, column);
            }
        }
        return this.editor;
    }

    protected Component getCompositeEditor(JComponent parent, Property property, boolean isSelected, int row, int column) {
        String propertyNameList = (String)property.getDescriptor().getValue("composite-editor: property list");
        boolean bl = this.isEditorComposite = propertyNameList != null;
        if (!this.isEditorComposite) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(propertyNameList, ";, ");
        LayoutManager layoutManager = (LayoutManager)property.getDescriptor().getValue("composite-editor: layout manager");
        if (layoutManager == null) {
            layoutManager = new GridLayout(1, tokens.countTokens());
        }
        JPanel compositeView = new JPanel();
        compositeView.setOpaque(false);
        compositeView.removeAll();
        compositeView.setLayout(layoutManager);
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            Property p = property.findProperty(name);
            if (p == null) {
                Logger.getLogger().error("ValueEditor#composite editor: property " + name + " not found in " + property.getCompleteName());
                continue;
            }
            Component view = this.getEditorComponent(parent, p, isSelected, row, column);
            compositeView.add(view);
        }
        return compositeView;
    }

    protected Component getEditorComponent(JComponent parentComp, Property property, boolean isSelected, int row, int column) {
        Class<?> propertyEditorClass;
        Object value = property.getValue();
        if (value == null) {
            value = this.newValueInstance(property);
        }
        if ((propertyEditorClass = this.getEditorClass(property, value)) == null) {
            Logger.getLogger().warn("Null editor class of property " + property.getCompleteName());
            return null;
        }
        Component editComp = null;
        PropertyEditor propertyEditor = null;
        EditorDelegate delegate = null;
        try {
            propertyEditor = (PropertyEditor)propertyEditorClass.newInstance();
        }
        catch (Exception e) {
            Logger.getLogger().error("can not instantiate property editor of " + propertyEditorClass, e);
            return null;
        }
        if (propertyEditor instanceof PropertyEditorEx) {
            Object owner = property.getOwner();
            if (owner instanceof Property.PropWrapper) {
                owner = ((Property.PropWrapper)owner).getOwner();
            }
            ((PropertyEditorEx)propertyEditor).setBean(owner);
            ((PropertyEditorEx)propertyEditor).setDescriptor(property.getDescriptor());
        }
        propertyEditor.setValue(value);
        if (propertyEditor.supportsCustomEditor()) {
            editComp = propertyEditor instanceof PropertyEditorEx ? ((PropertyEditorEx)propertyEditor).getCustomEditor(parentComp, isSelected) : propertyEditor.getCustomEditor();
            final PropertyEditor parent = propertyEditor;
            delegate = new EditorDelegate(property){

                @Override
                public Object getValue() {
                    return parent.getValue();
                }
            };
            propertyEditor.addPropertyChangeListener(delegate);
            editComp.addFocusListener(delegate);
        } else {
            String[] tags = propertyEditor.getTags();
            if (tags == null) {
                final JTextField tf = new JTextField(propertyEditor.getAsText());
                editComp = tf;
                final PropertyEditor parent = propertyEditor;
                delegate = new EditorDelegate(property){

                    @Override
                    public Object getValue() {
                        try {
                            parent.setAsText(tf.getText());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        return parent.getValue();
                    }
                };
                tf.addActionListener(delegate);
                editComp.addFocusListener(delegate);
            } else {
                final JComboBox<String> cb = new JComboBox<String>(tags);
                cb.setSelectedItem(propertyEditor.getAsText());
                editComp = cb;
                final PropertyEditor parent = propertyEditor;
                delegate = new EditorDelegate(property){

                    @Override
                    public Object getValue() {
                        String str = (String)cb.getSelectedItem();
                        try {
                            parent.setAsText(str);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        return parent.getValue();
                    }
                };
                cb.addActionListener(delegate);
            }
        }
        return editComp;
    }

    protected Class<?> getEditorClass(Property property, Object value) {
        Class<?> c = property.getPropertyEditorClass();
        if (c != null) {
            return c;
        }
        if (value instanceof Boolean) {
            return BooleanEditor.class;
        }
        if (value instanceof Integer) {
            return IntegerEditor.class;
        }
        if (value instanceof Long) {
            return LongEditor.class;
        }
        if (value instanceof Float) {
            return FloatEditor.class;
        }
        if (value instanceof Double) {
            return DoubleEditor.class;
        }
        if (value instanceof Color) {
            return ColorEditor.class;
        }
        if (value instanceof String) {
            return StringEditor.class;
        }
        return null;
    }

    protected Object newValueInstance(Property property) {
        Object newValue;
        block7: {
            newValue = null;
            try {
                Class<?> c = property.getValueClass();
                if (c.getName().equals("java.lang.Class") || c.getName().equals("java.lang.reflect.Method")) {
                    return null;
                }
                String typeName = c.getName();
                try {
                    if (c.isArray()) {
                        newValue = Array.newInstance(c.getComponentType(), 0);
                        break block7;
                    }
                    if (c.isPrimitive() || typeName.indexOf("java.lang") >= 0) {
                        newValue = ComponentFactory.instanceForClass(c);
                        break block7;
                    }
                    newValue = c.newInstance();
                }
                catch (InstantiationException exc) {
                    newValue = ComponentFactory.findStaticInstance(c);
                }
            }
            catch (Exception e) {
                Logger.getLogger().error("can not initialize empty value of property = " + property.getCompleteName(), e);
            }
        }
        return newValue;
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    protected abstract class EditorDelegate
    implements ActionListener,
    ItemListener,
    PropertyChangeListener,
    FocusListener {
        private final Property property;

        public EditorDelegate(Property property) {
            this.property = property;
        }

        public abstract Object getValue();

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doAction("action performed", e.getSource());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.doAction("item state changed", e.getSource());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.doAction("property change", e.getSource());
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.doAction("focus lost", e.getSource());
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        private void doAction(String eventType, Object source) {
            boolean equal;
            Object value = this.getValue();
            Object oldValue = this.property.getValue();
            boolean bl = equal = oldValue == null && value == null || oldValue != null && oldValue.equals(value);
            if (!equal) {
                try {
                    PropertyInspector pi = null;
                    TabularPropertyInspector tpi = null;
                    if (ValueEditor.this.propertyInspector != null && ValueEditor.this.propertyInspector instanceof PropertyInspector) {
                        pi = (PropertyInspector)ValueEditor.this.propertyInspector;
                    } else if (ValueEditor.this.propertyInspector != null && ValueEditor.this.propertyInspector instanceof TabularPropertyInspector) {
                        tpi = (TabularPropertyInspector)ValueEditor.this.propertyInspector;
                    }
                    if (pi != null) {
                        pi.fireStartTransaction(new TransactionEvent(this.property.getOwner(), "property change: " + this.property.getCompleteName()));
                    } else if (tpi != null) {
                        tpi.fireStartTransaction(new TransactionEvent(this.property.getOwner(), "property change: " + this.property.getCompleteName()));
                    }
                    this.property.setValue(value);
                    if (pi != null) {
                        pi.fireAddEdit(new PropertyChangeUndo(this.property, oldValue, value));
                        pi.fireCompleteTransaction();
                    } else if (tpi != null) {
                        tpi.fireAddEdit(new PropertyChangeUndo(this.property, oldValue, value));
                        tpi.fireCompleteTransaction();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger().error("EditorDelegate set value error." + e);
                }
            }
            if (!(ValueEditor.this.isEditorComposite || eventType.equals("focus lost") && source != ValueEditor.this.editor)) {
                ValueEditor.this.fireEditingStopped();
            }
        }
    }
}

