/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.AbstractPropertyInspector;
import com.developmentontheedge.beans.swing.ValueEditor;
import com.developmentontheedge.beans.swing.ValueRenderer;
import com.developmentontheedge.beans.swing.table.BeanTableModelAdapter;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnModel;
import com.developmentontheedge.beans.swing.table.ColumnWithSort;
import com.developmentontheedge.beans.swing.table.DefaultRowModel;
import com.developmentontheedge.beans.swing.table.RowModel;
import com.developmentontheedge.beans.swing.table.SortButtonRenderer;
import com.developmentontheedge.beans.swing.table.SortedBeanTableModelAdapter;
import com.developmentontheedge.beans.swing.table.SortedTableModel;
import com.developmentontheedge.beans.undo.Transactable;
import com.developmentontheedge.beans.undo.TransactionEvent;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.UndoableEdit;

public class TabularPropertyInspector
extends JPanel
implements AbstractPropertyInspector,
Transactable {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane;
    private JPopupMenu popup;
    private int propertyShowMode = 4;
    private boolean rowHeader = true;
    protected boolean sortEnabled = true;
    protected BeanTableModelAdapter tableModel;
    protected JTable table;
    protected EventListenerList listenerList = new EventListenerList();
    private final ValueRenderer valueRenderer = new ValueRenderer(this);
    private HeaderListener headerListener;
    private MouseListener tablePopupMouseListener;

    public TabularPropertyInspector() {
        this.popup = new JPopupMenu();
        this.setupPopupMenu(this.popup);
        this.initTable();
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    protected void setupPopupMenu(JPopupMenu popup) {
    }

    public int getPropertyShowMode() {
        return this.propertyShowMode;
    }

    public void setPropertyShowMode(int propertyShowMode) {
        this.propertyShowMode = propertyShowMode;
        if (this.tableModel != null) {
            this.tableModel.getColumnModel().setShowMode(propertyShowMode);
            this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
        }
    }

    public boolean getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(boolean rowHeaderVisibility) {
        TableColumn col;
        TableColumnModel columnModel;
        int prefSize = 75;
        if (this.table != null && this.table.getColumnCount() > 1) {
            prefSize = this.table.getColumnModel().getColumn(1).getPreferredWidth();
        }
        boolean oldValue = this.rowHeader;
        this.rowHeader = rowHeaderVisibility;
        if (this.tableModel != null) {
            this.tableModel.setRowHeader(this.rowHeader);
        }
        this.firePropertyChange("rowHeader", oldValue, this.rowHeader);
        if (this.table != null && (columnModel = this.table.getColumnModel()) != null && this.table.getColumnCount() > 0 && (col = columnModel.getColumn(0)) != null) {
            col.setResizable(!rowHeaderVisibility);
            if (rowHeaderVisibility) {
                col.setPreferredWidth(30);
                col.setMaxWidth(30);
                col.setMinWidth(30);
            } else {
                col.setMaxWidth(300);
                col.setMinWidth(0);
                col.setPreferredWidth(prefSize);
            }
        }
    }

    public boolean getSortEnabled() {
        return this.sortEnabled;
    }

    protected BeanTableModelAdapter createSortedTableModel(RowModel rowModel, ColumnModel options) {
        return new SortedBeanTableModelAdapter(rowModel, options);
    }

    public void setSortEnabled(boolean enabled) {
        boolean oldValue = this.sortEnabled;
        this.sortEnabled = enabled;
        if (this.tableModel == null) {
            this.firePropertyChange("sortEnabled", oldValue, this.sortEnabled);
            return;
        }
        boolean prevRowHeader = this.tableModel.getRowHeader();
        RowModel rowModel = this.tableModel.getRowModel();
        ColumnModel options = this.tableModel.getColumnModel();
        this.tableModel.unregisterListeners();
        this.tableModel = null;
        if (enabled) {
            this.tableModel = this.createSortedTableModel(rowModel, options);
            this.tableModel.getColumnModel().setSortEnabled(true);
        } else {
            this.tableModel = new BeanTableModelAdapter(rowModel, options);
            this.tableModel.getColumnModel().setSortEnabled(false);
        }
        this.tableModel.setRowHeader(prevRowHeader);
        this.table.setModel(this.tableModel);
        if (this.getRowHeader()) {
            TableColumn col = this.table.getColumnModel().getColumn(0);
            col.setResizable(false);
            col.setMinWidth(30);
            col.setPreferredWidth(30);
            col.setMaxWidth(30);
        }
        this.firePropertyChange("sortEnabled", oldValue, this.sortEnabled);
    }

    public NumberFormat getDefaultNumberFormat() {
        return this.valueRenderer.defaultNumberFormat;
    }

    public void setDefaultNumberFormat(NumberFormat format) {
        this.valueRenderer.defaultNumberFormat = format;
    }

    public boolean isVariableRowHeight() {
        return this.valueRenderer.variableRowHeight;
    }

    public void setVariableRowHeight(boolean variableRowHeight) {
        this.valueRenderer.variableRowHeight = variableRowHeight;
    }

    public JTable getTable() {
        return this.table;
    }

    public void explore(RowModel rowModel, ColumnModel columnModel) {
        this.unregisterListeners();
        if (rowModel != null) {
            this.tableModel = this.getSortEnabled() ? this.createSortedTableModel(rowModel, columnModel) : new BeanTableModelAdapter(rowModel, columnModel);
            this.tableModel.setRowHeader(this.getRowHeader());
            this.table.setModel(this.tableModel);
            if (this.getRowHeader()) {
                TableColumn col = this.table.getColumnModel().getColumn(0);
                col.setResizable(false);
                col.setMinWidth(30);
                col.setPreferredWidth(30);
                col.setMaxWidth(30);
            }
            if (this.table.getColumnCount() > 8) {
                this.table.setAutoResizeMode(0);
            } else {
                this.table.setAutoResizeMode(4);
            }
            if (this.tableModel instanceof SortedTableModel) {
                ((SortedTableModel)((Object)this.tableModel)).sort();
            }
        } else {
            this.table = null;
            this.tableModel = null;
            this.removeAll();
            this.repaint();
            this.initTable();
        }
        this.registerListeners();
    }

    protected void registerListeners() {
        this.unregisterListeners();
        if (this.table != null) {
            this.initHeaders();
            this.table.addMouseListener(this.getTablePopupMouseListener());
            this.table.getTableHeader().addMouseListener(this.headerListener);
            if (this.valueRenderer != null) {
                this.valueRenderer.registerListeners();
            }
            if (this.scrollPane != null) {
                this.scrollPane.setViewportView(this.table);
            }
        }
        if (this.tableModel != null) {
            if (this.tableModel instanceof ListSelectionListener) {
                this.addListSelectionListener((ListSelectionListener)((Object)this.tableModel));
            }
            this.tableModel.addTableModelListener(this.table);
            this.tableModel.registerListeners();
        }
        if (this.scrollPane != null) {
            this.scrollPane.setViewportView(this.table);
        }
    }

    protected void unregisterListeners() {
        if (this.table != null) {
            this.resetHeaderRenderers();
            this.table.removeMouseListener(this.getTablePopupMouseListener());
            this.table.getTableHeader().removeMouseListener(this.headerListener);
            if (this.valueRenderer != null) {
                this.valueRenderer.unregisterListeners();
            }
        }
        if (this.tableModel != null) {
            if (this.tableModel instanceof ListSelectionListener) {
                this.removeListSelectionListener((ListSelectionListener)((Object)this.tableModel));
            }
            this.tableModel.removeTableModelListener(this.table);
            this.tableModel.unregisterListeners();
        }
        if (this.scrollPane != null) {
            this.scrollPane.setViewportView(this.table);
        }
    }

    public void explore(RowModel rowModel, Object templateBean, int showMode) {
        this.propertyShowMode = showMode;
        this.explore(rowModel, new ColumnModel(templateBean, this.propertyShowMode));
    }

    public void explore(Object[] beans) {
        if (beans == null || beans.length == 0) {
            this.explore(null, null);
        } else {
            DefaultRowModel defaultRowModel = new DefaultRowModel();
            for (int i = 0; i < beans.length; ++i) {
                defaultRowModel.add(beans[i]);
            }
            this.explore(defaultRowModel, new ColumnModel(beans[0]));
        }
    }

    public void explore(Iterator beans) {
        if (beans == null || !beans.hasNext()) {
            this.explore(null, null);
        } else {
            DefaultRowModel defaultRowModel = new DefaultRowModel();
            while (beans.hasNext()) {
                defaultRowModel.add(beans.next());
            }
            this.explore(defaultRowModel, new ColumnModel(defaultRowModel.getBean(0)));
        }
    }

    @Override
    public void clear() {
        this.explore(null, null);
    }

    @Override
    public void removeNotify() {
        this.unregisterListeners();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerListeners();
    }

    public ColumnModel getColumnModel() {
        if (this.tableModel != null) {
            return this.tableModel.getColumnModel();
        }
        return null;
    }

    @Override
    public Property getProperty(Point pt) {
        int row = this.table.rowAtPoint(pt);
        if (row < 0) {
            return null;
        }
        int column = this.table.columnAtPoint(pt);
        if (column < 0) {
            return null;
        }
        Object value = this.table.getValueAt(row, column);
        if (value instanceof Property) {
            return (Property)value;
        }
        return null;
    }

    @Override
    public Rectangle getCellRect(Point pt) {
        int row = this.table.rowAtPoint(pt);
        if (row < 0) {
            return null;
        }
        int column = this.table.columnAtPoint(pt);
        if (column < 0) {
            return null;
        }
        return this.table.getCellRect(row, column, true);
    }

    public Object getModelOfSelectedRow() {
        return this.getModelForRow(this.table.getSelectedRow());
    }

    public Object getModelForRow(int row) {
        return row < 0 ? null : this.tableModel.getModelForRow(row);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(ListSelectionListener.class, l);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        if (this.table != null) {
            this.table.addMouseListener(listener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        if (this.table != null) {
            this.table.removeMouseListener(listener);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        if (this.table != null) {
            this.table.addMouseMotionListener(listener);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        if (this.table != null) {
            this.table.removeMouseMotionListener(listener);
        }
    }

    protected void fireValueChanged(ListSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    protected void initTable() {
        this.table = new JTable(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                if (TabularPropertyInspector.this != null) {
                    TabularPropertyInspector.this.fireValueChanged(e);
                }
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                if (TabularPropertyInspector.this != null && TabularPropertyInspector.this.table != null) {
                    TabularPropertyInspector.this.initHeaders();
                    if (TabularPropertyInspector.this.tableModel != null) {
                        if (TabularPropertyInspector.this.tableModel.getRowHeader() != TabularPropertyInspector.this.getRowHeader()) {
                            TabularPropertyInspector.this.setRowHeader(TabularPropertyInspector.this.tableModel.getRowHeader());
                        }
                        if (TabularPropertyInspector.this.tableModel.getColumnModel().isSortEnabled() != TabularPropertyInspector.this.getSortEnabled()) {
                            TabularPropertyInspector.this.setSortEnabled(TabularPropertyInspector.this.tableModel.getColumnModel().isSortEnabled());
                        }
                    }
                    if (TabularPropertyInspector.this.getRowHeader() && TabularPropertyInspector.this.table.getColumnModel() != null && TabularPropertyInspector.this.table.getColumnModel().getColumnCount() > 0) {
                        TableColumn col = TabularPropertyInspector.this.table.getColumnModel().getColumn(0);
                        col.setResizable(false);
                        col.setMinWidth(30);
                        col.setPreferredWidth(30);
                        col.setMaxWidth(30);
                    }
                }
            }

            @Override
            public void updateUI() {
                try {
                    this.setRowHeight(TabularPropertyInspector.this.getPreferredRowHeight());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.updateUI();
            }
        };
        this.table.setDefaultRenderer(Object.class, this.valueRenderer);
        this.table.setDefaultEditor(Object.class, new ValueEditor(this));
        this.table.setRowHeight(this.getPreferredRowHeight());
        this.table.getColumnModel().setColumnMargin(2);
        this.table.addMouseListener(this.getTablePopupMouseListener());
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        this.headerListener = new HeaderListener(header);
        this.scrollPane = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    protected int getPreferredRowHeight() {
        JTextField tf = new JTextField("Yy");
        return tf.getMinimumSize().height;
    }

    protected void initHeaders() {
        this.resetHeaderRenderers();
        TableColumnModel model = this.table.getColumnModel();
        if (this.getColumnModel() != null) {
            Column[] columns = this.getColumnModel().getColumns();
            int cnt = this.getRowHeader() ? 1 : 0;
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].getEnabled() || cnt >= model.getColumnCount()) continue;
                LocalButtonRenderer renderer = new LocalButtonRenderer(columns[i]);
                model.getColumn(cnt++).setHeaderRenderer(renderer);
            }
        }
    }

    private void resetHeaderRenderers() {
        TableColumnModel model = this.table.getColumnModel();
        if (this.getColumnModel() != null) {
            Column[] columns = this.getColumnModel().getColumns();
            int cnt = this.getRowHeader() ? 1 : 0;
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].getEnabled() || cnt >= model.getColumnCount()) continue;
                model.getColumn(cnt++).setHeaderRenderer(null);
            }
        }
    }

    private MouseListener getTablePopupMouseListener() {
        if (this.tablePopupMouseListener == null) {
            this.tablePopupMouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() && TabularPropertyInspector.this.popup.getComponentCount() > 0) {
                        TabularPropertyInspector.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() && TabularPropertyInspector.this.popup.getComponentCount() > 0) {
                        TabularPropertyInspector.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
        }
        return this.tablePopupMouseListener;
    }

    @Override
    public void addTransactionListener(TransactionListener listener) {
        this.listenerList.add(TransactionListener.class, listener);
    }

    @Override
    public void removeTransactionListener(TransactionListener listener) {
        this.listenerList.remove(TransactionListener.class, listener);
    }

    protected void fireStartTransaction(TransactionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).startTransaction(evt);
        }
    }

    protected void fireAddEdit(UndoableEdit ue) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).addEdit(ue);
        }
    }

    protected void fireCompleteTransaction() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).completeTransaction();
        }
        this.table.repaint();
    }

    class HeaderListener
    extends MouseAdapter {
        JTableHeader header;

        HeaderListener(JTableHeader header) {
            this.header = header;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col = this.header.columnAtPoint(e.getPoint()) + (TabularPropertyInspector.this.getRowHeader() ? -1 : 0);
            if (col < 0 || e.getClickCount() != 1 || !TabularPropertyInspector.this.getSortEnabled()) {
                return;
            }
            Column[] columns = TabularPropertyInspector.this.getColumnModel().getColumns();
            int cnt = 0;
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].getEnabled()) continue;
                if (cnt == col) {
                    col = i;
                    break;
                }
                ++cnt;
            }
            if (columns[col] instanceof ColumnWithSort) {
                ColumnWithSort fieldOption = (ColumnWithSort)columns[col];
                boolean isAscent = fieldOption.getSorting() != 1;
                Column[] cols = TabularPropertyInspector.this.tableModel.getColumnModel().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    ((ColumnWithSort)cols[i]).setSorting(0);
                }
                fieldOption.setSorting(isAscent ? 1 : 2);
            }
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            TabularPropertyInspector.this.tableModel.fireTableChanged(new TableModelEvent(TabularPropertyInspector.this.tableModel, -1));
        }
    }

    class LocalButtonRenderer
    extends SortButtonRenderer {
        private static final long serialVersionUID = 1L;

        public LocalButtonRenderer(Column fieldOptions) {
            super(fieldOptions);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (TabularPropertyInspector.this.getRowHeader()) {
                if (column == 0) {
                    return this;
                }
                --column;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

