/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ArrayProperty;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.PropertyInspector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class PropertyInspectorEx
extends PropertyInspector {
    private static final long serialVersionUID = 1L;
    protected JToolBar actionsPanel;
    public static final int TOOLBAR_BUTTON_SIZE = 20;
    protected Action insertAction;
    protected Action insertBeforeAction;
    protected Action insertAfterAction;
    protected Action removeItemAction;
    protected Action itemUpAction;
    protected Action itemDownAction;
    protected Action expandNodeAction;
    protected Action expandAllAction;
    protected Action collapseNodeAction;
    protected Action collapseAllAction;

    public PropertyInspectorEx() {
        this.initActions();
        this.add((Component)this.actionsPanel, "North");
    }

    protected void initActions() {
        this.insertAction = new NewElementAction();
        this.removeItemAction = new RemoveAction();
        this.insertBeforeAction = new InsertAction(true);
        this.insertAfterAction = new InsertAction(false);
        this.itemUpAction = new MoveAction(true);
        this.itemDownAction = new MoveAction(false);
        this.insertAction.setEnabled(false);
        this.removeItemAction.setEnabled(false);
        this.insertBeforeAction.setEnabled(false);
        this.insertAfterAction.setEnabled(false);
        this.itemUpAction.setEnabled(false);
        this.itemDownAction.setEnabled(false);
        this.actionsPanel = new JToolBar();
        this.actionsPanel.setFloatable(false);
        this.actionsPanel.setVisible(false);
        JButton button = new JButton(this.insertAction);
        this.configureButton(button, this.insertAction, "Add element", "addArrayElement.gif");
        this.actionsPanel.add((Component)button, 0);
        button = new JButton(this.removeItemAction);
        this.configureButton(button, this.removeItemAction, "Remove element", "removeArrayElement.gif");
        this.actionsPanel.add((Component)button, 1);
        button = new JButton(this.insertBeforeAction);
        this.configureButton(button, this.insertBeforeAction, "Insert before", "insertBeforeArrayElement.gif");
        this.actionsPanel.add((Component)button, 2);
        button = new JButton(this.insertAfterAction);
        this.configureButton(button, this.insertAfterAction, "Insert after", "insertAfterArrayElement.gif");
        this.actionsPanel.add((Component)button, 3);
        button = new JButton(this.itemUpAction);
        this.configureButton(button, this.itemUpAction, "Move up", "moveUpArrayElement.gif");
        this.actionsPanel.add((Component)button, 4);
        button = new JButton(this.itemDownAction);
        this.configureButton(button, this.itemDownAction, "Move down", "moveDownArrayElement.gif");
        this.actionsPanel.add((Component)button, 5);
    }

    protected void configureButton(AbstractButton button, Action action, String toolTipText, String iconName) {
        button.setAlignmentY(0.5f);
        Dimension btnSize = new Dimension(20, 20);
        button.setSize(btnSize);
        button.setPreferredSize(btnSize);
        button.setMinimumSize(btnSize);
        button.setMaximumSize(btnSize);
        button.setToolTipText(toolTipText);
        if (iconName != null) {
            iconName = "com/developmentontheedge/beans/swing/resources/" + iconName;
            URL iconUrl = this.getClass().getClassLoader().getResource(iconName);
            if (iconUrl != null) {
                button.setIcon(new ImageIcon(iconUrl));
            }
        }
    }

    protected int getArrayRow(ArrayProperty arrayProperty, int item) {
        Object[] path = item < 0 ? arrayProperty.getPathToRoot() : arrayProperty.getPropertyAt(item).getPathToRoot();
        path[0] = this.getComponentModel();
        int row = this.treeTable.getTree().getRowForPath(new TreePath(path));
        return row;
    }

    protected int getArrayIndexByRow(ArrayProperty arrayProperty, int row) {
        TreePath path = this.treeTable.getTree().getPathForRow(row);
        while (path.getParentPath() != null && path.getParentPath().getLastPathComponent() != arrayProperty) {
            path = path.getParentPath();
        }
        if (path.getParentPath() == null) {
            return 0;
        }
        for (int i = 0; i < arrayProperty.getPropertyCount(); ++i) {
            if (path.getLastPathComponent() != arrayProperty.getPropertyAt(i)) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected void setupPopupMenu(JPopupMenu popup) {
        super.setupPopupMenu(popup);
    }

    private void processInspectorEvent(InspectorEvent event) {
    }

    @Override
    protected void validateCell(int row, int column) {
        Property p;
        super.validateCell(row, column);
        boolean insertToEnd = false;
        boolean insertBefore = false;
        boolean insertAfter = false;
        boolean removeItem = false;
        boolean itemUp = false;
        boolean itemDown = false;
        Object value = null;
        if (row >= 0 && column >= 0) {
            if (column == 0) {
                ++column;
            }
            value = this.treeTable.getValueAt(row, column);
        }
        if (value != null && value instanceof Property && (p = (Property)value).isEnabled() && !p.isReadOnly()) {
            if (p.getParent() instanceof ArrayProperty) {
                removeItem = true;
                insertBefore = true;
                insertAfter = true;
                itemUp = true;
                itemDown = true;
            }
            ArrayItem item = this.handleArraySelection(p, column);
            if (item.array != null) {
                insertToEnd = true;
            }
        }
        if (insertToEnd || insertBefore || insertAfter || removeItem || itemUp || itemDown) {
            this.actionsPanel.setVisible(true);
        } else {
            this.actionsPanel.setVisible(false);
        }
        this.enableAction(this.insertAction, insertToEnd);
        this.enableAction(this.removeItemAction, removeItem);
        this.enableAction(this.insertBeforeAction, insertBefore);
        this.enableAction(this.insertAfterAction, insertAfter);
        this.enableAction(this.itemUpAction, itemUp);
        this.enableAction(this.itemDownAction, itemDown);
    }

    protected void enableAction(Action action, boolean enable) {
        action.setEnabled(enable);
    }

    protected ArrayItem handleArraySelection(Property p, int column) {
        int arrayItem = -1;
        ArrayProperty arrayProperty = null;
        if (p instanceof ArrayProperty && (arrayProperty = (ArrayProperty)p).getValue() == null) {
            Object array = Array.newInstance(arrayProperty.getItemClass(), 0);
            try {
                arrayProperty.setValue(array);
            }
            catch (NoSuchMethodException e) {
                Logger.getLogger().error("handleArraySelection", e);
            }
        }
        return new ArrayItem(arrayProperty, arrayItem);
    }

    protected void editSelectedCell() {
        int row = this.treeTable.getSelectedRow();
        int column = this.treeTable.getSelectedColumn();
        this.editCell(row, column);
    }

    public void editCell(int row, int column) {
        if (row < 0 || column < 0) {
            return;
        }
        this.treeTable.editCellAt(row, column);
    }

    static class InspectorEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        static final int ERROR = -1;
        static final int RESERVED = 0;
        static final int ARRAY_NODE_CHANGED = 1;
        static final int ARRAY_NODE_INSERTED = 2;
        static final int ARRAY_NODE_REMOVED = 3;
        int type = 0;
        ArrayProperty arrayProperty;
        Property property;
        int lastItem;
        int startItem;
        int count;

        InspectorEvent(PropertyInspector source, int type) {
            super(source);
            this.type = type;
        }

        InspectorEvent(PropertyInspector source, int type, ArrayProperty arrayProperty) {
            this(source, type);
            this.arrayProperty = arrayProperty;
        }

        InspectorEvent(PropertyInspector source, int type, ArrayProperty arrayProperty, int item) {
            this(source, type, arrayProperty);
            this.startItem = item;
        }

        InspectorEvent(PropertyInspector source, int type, ArrayProperty arrayProperty, Property lastProperty, int lastItem) {
            this(source, type, arrayProperty);
            this.property = lastProperty;
            this.lastItem = lastItem;
        }

        InspectorEvent(PropertyInspector source, int type, ArrayProperty arrayProperty, int startItem, int count) {
            this(source, type, arrayProperty);
            this.startItem = startItem;
            this.count = count;
        }

        public ArrayProperty getArrayProperty() {
            return this.arrayProperty;
        }

        public int getType() {
            return this.type;
        }

        public Property getProperty() {
            return this.property;
        }

        public int getLastItem() {
            return this.lastItem;
        }

        public int getStartItem() {
            return this.startItem;
        }

        public int getCount() {
            return this.count;
        }
    }

    public class CollapseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            JTree tree = PropertyInspectorEx.this.treeTable.getTree();
            for (int i = 1; i < tree.getRowCount(); ++i) {
                PropertyInspectorEx.this.collapseRow(i);
            }
        }
    }

    public class CollapseNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = PropertyInspectorEx.this.treeTable.getSelectedRow();
            int column = PropertyInspectorEx.this.treeTable.getSelectedColumn();
            PropertyInspectorEx.this.collapseRow(row);
            PropertyInspectorEx.this.selectCell(row, column);
        }
    }

    public class ExpandNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = PropertyInspectorEx.this.treeTable.getSelectedRow();
            int column = PropertyInspectorEx.this.treeTable.getSelectedColumn();
            PropertyInspectorEx.this.expandRow(row, true);
            PropertyInspectorEx.this.selectCell(row, column);
        }
    }

    public class ExpandAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            JTree tree = PropertyInspectorEx.this.treeTable.getTree();
            for (int i = 1; i < tree.getRowCount(); ++i) {
                PropertyInspectorEx.this.expandRow(i, false);
            }
        }
    }

    public class MoveAction
    extends ArrayAction {
        private static final long serialVersionUID = 1L;
        public static final String UP_TOOL_TIP_TEXT = "Move up";
        public static final String DOWN_TOOL_TIP_TEXT = "Move down";
        public static final String UP_ICON_NAME = "moveUpArrayElement.gif";
        public static final String DOWN_ICON_NAME = "moveDownArrayElement.gif";
        protected boolean up;

        public MoveAction(boolean up) {
            this.up = up;
        }

        @Override
        public int doArrayAction(ArrayItem item, int row) {
            if (item.array != null) {
                int targetItem = PropertyInspectorEx.this.getArrayIndexByRow(item.array, row);
                if (this.up) {
                    if (targetItem > 0) {
                        item.array.moveDown(--targetItem);
                        --row;
                    }
                } else if (targetItem < Array.getLength(item.array.getValue()) - 1) {
                    item.array.moveDown(targetItem);
                    ++row;
                }
                PropertyInspectorEx.this.processInspectorEvent(new InspectorEvent((PropertyInspector)PropertyInspectorEx.this, 1, item.array, item.index, 2));
                PropertyInspectorEx.this.treeTable.updateUI();
            }
            return row;
        }
    }

    public class RemoveAction
    extends ArrayAction {
        private static final long serialVersionUID = 1L;
        public static final String TOOL_TIP_TEXT = "Remove element";
        public static final String ICON_NAME = "removeArrayElement.gif";

        @Override
        public int doArrayAction(ArrayItem item, int row) {
            if (item.array != null) {
                int removeItem = PropertyInspectorEx.this.getArrayIndexByRow(item.array, row);
                item.array.removeItem(removeItem);
                PropertyInspectorEx.this.processInspectorEvent(new InspectorEvent(PropertyInspectorEx.this, 3, item.array, item.index));
                PropertyInspectorEx.this.treeTable.updateUI();
                --row;
            }
            return row;
        }
    }

    public class InsertAction
    extends ArrayAction {
        private static final long serialVersionUID = 1L;
        public static final String BEFORE_TOOL_TIP_TEXT = "Insert before";
        public static final String AFTER_TOOL_TIP_TEXT = "Insert after";
        public static final String BEFORE_ICON_NAME = "insertBeforeArrayElement.gif";
        public static final String AFTER_ICON_NAME = "insertAfterArrayElement.gif";
        protected boolean before;

        public InsertAction(boolean before) {
            this.before = before;
        }

        @Override
        public int doArrayAction(ArrayItem item, int row) {
            if (item.array != null) {
                try {
                    int insertItem = PropertyInspectorEx.this.getArrayIndexByRow(item.array, row);
                    if (!this.before) {
                        ++item.index;
                        ++insertItem;
                        ++row;
                    }
                    item.array.insertItem(insertItem, null);
                    PropertyInspectorEx.this.processInspectorEvent(new InspectorEvent(PropertyInspectorEx.this, 2, item.array, item.index));
                    PropertyInspectorEx.this.treeTable.updateUI();
                }
                catch (Exception e) {
                    Logger.getLogger().error("PropertyInspector.ArrayAction exception", e);
                }
            }
            return row;
        }
    }

    public abstract class ArrayAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public abstract int doArrayAction(ArrayItem var1, int var2);

        @Override
        public void actionPerformed(ActionEvent event) {
            Object value;
            int curRow = PropertyInspectorEx.this.treeTable.getSelectedRow();
            int column = PropertyInspectorEx.this.treeTable.getSelectedColumn();
            if (curRow < 0 || column < 0) {
                return;
            }
            if (column == 0) {
                ++column;
            }
            if (!((value = PropertyInspectorEx.this.treeTable.getValueAt(curRow, column)) instanceof Property)) {
                return;
            }
            Property property = (Property)value;
            if (property != null && property.getParent() instanceof ArrayProperty) {
                property = property.getParent();
                curRow = this.doArrayAction(PropertyInspectorEx.this.handleArraySelection(property, column), curRow);
                PropertyInspectorEx.this.selectCell(curRow, column);
            }
        }
    }

    public class NewElementAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        public static final String TOOL_TIP_TEXT = "Add element";
        public static final String ICON_NAME = "addArrayElement.gif";

        @Override
        public void actionPerformed(ActionEvent event) {
            Object value;
            int curRow = PropertyInspectorEx.this.treeTable.getSelectedRow();
            int column = PropertyInspectorEx.this.treeTable.getSelectedColumn();
            if (curRow < 0 || column < 0) {
                return;
            }
            if (column == 0) {
                ++column;
            }
            if (!((value = PropertyInspectorEx.this.treeTable.getValueAt(curRow, column)) instanceof Property)) {
                return;
            }
            Property property = (Property)value;
            if (property != null) {
                curRow = this.doArrayAction(PropertyInspectorEx.this.handleArraySelection(property, column), curRow);
                PropertyInspectorEx.this.selectCell(curRow, column);
            }
        }

        public int doArrayAction(ArrayItem item, int row) {
            if (item.array != null) {
                try {
                    item.array.insertItem(item.array.getPropertyCount(), null);
                    PropertyInspectorEx.this.processInspectorEvent(new InspectorEvent(PropertyInspectorEx.this, 2, item.array, item.index));
                    PropertyInspectorEx.this.expandRow(row, true);
                    PropertyInspectorEx.this.treeTable.updateUI();
                }
                catch (Exception e) {
                    Logger.getLogger().error("PropertyInspector.ArrayAction exception", e);
                }
            }
            return row;
        }
    }

    public static class ArrayItem {
        int index;
        ArrayProperty array;

        public ArrayItem(ArrayProperty array, int index) {
            this.array = array;
            this.index = index;
        }
    }
}

