/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.BeanEventListener;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.CompositeProperty;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.model.SimpleProperty;
import com.developmentontheedge.beans.swing.AbstractPropertyInspector;
import com.developmentontheedge.beans.swing.NameRenderer;
import com.developmentontheedge.beans.swing.PropertySetTreeModelAdapter;
import com.developmentontheedge.beans.swing.ValueEditor;
import com.developmentontheedge.beans.swing.ValueRenderer;
import com.developmentontheedge.beans.swing.treetable.DefaultTreeTableModel;
import com.developmentontheedge.beans.swing.treetable.JTreeTable;
import com.developmentontheedge.beans.undo.Transactable;
import com.developmentontheedge.beans.undo.TransactionEvent;
import com.developmentontheedge.beans.undo.TransactionListener;
import com.developmentontheedge.beans.util.SmartText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;

public class PropertyInspector
extends JPanel
implements PropertyChangeListener,
AbstractPropertyInspector,
Transactable {
    private static final long serialVersionUID = 1L;
    public static final int SHOW_USUAL = 0;
    public static final int SHOW_EXPERT = 1;
    public static final int SHOW_HIDDEN = 2;
    public static final int SHOW_PREFERRED = 4;
    protected JSplitPane splitPane = new JSplitPane(0);
    protected JTreeTable treeTable = null;
    protected JScrollPane treePane = null;
    private int propertyShowMode = 4;
    protected EventListenerList listenerList = new EventListenerList();
    private Object bean;
    private ComponentModel componentModel = null;
    private final ValueRenderer valueRenderer = new ValueRenderer(this);
    private PropertyTreeListenerAdapter treeListener;
    private MouseListener popupMouseListener;
    private JPopupMenu popup;
    private boolean showGrid = true;
    private boolean showToolTip = true;
    private int toolTipWidth = 50;
    protected JEditorPane toolTipPane;
    private boolean showTooTipPane = false;
    private int toolTipPanePreferredHeight = 75;

    public PropertyInspector() {
        super(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerSize(5);
        this.popup = new JPopupMenu();
        this.setupPopupMenu(this.popup);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                PropertyInspector.this.updateSplitPaneDivider();
            }
        });
    }

    @Override
    public void addTransactionListener(TransactionListener listener) {
        this.listenerList.add(TransactionListener.class, listener);
    }

    @Override
    public void removeTransactionListener(TransactionListener listener) {
        this.listenerList.remove(TransactionListener.class, listener);
    }

    protected void fireStartTransaction(TransactionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).startTransaction(evt);
        }
    }

    protected void fireAddEdit(UndoableEdit ue) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).addEdit(ue);
        }
    }

    protected void fireCompleteTransaction() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransactionListener.class) continue;
            ((TransactionListener)listeners[i + 1]).completeTransaction();
        }
    }

    @Override
    public Property getProperty(Point pt) {
        int row = this.treeTable.rowAtPoint(pt);
        if (row < 0) {
            return null;
        }
        int column = this.treeTable.columnAtPoint(pt);
        if (column < 0) {
            return null;
        }
        Object value = this.treeTable.getValueAt(row, column);
        if (value instanceof Property) {
            return (Property)value;
        }
        return null;
    }

    @Override
    public Rectangle getCellRect(Point pt) {
        int row = this.treeTable.rowAtPoint(pt);
        if (row < 0) {
            return null;
        }
        int column = this.treeTable.columnAtPoint(pt);
        if (column < 0) {
            return null;
        }
        return this.treeTable.getCellRect(row, column, true);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        if (this.treeTable != null) {
            this.treeTable.addMouseListener(listener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        if (this.treeTable != null) {
            this.treeTable.removeMouseListener(listener);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        if (this.treeTable != null) {
            this.treeTable.addMouseMotionListener(listener);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        if (this.treeTable != null) {
            this.treeTable.removeMouseMotionListener(listener);
        }
    }

    public void explore(Object bean) {
        if (bean == null) {
            if (this.treeTable != null) {
                this.remove(this.treePane);
                this.repaint();
            }
            return;
        }
        if (bean.getClass().isArray()) {
            bean = new ArrayBeanWrapper(bean);
        }
        this.bean = bean;
        ComponentModel mdl = ComponentFactory.getModel(bean, ComponentFactory.Policy.UI);
        this.setComponentModel(mdl);
    }

    public void explore(Object bean, String[] filter) {
        if (bean == null) {
            if (this.treeTable != null) {
                this.remove(this.treePane);
                this.repaint();
            }
            return;
        }
        this.bean = bean;
        ComponentModel mdl = ComponentFactory.getModel(bean, ComponentFactory.Policy.UI);
        ComponentModel fmdl = ComponentFactory.filterComponentModel(mdl, filter);
        this.setComponentModel(fmdl);
        this.treeTable.getTree().setRootVisible(false);
    }

    @Override
    public void clear() {
        this.explore(null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerListeners();
    }

    @Override
    public void removeNotify() {
        this.unregisterListeners();
        super.removeNotify();
    }

    public Object getBean() {
        return this.bean;
    }

    protected ComponentModel getComponentModel() {
        return this.componentModel;
    }

    public void setComponentModel(ComponentModel componentModel) {
        this.unregisterListeners();
        if (componentModel == null) {
            return;
        }
        this.componentModel = componentModel;
        this.treeTable = new JTreeTable(new PropertyInspectorTreeTableModel(componentModel, this.propertyShowMode)){

            @Override
            public String getToolTipText(MouseEvent event) {
                String tip = PropertyInspector.this.showToolTip ? PropertyInspector.this.getToolTip(event) : null;
                return tip;
            }
        };
        this.treeTable.getColumnModel().getColumn(1).setResizable(false);
        this.treeTable.getTableHeader().setReorderingAllowed(false);
        this.treeTable.getTree().setCellRenderer(new NameRenderer());
        this.treeTable.setDefaultRenderer(Object.class, this.valueRenderer);
        this.treeTable.setDefaultEditor(Object.class, new ValueEditor(this));
        this.treeTable.setIntercellSpacing(new Dimension(2, 2));
        this.treeTable.setShowGrid(this.showGrid);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setRowSelectionAllowed(false);
        this.treeTable.setColumnSelectionAllowed(false);
        this.treeTable.setCellSelectionEnabled(true);
        this.treeTable.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.treeListener = new PropertyTreeListenerAdapter();
        this.treePane = new JScrollPane(this.treeTable);
        this.splitPane.setTopComponent(this.treePane);
        this.validate();
        this.selectCell(0, 0);
        if (componentModel.isExpanded()) {
            this.restoreCollapsingState();
        } else {
            this.treeTable.getTree().collapseRow(0);
        }
        this.registerListeners();
        this.updateToolTipPane(componentModel);
    }

    private void registerListeners() {
        this.unregisterListeners();
        if (this.componentModel != null) {
            this.componentModel.addPropertyChangeListener(this);
        }
        if (this.treeTable != null) {
            this.treeTable.addMouseListener(this.getPopupMouseListener());
            if (this.treeListener != null) {
                this.treeTable.getTree().addTreeSelectionListener(this.treeListener);
                this.treeTable.getTree().addTreeExpansionListener(this.treeListener);
            }
            if (this.valueRenderer != null) {
                this.valueRenderer.registerListeners();
            }
        }
    }

    private void unregisterListeners() {
        if (this.componentModel != null) {
            this.componentModel.removePropertyChangeListener(this);
        }
        if (this.treeTable != null) {
            this.treeTable.removeMouseListener(this.getPopupMouseListener());
            if (this.treeListener != null) {
                this.treeTable.getTree().removeTreeSelectionListener(this.treeListener);
                this.treeTable.getTree().removeTreeExpansionListener(this.treeListener);
            }
            if (this.valueRenderer != null) {
                this.valueRenderer.unregisterListeners();
            }
        }
    }

    private MouseListener getPopupMouseListener() {
        if (this.popupMouseListener == null) {
            this.popupMouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() && PropertyInspector.this.popup.getComponentCount() > 0) {
                        PropertyInspector.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() && PropertyInspector.this.popup.getComponentCount() > 0) {
                        PropertyInspector.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
        }
        return this.popupMouseListener;
    }

    protected void selectCell(int row, int column) {
        this.validateCell(row, column);
        if (row < 0 || column < 0) {
            return;
        }
        final int r = row;
        final int c = column;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyInspector.this.treeTable.changeSelection(r, c, false, false);
            }
        });
    }

    public int getRow(String name) {
        Property p = null;
        if (this.componentModel != null) {
            p = this.componentModel.findProperty(name);
        }
        if (p != null) {
            return this.getRow(p);
        }
        return -1;
    }

    public void collapseProperty(String name) {
        this.collapseRow(this.getRow(name));
    }

    public void expandProperty(String name, boolean recursively) {
        this.expandRow(this.getRow(name), recursively);
    }

    public void expand(int level) {
        if (this.isRootVisible()) {
            this.expandRow(0, level);
        } else {
            for (int i = 0; i < this.componentModel.getPropertyCount(); ++i) {
                Property child = this.componentModel.getPropertyAt(i);
                this.expandRow(this.getRow(child), level);
            }
        }
    }

    public void expandAll(boolean recursive) {
        if (this.treeTable == null) {
            return;
        }
        JTree tree = this.treeTable.getTree();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            this.expandRow(i, recursive);
        }
    }

    public void collapseAll() {
        if (this.treeTable == null) {
            return;
        }
        JTree tree = this.treeTable.getTree();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            this.collapseRow(i);
        }
    }

    private void restoreCollapsingState() {
        JTree tree = this.treeTable.getTree();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            this.restoreCollapsingState(tree, i);
        }
    }

    private void restoreCollapsingState(JTree tree, int row) {
        block2: {
            Object o;
            block3: {
                if (row < 0) break block2;
                TreePath path = tree.getPathForRow(row);
                tree.expandRow(row);
                o = path.getLastPathComponent();
                if (row != 0) break block3;
                for (int i = 0; i < this.componentModel.getPropertyCount(); ++i) {
                    Property pChild = this.componentModel.getPropertyAt(i);
                    if (!pChild.isExpanded()) continue;
                    this.restoreCollapsingState(tree, this.getRow(pChild));
                }
                break block2;
            }
            if (!(o instanceof Property)) break block2;
            Property p = (Property)o;
            for (int i = 0; i < p.getPropertyCount(); ++i) {
                Property pChild = p.getPropertyAt(i);
                if (!pChild.isExpanded()) continue;
                this.restoreCollapsingState(tree, this.getRow(pChild));
            }
        }
    }

    protected void collapseRow(int row) {
        if (this.treeTable == null) {
            return;
        }
        if (row >= 0) {
            this.treeTable.getTree().collapseRow(row);
        }
    }

    protected void expandRow(int row, boolean recursively) {
        if (this.treeTable == null) {
            return;
        }
        if (row >= 0) {
            TreePath path;
            Object o;
            JTree tree = this.treeTable.getTree();
            tree.expandRow(row);
            if (recursively && (o = (path = tree.getPathForRow(row)).getLastPathComponent()) instanceof Property) {
                Property p = (Property)o;
                int n = p.getPropertyCount();
                for (int i = 0; i < n; ++i) {
                    Property pChild = p.getPropertyAt(i);
                    this.expandRow(this.getRow(pChild), true);
                }
            }
        }
    }

    protected void expandRow(int row, int level) {
        if (this.treeTable == null) {
            return;
        }
        if (row >= 0 && level > 0) {
            --level;
            JTree tree = this.treeTable.getTree();
            tree.expandRow(row);
            TreePath path = tree.getPathForRow(row);
            Property p = (Property)path.getLastPathComponent();
            int n = p.getPropertyCount();
            for (int i = 0; i < n; ++i) {
                Property pChild = p.getPropertyAt(i);
                this.expandRow(this.getRow(pChild), level);
            }
        }
    }

    protected int getRow(Property property) {
        if (this.treeTable == null) {
            return -1;
        }
        JTree tree = this.treeTable.getTree();
        int n = tree.getRowCount();
        String name = property.getCompleteName();
        for (int i = 1; i < n; ++i) {
            TreePath path = tree.getPathForRow(i);
            Property p = (Property)path.getLastPathComponent();
            if (!p.getCompleteName().startsWith(name)) continue;
            return i;
        }
        return -1;
    }

    protected Point getRowRange(Property property) {
        if (this.treeTable == null) {
            return null;
        }
        Point result = null;
        JTree tree = this.treeTable.getTree();
        String name = property.getCompleteName();
        boolean found = false;
        for (int i = 1; i < tree.getRowCount(); ++i) {
            TreePath path = tree.getPathForRow(i);
            Property p = (Property)path.getLastPathComponent();
            if (p.getCompleteName().startsWith(name)) {
                if (found) {
                    result.y = i;
                    continue;
                }
                found = true;
                result = new Point(i, i);
                continue;
            }
            if (!found) continue;
            return result;
        }
        return result;
    }

    private void handleTreeSelectionEvent(TreeSelectionEvent e) {
        int row = this.treeTable.getSelectedRow();
        int column = this.treeTable.getSelectedColumn();
        this.validateCell(row, column);
        TreePath path = e.getPath();
        Object node = path.getLastPathComponent();
        if (node instanceof Property) {
            this.updateToolTipPane((Property)node);
        }
    }

    protected void validateCell(int row, int column) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property p;
        String propertyName = evt.getPropertyName();
        boolean recreate = propertyName.equals("*");
        int ind = propertyName.lastIndexOf(46);
        String modifier = null;
        if (ind > 0) {
            modifier = propertyName.substring(ind);
            propertyName = propertyName.substring(0, ind);
        }
        if (modifier != null && (modifier.equals("") || modifier.equals(".added") || modifier.equals(".removed"))) {
            recreate = true;
        }
        if ((p = this.componentModel.findProperty(propertyName)) instanceof CompositeProperty && !p.isHideChildren()) {
            recreate = true;
        }
        if (p == null && !recreate) {
            return;
        }
        if (p instanceof SimpleProperty || !recreate) {
            Point rows = this.getRowRange(p);
            if (rows != null) {
                AbstractTableModel tm = (AbstractTableModel)this.treeTable.getModel();
                tm.fireTableChanged(new TableModelEvent(tm, rows.x, rows.y));
            }
        } else {
            ComponentFactory.recreateChildProperties(p);
            if (this.treeTable != null) {
                this.treeTable.updateUI();
            }
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.componentModel == null) {
            return;
        }
        if (propertyName == null) {
            this.componentModel.addPropertyChangeListener(listener);
        } else {
            Property prop = this.componentModel.findProperty(propertyName);
            if (prop != null) {
                prop.addPropertyChangeListener(listener);
            }
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.componentModel == null) {
            return;
        }
        if (propertyName == null) {
            this.componentModel.removePropertyChangeListener(listener);
        } else {
            Property prop = this.componentModel.findProperty(propertyName);
            if (prop != null) {
                prop.removePropertyChangeListener(listener);
            }
        }
    }

    public void addBeanEventListener(String propertyName, String eventName, BeanEventListener listener) {
        Property prop = propertyName == null || propertyName.length() == 0 ? this.componentModel : this.componentModel.findProperty(propertyName);
        if (prop instanceof CompositeProperty) {
            ((CompositeProperty)prop).addBeanEventListener(eventName, listener);
        }
    }

    public void removeBeanEventListener(String propertyName, String eventName, BeanEventListener listener) {
        Property prop = propertyName == null || propertyName.length() == 0 ? this.componentModel : this.componentModel.findProperty(propertyName);
        if (prop instanceof CompositeProperty) {
            ((CompositeProperty)prop).removeBeanEventListener(eventName, listener);
        }
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    protected void setupPopupMenu(JPopupMenu popup) {
        JMenuItem showGridMenuItem = new JMenuItem("Toggle Grid");
        showGridMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyInspector.this.setShowGrid(!PropertyInspector.this.isShowGrid());
            }
        });
        popup.add(showGridMenuItem);
    }

    public int getPropertyShowMode() {
        return this.propertyShowMode;
    }

    public void setPropertyShowMode(int propertyShowMode) {
        this.propertyShowMode = propertyShowMode;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        if (this.treeTable != null) {
            this.treeTable.setShowGrid(showGrid);
        }
    }

    public boolean isRootVisible() {
        return this.treeTable.getTree().isRootVisible();
    }

    public void setRootVisible(boolean visible) {
        this.treeTable.getTree().setRootVisible(visible);
    }

    public NumberFormat getDefaultNumberFormat() {
        return this.valueRenderer.defaultNumberFormat;
    }

    public void setDefaultNumberFormat(NumberFormat format) {
        this.valueRenderer.defaultNumberFormat = format;
    }

    public boolean isShowToolTip() {
        return this.showToolTip;
    }

    public void setShowToolTip(boolean showToolTip) {
        this.showToolTip = showToolTip;
    }

    public int getToolTipWidth() {
        return this.toolTipWidth;
    }

    public void setToolTipWidth(int toolTipWidth) {
        this.toolTipWidth = toolTipWidth;
    }

    protected String getToolTip(MouseEvent event) {
        SmartText descr = new SmartText();
        int column = this.treeTable.columnAtPoint(event.getPoint());
        if (column == 0) {
            int row = this.treeTable.rowAtPoint(event.getPoint());
            if (row == 0) {
                descr.setText(this.componentModel.getTypeDescription());
            } else {
                Object value = this.treeTable.getValueAt(row, 1);
                if (value instanceof Property) {
                    Property p = (Property)value;
                    descr.setText(p.getToolTip());
                }
            }
            descr.setText("<html>" + descr.insertBreaks("<br>", this.toolTipWidth, true) + "</html>");
            return descr.toString();
        }
        return null;
    }

    public boolean isShowToolTipPane() {
        return this.showTooTipPane;
    }

    public void setShowToolTipPane(boolean showTooTipPane) {
        if (this.showTooTipPane == showTooTipPane) {
            return;
        }
        this.showTooTipPane = showTooTipPane;
        if (showTooTipPane) {
            this.toolTipPane = new JEditorPane("text/html", "");
            this.toolTipPane.setEditable(false);
            this.toolTipPane.setPreferredSize(new Dimension(100, this.toolTipPanePreferredHeight));
            this.splitPane.setBottomComponent(new JScrollPane(this.toolTipPane));
            this.splitPane.setDividerSize(5);
            this.updateSplitPaneDivider();
        } else {
            this.toolTipPane = null;
            this.splitPane.setBottomComponent(null);
            this.splitPane.setDividerSize(0);
        }
    }

    public int getToolTipPanePreferredHeight() {
        return this.toolTipPanePreferredHeight;
    }

    public void setToolTipPanePreferredHeight(int value) {
        this.toolTipPanePreferredHeight = value;
        if (this.toolTipPane != null) {
            this.toolTipPane.setPreferredSize(new Dimension(100, this.toolTipPanePreferredHeight));
            this.updateSplitPaneDivider();
        }
    }

    protected void updateToolTipPane(Property property) {
        String text;
        if (this.toolTipPane != null && !(text = "<html><b>" + property.getDisplayName() + "</b><br>" + property.getToolTip() + "</html>").equals(this.toolTipPane.getText())) {
            this.toolTipPane.setText(text);
            this.toolTipPane.setCaretPosition(0);
        }
    }

    protected void updateSplitPaneDivider() {
        if (this.toolTipPane != null) {
            int height = Math.max((int)((double)this.getSize().height * 0.6), this.getSize().height - this.toolTipPanePreferredHeight);
            this.splitPane.setDividerLocation(height);
        }
    }

    void logNonCriticalErrorMessage(String msg, Exception e) {
        Logger.getLogger().error(msg, e);
    }

    public static class ArrayBeanWrapper {
        private final Object array;

        public ArrayBeanWrapper(Object array) {
            this.array = array;
        }

        public Object[] getArray() {
            return (Object[])this.array;
        }
    }

    private static class PropertyInspectorTreeTableModel
    extends DefaultTreeTableModel {
        public PropertyInspectorTreeTableModel(ComponentModel model, int showMode) {
            super(new PropertySetTreeModelAdapter(model, showMode), new DefaultTableModel(new String[]{"Property", "Value"}, 1));
        }

        @Override
        public Object getValueAt(Object node, int i) {
            return node;
        }

        @Override
        public void setValueAt(Object aValue, Object node, int column) {
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            if (column == 0) {
                return true;
            }
            if (node instanceof Property) {
                Property p = (Property)node;
                if (p.isReadOnly()) {
                    return false;
                }
                if (p instanceof SimpleProperty) {
                    return true;
                }
                Object cepl = p.getDescriptor().getValue("composite-editor: property list");
                if (cepl != null) {
                    Property prop;
                    boolean bReadOnly = false;
                    StringTokenizer st = new StringTokenizer((String)cepl, ";, ");
                    while (st.hasMoreTokens() && ((prop = p.findProperty(st.nextToken())) == null || !(bReadOnly = prop.isReadOnly()))) {
                    }
                    return !bReadOnly;
                }
                return ((PropertyDescriptor)p.getDescriptor()).getPropertyEditorClass() != null;
            }
            return false;
        }
    }

    private class PropertyTreeListenerAdapter
    implements TreeSelectionListener,
    TreeExpansionListener {
        private PropertyTreeListenerAdapter() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            PropertyInspector.this.handleTreeSelectionEvent(e);
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            Object node = path.getLastPathComponent();
            if (!(node instanceof Property)) {
                return;
            }
            Property property = (Property)node;
            property.setExpanded(true);
            PropertyInspector.this.restoreCollapsingState((JTree)e.getSource(), node instanceof ComponentModel ? 0 : PropertyInspector.this.getRow(property));
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            Object node = path.getLastPathComponent();
            if (node instanceof Property) {
                ((Property)node).setExpanded(false);
            } else {
                PropertyInspector.this.logNonCriticalErrorMessage("Unknown node type: " + node.getClass(), null);
            }
        }
    }
}

