/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import com.developmentontheedge.beans.swing.table.BeanTableModelAdapter;
import com.developmentontheedge.beans.swing.table.Column;
import com.developmentontheedge.beans.swing.table.ColumnModel;
import com.developmentontheedge.beans.swing.table.RowModel;
import com.developmentontheedge.beans.swing.table.RowModelEvent;
import com.developmentontheedge.beans.swing.table.SortedColumnModel;
import com.developmentontheedge.beans.swing.table.SortedTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;

public class PagedTabularPropertyInspector
extends TabularPropertyInspector {
    private static final long serialVersionUID = 1L;
    protected JButton firstButton;
    protected JButton previousButton;
    protected JEditorPane pageLabel;
    protected JLabel pageCountLabel;
    protected JButton nextButton;
    protected JButton lastButton;
    protected JComboBox entries;
    protected int[] pages;

    public PagedTabularPropertyInspector(int[] pages) {
        this.pages = pages;
        this.sortEnabled = false;
    }

    @Override
    public void setSortEnabled(boolean enabled) {
    }

    @Override
    public void explore(RowModel rowModel, ColumnModel columnModel) {
        this.unregisterListeners();
        if (rowModel != null) {
            this.tableModel = new PaginateBeanTableModelAdapter(rowModel, columnModel, this.pages[0]);
            this.tableModel.setRowHeader(this.getRowHeader());
            this.sortEnabled = columnModel instanceof SortedColumnModel;
            this.table.setModel(this.tableModel);
            if (this.getRowHeader()) {
                TableColumn col = this.table.getColumnModel().getColumn(0);
                col.setResizable(false);
                col.setMinWidth(30);
                col.setPreferredWidth(30);
                col.setMaxWidth(30);
            }
            if (this.table.getColumnCount() > 8) {
                this.table.setAutoResizeMode(0);
            } else {
                this.table.setAutoResizeMode(4);
            }
            if (this.tableModel instanceof SortedTableModel) {
                ((SortedTableModel)((Object)this.tableModel)).sort();
            }
        } else {
            this.table = null;
            this.tableModel = null;
            this.removeAll();
            this.repaint();
            this.initTable();
        }
        this.registerListeners();
        this.fillEntriesBox();
        this.updateControls();
    }

    @Override
    protected void initTable() {
        super.initTable();
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel pagePanel = new JPanel();
        this.firstButton = new JButton("First");
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PagedTabularPropertyInspector.this.tableModel != null) {
                    ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).setCurrentPage(1);
                    PagedTabularPropertyInspector.this.updateControls();
                }
            }
        });
        pagePanel.add(this.firstButton);
        this.previousButton = new JButton("Previous");
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentPage;
                if (PagedTabularPropertyInspector.this.tableModel != null && (currentPage = ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).getCurrentPage()) > 1) {
                    ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).setCurrentPage(--currentPage);
                    PagedTabularPropertyInspector.this.updateControls();
                }
            }
        });
        pagePanel.add(this.previousButton);
        pagePanel.add(new JLabel("Page "));
        this.pageLabel = new JEditorPane();
        this.pageLabel.setPreferredSize(new Dimension(50, 20));
        this.pageLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ke.consume();
                    if (PagedTabularPropertyInspector.this.tableModel != null) {
                        try {
                            int page = Integer.parseInt(PagedTabularPropertyInspector.this.pageLabel.getText().trim());
                            int pageCount = ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).getPageCount();
                            if (page >= 1 && page <= pageCount) {
                                ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).setCurrentPage(page);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    PagedTabularPropertyInspector.this.updateControls();
                }
            }
        });
        pagePanel.add(this.pageLabel);
        pagePanel.add(new JLabel(" of "));
        this.pageCountLabel = new JLabel();
        pagePanel.add(this.pageCountLabel);
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentPage;
                if (PagedTabularPropertyInspector.this.tableModel != null && (currentPage = ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).getCurrentPage()) < ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).getPageCount()) {
                    ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).setCurrentPage(++currentPage);
                    PagedTabularPropertyInspector.this.updateControls();
                }
            }
        });
        pagePanel.add(this.nextButton);
        this.lastButton = new JButton("Last");
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PagedTabularPropertyInspector.this.tableModel != null) {
                    ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).setCurrentPage(((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).getPageCount());
                    PagedTabularPropertyInspector.this.updateControls();
                }
            }
        });
        pagePanel.add(this.lastButton);
        controlPanel.add((Component)pagePanel, "West");
        JPanel rightPanel = new JPanel();
        rightPanel.add(new JLabel("Show "));
        this.entries = new JComboBox();
        this.entries.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PagedTabularPropertyInspector.this.tableModel != null) {
                    Object selectedObject = e.getItem();
                    int pageSize = Integer.parseInt(selectedObject.toString());
                    ((PaginateBeanTableModelAdapter)PagedTabularPropertyInspector.this.tableModel).setPageSize(pageSize);
                    PagedTabularPropertyInspector.this.updateControls();
                }
            }
        });
        rightPanel.add(this.entries);
        rightPanel.add(new JLabel(" entries"));
        controlPanel.add((Component)rightPanel, "East");
        this.add((Component)controlPanel, "North");
    }

    protected void fillEntriesBox() {
        this.entries.removeAllItems();
        for (int p : this.pages) {
            this.entries.addItem(Integer.toString(p));
        }
    }

    protected void updateControls() {
        int currentPage = ((PaginateBeanTableModelAdapter)this.tableModel).getCurrentPage();
        int pageCount = ((PaginateBeanTableModelAdapter)this.tableModel).getPageCount();
        this.firstButton.setEnabled(currentPage > 1);
        this.previousButton.setEnabled(currentPage > 1);
        this.nextButton.setEnabled(currentPage < pageCount);
        this.lastButton.setEnabled(currentPage < pageCount);
        this.pageLabel.setText(Integer.toString(currentPage));
        this.pageCountLabel.setText(Integer.toString(pageCount));
    }

    public static class PaginateBeanTableModelAdapter
    extends BeanTableModelAdapter
    implements SortedTableModel {
        protected int pageSize;
        protected int currentPage;

        public PaginateBeanTableModelAdapter(RowModel rm, ColumnModel columnModel, int pageSize) {
            super(rm, columnModel);
            this.pageSize = pageSize;
            this.currentPage = 1;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public int getPageCount() {
            int rowCount = super.getRowCount();
            if (rowCount % this.pageSize == 0) {
                return rowCount / this.pageSize;
            }
            return rowCount / this.pageSize + 1;
        }

        public void setCurrentPage(int currentPage) {
            this.currentPage = currentPage;
            this.fireTableDataChanged();
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            int rowCount = super.getRowCount();
            return Math.min(rowCount -= this.pageSize * (this.currentPage - 1), this.pageSize);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return super.getValueAt(this.getModelRow(row), column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            super.setValueAt(aValue, this.getModelRow(row), column);
        }

        @Override
        public Object getModelForRow(int row) {
            return super.getModelForRow(this.getModelRow(row));
        }

        protected int getModelRow(int viewRow) {
            return this.pageSize * (this.currentPage - 1) + viewRow;
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            String name = evt.getPropertyName();
            if (evt.getSource() != this.columnModel && name.equals("sorting")) {
                Column column = (Column)evt.getSource();
                if (!column.getEnabled()) {
                    return;
                }
                this.sort();
            }
        }

        @Override
        public synchronized void tableChanged(RowModelEvent evt) {
            super.tableChanged(evt);
            this.sort();
        }

        @Override
        public void sort() {
            if (this.getColumnModel() instanceof SortedColumnModel) {
                ((SortedColumnModel)this.getColumnModel()).sort();
            }
            this.fireTableDataChanged();
        }
    }
}

