/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.model.ArrayProperty;
import com.developmentontheedge.beans.model.Property;
import java.awt.Component;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class NameRenderer
implements TreeCellRenderer {
    protected DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        boolean isMotif = UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        this.defaultRenderer.setLeafIcon(this.defaultRenderer.getDefaultLeafIcon());
        this.defaultRenderer.setOpenIcon(this.defaultRenderer.getDefaultOpenIcon());
        this.defaultRenderer.setClosedIcon(this.defaultRenderer.getDefaultClosedIcon());
        if (value instanceof Property) {
            Image img = ((Property)value).getIcon();
            if (img != null) {
                ImageIcon icon = new ImageIcon(img);
                if (isLeaf) {
                    this.defaultRenderer.setLeafIcon(icon);
                } else if (isExpanded) {
                    this.defaultRenderer.setOpenIcon(icon);
                } else {
                    this.defaultRenderer.setClosedIcon(icon);
                }
            } else if (value instanceof ArrayProperty) {
                // empty if block
            }
        }
        Component comp = this.defaultRenderer.getTreeCellRendererComponent(tree, value instanceof Property ? ((Property)value).getDisplayName() : value, isSelected, isExpanded, isLeaf, row, hasFocus);
        if (isSelected && isMotif) {
            comp.setForeground(UIManager.getColor("Table.selectionForeground"));
            ((JComponent)comp).setOpaque(true);
        }
        return comp;
    }
}

