/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.beans.swing;

import com.developmentontheedge.beans.BeanEventListener;
import com.developmentontheedge.beans.log.Logger;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.CompositeProperty;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.model.SimpleProperty;
import com.developmentontheedge.beans.swing.AbstractPropertyInspector;
import com.developmentontheedge.beans.swing.ValueEditor;
import com.developmentontheedge.beans.swing.ValueRenderer;
import com.developmentontheedge.beans.util.SmartText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class DialogPropertyInspector
extends JPanel
implements PropertyChangeListener,
AbstractPropertyInspector {
    private int propertyShowMode = 4;
    private static final Dimension zeroDimension = new Dimension(0, 0);
    private static final JTable dummyTable = new JTable();
    private static final int MAX_RECURSION = 3;
    private JComponent contents = null;
    private ComponentModel componentModel = null;
    public static final int DEFAULT_EDITOR_WIDTH = 60;
    private final ValueEditor defEditor = new ValueEditor();
    private final ValueRenderer defRenderer = new ValueRenderer();
    private final HashMap<String, JPanel> map = new HashMap();
    private boolean bViewCreating = false;
    private final GridBagConstraints labelGridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
    private final GridBagConstraints editorGridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0);
    private boolean showToolTip = true;
    private int toolTipWidth = 50;
    private JPopupMenu popup;
    private int columnCount;
    private int maxRecursion = 3;

    public DialogPropertyInspector() {
        super(new BorderLayout());
        this.setSize(200, 200);
        this.popup = new JPopupMenu();
        this.setupPopupMenu(this.popup);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && DialogPropertyInspector.this.popup.getComponentCount() > 0) {
                    DialogPropertyInspector.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && DialogPropertyInspector.this.popup.getComponentCount() > 0) {
                    DialogPropertyInspector.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property p;
        if (this.bViewCreating) {
            return;
        }
        String propertyName = evt.getPropertyName();
        boolean recreate = false;
        int ind = propertyName.lastIndexOf(46);
        String modifier = null;
        if (ind > 0) {
            modifier = propertyName.substring(ind);
            propertyName = propertyName.substring(0, ind);
        }
        if (modifier != null && (modifier.equals("") || modifier.equals(".added") || modifier.equals(".removed"))) {
            recreate = true;
        }
        if ((p = this.componentModel.findProperty(propertyName)) == null) {
            return;
        }
        if (!(p instanceof SimpleProperty) && recreate) {
            ComponentFactory.recreateChildProperties(p);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogPropertyInspector.this.setComponentModel(DialogPropertyInspector.this.componentModel);
                }
            });
            return;
        }
        JPanel view = this.map.get(p.getCompleteName());
        if (view != null) {
            JLabel label = new JLabel(p.getDisplayName());
            JComponent editor = this.getEditor(p);
            view.removeAll();
            view.add((Component)label, this.labelGridBagConstraints);
            view.add((Component)editor, this.editorGridBagConstraints);
            this.validate();
            this.repaint();
        }
    }

    protected ComponentModel getComponentModel() {
        return this.componentModel;
    }

    public void setComponentModel(ComponentModel componentModel) {
        this.map.clear();
        this.removeAll();
        if (componentModel == null) {
            return;
        }
        if (this.componentModel != null) {
            this.componentModel.removePropertyChangeListener(this);
        }
        this.componentModel = componentModel;
        this.componentModel.addPropertyChangeListener(this);
        this.contents = this.createGroupPropertyView(componentModel, this.columnCount, this.maxRecursion);
        this.add((Component)new JScrollPane(this.contents), "Center");
        this.validate();
    }

    private JComponent getEditor(Property childProperty) {
        JComponent editor = (JComponent)this.defEditor.getEditorComponent(this, childProperty, false, -1, -1);
        boolean isReadOnly = childProperty.isReadOnly();
        if (editor == null && isReadOnly) {
            try {
                editor = (JComponent)this.defRenderer.getTableCellRendererComponent(dummyTable, childProperty, false, false, -1, -1);
            }
            catch (Exception e) {
                Logger.getLogger().warn("Cannot create editor for " + childProperty.getCompleteName(), e);
            }
        }
        if (editor != null) {
            editor.setEnabled(!isReadOnly);
            Component[] comps = editor.getComponents();
            for (int j = 0; j < comps.length; ++j) {
                comps[j].setEnabled(!isReadOnly);
            }
            Dimension editorDimension = childProperty.getEditorPreferredSize();
            if (editorDimension == null || editorDimension.equals(zeroDimension)) {
                editorDimension = new Dimension(60, editor.getPreferredSize().height);
                childProperty.setEditorPreferredSize(editorDimension);
            }
            editor.setPreferredSize(editorDimension);
            if (this.showToolTip) {
                SmartText descr = new SmartText();
                descr.setText(childProperty.getToolTip());
                descr.setText("<html>" + descr.insertBreaks("<br>", this.toolTipWidth, true) + "</html>");
                editor.setToolTipText(descr.toString());
            }
        }
        return editor;
    }

    private boolean insertEditor(JPanel contents, Property childProperty, int row, int column) {
        JComponent editor = this.getEditor(childProperty);
        if (editor != null) {
            PropertyPanel panel = new PropertyPanel(childProperty.getDisplayName(), editor);
            contents.add((Component)panel, new GridBagConstraints(column, row, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.map.put(childProperty.getCompleteName(), panel);
            return true;
        }
        return false;
    }

    private JComponent createTabbedPropertyView(Property property, int columns, int recursionLevel) {
        if (recursionLevel <= 0) {
            return null;
        }
        JComponent tabbedPane = null;
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        int row = 0;
        int column = 0;
        int propCount = property.getVisibleCount(this.propertyShowMode);
        while (propCount == 1) {
            boolean bFound = false;
            for (int k = 0; k < property.getPropertyCount(); ++k) {
                Property newProp = property.getPropertyAt(k);
                if (!newProp.isVisible(this.propertyShowMode) || newProp instanceof SimpleProperty) continue;
                bFound = true;
                property = newProp;
                propCount = property.getVisibleCount(this.propertyShowMode);
                break;
            }
            if (bFound) continue;
            break;
        }
        for (int i = 0; i < propCount; ++i) {
            Property childProperty = property.getVisiblePropertyAt(i, this.propertyShowMode);
            if (!(childProperty instanceof SimpleProperty)) {
                JComponent childPropertyView;
                if (tabbedPane == null) {
                    tabbedPane = new JTabbedPane();
                    Color temp = tabbedPane.getForeground();
                    tabbedPane.setForeground(Color.blue);
                    ((JTabbedPane)tabbedPane).addTab(property.getDisplayName(), new JScrollPane(contents));
                    tabbedPane.setForeground(temp);
                }
                if ((childPropertyView = this.createTabbedPropertyView(childProperty, columns, recursionLevel - 1)) == null) continue;
                ((JTabbedPane)tabbedPane).addTab(childProperty.getDisplayName(), childPropertyView);
                continue;
            }
            if (!this.insertEditor(contents, childProperty, row, column)) continue;
            if (column == columns - 1) {
                column = 0;
                ++row;
                continue;
            }
            ++column;
        }
        return tabbedPane != null ? tabbedPane : contents;
    }

    private JComponent createGroupPropertyView(Property property, int columns, int recursionLevel) {
        if (recursionLevel <= 0) {
            return null;
        }
        this.bViewCreating = true;
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        int row = 0;
        int column = 0;
        int propCount = property.getVisibleCount(this.propertyShowMode);
        while (propCount == 1) {
            boolean bFound = false;
            for (int k = 0; k < property.getPropertyCount(); ++k) {
                Property newProp = property.getPropertyAt(k);
                if (!newProp.isVisible(this.propertyShowMode) || newProp instanceof SimpleProperty) continue;
                bFound = true;
                property = newProp;
                propCount = property.getVisibleCount(this.propertyShowMode);
                break;
            }
            if (bFound) continue;
            break;
        }
        for (int i = 0; i < propCount; ++i) {
            Property childProperty = property.getVisiblePropertyAt(i, this.propertyShowMode);
            if (!(childProperty instanceof SimpleProperty)) {
                JPanel childPropertyView = (JPanel)this.createGroupPropertyView(childProperty, columns, recursionLevel - 1);
                if (childPropertyView == null || childPropertyView.getComponentCount() == 0) continue;
                TitledBorder border = new TitledBorder(BorderFactory.createEtchedBorder(), childProperty.getDisplayName());
                childPropertyView.setBorder(border);
                column = 0;
                contents.add((Component)childPropertyView, new GridBagConstraints(0, ++row, columns, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
                ++row;
                continue;
            }
            if (!this.insertEditor(contents, childProperty, row, column)) continue;
            if (column == columns - 1) {
                column = 0;
                ++row;
                continue;
            }
            ++column;
        }
        this.bViewCreating = false;
        return contents;
    }

    public boolean isShowToolTip() {
        return this.showToolTip;
    }

    public void setShowToolTip(boolean showToolTip) {
        this.showToolTip = showToolTip;
    }

    public int getToolTipWidth() {
        return this.toolTipWidth;
    }

    public void setToolTipWidth(int toolTipWidth) {
        this.toolTipWidth = toolTipWidth;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    protected void setupPopupMenu(JPopupMenu popup) {
    }

    void logNonCriticalErrorMessage(String msg, Exception e) {
        if (msg == null) {
            msg = "";
        }
        if (e == null) {
            Logger.getLogger().warn(msg);
        } else {
            Logger.getLogger().warn(msg, e);
        }
    }

    public void explore(Object bean) {
        ComponentModel mdl = ComponentFactory.getModel(bean, ComponentFactory.Policy.UI);
        this.setComponentModel(mdl);
    }

    public void explore(Class<?> beanClass) {
        this.setComponentModel(beanClass == null ? null : ComponentFactory.getModel(beanClass, ComponentFactory.Policy.UI));
    }

    @Override
    public void clear() {
        this.explore(null);
    }

    public void cleanup() {
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Property prop = this.componentModel.findProperty(propertyName);
        if (prop != null) {
            prop.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Property prop = this.componentModel.findProperty(propertyName);
        if (prop != null) {
            prop.removePropertyChangeListener(listener);
        }
    }

    public void addBeanEventListener(String propertyName, String eventName, BeanEventListener listener) {
        Property prop = propertyName == null || propertyName.length() == 0 ? this.componentModel : this.componentModel.findProperty(propertyName);
        if (prop instanceof CompositeProperty) {
            ((CompositeProperty)prop).addBeanEventListener(eventName, listener);
        }
    }

    public void removeBeanEventListener(String propertyName, String eventName, BeanEventListener listener) {
        Property prop = propertyName == null || propertyName.length() == 0 ? this.componentModel : this.componentModel.findProperty(propertyName);
        if (prop instanceof CompositeProperty) {
            ((CompositeProperty)prop).removeBeanEventListener(eventName, listener);
        }
    }

    public void setColumnCount(int value) {
        this.columnCount = value;
    }

    public int getMaxRecursion() {
        return this.maxRecursion;
    }

    public void setMaxRecursion(int value) {
        this.maxRecursion = value;
    }

    public int getPropertyShowMode() {
        return this.propertyShowMode;
    }

    public void setPropertyShowMode(int propertyShowMode) {
        this.propertyShowMode = propertyShowMode;
    }

    @Override
    public Property getProperty(Point pt) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Rectangle getCellRect(Point pt) {
        throw new RuntimeException("Not implemented!");
    }

    class PropertyPanel
    extends JPanel {
        PropertyPanel(String name, Component editor) {
            super(new GridBagLayout());
            JLabel label = new JLabel(name);
            this.add((Component)label, DialogPropertyInspector.this.labelGridBagConstraints);
            this.add(editor, DialogPropertyInspector.this.editorGridBagConstraints);
        }
    }
}

